/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RAnonymousFunction;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;

public class REvaluate
extends ROperation {
    public static final String TYPE_NUMERIC = "numeric";
    public static final String TYPE_BINARY = "binary";
    public static final String TYPE_CATEGORY = "category";
    private static final RChoiceKey TARGET_DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("target_data", "Input Data").setChoiceProvider(RChoiceProvider.globalDataFrames())).setPreviewFunction(DATA_PREVIEW)).setRequired(true)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(TARGET_DATA)).setRequired(true)).setOutput(true)).build();
    private static final RChoiceKey TARGET = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("target", "Target Variable").setChoiceProvider(RChoiceProvider.columns(TARGET_DATA, true))).setRequired(true)).build();
    private static final BoolKey ACTUAL_TARGET = ((BoolKey.Builder)BoolKey.builder("actual_target", "").setNoSave(true)).build();
    private static final RChoiceKey PREDICT_DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("predict_data", "Prediction Data").setChoiceProvider(RChoiceProvider.globalDataFrames())).setPreviewFunction(DATA_PREVIEW)).setNoSave(true)).build();
    private static final BoolKey ALL_COLUMNS = ((BoolKey.Builder)BoolKey.builder("all_columns", "").setNoSave(true)).build();
    private static final ChoiceKey PREDICT = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("predict", "Prediction").setChoiceEditable(true)).setChoiceProvider(RChoiceProvider.columns(TARGET_DATA, false))).build();
    private static final RTableKey PREDICTS = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("predicts", "Prediction", PREDICT).setUiControls(GeneralTableModel.UI_DEFAULT2)).setDefaultRowPredicate()).setRequired(true)).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValuesAndLabels("numeric", "Numeric", "binary", "Binary", "category", "Category")).build();
    private static final BoolKey TYPE_AUTO = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("type_auto", "Auto update when target is changed").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).build();
    private static final BoolKey SORT_RESULT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("sort_result", "Sort Result").setDefaultValue(Boolean.TRUE)).noLabel()).build();
    private static final ChoiceKey SORT_COLUMN = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("sort_column", "").setValues("Mean.Squared.Error", "Mean.Absolute.Error", "Bias")).addVisibleKeyLink(TYPE, "numeric")).addEnabledKeyLink(SORT_RESULT, true)).build();
    private static final BoolKey CONF_MATRIX = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("conf_matrix", "Output confusion matrix").noLabel()).addVisibleKeyLink(TYPE, "binary", "category")).build();
    private static final BoolKey CHART = ((BoolKey.Builder)BoolKey.builder("chart", "Draw chart").noLabel()).build();
    private static final BoolKey SINGLE = ((BoolKey.Builder)BoolKey.builder("single", "").setNoSave(true)).build();

    public static REvaluate instance(String string, String string2, String string3, String string4, String string5, Boolean bl, String string6, Boolean bl2, Boolean bl3, boolean bl4) {
        REvaluate rEvaluate = new REvaluate();
        rEvaluate.putValue(ACTUAL_TARGET, Boolean.TRUE);
        rEvaluate.putValue(ALL_COLUMNS, Boolean.TRUE);
        rEvaluate.putValue(SINGLE, bl4);
        rEvaluate.putValue(TARGET_DATA, string);
        rEvaluate.putValue(TARGET, string2);
        rEvaluate.putValue(PREDICT_DATA, string3);
        rEvaluate.putValue(OUTPUT, string4);
        rEvaluate.putValue(TYPE_AUTO, Boolean.FALSE);
        rEvaluate.putValue(TYPE, string5);
        rEvaluate.putValue(SORT_RESULT, bl);
        rEvaluate.putValue(SORT_COLUMN, string6);
        rEvaluate.putValue(CONF_MATRIX, bl2);
        rEvaluate.putValue(CHART, bl3);
        return rEvaluate;
    }

    @Override
    public Version getVersion() {
        return new Version(0, 0, 1, 5);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(TARGET_DATA, TARGET, ACTUAL_TARGET, PREDICT_DATA, PREDICTS, ALL_COLUMNS, OUTPUT, TYPE, TYPE_AUTO, SORT_RESULT, SORT_COLUMN, CONF_MATRIX, CHART);
    }

    @Override
    protected String getDefaultTitle() {
        return "Evaluation";
    }

    @Override
    public String getOpClass() {
        return "model";
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return TARGET_DATA;
    }

    @Override
    public boolean showPreviewInBrowser() {
        return this.isEnabled(CONF_MATRIX) && this.getValue(CONF_MATRIX) != false || this.getValue(CHART) != false;
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return REvaluate.suffix(this.getValue(TARGET_DATA), ".eval");
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        ScriptBuilder scriptBuilder = REvaluate.scriptBuilder();
        this.getRScript(scriptBuilder, bl, bl2, previewOption);
        return scriptBuilder.toString();
    }

    public void getRScript(ScriptBuilder scriptBuilder, boolean bl, boolean bl2, PreviewOption previewOption) {
        if (!this.getValue(OUTPUT).isEmpty()) {
            scriptBuilder.append(this.getValue(OUTPUT) + " <- ");
        }
        RAnonymousFunction rAnonymousFunction = new RAnonymousFunction();
        rAnonymousFunction.addArgs("data", this.getValue(TARGET_DATA));
        rAnonymousFunction.addArgs("y", this.y());
        String string = this.getValue(ALL_COLUMNS) != false ? this.getValue(PREDICT_DATA) : RUtility.combineCharacters(this.getValue(PREDICTS).getValidValues(PREDICT));
        if (string.isEmpty()) {
            string = "";
        }
        rAnonymousFunction.addArgs("pred", string);
        scriptBuilder.appLnInd(rAnonymousFunction.getHeadStr());
        switch (this.getValue(TYPE)) {
            case "numeric": {
                this.numeric(scriptBuilder);
                break;
            }
            case "binary": {
                this.binary(scriptBuilder);
                break;
            }
            case "category": {
                this.category(scriptBuilder);
                break;
            }
        }
        this.result(scriptBuilder);
        scriptBuilder.unind_Ln(rAnonymousFunction.getTailStr());
    }

    private String y() {
        Object object = this.getValue(ACTUAL_TARGET) != false ? this.getValue(TARGET) : "with(" + this.getValue(TARGET_DATA) + ", " + this.getValue(TARGET) + ")";
        return object;
    }

    private void result(ScriptBuilder scriptBuilder) {
        if (this.isEnabled(CONF_MATRIX) && this.getValue(CONF_MATRIX).booleanValue() || this.getValue(CHART).booleanValue()) {
            boolean bl;
            scriptBuilder.appendLn();
            ArgsList argsList = new ArgsList();
            argsList.add("Evaluation", "evl");
            if (this.isEnabled(CONF_MATRIX) && this.getValue(CONF_MATRIX).booleanValue()) {
                String string = this.getValue(SINGLE) != false ? "ConfusionMatrix" : "ConfusionMatrices";
                argsList.add(string, "cf");
            }
            boolean bl2 = bl = this.getValue(TYPE).equals(TYPE_CATEGORY) && this.getValue(CHART) != false;
            if (bl) {
                scriptBuilder.appLnInd("if (is.null(charts)) {");
                scriptBuilder.appendLn(RUtility.function("list", argsList));
                scriptBuilder.unLn_Ind("} else {");
            }
            if (this.getValue(CHART).booleanValue()) {
                argsList.add("Charts", "charts");
            }
            scriptBuilder.appendLn(RUtility.function("list", argsList));
            if (bl) {
                scriptBuilder.unind_Ln("}");
            }
        } else {
            scriptBuilder.appendLn("evl");
        }
    }

    private void numeric(ScriptBuilder scriptBuilder) {
        scriptBuilder.appendLn("y <- as.numeric(y)");
        scriptBuilder.appendLn("predicts <- if(is.data.frame(pred)) pred else data[, pred, drop = FALSE]");
        scriptBuilder.appendLn("e <- lapply(predicts, function(x) as.numeric(x) - y)");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("evl <- data.frame(row.names = names(predicts))");
        scriptBuilder.appendLn("evl$Mean.Squared.Error <- unlist(lapply(e, function(x) mean(x^2)))");
        scriptBuilder.appendLn("evl$Mean.Absolute.Error <- unlist(lapply(e, function(x) mean(abs(x))))");
        scriptBuilder.appendLn("evl$Bias <- unlist(lapply(e, function(x) mean(x)))");
        if (this.getValue(SORT_RESULT).booleanValue()) {
            String string = "evl$" + this.getValue(SORT_COLUMN);
            if (this.getValue(SORT_COLUMN).equals("Bias")) {
                string = "abs(" + string + ")";
            }
            scriptBuilder.appendLn("evl <- evl[order(" + string + "), ]");
        }
        if (this.getValue(CHART).booleanValue()) {
            scriptBuilder.appendLn();
            scriptBuilder.appLnInd("createPlot <- function(label, ev, bias = FALSE) {");
            scriptBuilder.appendLn("m <- unlist(lapply(ev, mean))");
            scriptBuilder.appendLn("ordr <- order(if (bias) abs(m) else m, decreasing = TRUE)");
            scriptBuilder.appendLn("ev.df <- data.frame(model = factor(rep(names(ev), each = length(ev[[1]])), levels = names(ev)[ordr]), error = unlist(ev, use.names = FALSE), stringsAsFactors = FALSE)");
            scriptBuilder.appLnInd("lattice::bwplot(model ~ error, data = ev.df, xlab = label, pch = \"|\", panel = function(...) {");
            scriptBuilder.appendLn("if (bias) lattice::panel.abline(v = 0, lty = 3)");
            scriptBuilder.appendLn("lattice::panel.points(x = m[ordr], y = seq_along(m), pch = 16, col = 1)");
            scriptBuilder.appendLn("lattice::panel.bwplot(...)");
            scriptBuilder.unind_Ln("}, key=list(space = \"top\", text=list(\"Average\"), points=list(pch = 16)))");
            scriptBuilder.unind_Ln("}");
            scriptBuilder.appendLn("charts <- list()");
            scriptBuilder.appendLn("charts$SquaredError <- createPlot(label = \"Squared Error\", ev = lapply(e, `^`, 2))");
            scriptBuilder.appendLn("charts$AbsoluteError <- createPlot(label = \"Absolute Error\", ev = lapply(e, abs))");
            scriptBuilder.appendLn("charts$Error <- createPlot(label = \"Error (Prediction - Actual)\", ev = e, bias = TRUE)");
        }
    }

    private void binary(ScriptBuilder scriptBuilder) {
        scriptBuilder.appendLn("if(is.factor(y) || is.character(y)) y <- y %in% c(\"TRUE\", \"1\")");
        if (this.getValue(CONF_MATRIX).booleanValue()) {
            scriptBuilder.appendLn("is.L <- is.logical(y)");
        }
        scriptBuilder.appendLn("y <- as.logical(y)");
        scriptBuilder.appendLn("predicts <- if(is.data.frame(pred)) pred else data[, pred, drop = FALSE]");
        scriptBuilder.appendLn("e <- lapply(predicts, function(x) if(is.logical(x)) x == y else if(is.factor(x) || is.character(x)) x %in% c(\"TRUE\", \"1\") == y else (x >= 0.5) == y)");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("evl <- data.frame(row.names = names(predicts))");
        scriptBuilder.appendLn("evl$Accuracy <- unlist(lapply(e, function(x) mean(x)))");
        if (this.getValue(SORT_RESULT).booleanValue()) {
            scriptBuilder.appendLn("evl <- evl[order(evl$Accuracy, decreasing = TRUE), , drop = FALSE]");
        }
        if (this.getValue(CONF_MATRIX).booleanValue()) {
            scriptBuilder.appendLn();
            if (this.getValue(SINGLE).booleanValue()) {
                scriptBuilder.appLnInd("cf <- (function(x) {");
            } else {
                scriptBuilder.appLnInd("cf <- lapply(predicts, function(x) {");
            }
            scriptBuilder.appLnInd("if (!is.logical(x)) {");
            scriptBuilder.appendLn("x <- x >= 0.5");
            scriptBuilder.unind_Ln("}");
            scriptBuilder.appLnInd("if (is.L) {");
            scriptBuilder.appendLn("Actual <- y");
            scriptBuilder.appendLn("Predict <- x");
            scriptBuilder.unind_Ln("} else {");
            scriptBuilder.indentLn("Actual <- as.integer(y)");
            scriptBuilder.appendLn("Predict <- as.integer(x)");
            scriptBuilder.unind_Ln("}");
            scriptBuilder.appendLn("xtabs(~ Predict + Actual)");
            if (this.getValue(SINGLE).booleanValue()) {
                scriptBuilder.unind_Ln("})(predicts[[1]])");
            } else {
                scriptBuilder.unind_Ln("})");
            }
        }
        if (this.getValue(CHART).booleanValue()) {
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("charts <- list()");
            scriptBuilder.appLnInd("g <- lapply(names(predicts), function(x) {");
            scriptBuilder.appendLn("od <- order(predicts[, x], decreasing = TRUE)");
            scriptBuilder.appendLn("data.frame(p = (1:length(y)) / length(y) * 100, gain = cumsum(y[od]) / sum(y) * 100, model = x)");
            scriptBuilder.unind_Ln("})");
            scriptBuilder.appendLn("gdf <- do.call(rbind, g)");
            String string = this.getValue(SINGLE) != false ? "" : "auto.key = list(space = \"right\"), ";
            scriptBuilder.appLnInd("charts$Gains <- lattice::xyplot(x = gain ~ p, data = gdf, type = \"l\", " + string + "groups = model,");
            scriptBuilder.appendLn("panel = function(...) {lattice::panel.segments(x0 = 0, y0 = 0, x1 = 100, y1 = 100, col = \"gray\"); lattice::panel.xyplot(...)},");
            scriptBuilder.appendLn("xlim = extendrange(c(0, 100)), ylim = extendrange(c(0, 100)), xlab = \"Top Percentile (%)\", ylab = \"Coverage of Responses (%)\", main = \"Gains Chart\")");
            scriptBuilder.unindent();
            scriptBuilder.appLnInd("g <- lapply(names(predicts), function(x) {");
            scriptBuilder.appendLn("od <- order(predicts[, x], decreasing = TRUE)");
            scriptBuilder.appendLn("data.frame(p = (1:length(y)) / length(y) * 100, response = cumsum(y[od]) / 1:length(y) * 100, cs = cumsum(y[od]), model = x)");
            scriptBuilder.unind_Ln("})");
            scriptBuilder.appendLn("gdf <- do.call(rbind, g)");
            scriptBuilder.appendLn("base <- mean(y) * 100");
            scriptBuilder.appLnInd("charts$Response <- lattice::xyplot(x = response ~ p, data = gdf, type = \"l\", " + string + "groups = model,");
            scriptBuilder.appendLn("panel = function(...) {lattice::panel.segments(x0 = 0, y0 = base, x1 = 100, y1 = base, col = \"gray\"); lattice::panel.xyplot(...)},");
            scriptBuilder.appendLn("xlim = extendrange(c(0, 100)), xlab = \"Top Percentile (%)\", ylab = \"Cumulative Response Rate (%)\", main = \"Response Chart\")");
            scriptBuilder.unindent();
        }
    }

    private void category(ScriptBuilder scriptBuilder) {
        scriptBuilder.appendLn("predicts <- if(is.data.frame(pred)) pred else data[, pred, drop = FALSE]");
        scriptBuilder.appendLn("e <- lapply(predicts, function(x) if(is.matrix(x)) y == colnames(x)[apply(x, 1, which.max)] else y == x)");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("evl <- data.frame(row.names = names(predicts))");
        scriptBuilder.appendLn("evl$Accuracy <- unlist(lapply(e, function(x) mean(x)))");
        if (this.getValue(SORT_RESULT).booleanValue()) {
            scriptBuilder.appendLn("evl <- evl[order(evl$Accuracy, decreasing = TRUE), , drop = FALSE]");
        }
        if (this.getValue(CONF_MATRIX).booleanValue()) {
            scriptBuilder.appendLn();
            if (this.getValue(SINGLE).booleanValue()) {
                scriptBuilder.appLnInd("cf <- (function(x) {");
            } else {
                scriptBuilder.appLnInd("cf <- lapply(predicts, function(x) {");
            }
            scriptBuilder.appendLn("Actual <- y");
            scriptBuilder.appLnInd("Predict <- if (is.matrix(x)) {");
            scriptBuilder.appendLn("colnames(x)[apply(x, 1, which.max)]");
            scriptBuilder.unLn_Ind("} else {");
            scriptBuilder.appendLn("x");
            scriptBuilder.unind_Ln("}");
            scriptBuilder.appendLn("xtabs(~ Predict + Actual)");
            if (this.getValue(SINGLE).booleanValue()) {
                scriptBuilder.unind_Ln("})(predicts[[1]])");
            } else {
                scriptBuilder.unind_Ln("})");
            }
        }
        if (this.getValue(CHART).booleanValue()) {
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("charts <- NULL");
            scriptBuilder.appLnInd("if (all(unlist(lapply(predicts, is.matrix)))) {");
            scriptBuilder.appendLn("charts <- list(Gains = list(), Response = list())");
            scriptBuilder.appLnInd("for (plot.target in colnames(predicts[, 1])) {");
            scriptBuilder.appendLn("z <- y == plot.target");
            scriptBuilder.appendLn();
            scriptBuilder.appLnInd("g <- lapply(names(predicts), function(x) {");
            scriptBuilder.appendLn("od <- order(predicts[, x][, plot.target], decreasing = TRUE)");
            scriptBuilder.appendLn("data.frame(p = (1:length(z)) / length(z) * 100, gain = cumsum(z[od]) / sum(z) * 100, model = x)");
            scriptBuilder.unind_Ln("})");
            scriptBuilder.appendLn("gdf <- do.call(rbind, g)");
            String string = this.getValue(SINGLE) != false ? "" : "auto.key = list(space = \"right\"), ";
            scriptBuilder.appLnInd("charts$Gains[[plot.target]] <- lattice::xyplot(x = gain ~ p, data = gdf, type = \"l\", " + string + "groups = model,");
            scriptBuilder.appendLn("panel = function(...) {lattice::panel.segments(x0 = 0, y0 = 0, x1 = 100, y1 = 100, col = \"gray\"); lattice::panel.xyplot(...)},");
            scriptBuilder.appendLn("xlim = extendrange(c(0, 100)), ylim = extendrange(c(0, 100)), xlab = \"Top Percentile (%)\", ylab = \"Coverage of Responses (%)\",");
            scriptBuilder.appendLn("main = paste(\"Gains Chart (\", as.character(plot.target), \")\", sep = \"\"))");
            scriptBuilder.unindent();
            scriptBuilder.appendLn();
            scriptBuilder.appLnInd("g <- lapply(names(predicts), function(x) {");
            scriptBuilder.appendLn("od <- order(predicts[, x][, plot.target], decreasing = TRUE)");
            scriptBuilder.appendLn("data.frame(p = (1:length(z)) / length(z) * 100, response = cumsum(z[od]) / 1:length(z) * 100, cs = cumsum(z[od]), model = x)");
            scriptBuilder.unind_Ln("})");
            scriptBuilder.appendLn("gdf <- do.call(rbind, g)");
            scriptBuilder.appLnInd("charts$Response[[plot.target]] <- lattice::xyplot(x = response ~ p, data = gdf, type = \"l\", " + string + "groups = model, base = gdf$response[nrow(gdf)],");
            scriptBuilder.appendLn("panel = function(base, ...) {lattice::panel.segments(x0 = 0, y0 = base, x1 = 100, y1 = base, col = \"gray\"); lattice::panel.xyplot(...)},");
            scriptBuilder.appendLn("xlim = extendrange(c(0, 100)), xlab = \"Top Percentile (%)\", ylab = \"Cumulative Response Rate (%)\",");
            scriptBuilder.appendLn("main = paste(\"Response Chart (\", as.character(plot.target), \")\", sep = \"\"))");
            scriptBuilder.unindent();
            scriptBuilder.unind_Ln("}");
            scriptBuilder.unLn_Ind("} else {");
            scriptBuilder.appendLn("warning(\"Charts cannot be drawn for categorical prediction\")");
            scriptBuilder.unind_Ln("}");
        }
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new SplitPaneWidgetNode(false, 0.5f).addElements(new PanelWidgetNode().addElements(TARGET_DATA, OUTPUT, TARGET, PREDICTS), new PanelWidgetNode().addElements(TYPE, PanelWidgetNode.indent().addKeys(TYPE_AUTO), new XFlowPanelWidgetNode().addElements(SORT_RESULT, SORT_COLUMN), CONF_MATRIX, CHART));
    }

    @Override
    protected void processValueChanged(ValueChangeEvent valueChangeEvent) {
        super.processValueChanged(valueChangeEvent);
        if (TARGET.equals(valueChangeEvent.getKey())) {
            this.autoDetectType();
        }
    }

    private void autoDetectType() {
        if (this.getValue(TARGET_DATA).isEmpty() || this.getValue(TARGET).isEmpty() || !this.getValue(TYPE_AUTO).booleanValue()) {
            return;
        }
        String string = this.getValue(TARGET_DATA) + "[[" + REvaluate.quote(this.getValue(TARGET)) + "]]";
        String string2 = REvaluate.scriptBuilder().appendLn("(function(target) {").appendLn("if (inherits(target, \"try-error\")) { \"\" ").appendLn("} else if (is.factor(target) || is.character(target)) { \"category\" ").appendLn("} else if (is.logical(target)) { \"binary\" ").appendLn("} else if (is.numeric(target) && head(target, 1000) %in% c(0, 1)) { \"binary\" ").appendLn("} else if (is.numeric(target)) { \"numeric\" ").appendLn("} else { \"\" }").appendLn("})(target = try(" + string + ", silent = TRUE))").toString();
        R.queryQueue().addQuery(() -> {
            String string2;
            switch (string2 = RClient.rexpToString(R.client().silentTimeoutEvalGet(string2), "")) {
                case "category": {
                    this.putValue(TYPE, TYPE_CATEGORY);
                    break;
                }
                case "binary": {
                    this.putValue(TYPE, TYPE_BINARY);
                    break;
                }
                case "numeric": {
                    this.putValue(TYPE, TYPE_NUMERIC);
                    break;
                }
            }
        });
    }
}

