/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ComponentTableKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RMinimizedTableKey;
import java.util.List;

public class RFormRowSelector
extends ROperation {
    protected static final String EQUALS = "eq";
    protected static final String NOT_EQUALS = "ne";
    protected static final String LESS_THAN = "lt";
    protected static final String GREATER_THAN = "gt";
    protected static final String LESS_THAN_OR_EQUAL = "le";
    protected static final String GREATER_THAN_OR_EQUAL = "ge";
    protected static final String MATCHES = "match";
    protected static final String NOT_MATCHES = "nmatch";
    protected static final String IS_NA = "na";
    protected static final String IS_NOT_NA = "notna";
    protected static final String CONTAINS = "contain";
    protected static final String NOT_CONTAINS = "notcontain";
    protected static final String STARTS_WITH = "start";
    protected static final String ENDS_WITH = "end";
    private static final StrKey DATA = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("data", "Data").setHidden(true)).setNoSave(true)).build();
    protected static final RChoiceKey COLUMN = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("column", "Column").setCompletionSupport(RChoiceProvider.columns(DATA, true))).setLabelPosition("none")).setRequired(true)).build();
    protected static final ChoiceKey CONDITION = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("condition", "Condition").setValuesAndLabels("eq", "== (equal to)", "ne", "!= (not equal to)", "lt", "< (less than)", "gt", "> (greater than)", "le", "<= (less than or equal to)", "ge", ">= (greater than or equal to)", "match", "%in% (one of)", "nmatch", "!(%in%) (not one of)", "na", "is.na (missing)", "notna", "!is.na (not missing)", "contain", "[String] contains", "notcontain", "[String] does not contain", "start", "[String] starts with", "end", "[String] ends with")).setLabelPosition("none")).build();
    protected static final RChoiceKey FACTOR_VALUE = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("fvalue", "Value").setCompletionSupport(RChoiceProvider.levels("data", "column"))).addVisibleKeyLink(CONDITION, "eq", "ne", "lt", "gt", "le", "ge")).setLabelPosition("none")).setRequired(true)).build();
    protected static final RChoiceKey STRING_VALUE = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("svalue", "Value").setCompletionSupport(RChoiceProvider.levels("data", "column"))).addVisibleKeyLink(CONDITION, "contain", "notcontain", "start", "end")).setCharSupport(true)).setLabelPosition("none")).setRequired(true)).build();
    protected static final RChoiceKey COL_VALUE = ((RChoiceKey.Builder)RChoiceKey.builder("colvalue", "Value").setCompletionSupport(RChoiceProvider.levels("data", "column"))).build();
    protected static final RMinimizedTableKey VALUES = ((RMinimizedTableKey.Builder)((RMinimizedTableKey.Builder)((Key.Builder)((RMinimizedTableKey.Builder)((RMinimizedTableKey.Builder)((RMinimizedTableKey.Builder)RMinimizedTableKey.builder("values", "Values", COL_VALUE).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(CONDITION, "match", "nmatch")).setLabelPosition("none")).setDialogSize(new int[]{300, 400})).setRequired(true)).setMaxRows(2)).build();

    public RFormRowSelector() {
        this.addLookUpKey("data");
    }

    @Override
    protected void initKeys() {
        this.registerKeys(COLUMN, this.conditionKey(), FACTOR_VALUE, STRING_VALUE, VALUES);
    }

    @Override
    public String getDefaultTitle() {
        return "Form";
    }

    @Override
    public String getSummary() {
        return this.getExpression();
    }

    @Override
    public String getSmallIconKey() {
        return "16/form.png";
    }

    public String toString() {
        return this.getSummary();
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        return new XFlowPanelWidgetNode().addElements(COLUMN, this.conditionKey(), FACTOR_VALUE, STRING_VALUE, VALUES);
    }

    protected ChoiceKey conditionKey() {
        return CONDITION;
    }

    public String getExpression() {
        String string;
        String string2 = this.getValue(COLUMN);
        switch (string = this.getValue(this.conditionKey())) {
            case "gt": {
                return string2 + " > " + this.getValue(FACTOR_VALUE);
            }
            case "ge": {
                return string2 + " >= " + this.getValue(FACTOR_VALUE);
            }
            case "lt": {
                return string2 + " < " + this.getValue(FACTOR_VALUE);
            }
            case "le": {
                return string2 + " <= " + this.getValue(FACTOR_VALUE);
            }
            case "eq": 
            case "ne": {
                String string3 = string.equals(EQUALS) ? " == " : " != ";
                return string2 + string3 + this.getValue(FACTOR_VALUE);
            }
            case "match": 
            case "nmatch": {
                List<String> list = this.getValue(VALUES).getValues(COL_VALUE);
                if (list.isEmpty()) {
                    return "";
                }
                String string4 = string2 + " %in% " + RUtility.combine(list);
                if (string.equals(NOT_MATCHES)) {
                    string4 = "!(" + string4 + ")";
                }
                return string4;
            }
            case "na": 
            case "notna": {
                String string5 = "is.na(" + string2 + ")";
                if (string.equals(IS_NOT_NA)) {
                    string5 = "!" + string5;
                }
                return string5;
            }
            case "contain": 
            case "notcontain": {
                String string6 = string.equals(NOT_CONTAINS) ? "!" : "";
                return string6 + "grepl(" + this.getValue(STRING_VALUE) + ", " + string2 + ", fixed = TRUE)";
            }
            case "start": {
                return "substr(" + string2 + ", 1, nchar(" + this.getValue(STRING_VALUE) + ")) == " + this.getValue(STRING_VALUE);
            }
            case "end": {
                String string7 = "nchar(as.character(" + string2 + "))";
                return "substr(" + string2 + ", pmax(1, " + string7 + " - nchar(" + this.getValue(STRING_VALUE) + ") + 1), " + string7 + ") == " + this.getValue(STRING_VALUE);
            }
        }
        return "";
    }

    @Override
    public boolean isEmpty() {
        String string;
        if (!this.getValue(COLUMN).isEmpty()) {
            return false;
        }
        boolean bl = false;
        switch (string = this.getValue(this.conditionKey())) {
            case "gt": 
            case "ge": 
            case "lt": 
            case "le": 
            case "eq": 
            case "ne": {
                bl = this.getValue(FACTOR_VALUE).isEmpty();
                break;
            }
            case "contain": 
            case "notcontain": 
            case "start": 
            case "end": {
                bl = this.getValue(STRING_VALUE).isEmpty();
                break;
            }
            case "match": 
            case "nmatch": {
                bl = this.getValue(VALUES).getRowCount() == 0;
                break;
            }
        }
        return bl;
    }

    @Override
    protected void configureValidationContext(ValidationContext validationContext) {
        super.configureValidationContext(validationContext);
        validationContext.addValidator(ComponentTableKey.createIgnoreEmptyValidator(this));
    }

    static {
        OpManager.getInstance().add(new RFormRowSelector());
    }
}

