/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTextKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RFormula2
extends ROperation {
    private static final String FORMULA_TYPE_TEXT = "Text";
    private static final String FORMULA_TYPE_UI = "UI";
    private static final String X_ALL = "all";
    private static final String X_INCLUDE = "include";
    private static final String X_EXCLUDE = "exclude";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA)).setOutput(true)).build();
    private static final RadioButtonKey FORMULA_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("formula", "Formula").setValuesAndLabels("UI", "GUI", "Text", "Direct Input")).setLabelPosition("none")).build();
    private static final RTextKey FORMULA_TEXT = ((RTextKey.Builder)((Key.Builder)RTextKey.builder("formula_text", "").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addVisibleKeyLink(FORMULA_TYPE, "Text")).build();
    private static final RChoiceKey FORMULA_Y = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("formula_y", "Output (Y)").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    private static final RadioButtonKey FORMULA_X = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("formula_x", "Input (X)").setValuesAndLabels("all", "All", "include", "Include", "exclude", "Exclude")).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    private static final RChoiceKey FORMULA_COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("formula_column", "X").setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    private static final RTableKey FORMULA_LIST = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("formula_list", "Input (X)", FORMULA_COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT2)).addKeyLink(KeyLink.visible(StrKeyTest.create(FORMULA_X, "include", "exclude")))).setLabelPosition("none")).build();
    private static final BoolKey FORMULA_INTERCEPT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("formula_intercept", "Intercept").setDefaultValue(true)).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    private static final BoolKey TERMS_FORMULA = ((BoolKey.Builder)BoolKey.builder("terms_formula", "Expand dot(.)").setLabelPosition("none")).build();
    private static final RTableKey ADVANCED = RFormula2.argsKey("terms.formula");

    @Override
    public Version getVersion() {
        return new Version(0, 2, 0);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1") && this.getValue(FORMULA_TYPE).equals(FORMULA_TYPE_UI)) {
            List<String> list = this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN);
            if (list.isEmpty()) {
                this.putValue(FORMULA_X, X_ALL);
            } else {
                this.putValue(FORMULA_X, X_INCLUDE);
            }
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, FORMULA_TYPE, FORMULA_TEXT, FORMULA_Y, FORMULA_X, FORMULA_LIST, FORMULA_INTERCEPT, TERMS_FORMULA, ADVANCED);
    }

    @Override
    protected String getDefaultTitle() {
        return "Create Model Formula";
    }

    @Override
    public String getOpClass() {
        return "model";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return RFormula2.suffix(this.getValue(DATA), ".formula");
        }
        return super.getAutoValue(key);
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    protected String getFormula() {
        String string = this.getValue(FORMULA_TYPE);
        if (string.equals(FORMULA_TYPE_TEXT)) {
            return this.getValue(FORMULA_TEXT);
        }
        String string2 = this.getValue(FORMULA_X);
        String string3 = this.getValue(FORMULA_Y);
        List<String> list = this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(" ~ ");
        if (string2.equals(X_ALL)) {
            stringBuilder.append(".");
        } else if (string2.equals(X_INCLUDE)) {
            if (list.isEmpty()) {
                if (this.getValue(FORMULA_INTERCEPT).booleanValue()) {
                    stringBuilder.append("1");
                }
            } else {
                stringBuilder.append(StringUtils.join(list, (String)" + "));
            }
        } else {
            stringBuilder.append(".");
            if (!list.isEmpty() && !this.getValue(TERMS_FORMULA).booleanValue()) {
                stringBuilder.append(" - ");
                stringBuilder.append(StringUtils.join(list, (String)" - "));
            }
        }
        if (!this.getValue(FORMULA_INTERCEPT).booleanValue()) {
            stringBuilder.append(" - 1");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string3 = this.getFormula();
        if (this.getValue(TERMS_FORMULA).booleanValue()) {
            Object object = this.getValue(DATA);
            if (this.getValue(FORMULA_TYPE).equals(FORMULA_TYPE_UI) && this.getValue(FORMULA_X).equals(X_EXCLUDE)) {
                String string4 = this.getValue(FORMULA_Y);
                List<String> list = this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN).stream().filter(string2 -> !string2.equals(string4)).map(string -> RUtility.removeBackticks(string)).collect(Collectors.toList());
                if (!list.isEmpty()) {
                    object = (String)object + "[, !(names(" + (String)object + ") %in% " + RUtility.combineCharacters(list) + ")]";
                }
            }
            string3 = RUtility.function("terms", this.getArgs(ADVANCED), new String[]{"", string3, "data", object});
            string3 = RUtility.function("formula", "", string3);
        }
        return RUtility.assign(this.getValue(OUTPUT), string3);
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, new TitledPanelWidgetNode("Formula", true).addElements(FORMULA_TYPE, FORMULA_TEXT, FORMULA_Y, FORMULA_X, FORMULA_LIST, FORMULA_INTERCEPT)).addTabWithElements("Options", TERMS_FORMULA).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    protected int getSplitHeight() {
        return 325;
    }
}

