/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTextKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.node.ui.UIInterfaceInitializer;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public interface RFormulaInterface {
    public static final String FORMULA_TYPE_TEXT = "Text";
    public static final String FORMULA_TYPE_UI = "UI";
    public static final String FORMULA_TYPE_OBJECT = "Object";
    public static final String X_ALL = "all";
    public static final String X_INCLUDE = "include";
    public static final String X_EXCLUDE = "exclude";
    public static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(ROperation.DATA_PREVIEW)).build();
    public static final RadioButtonKey FORMULA_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("formula", "Formula").setValuesAndLabels("UI", "GUI", "Object", "Formula Object", "Text", "Direct Input")).setLabelPosition("none")).build();
    public static final RTextKey FORMULA_TEXT = ((RTextKey.Builder)((Key.Builder)RTextKey.builder("formula_text", "").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addVisibleKeyLink(FORMULA_TYPE, "Text")).build();
    public static final RChoiceKey FORMULA_Y = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("formula_y", "Output (Y)").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    public static final RadioButtonKey FORMULA_X = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("formula_x", "Input (X)").setValuesAndLabels("all", "All", "include", "Include", "exclude", "Exclude")).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    public static final RChoiceKey FORMULA_COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("formula_column", "X").setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    public static final RTableKey FORMULA_LIST = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("formula_list", "Input (X)", FORMULA_COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT2)).addKeyLink(KeyLink.visible(StrKeyTest.create(FORMULA_X, "include", "exclude")))).setDefaultRowPredicate()).setLabelPosition("none")).build();
    public static final BoolKey FORMULA_INTERCEPT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("formula_intercept", "Intercept").setDefaultValue(true)).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    public static final RChoiceKey FORMULA_OBJECT = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("formula_object", "Object").setCompletionSupport(RChoiceProvider.inherits("formula"))).addVisibleKeyLink(FORMULA_TYPE, "Object")).build();
    public static final UIInterfaceInitializer init = new UIInterfaceInitializer(RFormulaInterface.class);

    default public boolean formulaUseIntercept() {
        return true;
    }

    default public Key<?>[] getFormulaKeys() {
        if (this.formulaUseIntercept()) {
            return new Key[]{DATA, FORMULA_TYPE, FORMULA_TEXT, FORMULA_OBJECT, FORMULA_Y, FORMULA_X, FORMULA_LIST, FORMULA_INTERCEPT};
        }
        return new Key[]{DATA, FORMULA_TYPE, FORMULA_TEXT, FORMULA_OBJECT, FORMULA_Y, FORMULA_X, FORMULA_LIST};
    }

    default public String getFormula(ValueMap valueMap) {
        String string = valueMap.getValue(FORMULA_TYPE);
        if (string.equals(FORMULA_TYPE_TEXT)) {
            return valueMap.getValue(FORMULA_TEXT);
        }
        if (string.equals(FORMULA_TYPE_OBJECT)) {
            return valueMap.getValue(FORMULA_OBJECT);
        }
        String string2 = valueMap.getValue(FORMULA_X);
        String string3 = valueMap.getValue(FORMULA_Y);
        List<String> list = valueMap.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(" ~ ");
        if (string2.equals(X_ALL)) {
            stringBuilder.append(".");
        } else if (string2.equals(X_INCLUDE)) {
            if (list.isEmpty()) {
                if (!this.formulaUseIntercept() || valueMap.getValue(FORMULA_INTERCEPT).booleanValue()) {
                    stringBuilder.append("1");
                }
            } else {
                stringBuilder.append(StringUtils.join(list, (String)" + "));
            }
        } else {
            stringBuilder.append(".");
            if (!list.isEmpty()) {
                stringBuilder.append(" - ");
                stringBuilder.append(StringUtils.join(list, (String)" - "));
            }
        }
        if (this.formulaUseIntercept() && !valueMap.getValue(FORMULA_INTERCEPT).booleanValue()) {
            stringBuilder.append(" - 1");
        }
        return stringBuilder.toString();
    }
}

