/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RSubsetInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RConsoleResultView;
import com.ef_prime.rflow.ui.app.r.RPlotPreviewView;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RLatticeBWPlot
extends ROperation
implements RSubsetInterface {
    private static final String ORIENTATION_VERTICAL = "v";
    private static final String ORIENTATION_HORIZONTAL = "h";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("data", "Data").setChoiceProvider(RChoiceProvider.globalDataFrames())).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RChoiceKey VARIABLE = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("variable", "Variable").setRequired(true)).setChoiceProvider(RChoiceProvider.columns(DATA, true))).build();
    private static final RChoiceKey GROUP_BY = ((RChoiceKey.Builder)RChoiceKey.builder("group_by", "Group By").setChoiceProvider(RChoiceProvider.columns(DATA, true))).build();
    private static final RChoiceKey CONDITIONING = ((RChoiceKey.Builder)RChoiceKey.builder("conditioning", "Condition By").setChoiceProvider(RChoiceProvider.columns(DATA, true))).build();
    private static final RadioButtonKey ORIENTATION = ((RadioButtonKey.Builder)RadioButtonKey.builder("orientation", "Orientation").setValuesAndLabels("v", "Vertical", "h", "Horizontal")).build();
    private static final RStrKey MAIN = ((RStrKey.Builder)RStrKey.builder("main", "Title").setCharSupport(true)).build();
    private static final RStrKey SUB = ((RStrKey.Builder)RStrKey.builder("sub", "Subtitle").setCharSupport(true)).build();
    private static final RStrKey V_LAB = ((RStrKey.Builder)RStrKey.builder("vlab", "Title").setCharSupport(true)).build();
    private static final RStrKey V_MIN = RStrKey.builder("vmin", "Min").build();
    private static final RStrKey V_MAX = RStrKey.builder("vmax", "Max").build();
    private static final RChoiceKey V_LOG_SCALE = RLatticeBWPlot.logicalKey("v_log_scale", "Log Scale", "");
    private static final RStrKey GROUP_LAB = ((RStrKey.Builder)RStrKey.builder("group_lab", "Title").setCharSupport(true)).build();
    private static final RTableKey ADVANCED = RLatticeBWPlot.argsKey("lattice:::bwplot.formula", "lattice::bwplot", "xlim", "ylim", "scales");

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, VARIABLE, GROUP_BY, CONDITIONING, ORIENTATION, MAIN, SUB, V_LAB, V_MIN, V_MAX, V_LOG_SCALE, GROUP_LAB, ADVANCED);
        this.registerKeys(this.getSubsetKeys());
    }

    @Override
    protected String getDefaultTitle() {
        return "Box Plot";
    }

    @Override
    public RPackage[] getRPackages() {
        return new RPackage[]{new RPackage("lattice", true, false)};
    }

    @Override
    public String getOpClass() {
        return "chart";
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return new ViewWidgetNode(RPlotPreviewView.class);
    }

    @Override
    public boolean canImport(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.size() != 1) {
            return false;
        }
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        RObject rObject = RObjectFlavor.getObject(transferable);
        if (rObject == null) {
            return;
        }
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null || rObject.inherits("data.frame")) {
            this.putValue(DATA, rObject.getFullName(false));
        } else {
            this.putValue(DATA, rObject2.getFullName(false));
            this.putValue(VARIABLE, rObject.getName(true));
        }
    }

    @Override
    public void setPreviewValues(PreviewOption previewOption) {
        if (this.isStringEmpty(DATA)) {
            this.setPreviewData(VARIABLE, previewOption);
            this.setPreviewData(GROUP_BY, previewOption);
            this.setPreviewData(CONDITIONING, previewOption);
        }
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getContentWidgetNode(viewOptions);
        if (!viewOptions.isWizard()) {
            return this.createTabPaneWithScript(widgetNode);
        }
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        WidgetNode widgetNode2 = this.getPreviewWidgetNode();
        if (widgetNode2 != null) {
            tabPaneWidgetNode.add(widgetNode2);
            tabPaneWidgetNode.add(new ViewWidgetNode(RConsoleResultView.class));
        }
        tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
        return this.createSplitPaneWidgetNode().addElements(widgetNode, tabPaneWidgetNode);
    }

    @Override
    protected int getSplitHeight() {
        return 200;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, VARIABLE, GROUP_BY, CONDITIONING, ORIENTATION).addTabWithElements("Title", MAIN, SUB).addTabWithElements("Axis", new SplitPaneWidgetNode(false, 0.5f).addElements(new TitledPanelWidgetNode("Variable", true).addElements(V_LAB, V_MIN, V_MAX, V_LOG_SCALE), new TitledPanelWidgetNode("Group", true).addElements(GROUP_LAB)).setGrowY(true)).addTabWithKeys("Select Rows", this.getSubsetKeys()).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Object object;
        boolean bl3 = this.getValue(ORIENTATION).equals(ORIENTATION_VERTICAL);
        if (bl3) {
            object = this.getValue(GROUP_BY).isEmpty() ? "character(nrow(" + this.getValue(DATA) + "))" : this.getValue(GROUP_BY);
            string7 = this.getValue(VARIABLE) + " ~ " + (String)object;
        } else {
            object = this.getValue(GROUP_BY).isEmpty() ? "" : this.getValue(GROUP_BY) + " ";
            string7 = (String)object + "~ " + this.getValue(VARIABLE);
        }
        if (!this.getValue(CONDITIONING).isEmpty()) {
            string7 = string7 + " | " + this.getValue(CONDITIONING);
        }
        object = "";
        if (!this.getValue(V_LOG_SCALE).isEmpty()) {
            string6 = RUtility.function("list", "log", this.getValue(V_LOG_SCALE), "equispaced.log", this.getValue(V_LOG_SCALE).equals("FALSE") ? "" : "FALSE");
            object = RUtility.function("list", bl3 ? "y" : "x", string6);
        }
        String string8 = string5 = this.getValue(V_MIN).isEmpty() && this.getValue(V_MAX).isEmpty() ? "" : RUtility.combine((String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(V_MIN), (CharSequence)"NA"), (String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(V_MAX), (CharSequence)"NA"));
        String string9 = !this.getValue(GROUP_LAB).isEmpty() ? this.getValue(GROUP_LAB) : (string4 = !this.getValue(GROUP_BY).isEmpty() ? RLatticeBWPlot.quote(this.getValue(GROUP_BY)) : "");
        if (bl3) {
            string6 = string4;
            string3 = this.getValue(V_LAB);
            string2 = "";
            string = string5;
        } else {
            string6 = this.getValue(V_LAB);
            string3 = string4;
            string2 = string5;
            string = "";
        }
        String string10 = RUtility.function("lattice::bwplot", this.getArgs(ADVANCED), new String[]{"x", string7, "data", this.getValue(DATA), "scales", object, "xlab", string6, "xlim", string2, "ylab", string3, "ylim", string, "horizontal", RUtility.toRBoolean(!bl3), "pch", RLatticeBWPlot.sQuote("|"), "main", this.getValue(MAIN), "sub", this.getValue(SUB), "subset", this.getSubset(this)});
        return "print(" + string10 + ")";
    }
}

