/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RSubsetInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RConsoleResultView;
import com.ef_prime.rflow.ui.app.r.RPlotPreviewView;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RLatticeHistogram
extends ROperation
implements RSubsetInterface {
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RChoiceKey VARIABLE = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("variable", "Variable").setRequired(true)).setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    private static final RChoiceKey CONDITIONING = ((RChoiceKey.Builder)RChoiceKey.builder("conditioning", "Condition By").setCompletionSupport(RChoiceProvider.columns(DATA.getId(), true))).build();
    private static final RStrKey NINT = RStrKey.builder("nint", "Number of Bins").build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValues(RLatticeHistogram.quote("percent"), RLatticeHistogram.quote("count"), RLatticeHistogram.quote("density"))).setLabels("Percent", "Count", "Density")).build();
    private static final RStrKey MAIN = ((RStrKey.Builder)RStrKey.builder("main", "Title").setCharSupport(true)).build();
    private static final RStrKey SUB = ((RStrKey.Builder)RStrKey.builder("sub", "Subtitle").setCharSupport(true)).build();
    private static final RStrKey X_LAB = ((RStrKey.Builder)RStrKey.builder("xlab", "Title").setCharSupport(true)).build();
    private static final RStrKey X_MIN = RStrKey.builder("xmin", "Min").build();
    private static final RStrKey X_MAX = RStrKey.builder("xmax", "Max").build();
    private static final RStrKey Y_LAB = ((RStrKey.Builder)RStrKey.builder("ylab", "Title").setCharSupport(true)).build();
    private static final RStrKey Y_MIN = RStrKey.builder("ymin", "Min").build();
    private static final RStrKey Y_MAX = RStrKey.builder("ymax", "Max").build();
    private static final RTableKey ADVANCED = RLatticeHistogram.argsKey("lattice:::histogram.formula", "lattice::histogram", "x", "xlim", "ylim");

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, VARIABLE, CONDITIONING, NINT, TYPE, MAIN, SUB, X_LAB, X_MIN, X_MAX, Y_LAB, Y_MIN, Y_MAX, ADVANCED);
        this.registerKeys(this.getSubsetKeys());
    }

    @Override
    public RPackage[] getRPackages() {
        return new RPackage[]{new RPackage("lattice", true, false)};
    }

    @Override
    protected String getDefaultTitle() {
        return "Histogram";
    }

    @Override
    public String getOpClass() {
        return "chart";
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return new ViewWidgetNode(RPlotPreviewView.class);
    }

    @Override
    public boolean canImport(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.size() != 1) {
            return false;
        }
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        RObject rObject = RObjectFlavor.getObject(transferable);
        if (rObject == null) {
            return;
        }
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null || rObject.inherits("data.frame")) {
            this.putValue(DATA, rObject.getFullName(false));
        } else {
            this.putValue(DATA, rObject2.getFullName(false));
            this.putValue(VARIABLE, rObject.getName(true));
        }
    }

    @Override
    public void setPreviewValues(PreviewOption previewOption) {
        if (this.isStringEmpty(DATA)) {
            this.setPreviewData(VARIABLE, previewOption);
            this.setPreviewData(CONDITIONING, previewOption);
        }
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getContentWidgetNode(viewOptions);
        if (!viewOptions.isWizard()) {
            return this.createTabPaneWithScript(widgetNode);
        }
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        WidgetNode widgetNode2 = this.getPreviewWidgetNode();
        if (widgetNode2 != null) {
            tabPaneWidgetNode.add(widgetNode2);
            tabPaneWidgetNode.add(new ViewWidgetNode(RConsoleResultView.class));
        }
        tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
        return this.createSplitPaneWidgetNode().addElements(widgetNode, tabPaneWidgetNode);
    }

    @Override
    protected int getSplitHeight() {
        return 200;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, VARIABLE, CONDITIONING, NINT, TYPE).addTabWithElements("Title", MAIN, SUB).addTabWithElements("Axis", new SplitPaneWidgetNode(false, 0.5f).addElements(new TitledPanelWidgetNode("X axis", true).addElements(X_LAB, X_MIN, X_MAX), new TitledPanelWidgetNode("Y axis", true).addElements(Y_LAB, Y_MIN, Y_MAX)).setGrowY(true)).addTabWithKeys("Select Rows", this.getSubsetKeys()).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string = "~ " + this.getValue(VARIABLE);
        if (!this.getValue(CONDITIONING).isEmpty()) {
            string = string + " | " + this.getValue(CONDITIONING);
        }
        String string2 = this.getValue(X_MIN).isEmpty() && this.getValue(X_MAX).isEmpty() ? "" : RUtility.combine((String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(X_MIN), (CharSequence)"NA"), (String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(X_MAX), (CharSequence)"NA"));
        String string3 = this.getValue(Y_MIN).isEmpty() && this.getValue(Y_MAX).isEmpty() ? "" : RUtility.combine((String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(Y_MIN), (CharSequence)"NA"), (String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(Y_MAX), (CharSequence)"NA"));
        String string4 = RUtility.function("lattice::histogram", this.getArgs(ADVANCED), "x", string, "data", this.getValue(DATA), "xlab", this.getValue(X_LAB), "xlim", string2, "ylab", this.getValue(Y_LAB), "ylim", string3, "type", this.getValue(TYPE), "nint", this.getValue(NINT), "main", this.getValue(MAIN), "sub", this.getValue(SUB), "subset", this.getSubset(this));
        return "print(" + string4 + ")";
    }
}

