/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RSubsetInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.MultipleKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TextWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RConsoleResultView;
import com.ef_prime.rflow.ui.app.r.RPlotPreviewView;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RLatticeXYPlot
extends ROperation
implements RSubsetInterface {
    private static final String AUTO_KEY_NONE = "NONE";
    private static final String AUTO_KEY_TOP = "TOP";
    private static final String AUTO_KEY_BOTTOM = "BOTTOM";
    private static final String AUTO_KEY_LEFT = "LEFT";
    private static final String AUTO_KEY_RIGHT = "RIGHT";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RChoiceKey X = ((RChoiceKey.Builder)RChoiceKey.builder("x", "X").setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    private static final RChoiceKey Y = ((RChoiceKey.Builder)RChoiceKey.builder("y", "Y").setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    private static final RChoiceKey GROUPS = ((RChoiceKey.Builder)RChoiceKey.builder("groups", "Group By").setCompletionSupport(RChoiceProvider.columns(DATA.getId(), true))).build();
    private static final RChoiceKey CONDITIONING = ((RChoiceKey.Builder)RChoiceKey.builder("conditioning", "Condition By").setCompletionSupport(RChoiceProvider.columns(DATA.getId(), true))).build();
    private static final BoolKey POINTS = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("points", "Draw points").setDefaultValue(Boolean.TRUE)).noLabel()).build();
    private static final BoolKey LINES = ((BoolKey.Builder)BoolKey.builder("lines", "Draw lines").noLabel()).build();
    private static final ChoiceKey LINE_TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("line_type", "").setValuesAndLabels(RLatticeXYPlot.sQuote("l"), "Lines", RLatticeXYPlot.sQuote("h"), "Vertical lines", RLatticeXYPlot.sQuote("s"), "Steps (horizontal first)", RLatticeXYPlot.sQuote("S"), "Steps (vertical first)")).addEnabledKeyLink(LINES, true)).build();
    private static final BoolKey SORT_BY_X = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("sort_by_x", "Sort by X axis").setDefaultValue(Boolean.TRUE)).addVisibleKeyLink(LINE_TYPE, RLatticeXYPlot.sQuote("l"))).noLabel()).build();
    private static final BoolKey FITTED_LINE = ((BoolKey.Builder)BoolKey.builder("fitted_line", "Draw fitted line").noLabel()).build();
    private static final ChoiceKey FITTED_LINE_TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("fitted_line_type", "").setValuesAndLabels(RLatticeXYPlot.sQuote("spline"), "Smoothing spline", RLatticeXYPlot.sQuote("smooth"), "Loess Smoother", RLatticeXYPlot.sQuote("r"), "Linear regression", RLatticeXYPlot.sQuote("a"), "Pointwise average")).addEnabledKeyLink(FITTED_LINE, true)).build();
    private static final BoolKey GRID = ((BoolKey.Builder)BoolKey.builder("grid", "Draw grid").noLabel()).build();
    private static final ChoiceKey GRID_TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("grid_type", "").setValuesAndLabels("TRUE", "Both", RLatticeXYPlot.sQuote("h"), "Horizontal", RLatticeXYPlot.sQuote("v"), "Vertical")).addEnabledKeyLink(GRID, true)).build();
    private static final BoolKey CHANGE_COLORS = ((BoolKey.Builder)((Key.Builder)((BoolKey.Builder)BoolKey.builder("change_colors", "Type").setDefaultValue(Boolean.TRUE)).setText("Colors")).addKeyLink(KeyLink.disabled(StrKeyTest.create(GROUPS, "")))).build();
    private static final BoolKey CHANGE_POINTS = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("change_points", "Points").noLabel()).addKeyLink(KeyLink.disabled(MultipleKeyTest.or(StrKeyTest.create(GROUPS, ""), BoolKeyTest.create(POINTS, false))))).build();
    private static final BoolKey CHANGE_LINES = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("change_lines", "Lines").noLabel()).addKeyLink(KeyLink.disabled(MultipleKeyTest.or(StrKeyTest.create(GROUPS, ""), MultipleKeyTest.and(BoolKeyTest.create(LINES, false), BoolKeyTest.create(FITTED_LINE, false)))))).build();
    private static final ChoiceKey AUTO_KEY = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("auto.key", "Legends").setValuesAndLabels("NONE", "None", "TOP", "Top", "BOTTOM", "Bottom", "LEFT", "Left", "RIGHT", "Right")).setDefaultValue("RIGHT")).addKeyLink(KeyLink.disabled(StrKeyTest.create(GROUPS, "")))).build();
    private static final RStrKey MAIN = ((RStrKey.Builder)RStrKey.builder("main", "Title").setCharSupport(true)).build();
    private static final RStrKey SUB = ((RStrKey.Builder)RStrKey.builder("sub", "Subtitle").setCharSupport(true)).build();
    private static final RStrKey X_LAB = ((RStrKey.Builder)RStrKey.builder("xlab", "Title").setCharSupport(true)).build();
    private static final RStrKey X_MIN = RStrKey.builder("xmin", "Min").build();
    private static final RStrKey X_MAX = RStrKey.builder("xmax", "Max").build();
    private static final RChoiceKey X_LOG_SCALE = RLatticeXYPlot.logicalKey("x_log_scale", "Log Scale", "");
    private static final RStrKey Y_LAB = ((RStrKey.Builder)RStrKey.builder("ylab", "Title").setCharSupport(true)).build();
    private static final RStrKey Y_MIN = RStrKey.builder("ymin", "Min").build();
    private static final RStrKey Y_MAX = RStrKey.builder("ymax", "Max").build();
    private static final RChoiceKey Y_LOG_SCALE = RLatticeXYPlot.logicalKey("y_log_scale", "Log Scale", "");
    private static final RTableKey ADVANCED = RLatticeXYPlot.argsKey("lattice:::xyplot.formula", "lattice::xyplot", "xlim", "ylim", "scales");

    @Override
    public Version getVersion() {
        return new Version(0, 2, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, X, Y, GROUPS, CHANGE_COLORS, CHANGE_POINTS, CHANGE_LINES, AUTO_KEY, CONDITIONING, POINTS, LINES, LINE_TYPE, SORT_BY_X, FITTED_LINE, FITTED_LINE_TYPE, GRID, GRID_TYPE, MAIN, SUB, X_LAB, X_MIN, X_MAX, X_LOG_SCALE, Y_LAB, Y_MIN, Y_MAX, Y_LOG_SCALE, ADVANCED);
        this.registerKeys(this.getSubsetKeys());
    }

    @Override
    public RPackage[] getRPackages() {
        return new RPackage[]{new RPackage("lattice", true, false)};
    }

    @Override
    protected String getDefaultTitle() {
        return "X-Y Plot";
    }

    @Override
    public String getOpClass() {
        return "chart";
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return new ViewWidgetNode(RPlotPreviewView.class);
    }

    @Override
    public boolean canImport(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.isEmpty() || list.size() > 2) {
            return false;
        }
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        RObject rObject = list.get(0);
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null || rObject.inherits("data.frame")) {
            this.putValue(DATA, rObject.getFullName(false));
        } else {
            this.putValue(DATA, rObject2.getFullName(false));
            this.putValue(X, rObject.getName(true));
            if (list.size() > 1) {
                this.putValue(Y, list.get(1).getName(true));
            }
        }
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getContentWidgetNode(viewOptions);
        if (!viewOptions.isWizard()) {
            return this.createTabPaneWithScript(widgetNode);
        }
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        WidgetNode widgetNode2 = this.getPreviewWidgetNode();
        if (widgetNode2 != null) {
            tabPaneWidgetNode.add(widgetNode2);
            tabPaneWidgetNode.add(new ViewWidgetNode(RConsoleResultView.class));
        }
        tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
        return this.createSplitPaneWidgetNode().addElements(widgetNode, tabPaneWidgetNode);
    }

    @Override
    protected int getSplitHeight() {
        return 225;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        ButtonWidgetNode buttonWidgetNode = new ButtonWidgetNode("Swap X and Y", "swap_xy").setIconOnly(true).setIconPath("16/arrow_switch.png");
        KeyLink keyLink = KeyLink.invisible(StrKeyTest.create(GROUPS, ""));
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, X, new XFlowPanelWidgetNode(true).addElements(Y, buttonWidgetNode), GROUPS, CONDITIONING).addTabWithElements("Options", POINTS, new XFlowPanelWidgetNode(true).addElements(LINES, LINE_TYPE), PanelWidgetNode.indent().addElements(SORT_BY_X).addKeyLinks(SORT_BY_X.getKeyLinks()), new XFlowPanelWidgetNode(true).addElements(FITTED_LINE, FITTED_LINE_TYPE), new XFlowPanelWidgetNode(true).addElements(GRID, GRID_TYPE), new TextWidgetNode("Group By").addKeyLink(keyLink), PanelWidgetNode.indent().addElements(AUTO_KEY, new XFlowPanelWidgetNode(true).addElements(CHANGE_COLORS, CHANGE_POINTS, CHANGE_LINES)).addKeyLink(keyLink)).addTabWithElements("Title", MAIN, SUB).addTabWithElements("Axis", new SplitPaneWidgetNode(false, 0.5f).addElements(new TitledPanelWidgetNode("X axis", true).addElements(X_LAB, X_MIN, X_MAX, X_LOG_SCALE), new TitledPanelWidgetNode("Y axis", true).addElements(Y_LAB, Y_MIN, Y_MAX, Y_LOG_SCALE)).setGrowY(true)).addTabWithKeys("Select Rows", this.getSubsetKeys()).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if ("swap_xy".equals(string)) {
            String string2 = this.getValue(X);
            this.putValue(X, this.getValue(Y));
            this.putValue(Y, string2);
        }
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        Object object;
        Object object2 = this.getValue(DATA);
        String string = this.getValue(X);
        if (this.isEnabled(SORT_BY_X) && this.getValue(SORT_BY_X).booleanValue()) {
            object2 = (String)object2 + "[with(" + (String)object2 + ", order(" + string + ")), ]";
        }
        String string2 = this.getValue(Y) + " ~ " + string;
        if (!this.getValue(CONDITIONING).isEmpty()) {
            string2 = string2 + " | " + this.getValue(CONDITIONING);
        }
        String string3 = this.getValue(X_MIN).isEmpty() && this.getValue(X_MAX).isEmpty() ? "" : RUtility.combine((String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(X_MIN), (CharSequence)"NA"), (String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(X_MAX), (CharSequence)"NA"));
        String string4 = this.getValue(Y_MIN).isEmpty() && this.getValue(Y_MAX).isEmpty() ? "" : RUtility.combine((String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(Y_MIN), (CharSequence)"NA"), (String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(Y_MAX), (CharSequence)"NA"));
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (this.getValue(POINTS).booleanValue()) {
            arrayList.add(RLatticeXYPlot.sQuote("p"));
        }
        if (this.getValue(LINES).booleanValue()) {
            arrayList.add(this.getValue(LINE_TYPE));
        }
        if (this.getValue(FITTED_LINE).booleanValue()) {
            arrayList.add(this.getValue(FITTED_LINE_TYPE));
        }
        String string5 = arrayList.isEmpty() ? "NULL" : RUtility.combine(arrayList);
        String string6 = this.getValue(GRID) != false ? this.getValue(GRID_TYPE) : "";
        String string7 = "";
        if (this.isEnabled(CHANGE_COLORS)) {
            object = new ArgsList();
            ArgsList argsList = new ArgsList();
            if (!this.getValue(CHANGE_COLORS).booleanValue()) {
                ((ArgsList)object).add("col", "lattice::trellis.par.get(\"superpose.symbol\")$col[1]");
                argsList.add("col", "lattice::trellis.par.get(\"superpose.line\")$col[1]");
            }
            if (this.getValue(CHANGE_POINTS).booleanValue()) {
                ((ArgsList)object).add("pch", "seq_along(lattice::trellis.par.get(\"superpose.symbol\")$pch)");
            }
            if (this.getValue(CHANGE_LINES).booleanValue()) {
                argsList.add("lty", "seq_along(lattice::trellis.par.get(\"superpose.line\")$lty)");
            }
            ArgsList argsList2 = new ArgsList();
            if (!((ArrayList)object).isEmpty()) {
                argsList2.add("superpose.symbol", RUtility.function("list", (Collection<String>)object));
            }
            if (!argsList.isEmpty()) {
                argsList2.add("superpose.line", RUtility.function("list", argsList));
            }
            if (!argsList2.isEmpty()) {
                string7 = RUtility.function("list", argsList2);
            }
        }
        object = RUtility.function("lattice::xyplot", this.getArgs(ADVANCED), new String[]{"x", string2, "data", object2, "auto.key", this.getAutoKey(), "scales", this.getScales(), "groups", this.getValue(GROUPS), "xlab", this.getValue(X_LAB), "xlim", string3, "ylab", this.getValue(Y_LAB), "ylim", string4, "type", string5, "grid", string6, "main", this.getValue(MAIN), "sub", this.getValue(SUB), "par.settings", string7, "subset", this.getSubset(this)});
        return "print(" + (String)object + ")";
    }

    private String getAutoKey() {
        if (!this.isEnabled(AUTO_KEY)) {
            return "";
        }
        switch (this.getValue(AUTO_KEY)) {
            case "NONE": {
                return "FALSE";
            }
            case "TOP": {
                return "list(space = \"top\")";
            }
            case "BOTTOM": {
                return "list(space = \"bottom\")";
            }
            case "LEFT": {
                return "list(space = \"left\")";
            }
            case "RIGHT": {
                return "list(space = \"right\")";
            }
        }
        return "";
    }

    private String getScales() {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (!this.getValue(X_LOG_SCALE).isEmpty()) {
            string2 = RUtility.function("list", "log", this.getValue(X_LOG_SCALE), "equispaced.log", this.getValue(X_LOG_SCALE).equals("FALSE") ? "" : "FALSE");
        }
        if (!this.getValue(Y_LOG_SCALE).isEmpty()) {
            string3 = RUtility.function("list", "log", this.getValue(Y_LOG_SCALE), "equispaced.log", this.getValue(Y_LOG_SCALE).equals("FALSE") ? "" : "FALSE");
        }
        if (!string2.isEmpty() || !string3.isEmpty()) {
            string = RUtility.function("list", "x", string2, "y", string3);
        }
        return string;
    }
}

