/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TitleLink;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RManageObjects
extends ROperation {
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_DELETE = "delete";
    private static final String COMMAND_RENAME = "rename";
    private static final ChoiceKey COMMAND = ((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValuesAndLabels("copy", "Copy", "delete", "Delete", "rename", "Rename")).build();
    private static final RChoiceKey TABLE_OBJECT = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("table_object", "Object").setChoiceEditable(true)).setRequired(true)).setChoiceProvider(RChoiceProvider.globalObjects(false))).build();
    private static final StrKey TABLE_DEST = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)StrKey.builder("table_dest", "Copy to").setRequired(true)).addVisibleKeyLink(COMMAND, "copy", "rename")).setTitleLink(new TitleLink(RManageObjects::tableDestTitle, COMMAND))).build();
    private static final RTableKey TABLE = ((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("table", "Table", TABLE_OBJECT, TABLE_DEST).setUiControls(GeneralTableModel.UI_DEFAULT2)).setDefaultRowPredicate()).build();
    private static final ChoiceKey RESOURCE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("resource", "").setValuesAndLabels("copy", "Copy to", "rename", "Rename to")).setNoSave(true)).build();
    @Deprecated
    private static final StrKey TABLE_ASSIGN_TO = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("table_assign_to", "Copy to").setRequired(true)).setObsolete(true)).build();
    @Deprecated
    private static final RTableKey ASSIGN_TABLE = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("assign_table", "Table", TABLE_OBJECT, TABLE_ASSIGN_TO).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(COMMAND, "copy")).setDefaultRowPredicate()).setNoSave(true)).setObsolete(true)).build();
    @Deprecated
    private static final RTableKey DELETE_TABLE = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("delete_table", "Object", TABLE_OBJECT).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(COMMAND, "delete")).setDefaultRowPredicate()).setNoSave(true)).setObsolete(true)).build();
    @Deprecated
    private static final StrKey TABLE_RENAME_TO = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("table_rename_to", "Rename to").setRequired(true)).setObsolete(true)).build();
    @Deprecated
    private static final RTableKey RENAME_TABLE = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("rename_table", "Table", TABLE_OBJECT, TABLE_RENAME_TO).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(COMMAND, "rename")).setDefaultRowPredicate()).setNoSave(true)).setObsolete(true)).build();

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            KeysTableModel keysTableModel = this.getValue(TABLE);
            switch (this.getValue(COMMAND)) {
                case "copy": {
                    for (KeysTableRow keysTableRow : this.getValue(ASSIGN_TABLE)) {
                        if (keysTableRow.getColumnCount() <= 1) continue;
                        keysTableModel.addNewRow(keysTableRow.getValue(0), keysTableRow.getValue(1));
                    }
                    break;
                }
                case "rename": {
                    for (KeysTableRow keysTableRow : this.getValue(RENAME_TABLE)) {
                        if (keysTableRow.getColumnCount() <= 1) continue;
                        keysTableModel.addNewRow(keysTableRow.getValue(0), keysTableRow.getValue(1));
                    }
                    break;
                }
                case "delete": {
                    for (KeysTableRow keysTableRow : this.getValue(DELETE_TABLE)) {
                        if (keysTableRow.getColumnCount() <= 0) continue;
                        keysTableModel.addNewRow(keysTableRow.getValue(0), "");
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(COMMAND, TABLE, RESOURCE, ASSIGN_TABLE, DELETE_TABLE, RENAME_TABLE);
    }

    @Override
    protected String getDefaultTitle() {
        return "Manage Objects";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return RObjectFlavor.isSupported(transferable);
    }

    @Override
    protected void importValues(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.importToTableFullName(TABLE, 0, list);
    }

    @Override
    protected String[] getNewRObjects() {
        switch (this.getValue(COMMAND)) {
            case "copy": 
            case "rename": {
                return this.getValue(TABLE).getValidValues(TABLE_DEST).toArray(new String[0]);
            }
        }
        return super.getNewRObjects();
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        switch (this.getValue(COMMAND)) {
            case "copy": {
                return this.copyCommand(previewOption);
            }
            case "delete": {
                return this.deleteCommand(previewOption);
            }
            case "rename": {
                return this.renameCommand(previewOption);
            }
        }
        throw new RuntimeException("Invalid command.");
    }

    private String copyCommand(PreviewOption previewOption) {
        ScriptBuilder scriptBuilder = RManageObjects.scriptBuilder();
        KeysTableModel keysTableModel = this.getValue(TABLE);
        List<String> list = keysTableModel.getValidValues(TABLE_OBJECT);
        List<String> list2 = keysTableModel.getValidValues(TABLE_DEST);
        if (list.isEmpty()) {
            return "";
        }
        if (!CollectionUtils.containsAny(list, list2)) {
            for (KeysTableRow keysTableRow : keysTableModel.validRows()) {
                String string = keysTableRow.getValue(TABLE_OBJECT);
                if (previewOption.isEnabled()) {
                    scriptBuilder.appendLn(RUtility.assign(string, string));
                }
                scriptBuilder.appendLn(RUtility.assign(keysTableRow.getValue(TABLE_DEST), string));
            }
        } else {
            scriptBuilder.appendLn("local({").indent();
            scriptBuilder.appendLn("from <- " + RUtility.combineCharacters(list));
            scriptBuilder.appendLn("to <- " + RUtility.combineCharacters(list2));
            scriptBuilder.appendLn();
            if (!previewOption.isEnabled()) {
                scriptBuilder.appendLn("source <- mget(from, envir = sys.frame(-2))");
            } else {
                scriptBuilder.appendLn("for (i in seq_along(from))");
                scriptBuilder.appendLn("\tassign(from[i], value = get(from[i]), pos = sys.frame(-2))");
                scriptBuilder.appendLn("source <- mget(from, envir = sys.frame(-2))");
            }
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("for (i in seq_along(to))");
            scriptBuilder.appendLn("\tassign(to[i], value = source[[i]], pos = sys.frame(-2))");
            scriptBuilder.unind_Ln("})");
        }
        return scriptBuilder.toString();
    }

    private String deleteCommand(PreviewOption previewOption) {
        if (previewOption.isEnabled()) {
            return "";
        }
        List<String> list = this.getValue(TABLE).getValidValues(TABLE_OBJECT);
        if (list.isEmpty()) {
            return "";
        }
        return "rm(" + StringUtils.join(list, (String)", ") + ")";
    }

    private String renameCommand(PreviewOption previewOption) {
        ScriptBuilder scriptBuilder = RManageObjects.scriptBuilder();
        KeysTableModel keysTableModel = this.getValue(TABLE);
        List<String> list = keysTableModel.getValidValues(TABLE_OBJECT);
        List<String> list2 = keysTableModel.getValidValues(TABLE_DEST);
        if (list.isEmpty()) {
            return "";
        }
        if (!CollectionUtils.containsAny(list, list2)) {
            for (KeysTableRow keysTableRow : keysTableModel.validRows()) {
                String string = keysTableRow.getValue(TABLE_OBJECT);
                scriptBuilder.append(RUtility.assign(keysTableRow.getValue(TABLE_DEST), string));
                if (previewOption.isEnabled()) {
                    scriptBuilder.appendLn();
                    continue;
                }
                scriptBuilder.appendLn("; rm(" + string + ")");
            }
        } else {
            String string = RUtility.combineCharacters(list);
            String string2 = RUtility.combineCharacters(list2);
            scriptBuilder.appendLn("local({").indent();
            scriptBuilder.appendLn("from <- " + string);
            scriptBuilder.appendLn("to <- " + string2);
            scriptBuilder.appendLn();
            if (!previewOption.isEnabled()) {
                scriptBuilder.appendLn("source <- mget(from, envir = sys.frame(-2))");
            } else {
                scriptBuilder.appendLn("source <- mget(from, envir = sys.frame(-2), inherits = TRUE)");
            }
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("for (i in seq_along(to))");
            scriptBuilder.appendLn("\tassign(to[i], value = source[[i]], pos = sys.frame(-2))");
            if (!previewOption.isEnabled()) {
                scriptBuilder.appendLn();
                scriptBuilder.appendLn("rm(list = setdiff(from, to), pos = sys.frame(-2))");
            }
            scriptBuilder.unind_Ln("})");
        }
        return scriptBuilder.toString();
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new PanelWidgetNode().addKeys(COMMAND, TABLE);
    }

    private static String tableDestTitle(ValueMap valueMap) {
        String string = RESOURCE.getLabel(valueMap.getValue(COMMAND), valueMap);
        return string == null ? TABLE_DEST.getTitle() : string;
    }
}

