/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.RMerge;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RArgsKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.common.table.AbstractGeneralTableModel;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.common.table.RowBasedTableModel;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class RMerge2
extends ROperation {
    private static final String INNER = "inner";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String FULL = "full";
    private static final String ROW = "row";
    private static final String COLUMN = "column";
    private static final RChoiceKey X = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("x", "Input (X)").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RChoiceKey Y = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("y", "Input (Y)").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setDefaultValue("merged")).setRequired(true)).setOutput(true)).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValues("inner", "left", "right", "full", "row", "column")).setLabels("Inner Join", "Left Outer Join", "Right Outer Join", "Full Outer Join", "Append Rows", "Append Columns")).build();
    private static final ChoiceKey MATCH_X = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("match_x", "X").setChoiceProvider(RChoiceProvider.columns(X, false))).setChoiceEditable(true)).setDynamicDefault(true)).build();
    private static final ChoiceKey MATCH_Y = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("match_y", "Y").setChoiceProvider(RChoiceProvider.columns(Y, false))).setChoiceEditable(true)).setDynamicDefault(true)).build();
    private static final RTableKey MATCH_COLUMNS = ((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("match_columns", "Matching Columns", MATCH_X, MATCH_Y).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(TYPE, "inner", "left", "right", "full")).build();
    private static final BoolKey REMOVE_ROW_NAME = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("remove_row_name", "Remove Row Names").addVisibleKeyLink(TYPE, "row")).setLabelPosition("none")).build();
    private static final BoolKey UNIQUE_COLUMN_NAME = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("unique_column_name", "Make Column Names Unique").setDefaultValue(true)).addVisibleKeyLink(TYPE, "column")).setLabelPosition("none")).build();
    private static final RStrKey SUFFIXES_X = ((RStrKey.Builder)RStrKey.builder("suffixes_x", "X").setDefaultMessage(RMerge2.quote(".x"))).build();
    private static final RStrKey SUFFIXES_Y = ((RStrKey.Builder)RStrKey.builder("suffixes_y", "Y").setDefaultMessage(RMerge2.quote(".y"))).build();
    private static final ChoiceKey ARGS_SWITCH = RMerge2.argsSwitchKey("args_switch", new AutoValueLink(true, TYPE), "merge", "rbind", "cbind");
    private static final RArgsKey ARGS_MERGE = RMerge2.argsKey("args_merge", "merge.data.frame", "merge", ARGS_SWITCH, "all", "all.x", "all.y", "by", "by.x", "by.y", "suffixes");
    private static final RArgsKey ARGS_RBIND = RMerge2.argsKey("args_rbind", "rbind.data.frame", "rbind", ARGS_SWITCH, new String[0]);
    private static final RArgsKey ARGS_CBIND = RMerge2.argsKey("args_cbind", "cbind.data.frame", "cbind", ARGS_SWITCH, new String[0]);

    public RMerge2() {
    }

    public RMerge2(RMerge rMerge) {
        String string;
        this.putValue(OUTPUT, rMerge.getValue(RMerge.KEY_OUTPUT));
        switch (string = rMerge.getValue(RMerge.KEY_TYPE)) {
            case "row": 
            case "column": {
                this.putValue(TYPE, string.equals(ROW) ? ROW : COLUMN);
                List<String> list = rMerge.getValue(RMerge.KEY_DATA).getValues(RMerge.COL_DATA);
                if (list.size() > 0) {
                    this.putValue(X, list.get(0));
                }
                if (list.size() > 1) {
                    this.putValue(Y, list.get(1));
                }
                this.putValue(REMOVE_ROW_NAME, rMerge.getValue(RMerge.KEY_REMOVE_ROW_NAME));
                this.putValue(UNIQUE_COLUMN_NAME, rMerge.getValue(RMerge.KEY_UNIQUE_COLUMN_NAME));
                break;
            }
            case "key": {
                this.putValue(TYPE, INNER);
                this.putValue(X, rMerge.getValue(RMerge.KEY_X));
                this.putValue(Y, rMerge.getValue(RMerge.KEY_Y));
                break;
            }
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(X, Y, OUTPUT, TYPE, MATCH_COLUMNS, REMOVE_ROW_NAME, UNIQUE_COLUMN_NAME, SUFFIXES_X, SUFFIXES_Y, ARGS_SWITCH, ARGS_MERGE, ARGS_RBIND, ARGS_CBIND);
    }

    @Override
    public String getDefaultTitle() {
        return "Merge";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return X;
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (ARGS_SWITCH.equals(key)) {
            switch (this.getValue(TYPE)) {
                case "inner": 
                case "left": 
                case "right": 
                case "full": {
                    return ARGS_MERGE.getFunctionLabel();
                }
                case "row": {
                    return ARGS_RBIND.getFunctionLabel();
                }
                case "column": {
                    return ARGS_CBIND.getFunctionLabel();
                }
            }
        }
        return super.getAutoValue(key);
    }

    @Override
    public Object getDynamicDefaultValue(KeysTableModel keysTableModel, int n, Key<?> key) {
        String string;
        if (key == MATCH_X) {
            String string2 = ((KeysTableRow)keysTableModel.getRow(n)).getValue(MATCH_Y);
            if (!string2.isEmpty()) {
                return string2;
            }
        } else if (key == MATCH_Y && !(string = ((KeysTableRow)keysTableModel.getRow(n)).getValue(MATCH_X)).isEmpty()) {
            return string;
        }
        return super.getDynamicDefaultValue(keysTableModel, n, key);
    }

    @Override
    protected void importValues(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.putValue(X, list.get(0).getFullName(false));
        if (list.size() > 1) {
            this.putValue(Y, list.get(1).getFullName(false));
        }
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        switch (this.getValue(TYPE)) {
            case "inner": 
            case "left": 
            case "right": 
            case "full": {
                return this.merge();
            }
            case "row": {
                return this.rbind();
            }
            case "column": {
                return this.cbind();
            }
        }
        throw new RuntimeException("Invalid Type: " + this.getValue(TYPE));
    }

    private String merge() {
        Object object;
        ArgsList argsList = new ArgsList();
        argsList.add("x", this.getValue(X));
        argsList.add("y", this.getValue(Y));
        switch (this.getValue(TYPE)) {
            case "inner": {
                argsList.add("all", "FALSE");
                break;
            }
            case "left": {
                argsList.add("all.x", "TRUE");
                argsList.add("all.y", "FALSE");
                break;
            }
            case "right": {
                argsList.add("all.x", "FALSE");
                argsList.add("all.y", "TRUE");
                break;
            }
            case "full": {
                argsList.add("all", "TRUE");
            }
        }
        Object object2 = this.getValue(MATCH_COLUMNS);
        if (((RowBasedTableModel)object2).getRowCount() > 0) {
            List<String> list = ((AbstractGeneralTableModel)object2).getValues(MATCH_X);
            object = ((AbstractGeneralTableModel)object2).getValues(MATCH_Y);
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                String string2 = (String)object.get(i);
                if (string.isEmpty()) {
                    list.set(i, string2);
                    string = string2;
                }
                if (string2.isEmpty()) {
                    object.set(i, string);
                    string2 = string;
                }
                if (!bl || string.equals(string2)) continue;
                bl = false;
            }
            if (bl) {
                argsList.add("by", RUtility.combineCharacters(list));
            } else {
                argsList.add("by.x", RUtility.combineCharacters(list));
                argsList.add("by.y", RUtility.combineCharacters((Collection<String>)object));
            }
        }
        String string = this.getValue(SUFFIXES_X);
        object = this.getValue(SUFFIXES_Y);
        if (!string.isEmpty() || !((String)object).isEmpty()) {
            if (string.isEmpty()) {
                string = RMerge2.quote(".x");
            }
            if (((String)object).isEmpty()) {
                object = RMerge2.quote(".y");
            }
            argsList.add("suffixes", RUtility.combine(new String[]{string, object}));
        }
        argsList.addAll(this.getArgs(ARGS_MERGE));
        return RUtility.assignFunction(this.getValue(OUTPUT), "merge", argsList);
    }

    private String rbind() {
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        scriptBuilder.appendLn(RUtility.assignFunction(this.getValue(OUTPUT), "rbind", this.getArgs(ARGS_RBIND), "", this.getValue(X), "", this.getValue(Y)));
        if (this.getValue(REMOVE_ROW_NAME).booleanValue()) {
            scriptBuilder.appendLn("row.names(" + this.getValue(OUTPUT) + ") <- NULL");
        }
        return scriptBuilder.toString();
    }

    private String cbind() {
        ScriptBuilder scriptBuilder = new ScriptBuilder("\n");
        scriptBuilder.appendLn(RUtility.assignFunction(this.getValue(OUTPUT), "cbind", this.getArgs(ARGS_CBIND), "", this.getValue(X), "", this.getValue(Y)));
        if (this.getValue(UNIQUE_COLUMN_NAME).booleanValue()) {
            scriptBuilder.appendLn("colnames(" + this.getValue(OUTPUT) + ") <- make.unique(colnames(" + this.getValue(OUTPUT) + "), sep = \".\")");
        }
        return scriptBuilder.toString();
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        ButtonWidgetNode buttonWidgetNode = new ButtonWidgetNode("Swap X and Y", "swap_xy").setIconOnly(true).setIconPath("16/arrow_switch.png");
        return new TabPaneWidgetNode().addTabWithElements("Main", X, new XFlowPanelWidgetNode(true).addElements(Y, buttonWidgetNode), OUTPUT, TYPE, MATCH_COLUMNS, REMOVE_ROW_NAME, UNIQUE_COLUMN_NAME).addTabWithElements("Options", new TitledPanelWidgetNode("Suffixes for Duplicate Columns", true).addElements(SUFFIXES_X, SUFFIXES_Y)).addTabWithElements("Advanced", ARGS_SWITCH, ARGS_MERGE, ARGS_RBIND, ARGS_CBIND).setAutoUpdate(true);
    }

    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if ("swap_xy".equals(string)) {
            String string2 = this.getValue(X);
            this.putValue(X, this.getValue(Y));
            this.putValue(Y, string2);
        }
    }
}

