/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.RModelInterface;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.node.ui.OpManager;
import java.util.List;

public class RModel
extends ROperation
implements RModelInterface {
    private static final StrKey NAME = StrKey.builder("name", "Output Name").build();
    private static final ChoiceKey DEFAULT_NAMES = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("def_names", "").setValuesAndLabels("lm", "Regression", "logit", "Logistic", "multinom", "Multinomial", "glm", "GLM", "rpart", "Tree", "nnet", "Neural", "ranger", "RandomForest", "xgboost", "Boosting", "glmnet", "ElasticNet")).setNoSave(true)).build();
    private static final ChoiceKey MODEL_ARGS_SWITCH = ((ChoiceKey.Builder)ChoiceKey.builder("args_switch", "").setChoiceProvider(new FunctionsProvider())).build();

    public RModel() {
        this.addLookUpKey("data");
    }

    @Override
    protected void initKeys() {
        this.registerKeys(NAME, METHOD, FAMILY, EXCLUDE_INTERCEPT, INCLUDE_INTERACTION, STEPWISE, STEPWISE_DIRECTION, USE_LOWER, LOWER_FORMULA_TYPE, LOWER_X, LOWER_FORMULA_OBJECT, LOWER_FORMULA_TEXT, RPART_METHOD, RPART_AUTO_PRUNING, RPART_CP, RPART_PRUNING, RPART_AUTO_CP, RPART_MANUAL_CP, RPART_XVAL, RPART_MINSPLIT, RPART_MINBUCKET, RPART_MAX_DEPTH, NNET_SIZE, NNET_DECAY, NNET_MAXIT, RANGER_MTRY, RANGER_NUM_TREES, RANGER_MIN_NODE_SIZE, RANGER_IMPORTANCE, RANGER_AUTO_PROB, RANGER_CLASSIFY_BINARY, XGBOOST_CV, XGBOOST_CV_NFOLDS, XGBOOST_CV_MAXIT, XGBOOST_CV_EARLY_STOP, XGBOOST_NROUNDS, XGBOOST_IMPORTANCE, XGBOOST_MAX_DEPTH, XGBOOST_ETA, GLMNET_FAMILY, GLMNET_TYPE, GLMNET_ALPHA_GRID, GLMNET_NFOLDS, SUBSET_TYPE, SUBSET_LOGICAL, SUBSET_CONDITIONS, WEIGHTS, MODEL_ARGS_SWITCH, ARGS_LM, ARGS_GLM, ARGS_MULTINOM, ARGS_RPART, ARGS_RPART_CONTROL, ARGS_NNET, ARGS_RANGER, ARGS_XGBOOST, ARGS_XGBOOST_CV, ARGS_GLMNET, ARGS_CV_GLMNET, ARGS_STEP, DEFAULT_NAMES);
    }

    @Override
    protected String getDefaultTitle() {
        return "Model";
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        return this.getContentWidgetNode(viewOptions);
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements(this.getMethodLabel(), NAME, this.getModelWidgetNode()).addTabWithElements("Advanced", MODEL_ARGS_SWITCH, ARGS_LM, ARGS_GLM, ARGS_MULTINOM, ARGS_RPART, ARGS_RPART_CONTROL, ARGS_NNET, ARGS_RANGER, ARGS_XGBOOST, ARGS_XGBOOST_CV, ARGS_GLMNET, ARGS_STEP);
    }

    public String getName() {
        return this.getValue(NAME);
    }

    public void setName(String string) {
        this.putValue(NAME, string);
    }

    public String getDefaultName() {
        return DEFAULT_NAMES.getChoice(this.getValue(METHOD)).getLabel();
    }

    public String getMethodLabel() {
        return METHOD.getChoice(this.getValue(METHOD)).getLabel();
    }

    public String toString() {
        return this.getValue(NAME);
    }

    @Override
    protected void processValueChanged(ValueChangeEvent valueChangeEvent) {
        List<Choice> list;
        super.processValueChanged(valueChangeEvent);
        if (METHOD.equals(valueChangeEvent.getKey()) && (list = MODEL_ARGS_SWITCH.getChoices(this)).size() > 0) {
            this.putValue(MODEL_ARGS_SWITCH, list.get(0).getValue());
        }
    }

    static {
        OpManager.getInstance().add(new RModel());
    }

    private static class FunctionsProvider
    implements ChoiceProvider {
        private FunctionsProvider() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            switch (valueMap.getValue(RModelInterface.METHOD)) {
                case "lm": {
                    return this.toChoices("lm", "step");
                }
                case "logit": {
                    return this.toChoices("glm", "step");
                }
                case "multinom": {
                    return this.toChoices("nnet::multinom", "step");
                }
                case "glm": {
                    return this.toChoices("glm", "step");
                }
                case "rpart": {
                    return this.toChoices("rpart::rpart", "rpart::rpart.control");
                }
                case "nnet": {
                    return this.toChoices("nnet::nnet");
                }
                case "ranger": {
                    return this.toChoices("ranger::ranger");
                }
                case "xgboost": {
                    return this.toChoices("xgboost::xgboost", "xgboost::xgb.cv");
                }
                case "glmnet": {
                    return this.toChoices("glmnet::glmnet", "glmnet::cv.glmnet");
                }
            }
            return this.toChoices("");
        }
    }
}

