/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.RFormRowSelector;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RSimpleRowSelector;
import com.ef_prime.rflow.core.app.r.keyvalue.RArgsKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTextKey;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ComponentTableKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.UIInterfaceInitializer;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface RModelInterface {
    public static final String FORMULA_TYPE_TEXT = "Text";
    public static final String FORMULA_TYPE_UI = "UI";
    public static final String FORMULA_TYPE_OBJECT = "Object";
    public static final String METHOD_LM = "lm";
    public static final String METHOD_LOGIT = "logit";
    public static final String METHOD_MULTINOM = "multinom";
    public static final String METHOD_GLM = "glm";
    public static final String METHOD_RPART = "rpart";
    public static final String METHOD_NNET = "nnet";
    public static final String METHOD_RANGER = "ranger";
    public static final String METHOD_XGBOOST = "xgboost";
    public static final String METHOD_GLMNET = "glmnet";
    public static final String STEPWISE_BACKWARD_BOTH = "backward_both";
    public static final String STEPWISE_FORWARD_BOTH = "forward_both";
    public static final String STEPWISE_BACKWARD = "backward";
    public static final String STEPWISE_FORWARD = "forward";
    public static final String TYPE_INCLUDE = "include";
    public static final String TYPE_EXCLUDE = "exclude";
    public static final String GLMNET_TYPE_GRID = "grid_search";
    public static final String GLMNET_TYPE_LASSO = "lasso";
    public static final String GLMNET_TYPE_RIDGE = "ridge";
    public static final String LOGICAL_AND = "AND";
    public static final String LOGICAL_OR = "OR";
    @Deprecated
    public static final String PRUNING_AUTO = "auto";
    @Deprecated
    public static final String PRUNING_MANUAL = "manual";
    public static final String ENTROPY_OFF = "off";
    public static final String ENTROPY_ON = "on";
    public static final String DATA_ID = "data";
    public static final Map<String, String> METHOD_PACKAGE_MAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(RModelInterface.METHOD_MULTINOM, RModelInterface.METHOD_NNET);
            this.put(RModelInterface.METHOD_RPART, RModelInterface.METHOD_RPART);
            this.put(RModelInterface.METHOD_NNET, RModelInterface.METHOD_NNET);
            this.put(RModelInterface.METHOD_RANGER, RModelInterface.METHOD_RANGER);
            this.put(RModelInterface.METHOD_XGBOOST, RModelInterface.METHOD_XGBOOST);
            this.put(RModelInterface.METHOD_GLMNET, RModelInterface.METHOD_GLMNET);
        }
    });
    public static final ChoiceKey METHOD = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("method", "Method").setValuesAndLabels("lm", "Linear Regression", "logit", "Logistic Regression", "multinom", "Multinomial Logistic Regression", "glm", "Generalized Linear Models", "rpart", "Tree Models", "nnet", "Neural Networks", "ranger", "Random Forests", "xgboost", "Gradient Boosting", "glmnet", "Elastic Net")).setRequiredRPackageMap(METHOD_PACKAGE_MAP)).build();
    public static final BoolKey EXCLUDE_INTERCEPT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("exclude_intercept", "Exclude intercept").addVisibleKeyLink(METHOD, "lm", "logit", "multinom", "glm", "glmnet")).setLabelPosition("none")).build();
    public static final BoolKey INCLUDE_INTERACTION = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("include_interaction", "Include interaction").addVisibleKeyLink(METHOD, "lm", "logit", "multinom", "glm", "glmnet")).setLabelPosition("none")).build();
    public static final BoolKey STEPWISE = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("stepwise", "Stepwise").addVisibleKeyLink(METHOD, "lm", "logit", "multinom", "glm")).setLabelPosition("none")).build();
    public static final ChoiceKey STEPWISE_DIRECTION = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("stepwise_direction", "Search Direction").setValuesAndLabels("forward", "Forward Selection", "backward", "Backward Elimination", "forward_both", "Forward Stepwise", "backward_both", "Backward Stepwise")).addVisibleKeyLink(STEPWISE, true)).build();
    public static final BoolKey USE_LOWER = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("lower", "Always include:").addVisibleKeyLink(STEPWISE, true)).setLabelPosition("none")).build();
    public static final RadioButtonKey LOWER_FORMULA_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("lower_formula", "Model Formula").setValuesAndLabels("UI", "GUI", "Object", "Formula Object", "Text", "Direct Input")).setLabelPosition("none")).build();
    public static final RChoiceKey FORMULA_COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("formula_column", "X").setCompletionSupport(RChoiceProvider.columns("data", true))).build();
    public static final RTableKey LOWER_X = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("lower_x", "Input (X)", FORMULA_COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(LOWER_FORMULA_TYPE, "UI")).setLabelPosition("none")).setDefaultRowPredicate()).build();
    public static final RChoiceKey LOWER_FORMULA_OBJECT = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("lower_formula_object", "Object").setCompletionSupport(RChoiceProvider.inherits("formula"))).addVisibleKeyLink(LOWER_FORMULA_TYPE, "Object")).build();
    public static final RTextKey LOWER_FORMULA_TEXT = ((RTextKey.Builder)((Key.Builder)RTextKey.builder("lower_formula_text", "").setCompletionSupport(RChoiceProvider.columns("data", true))).addVisibleKeyLink(LOWER_FORMULA_TYPE, "Text")).build();
    public static final RChoiceKey FAMILY = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("family", "Family").setValuesAndLabels("binomial", "Binomial", "gaussian", "Gaussian", "Gamma", "Gamma", "inverse.gaussian", "Inverse Gaussian", "poisson", "Poisson")).setDefaultValue("binomial")).addVisibleKeyLink(METHOD, "glm")).build();
    public static final RChoiceKey RPART_METHOD = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("rpart_method", "Type").setValuesAndLabels("", "Auto", "\"anova\"", "Regression", "\"class\"", "Classification")).addVisibleKeyLink(METHOD, "rpart")).build();
    public static final BoolKey RPART_AUTO_PRUNING = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("rpart_auto_pruning", "Auto Pruning").addVisibleKeyLink(METHOD, "rpart")).setDefaultValue(Boolean.TRUE)).noLabel()).build();
    public static final RStrKey RPART_CP = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("rpart_cp", "Complexity Parameter").setDefaultValue("0.001")).setDefaultMessage("0.01")).addVisibleKeyLink(METHOD, "rpart")).build();
    public static final RStrKey RPART_XVAL = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("rpart_xval", "Number of Cross Validation").setDefaultMessage("10")).addVisibleKeyLink(METHOD, "rpart")).build();
    public static final RStrKey RPART_MINSPLIT = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("rpart_minsplit", "Minimum Sample Size Before Split").setDefaultMessage("20")).addVisibleKeyLink(METHOD, "rpart")).build();
    public static final RStrKey RPART_MINBUCKET = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("rpart_minbucket", "Minimum Sample Size After Split").setDefaultMessage("round(minsplit/3)")).addVisibleKeyLink(METHOD, "rpart")).build();
    public static final RStrKey RPART_MAX_DEPTH = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("rpart_maxdepth", "Max Depth of Tree").setDefaultMessage("30")).addVisibleKeyLink(METHOD, "rpart")).build();
    @Deprecated
    public static final RadioButtonKey RPART_PRUNING = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("rpart_pruning", "Pruning").setValuesAndLabels("auto", "Auto", "manual", "Manual")).addVisibleKeyLink(METHOD, "rpart")).setObsolete(true)).build();
    @Deprecated
    public static final RStrKey RPART_AUTO_CP = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("rpart_auto_cp", "Complexity Parameter >=").setDefaultValue("0.001")).setRequired(true)).addVisibleKeyLink(RPART_PRUNING, "auto")).setObsolete(true)).build();
    @Deprecated
    public static final RStrKey RPART_MANUAL_CP = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("rpart_manual_cp", "Complexity Parameter =").setDefaultMessage("0.01")).addVisibleKeyLink(RPART_PRUNING, "manual")).setObsolete(true)).build();
    public static final RStrKey NNET_SIZE = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("nnet_size", "Number of Hidden Units").setDefaultValue("3")).addVisibleKeyLink(METHOD, "nnet")).build();
    public static final RStrKey NNET_DECAY = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("nnet_decay", "Decay Parameter").setDefaultMessage("0")).addVisibleKeyLink(METHOD, "nnet")).build();
    public static final RStrKey NNET_MAXIT = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("nnet_maxit", "Maximum Number of Iterations").setDefaultMessage("100")).addVisibleKeyLink(METHOD, "nnet")).build();
    public static final RStrKey RANGER_MTRY = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("ranger_mtry", "Number of Splitting Variables").setDefaultMessage("\u221a(Number of variables)")).addVisibleKeyLink(METHOD, "ranger")).build();
    public static final RStrKey RANGER_NUM_TREES = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("ranger_num_trees", "Number of Trees").setDefaultMessage("500")).addVisibleKeyLink(METHOD, "ranger")).build();
    public static final RChoiceKey RANGER_IMPORTANCE = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("ranger_importance", "Variable Importance").setValuesAndLabels("\"none\"", "None", "\"impurity\"", null, "\"impurity_corrected\"", null, "\"permutation\"", null)).setDefaultValue("\"impurity\"")).addVisibleKeyLink(METHOD, "ranger")).build();
    public static final RStrKey RANGER_MIN_NODE_SIZE = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("ranger_min_node_size", "Minimal Node Size").setDefaultMessage("(Default)")).addVisibleKeyLink(METHOD, "ranger")).build();
    public static final BoolKey RANGER_AUTO_PROB = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("ranger_auto_prob", "Estimate Probabilities for Classification").setDefaultValue(Boolean.TRUE)).noLabel()).addVisibleKeyLink(METHOD, "ranger")).build();
    public static final BoolKey RANGER_CLASSIFY_BINARY = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("ranger_classify_binary", "Apply Classification to Logical or 0/1 Target").setDefaultValue(Boolean.TRUE)).noLabel()).addVisibleKeyLink(METHOD, "ranger")).build();
    public static final BoolKey XGBOOST_CV = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("xgboost_cv", "Cross Validation").setDefaultValue(Boolean.TRUE)).setRequired(true)).noLabel()).addVisibleKeyLink(METHOD, "xgboost")).build();
    public static final RStrKey XGBOOST_CV_NFOLDS = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("xgboost_cv_nfolds", "Number of Folds").setDefaultValue("5")).setRequired(true)).addVisibleKeyLink(METHOD, "xgboost")).addVisibleKeyLink(XGBOOST_CV, Boolean.TRUE)).build();
    public static final RStrKey XGBOOST_CV_MAXIT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("xgboost_cv_maxit", "Max Number of Iterations").setDefaultValue("50")).setRequired(true)).addVisibleKeyLink(METHOD, "xgboost")).addVisibleKeyLink(XGBOOST_CV, Boolean.TRUE)).build();
    public static final RStrKey XGBOOST_CV_EARLY_STOP = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("xgboost_cv_early_stop", "Early Stopping Rounds").setDefaultValue("5")).setRequired(true)).addVisibleKeyLink(METHOD, "xgboost")).addVisibleKeyLink(XGBOOST_CV, Boolean.TRUE)).build();
    public static final RStrKey XGBOOST_NROUNDS = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("xgboost_nrounds", "Number of Iterations").setDefaultValue("5")).addVisibleKeyLink(METHOD, "xgboost")).addVisibleKeyLink(XGBOOST_CV, Boolean.FALSE)).build();
    public static final BoolKey XGBOOST_IMPORTANCE = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("xgboost_importance", "Compute Variable Importance").setDefaultValue(Boolean.TRUE)).noLabel()).addVisibleKeyLink(METHOD, "xgboost")).build();
    public static final RStrKey XGBOOST_MAX_DEPTH = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("xgboost_max_depth", "Max Depth of Tree").setDefaultMessage("6")).addVisibleKeyLink(METHOD, "xgboost")).build();
    public static final RStrKey XGBOOST_ETA = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("xgboost_eta", "Learning Rate").setDefaultMessage("0.3")).addVisibleKeyLink(METHOD, "xgboost")).build();
    public static final RChoiceKey GLMNET_FAMILY = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("glmnet_family", "Response Type").setValuesAndLabels("", "Auto Detect", "\"gaussian\"", "Numeric", "\"poisson\"", "Non-Negative Integer", "\"binomial\"", "Binary", "\"multinomial\"", "Category")).addVisibleKeyLink(METHOD, "glmnet")).build();
    public static final ChoiceKey GLMNET_TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("glmnet_type", "Mixing Parameter").setValuesAndLabels("grid_search", "Grid Search", "lasso", "Lasso (\u03b1 = 1)", "ridge", "Ridge (\u03b1 = 0)")).addVisibleKeyLink(METHOD, "glmnet")).build();
    public static final RStrKey GLMNET_ALPHA_GRID = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("glmnet_alpha_grid", "Choose \u03b1 from").setDefaultValue("seq(0, 1, by = .1)")).addVisibleKeyLink(METHOD, "glmnet")).addVisibleKeyLink(GLMNET_TYPE, "grid_search")).build();
    public static final RStrKey GLMNET_NFOLDS = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("glmnet_nfold", "Number of Cross Validation").setDefaultValue("5")).addVisibleKeyLink(METHOD, "glmnet")).build();
    public static final RadioButtonKey SUBSET_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("subset_type", "Type").setValues("include", "exclude")).setLabels("Include", "Exclude")).build();
    public static final RadioButtonKey SUBSET_LOGICAL = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("subset_logical", "And/Or").setValues("AND", "OR")).setLabels("And", "Or")).build();
    public static final ValueMapKey CONDITION_TYPES = ((ValueMapKey.Builder)((ValueMapKey.Builder)((Object)ValueMapKey.builder("types", "Types", new RFormRowSelector()).addClass("form", RFormRowSelector.class))).addClass("simple", RSimpleRowSelector.class)).build();
    public static final ComponentTableKey SUBSET_CONDITIONS = ((ComponentTableKey.Builder)((ComponentTableKey.Builder)ComponentTableKey.builder("subset_conditions", "Conditions", CONDITION_TYPES).setHeight(100)).setGrowY(false)).build();
    public static final RChoiceKey WEIGHTS = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("weights", "Fitting Weights").setChoiceProvider(RChoiceProvider.columns("data", true))).setEmptyMessage("(None)")).build();
    public static final BoolKey EXCLUDE_WEIGHT = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("exclude_weight", "Exclude from model input").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).addKeyLink(KeyLink.disabled(StrKeyTest.create(WEIGHTS, "")))).build();
    public static final ChoiceKey ARGS_SWITCH = ROperation.argsSwitchKey("args_switch", new AutoValueLink(true, METHOD), "lm", "glm", "nnet::multinom", "rpart::rpart", "rpart::rpart.control", "nnet::nnet", "ranger::ranger", "xgboost::xgboost", "xgboost::xgb.cv", "glmnet::glmnet", "glmnet::cv.glmnet", "step");
    public static final RArgsKey ARGS_LM = ROperation.argsKey("args_lm", "lm", null, ARGS_SWITCH, new String[0]);
    public static final RArgsKey ARGS_GLM = ROperation.argsKey("args_glm", "glm", null, ARGS_SWITCH, new String[0]);
    public static final RArgsKey ARGS_MULTINOM = ROperation.argsKey("args_multinom", "nnet::multinom", null, ARGS_SWITCH, new String[0]);
    public static final RArgsKey ARGS_RPART = ROperation.argsKey("args_rpart", "rpart::rpart", null, ARGS_SWITCH, "control", "formula", "subset");
    public static final RArgsKey ARGS_RPART_CONTROL = ROperation.argsKey("args_rpart.control", "rpart::rpart.control", null, ARGS_SWITCH, "minsplit", "minbucket", "cp", "xval", "maxdepth");
    public static final RArgsKey ARGS_NNET = ROperation.argsKey("args_nnet", "nnet::nnet", null, ARGS_SWITCH, new String[0]);
    public static final RArgsKey ARGS_RANGER = ROperation.argsKey("args_ranger", "ranger::ranger", null, ARGS_SWITCH, "case.weights", "importance", "mtry", "num.trees", "min.node.size");
    public static final RArgsKey ARGS_XGBOOST = ROperation.argsKey("args_xgboost", "xgboost::xgboost", null, ARGS_SWITCH, "nrounds", "eta", "max_depth");
    public static final RArgsKey ARGS_XGBOOST_CV = ROperation.argsKey("args_xgboost_cv", "xgboost::xgb.cv", null, ARGS_SWITCH, "nrounds", "nfold", "early_stopping_rounds", "eta", "max_depth");
    public static final RArgsKey ARGS_GLMNET = ROperation.argsKey("args_glmnet", "glmnet::glmnet", null, ARGS_SWITCH, "x", "y", "familly", "alpha", "intercept");
    public static final RArgsKey ARGS_CV_GLMNET = ROperation.argsKey("args_cv.glmnet", "glmnet::cv.glmnet", null, ARGS_SWITCH, "x", "y", "nfolds", "foldid");
    public static final RArgsKey ARGS_STEP = ROperation.argsKey("args_step", "step", null, ARGS_SWITCH, new String[0]);
    public static final UIInterfaceInitializer init = new UIInterfaceInitializer(RModelInterface.class);

    default public void setPreviewValues(ROperation rOperation, PreviewOption previewOption) {
        KeysTableModel keysTableModel = rOperation.getValue(ARGS_STEP);
        int n = keysTableModel.rowOf(0, "steps");
        if (n >= 0) {
            keysTableModel.setValueAt("min(5, " + String.valueOf(keysTableModel.getValueAt(n, 1)) + ")", n, 1);
        } else {
            keysTableModel.addNewRow("steps", "5");
        }
    }

    default public boolean excludeIntercept(ROperation rOperation) {
        return rOperation.isEnabled(EXCLUDE_INTERCEPT) && rOperation.getValue(EXCLUDE_INTERCEPT) != false;
    }

    default public boolean includeInteraction(ROperation rOperation) {
        return rOperation.isEnabled(INCLUDE_INTERACTION) && rOperation.getValue(INCLUDE_INTERACTION) != false;
    }

    default public WidgetNode getModelWidgetNode() {
        WidgetNode widgetNode = PanelWidgetNode.noScroll().addElements(LOWER_FORMULA_TYPE, LOWER_X, LOWER_FORMULA_OBJECT, LOWER_FORMULA_TEXT).addVisibleKeyLink(USE_LOWER, true);
        WidgetNode widgetNode2 = PanelWidgetNode.indent().addElements(STEPWISE_DIRECTION, USE_LOWER, widgetNode).addVisibleKeyLink(STEPWISE, true);
        return PanelWidgetNode.noScroll().addElements(FAMILY, EXCLUDE_INTERCEPT, INCLUDE_INTERACTION, STEPWISE, widgetNode2, RPART_METHOD, RPART_AUTO_PRUNING, new TitledPanelWidgetNode("Model Details", true).addVisibleKeyLink(METHOD, METHOD_RPART).addElements(RPART_MINSPLIT, RPART_MINBUCKET, RPART_CP, RPART_XVAL, RPART_MAX_DEPTH), NNET_SIZE, NNET_DECAY, NNET_MAXIT, RANGER_MTRY, RANGER_NUM_TREES, RANGER_MIN_NODE_SIZE, RANGER_IMPORTANCE, new TitledPanelWidgetNode("Model Details", true).addVisibleKeyLink(METHOD, METHOD_RANGER).addElements(RANGER_AUTO_PROB, RANGER_CLASSIFY_BINARY), XGBOOST_CV, XGBOOST_CV_NFOLDS, XGBOOST_CV_MAXIT, XGBOOST_CV_EARLY_STOP, XGBOOST_NROUNDS, XGBOOST_IMPORTANCE, new TitledPanelWidgetNode("Model Details", true).addVisibleKeyLink(METHOD, METHOD_XGBOOST).addElements(XGBOOST_MAX_DEPTH, XGBOOST_ETA), GLMNET_FAMILY, GLMNET_TYPE, GLMNET_ALPHA_GRID, GLMNET_NFOLDS);
    }
}

