/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.REvaluate;
import com.ef_prime.rflow.core.app.r.RFormRowSelector;
import com.ef_prime.rflow.core.app.r.RModel;
import com.ef_prime.rflow.core.app.r.RModelInterface;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RPredict;
import com.ef_prime.rflow.core.app.r.RSimpleRowSelector;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RAnonymousFunction;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTextKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ListAndDetailsKey;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.SeparatorWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.util.StringUtility;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.core.task.NodeModelTask;
import com.ef_prime.rflow.core.task.TaskQueue;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.node.RModelsWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class RModeling
extends ROperation
implements RModelInterface {
    private static final String SINGLE = "single";
    private static final String MULTIPLE_LIST = "multiple_list";
    private static final String X_ALL = "all";
    private static final String X_INCLUDE = "include";
    private static final String X_EXCLUDE = "exclude";
    public static final String EVAL_NUMERIC = "numeric";
    public static final String EVAL_BINARY = "binary";
    public static final String EVAL_CATEGORY = "category";
    private static final RadioButtonKey INTERFACE = ((RadioButtonKey.Builder)RadioButtonKey.builder("interface", "Model").setValuesAndLabels("single", "Single", "multiple_list", "List")).build();
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((Key.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA, METHOD, INTERFACE)).setOutput(true)).addVisibleKeyLink(INTERFACE, "single", "multiple_list")).build();
    private static final RadioButtonKey FORMULA_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("formula", "Model Formula").setValuesAndLabels("UI", "GUI", "Object", "Formula Object", "Text", "Direct Input")).setLabelPosition("none")).build();
    private static final RTextKey FORMULA_TEXT = ((RTextKey.Builder)((Key.Builder)RTextKey.builder("formula_text", "").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addVisibleKeyLink(FORMULA_TYPE, "Text")).build();
    private static final RChoiceKey FORMULA_Y = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("formula_y", "Output (Y)").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    private static final RadioButtonKey FORMULA_X = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("formula_x", "Input (X)").setValuesAndLabels("all", "All", "include", "Include", "exclude", "Exclude")).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    private static final RChoiceKey FORMULA_COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("formula_column", "X").setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    private static final RTableKey FORMULA_LIST = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("formula_list", "Input (X)", FORMULA_COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(FORMULA_X, "include", "exclude")).setDefaultRowPredicate()).setLabelPosition("none")).setWidth(500)).build();
    @Deprecated
    private static final BoolKey FORMULA_INTERCEPT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("formula_intercept", "Intercept").setDefaultValue(true)).addVisibleKeyLink(FORMULA_TYPE, "UI")).build();
    private static final RChoiceKey FORMULA_OBJECT = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("formula_object", "Object").setCompletionSupport(RChoiceProvider.inherits("formula"))).addVisibleKeyLink(FORMULA_TYPE, "Object")).build();
    private static final BoolKey SKIP_ERROR = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("skip_error", "Skip error on each model").noLabel()).addVisibleKeyLink(INTERFACE, "multiple_list")).build();
    private static final BoolKey APPEND = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("append", "Append to the existing list").noLabel()).addVisibleKeyLink(INTERFACE, "multiple_list")).build();
    private static final ValueMapKey MODEL = ((ValueMapKey.Builder)((ValueMapKey.Builder)ValueMapKey.builder("model", "Model", new RModel()).setWidth(250)).setEditable(false)).build();
    private static final ListAndDetailsKey MODELS = ((ListAndDetailsKey.Builder)((ListAndDetailsKey.Builder)((ListAndDetailsKey.Builder)ListAndDetailsKey.builderForCatalog("models", "Models", MODEL).setLabelPosition("none")).setRequired(true)).addEnabledKeyLink(INTERFACE, "multiple_list")).build();
    private static final BoolKey EVALUATION = ((BoolKey.Builder)BoolKey.builder("eval", "Evaluate Predictive Performance").noLabel()).build();
    private static final RChoiceKey EVAL_TEST_DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("test_data", "Test Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).addEnabledKeyLink(EVALUATION, true)).build();
    private static final RStrKey EVAL_OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("eval_output", "Output").setRequired(true)).setAutoValueLink(EVAL_TEST_DATA)).addEnabledKeyLink(EVALUATION, true)).build();
    private static final ChoiceKey EVAL_TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("eval_type", "Type").setValuesAndLabels("numeric", "Numeric", "binary", "Binary", "category", "Category")).build();
    private static final BoolKey EVAL_TYPE_AUTO = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("eval_type_auto", "Auto update when target is changed").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).build();
    private static final BoolKey EVAL_SORT_RESULT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("eval_sort_result", "Sort Result").setDefaultValue(Boolean.TRUE)).noLabel()).build();
    private static final ChoiceKey EVAL_SORT_COLUMN = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("eval_sort_column", "").setValues("Mean.Squared.Error", "Mean.Absolute.Error", "Bias")).addVisibleKeyLink(EVAL_TYPE, "numeric")).addEnabledKeyLink(EVAL_SORT_RESULT, true)).build();
    private static final BoolKey EVAL_CONF_MATRIX = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("eval_conf_matrix", "Output confusion matrix").noLabel()).addVisibleKeyLink(EVAL_TYPE, "binary", "category")).build();
    private static final BoolKey EVAL_CHART = ((BoolKey.Builder)BoolKey.builder("eval_chart", "Draw chart").noLabel()).build();
    private static final BoolKey EVAL_RUN = ((BoolKey.Builder)BoolKey.builder("eval_run", "").setNoSave(true)).build();

    @Override
    public Version getVersion() {
        return new Version(0, 5, 3, 0);
    }

    @Override
    public void updateVersion(Version version) {
        List<String> list;
        if (version.isOlderThan("0.1") && this.getValue(FORMULA_TYPE).equals("UI")) {
            list = this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN);
            if (list.isEmpty()) {
                this.putValue(FORMULA_X, X_ALL);
            } else {
                this.putValue(FORMULA_X, X_INCLUDE);
            }
        }
        if (version.isOlderThan("0.3")) {
            if (this.getValue(FORMULA_TYPE).equals("UI") && !this.getValue(FORMULA_INTERCEPT).booleanValue()) {
                this.putValue(EXCLUDE_INTERCEPT, Boolean.TRUE);
            }
            if (this.getValue(METHOD).equals("rpart")) {
                this.putValue(RPART_PRUNING, "manual");
            }
        }
        if (version.isOlderThan("0.3.1")) {
            list = valueMap -> {
                if (valueMap.getValue(METHOD).equals("rpart")) {
                    boolean bl = valueMap.getValue(RPART_PRUNING).equals("auto");
                    valueMap.putValue(RPART_AUTO_PRUNING, bl);
                    valueMap.putValue(RPART_CP, bl ? valueMap.getValue(RPART_AUTO_CP) : valueMap.getValue(RPART_MANUAL_CP));
                }
            };
            list.accept((ValueMap)this);
            this.getValue(MODELS).getValues(MODEL).stream().forEach(list);
        }
        if (version.isOlderThan("0.5.0")) {
            this.putValue(EXCLUDE_WEIGHT, Boolean.FALSE);
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(INTERFACE, DATA, OUTPUT, FORMULA_TYPE, FORMULA_TEXT, FORMULA_OBJECT, FORMULA_Y, FORMULA_X, FORMULA_LIST, FORMULA_INTERCEPT, MODELS, METHOD, FAMILY, EXCLUDE_INTERCEPT, INCLUDE_INTERACTION, STEPWISE, STEPWISE_DIRECTION, USE_LOWER, LOWER_FORMULA_TYPE, LOWER_X, LOWER_FORMULA_OBJECT, LOWER_FORMULA_TEXT, RPART_METHOD, RPART_AUTO_PRUNING, RPART_CP, RPART_XVAL, RPART_MINSPLIT, RPART_MINBUCKET, RPART_MAX_DEPTH, RPART_PRUNING, RPART_AUTO_CP, RPART_MANUAL_CP, NNET_SIZE, NNET_DECAY, NNET_MAXIT, RANGER_MTRY, RANGER_NUM_TREES, RANGER_MIN_NODE_SIZE, RANGER_IMPORTANCE, RANGER_AUTO_PROB, RANGER_CLASSIFY_BINARY, XGBOOST_CV, XGBOOST_CV_NFOLDS, XGBOOST_CV_MAXIT, XGBOOST_CV_EARLY_STOP, XGBOOST_NROUNDS, XGBOOST_IMPORTANCE, XGBOOST_MAX_DEPTH, XGBOOST_ETA, GLMNET_FAMILY, GLMNET_TYPE, APPEND, SKIP_ERROR, SUBSET_TYPE, SUBSET_LOGICAL, SUBSET_CONDITIONS, WEIGHTS, EXCLUDE_WEIGHT, ARGS_SWITCH, ARGS_LM, EVALUATION, EVAL_TEST_DATA, EVAL_OUTPUT, EVAL_TYPE, EVAL_TYPE_AUTO, EVAL_SORT_RESULT, EVAL_SORT_COLUMN, EVAL_CONF_MATRIX, EVAL_CHART, ARGS_GLM, ARGS_MULTINOM, ARGS_RPART, ARGS_RPART_CONTROL, ARGS_NNET, ARGS_RANGER, ARGS_XGBOOST, ARGS_XGBOOST_CV, ARGS_GLMNET, ARGS_CV_GLMNET, ARGS_STEP);
    }

    @Override
    protected String getDefaultTitle() {
        return "Build Predictive Model";
    }

    @Override
    public String getOpClass() {
        return "model";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            String string;
            if (this.getValue(INTERFACE).equals(MULTIPLE_LIST)) {
                string = ".models";
            } else {
                switch (this.getValue(METHOD)) {
                    case "lm": {
                        string = ".lm";
                        break;
                    }
                    case "logit": {
                        string = ".logit";
                        break;
                    }
                    case "multinom": {
                        string = ".multinom";
                        break;
                    }
                    case "glm": {
                        string = ".glm";
                        break;
                    }
                    case "rpart": {
                        string = ".rpart";
                        break;
                    }
                    case "nnet": {
                        string = ".nnet";
                        break;
                    }
                    case "ranger": {
                        string = ".ranger";
                        break;
                    }
                    case "xgboost": {
                        string = ".xgboost";
                        break;
                    }
                    case "glmnet": {
                        string = ".glmnet";
                        break;
                    }
                    default: {
                        string = ".model";
                    }
                }
            }
            return RModeling.suffix(this.getValue(DATA), string);
        }
        if (ARGS_SWITCH.equals(key)) {
            switch (this.getValue(METHOD)) {
                case "lm": {
                    return ARGS_LM.getFunctionLabel();
                }
                case "logit": 
                case "glm": {
                    return ARGS_GLM.getFunctionLabel();
                }
                case "rpart": {
                    return ARGS_RPART.getFunctionLabel();
                }
                case "nnet": {
                    return ARGS_NNET.getFunctionLabel();
                }
                case "multinom": {
                    return ARGS_MULTINOM.getFunctionLabel();
                }
                case "ranger": {
                    return ARGS_RANGER.getFunctionLabel();
                }
                case "xgboost": {
                    return ARGS_XGBOOST.getFunctionLabel();
                }
                case "glmnet": {
                    return ARGS_GLMNET.getFunctionLabel();
                }
            }
        } else if (EVAL_OUTPUT.equals(key)) {
            return RModeling.suffix(this.getValue(EVAL_TEST_DATA), ".eval");
        }
        return super.getAutoValue(key);
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    @Override
    public void setPreviewValues(PreviewOption previewOption) {
        if (this.getValue(INTERFACE).equals(SINGLE)) {
            this.setPreviewValues(this, previewOption);
        } else {
            List<ValueMap> list = this.getValue(MODELS).getValues(MODEL);
            for (ValueMap valueMap : list) {
                if (!(valueMap instanceof RModel)) continue;
                this.setPreviewValues((RModel)valueMap, previewOption);
            }
        }
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = new TitledPanelWidgetNode("Model Formula", true).addElements(FORMULA_TYPE, FORMULA_TEXT, FORMULA_OBJECT, FORMULA_Y, FORMULA_X, FORMULA_LIST);
        WidgetNode widgetNode2 = new TitledPanelWidgetNode("Model Settings", true).addVisibleKeyLink(INTERFACE, SINGLE).addElements(PanelWidgetNode.noScroll().addElements(METHOD), this.getModelWidgetNode());
        WidgetNode widgetNode3 = PanelWidgetNode.noScroll().addElements(widgetNode2, SKIP_ERROR, APPEND);
        WidgetNode widgetNode4 = PanelWidgetNode.noScroll().addElements(EVAL_TEST_DATA, EVAL_OUTPUT, new XFlowPanelWidgetNode().addElements(EVAL_TYPE, EVAL_TYPE_AUTO), new XFlowPanelWidgetNode().addElements(EVAL_SORT_RESULT, EVAL_SORT_COLUMN), EVAL_CONF_MATRIX, EVAL_CHART, new ButtonWidgetNode("Run Evaluation Only", "eval").setIconPath("16/bullet_arrow_right.png")).addKeyLink(KeyLink.enabled(BoolKeyTest.create(EVALUATION, true)));
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode().addTabWithElements("Main", new SplitPaneWidgetNode(false, 0.5f).setGrowY(true).addElements(new PanelWidgetNode().addElements(PanelWidgetNode.noScroll().addKeys(INTERFACE), DATA, OUTPUT, widgetNode), widgetNode3)).addTab((TabWidgetNode)new TabWidgetNode("Models").addVisibleKeyLink(INTERFACE, MULTIPLE_LIST).addElements(new KeyWidgetNode(MODELS, RModelsWidget.class))).addTabWithElements("Options", new XFlowPanelWidgetNode().addElements(WEIGHTS, EXCLUDE_WEIGHT), new SeparatorWidgetNode("Select Rows", true), SUBSET_TYPE, SUBSET_LOGICAL, SUBSET_CONDITIONS).addTab((TabWidgetNode)new TabWidgetNode("Evaluation").addElements(EVALUATION, widgetNode4)).addTab((TabWidgetNode)new TabWidgetNode("Advanced").addVisibleKeyLink(INTERFACE, SINGLE).addElements(ARGS_SWITCH, ARGS_LM, ARGS_GLM, ARGS_MULTINOM, ARGS_RPART, ARGS_RPART_CONTROL, ARGS_NNET, ARGS_RANGER, ARGS_XGBOOST, ARGS_XGBOOST_CV, ARGS_GLMNET, ARGS_CV_GLMNET, ARGS_STEP));
        return tabPaneWidgetNode;
    }

    @Override
    protected int getSplitHeight() {
        return 330;
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        Object object;
        Object object2;
        String string2;
        Object object3;
        Object object4 = object3 = this.getValue(DATA);
        String string3 = this.getSubset(this);
        if (!string3.isEmpty()) {
            object3 = RUtility.function("subset", new String[]{"x", object3, "subset", string3});
        }
        if ((string2 = this.getValue(FORMULA_TYPE)).equals("UI") && this.getValue(FORMULA_X).equals(X_EXCLUDE)) {
            object2 = this.getValue(FORMULA_Y);
            List<String> list = this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN).stream().filter(arg_0 -> RModeling.lambda$getRScript$1((String)object2, arg_0)).map(string -> RUtility.removeBackticks(string)).collect(Collectors.toList());
            object = this.getValue(WEIGHTS);
            if (!((String)object).isEmpty()) {
                list.remove(object);
            }
            if (!list.isEmpty()) {
                String string4 = "[, !(names(" + this.getValue(DATA) + ") %in% " + RUtility.combineCharacters(list) + ")]";
                object3 = (String)object3 + string4;
                object4 = (String)object4 + string4;
            }
        }
        if (this.getValue(INTERFACE).equals(SINGLE)) {
            object2 = RModeling.scriptBuilder();
            this.getRScript((ScriptBuilder)object2, this, null, (String)object3, (String)object4, this.getValue(OUTPUT), null, previewOption.isEnabled());
            if (this.getValue(EVALUATION).booleanValue()) {
                this.evaluation((ScriptBuilder)object2, true, bl, bl2, previewOption);
            }
            return ((ScriptBuilder)object2).toString();
        }
        boolean bl3 = this.getValue(INTERFACE).equals(MULTIPLE_LIST);
        boolean bl4 = bl3 && this.getValue(APPEND) != false;
        object = this.getValue(MODELS).getValues(MODEL).stream().map(valueMap -> (RModel)valueMap).collect(Collectors.toList());
        boolean bl5 = object.stream().anyMatch(rModel -> rModel.getValue(METHOD).equals("nnet"));
        boolean bl6 = object.stream().anyMatch(rModel -> rModel.getValue(METHOD).equals("rpart") && rModel.getValue(RPART_AUTO_PRUNING) != false);
        boolean bl7 = object.stream().anyMatch(rModel -> rModel.getValue(METHOD).equals("ranger"));
        boolean bl8 = object.stream().anyMatch(rModel -> rModel.getValue(METHOD).equals("xgboost"));
        boolean bl9 = object.stream().anyMatch(rModel -> rModel.getValue(METHOD).equals("glmnet"));
        ScriptBuilder scriptBuilder = RModeling.scriptBuilder();
        scriptBuilder.appLnInd(RAnonymousFunction.getEmptyHeadStr());
        this.tryFunc(scriptBuilder, this.getValue(SKIP_ERROR));
        if (!this.getValue(EVAL_RUN).booleanValue()) {
            Object object5;
            if (bl6) {
                this.rpartPrune(scriptBuilder, "model", true);
            }
            if (bl5) {
                this.nnetFunc(scriptBuilder);
            }
            if (bl7) {
                this.rangerFunc(scriptBuilder);
            }
            if (bl8) {
                this.appendCustomFunc(scriptBuilder, "xgboost", true);
            }
            if (bl9) {
                this.appendCustomFunc(scriptBuilder, "glmnet", true);
            }
            scriptBuilder.appLnInd("eval.parent(bquote({");
            if (bl3) {
                object5 = this.getValue(OUTPUT) + " <- list()";
                if (bl4) {
                    scriptBuilder.appLnInd("if (tryCatch(!is.list(" + this.getValue(OUTPUT) + "), error = function(e) TRUE)) {");
                    scriptBuilder.appendLn((CharSequence)object5);
                    scriptBuilder.unind_Ln("}");
                } else {
                    scriptBuilder.appendLn((CharSequence)object5);
                }
            }
            object5 = object.iterator();
            while (object5.hasNext()) {
                RModel rModel2 = (RModel)object5.next();
                String string5 = bl3 ? this.getValue(OUTPUT) + "[[" + RModeling.quote(rModel2.getName()) + "]]" : rModel2.getName();
                this.getRScript(scriptBuilder, rModel2, this, (String)object3, (String)object4, string5, rModel2.getName(), previewOption.isEnabled());
            }
            scriptBuilder.unind_Ln("}))");
        }
        if (this.getValue(EVALUATION).booleanValue()) {
            this.evaluation(scriptBuilder, false, bl, bl2, previewOption);
        }
        scriptBuilder.unind_Ln(RAnonymousFunction.getEmptyTailStr());
        return scriptBuilder.toString();
    }

    private String getLowerFormula(ROperation rOperation) {
        String string = this.getValue(FORMULA_Y);
        boolean bl = this.excludeIntercept(rOperation);
        String string2 = rOperation.getValue(LOWER_FORMULA_TYPE);
        String string3 = rOperation.getValue(FORMULA_TYPE);
        if (rOperation.getValue(USE_LOWER).booleanValue()) {
            if (string2.equals("UI")) {
                List<String> list = rOperation.getValue(LOWER_X).getValidValues(FORMULA_COLUMN);
                Object object = StringUtility.limitedJoin(list, " + ", 1000, 2);
                if (!((String)object).isEmpty()) {
                    object = " " + (String)object;
                }
                if (string3.equals("UI")) {
                    if (bl) {
                        return string + " ~" + (String)object + " - 1";
                    }
                    if (((String)object).isEmpty()) {
                        object = " 1";
                    }
                    return string + " ~" + (String)object;
                }
                if (string3.equals("Text") || string3.equals("Object")) {
                    String string4;
                    String string5 = string4 = string3.equals("Text") ? this.getValue(FORMULA_TEXT) : this.getValue(FORMULA_OBJECT);
                    if (bl) {
                        return "update(terms(" + string4 + ", data = " + this.getValue(DATA) + "), ~" + (String)object + " - 1)";
                    }
                    ScriptBuilder scriptBuilder = RModeling.scriptBuilder();
                    scriptBuilder.appendLn("if(attr(terms(" + string4 + ", data = " + this.getValue(DATA) + "), \"intercept\") == 1)");
                    if (((String)object).isEmpty()) {
                        scriptBuilder.appendLn("\tupdate(" + string4 + ",. ~ 1)");
                    } else {
                        scriptBuilder.appendLn("\tupdate(" + string4 + ",. ~" + (String)object + ")");
                    }
                    scriptBuilder.appendLn("else");
                    scriptBuilder.appendLn("\tupdate(" + string4 + ",. ~" + (String)object + " - 1)");
                    return scriptBuilder.toString();
                }
            } else if (string2.equals("Text") || string2.equals("Object")) {
                String string6 = string2.equals("Text") ? this.getValue(LOWER_FORMULA_TEXT) : this.getValue(LOWER_FORMULA_OBJECT);
                return string6;
            }
        } else {
            if (string3.equals("UI")) {
                if (bl) {
                    return string + " ~ - 1";
                }
                return string + " ~ 1";
            }
            if (string3.equals("Text") || string3.equals("Object")) {
                String string7;
                String string8 = string7 = string3.equals("Text") ? this.getValue(FORMULA_TEXT) : this.getValue(FORMULA_OBJECT);
                if (bl) {
                    return "update(terms(" + string7 + ", data = " + this.getValue(DATA) + "), ~ - 1)";
                }
                ScriptBuilder scriptBuilder = RModeling.scriptBuilder();
                scriptBuilder.appendLn("if(attr(terms(" + string7 + ", data = " + this.getValue(DATA) + "), \"intercept\") == 1)");
                scriptBuilder.appendLn("\tupdate(" + string7 + ", ~ 1)");
                scriptBuilder.appendLn("else");
                scriptBuilder.appendLn("\tupdate(" + string7 + ", ~ - 1)");
                return scriptBuilder.toString();
            }
        }
        return "";
    }

    private String getUpperFormula(ROperation rOperation) {
        String string;
        String string2 = this.getValue(FORMULA_Y);
        boolean bl = this.excludeIntercept(rOperation);
        boolean bl2 = this.includeInteraction(rOperation);
        String string3 = this.getValue(WEIGHTS);
        boolean bl3 = string3.length() > 0 && this.getValue(EXCLUDE_WEIGHT) != false;
        Object object = "";
        if (bl3) {
            object = (String)object + " - " + string3;
        }
        if (bl) {
            object = (String)object + " - 1";
        }
        if ((string = rOperation.getValue(FORMULA_TYPE)).equals("UI")) {
            String string4 = this.getValue(FORMULA_X);
            if (string4.equals(X_ALL)) {
                String string5 = bl2 ? " ~ .^2" : " ~ .";
                return string2 + string5 + (String)object;
            }
            if (string4.equals(X_INCLUDE)) {
                ArrayList<String> arrayList = new ArrayList<String>(this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN));
                Object object2 = StringUtility.limitedJoin(arrayList, " + ", 1000, 2);
                if (bl2 && arrayList.size() > 1) {
                    object2 = "(" + (String)object2 + ")^2";
                }
                if (bl3) {
                    arrayList.remove(string3);
                }
                if (arrayList.isEmpty()) {
                    if (bl) {
                        return string2 + " ~ - 1";
                    }
                    return string2 + " ~ 1";
                }
                if (bl) {
                    return string2 + " ~ " + (String)object2 + "- 1";
                }
                return string2 + " ~ " + (String)object2;
            }
            if (string4.equals(X_EXCLUDE)) {
                ArrayList<String> arrayList = new ArrayList<String>(this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN));
                Object object3 = "";
                if (bl3 || arrayList.contains(string3)) {
                    object3 = (String)object3 + " - " + string3;
                }
                if (bl) {
                    object3 = (String)object3 + " - 1";
                }
                String string6 = bl2 ? " ~ .^2" : " ~ .";
                return string2 + string6 + (String)object3;
            }
        } else if (string.equals("Text") || string.equals("Object")) {
            String string7;
            String string8 = string7 = string.equals("Text") ? this.getValue(FORMULA_TEXT) : this.getValue(FORMULA_OBJECT);
            if (((String)object).isEmpty()) {
                return string7;
            }
            return "update(terms(" + string7 + ", data = " + rOperation.getValue(DATA) + "), . ~ ." + (String)object + ")";
        }
        return "";
    }

    private String y(String string) {
        String string2;
        String string3 = this.getValue(FORMULA_TYPE);
        if (string3.equals("Text") || string3.equals("Object")) {
            Object object = string3.equals("Text") ? "(" + this.getValue(FORMULA_TEXT) + ")" : this.getValue(FORMULA_OBJECT);
            string2 = "update(" + (String)object + ", . ~ 1)";
        } else {
            string2 = this.getValue(FORMULA_Y) + " ~ 1";
        }
        return "model.response(model.frame(" + string2 + ", data = " + string + ", na.action = na.pass))";
    }

    private void tryFunc(ScriptBuilder scriptBuilder, boolean bl) {
        scriptBuilder.appLnInd("try_ <- function(expr, modelName) {");
        scriptBuilder.appLnInd("eval(bquote(tryCatch(expr, error = function(e) {");
        scriptBuilder.appendLn("cl <- conditionCall(e)");
        scriptBuilder.appendLn("cl <- if (is.null(cl)) \"\" else deparse(cl, nlines = 1)");
        if (bl) {
            scriptBuilder.appendLn("warning(\"Error in \", .(modelName), \" \", cl, \": \", conditionMessage(e), immediate. = TRUE, call. = FALSE)");
            scriptBuilder.appendLn("flush.console()");
        } else {
            scriptBuilder.appendLn("stop(.(modelName), \" \", cl, \": \", conditionMessage(e), call. = FALSE)");
        }
        scriptBuilder.unind_Ln("})))");
        scriptBuilder.unind_Ln("}");
    }

    private void nnetFunc(ScriptBuilder scriptBuilder) {
        scriptBuilder.appLnInd("nnet_ <- function(formula, data, subset = NULL, na.action, ...) {");
        scriptBuilder.appendLn("mf <- match.call(expand.dots = FALSE)");
        scriptBuilder.appendLn("mf[[1]] <- quote(stats::model.frame)");
        scriptBuilder.appendLn("mf$formula <- update(terms(formula, data = data), . ~ 1)");
        scriptBuilder.appendLn("mf$... <- NULL");
        scriptBuilder.appendLn("y <- model.response(eval(mf))");
        scriptBuilder.appendLn("cl <- match.call()");
        scriptBuilder.appendLn("cl[[1]] <- quote(nnet::nnet)");
        scriptBuilder.appLnInd("if (is.character(y)) {");
        scriptBuilder.appendLn("cl$formula <- update(terms(formula, data = data), as.factor(.) ~ .)");
        scriptBuilder.unLn_Ind("} else if (is.logical(y) || (!is.factor(y) && all(y %in% c(0, 1)))) {");
        scriptBuilder.appendLn("if (!(\"entropy\" %in% names(cl))) cl$entropy <- TRUE");
        scriptBuilder.unLn_Ind("} else if (is.numeric(y) && any(y > 1 | y < 0)) {");
        scriptBuilder.appendLn("if (!(\"linout\" %in% names(cl))) cl$linout <- TRUE");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn("eval(cl)");
        scriptBuilder.unind_Ln("}");
    }

    private void rangerFunc(ScriptBuilder scriptBuilder) {
        scriptBuilder.appLnInd("ranger_ <- function(formula, data, ...) {");
        scriptBuilder.appendLn("mf <- match.call(expand.dots = FALSE)");
        scriptBuilder.appendLn("mf[[1]] <- quote(stats::model.frame)");
        scriptBuilder.appendLn("mf$formula <- update(terms(formula, data = data), . ~ 1)");
        scriptBuilder.appendLn("mf$... <- NULL");
        scriptBuilder.appendLn("y <- model.response(eval(mf))");
        scriptBuilder.appendLn("cl <- match.call()");
        scriptBuilder.appendLn("cl[[1]] <- quote(ranger::ranger)");
        scriptBuilder.appLnInd("if (cl$.CLASSIFY_BINARY) {");
        scriptBuilder.appLnInd("if (is.logical(y) || (!is.factor(y) && all(y %in% c(0, 1)))) {");
        scriptBuilder.appendLn("cl$formula <- update(terms(formula, data = data), as.factor(.) ~ .)");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appLnInd("if (!(\"probability\" %in% names(cl))) {");
        scriptBuilder.appLnInd("if (cl$.AUTO_PROB && (is.factor(y) || is.character(y) || (cl$.CLASSIFY_BINARY && (is.logical(y) || all(y %in% c(0, 1)))))) {");
        scriptBuilder.appendLn("cl$probability <- TRUE");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn("cl$.AUTO_PROB <- NULL");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn("cl$.CLASSIFY_BINARY <- NULL");
        scriptBuilder.appendLn("eval(cl)");
        scriptBuilder.unind_Ln("}");
    }

    private void appendCustomFunc(ScriptBuilder scriptBuilder, String string, boolean bl) {
        if (bl) {
            switch (string) {
                case "xgboost": {
                    scriptBuilder.append("xgboost_ <- ");
                    break;
                }
                case "glmnet": {
                    scriptBuilder.append("glmnet_ <- ");
                    break;
                }
            }
        }
        scriptBuilder.append("function(formula, data, subset = NULL, na.action = na.fail, ");
        if (string.equals("xgboost")) {
            scriptBuilder.append("nrounds, .CV_ARGS = list(), .IMPORTANCE = TRUE, ");
        }
        if (string.equals("glmnet")) {
            scriptBuilder.append("alpha, family = NULL, .CV_ARGS = list(), ");
        }
        scriptBuilder.appendLn("...) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("mf <- match.call(expand.dots = FALSE)");
        scriptBuilder.appendLn("m <- match(c(\"formula\", \"data\", \"subset\", \"na.action\"), names(mf), 0L)");
        scriptBuilder.appendLn("mf <- mf[c(1L, m)]");
        scriptBuilder.appendLn("mf[[1L]] <- quote(stats::model.frame)");
        scriptBuilder.appendLn("mf$drop.unused.levels <- TRUE");
        scriptBuilder.appendLn("mf <- eval(mf, parent.frame())");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("mt <- attr(mf, \"terms\")");
        scriptBuilder.appendLn("xlev <- stats::.getXlevels(mt, mf)");
        scriptBuilder.appendLn("mt <- update(mt, . ~ . - 1)");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("x <- model.matrix(mt, mf)");
        scriptBuilder.appendLn("y <- model.response(mf)");
        scriptBuilder.appendLn();
        if (string.equals("glmnet")) {
            scriptBuilder.appendLn("if(is.null(family)) {");
            scriptBuilder.indent();
        }
        scriptBuilder.appendLn("if(is.logical(y) || (!is.factor(y) && all(y %in% c(0, 1)))) {");
        scriptBuilder.indent();
        switch (string) {
            case "xgboost": {
                scriptBuilder.appendLn("obj <- \"binary:logistic\"");
                scriptBuilder.appendLn("train <- xgboost::xgb.DMatrix(data = x, label = as.logical(y))");
                break;
            }
            case "glmnet": {
                scriptBuilder.appendLn("family <- \"binomial\"");
            }
        }
        scriptBuilder.unindent();
        scriptBuilder.appendLn("} else if(is.factor(y) || is.character(y)) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("y <- as.factor(y)");
        switch (string) {
            case "xgboost": {
                scriptBuilder.appendLn("obj <- \"multi:softprob\"");
                scriptBuilder.appendLn("train <- xgboost::xgb.DMatrix(data = x, label = as.integer(y) - 1)");
                break;
            }
            case "glmnet": {
                scriptBuilder.appendLn("family <- \"multinomial\"");
            }
        }
        scriptBuilder.unindent();
        scriptBuilder.appendLn("} else {");
        scriptBuilder.indent();
        switch (string) {
            case "xgboost": {
                scriptBuilder.appendLn("obj <- \"reg:linear\"");
                scriptBuilder.appendLn("train <- xgboost::xgb.DMatrix(data = x, label = y)");
                break;
            }
            case "glmnet": {
                scriptBuilder.appendLn("family <- \"gaussian\"");
            }
        }
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        if (string.equals("glmnet")) {
            scriptBuilder.unindent();
            scriptBuilder.appendLn("}");
        }
        scriptBuilder.appendLn();
        if (string.equals("xgboost")) {
            scriptBuilder.appendLn("cl <- quote(");
            scriptBuilder.indent();
            scriptBuilder.appendLn("xgboost::xgboost(data = train, objective = obj, boster = \"gbtree\", nrounds = nrounds, ...)");
            scriptBuilder.unindent();
            scriptBuilder.appendLn(")");
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("if(obj == \"multi:softprob\") cl$num_class <- length(levels(y))");
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("if(!is.null(.CV_ARGS)) {");
            scriptBuilder.indent();
            scriptBuilder.appendLn("cl_cv <- cl");
            scriptBuilder.appendLn("cl_cv[[1L]] <- quote(xgboost::xgb.cv)");
            scriptBuilder.appendLn("for(i in names(.CV_ARGS)) cl_cv[[i]] <- .CV_ARGS[[i]]");
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("cv_result <- eval(cl_cv)");
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("cl$nrounds <- cv_result$best_iteration");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("}");
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("model <- eval(cl)");
            scriptBuilder.appendLn();
        }
        if (string.equals("glmnet")) {
            scriptBuilder.appendLn("cl <- quote(glmnet::glmnet(x = x, y = y, family = family, ...))");
            scriptBuilder.appendLn("if(\"lambda\" %in% names(match.call())) {");
            scriptBuilder.indent();
            scriptBuilder.appendLn("stopifnot(length(alpha) == 1)");
            scriptBuilder.appendLn("cl$alpha <- alpha");
            scriptBuilder.appendLn("model <- eval(cl)");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("} else {");
            scriptBuilder.indent();
            scriptBuilder.appendLn("cl_cv <- cl");
            scriptBuilder.appendLn("cl_cv[[1L]] <- quote(glmnet::cv.glmnet)");
            scriptBuilder.appendLn("for(i in names(.CV_ARGS)) cl_cv[[i]] <- .CV_ARGS[[i]]");
            scriptBuilder.appendLn("if(length(alpha) == 1) {");
            scriptBuilder.indent();
            scriptBuilder.appendLn("cl_cv$alpha <- alpha");
            scriptBuilder.appendLn("model <- eval(cl_cv)");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("} else {");
            scriptBuilder.indent();
            scriptBuilder.appendLn("cl_cv$foldid <- if(is.null(.CV_ARGS$foldid)) {");
            scriptBuilder.indent();
            scriptBuilder.appendLn("sample(1:.CV_ARGS$nfolds, size = length(y), replace = TRUE)");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("} else {");
            scriptBuilder.indent();
            scriptBuilder.appendLn(".CV_ARGS$foldid");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("}");
            scriptBuilder.appendLn("cvlist <- list(alpha = alpha, cvfit = list())");
            scriptBuilder.appendLn("for(i in 1:length(alpha)) {");
            scriptBuilder.indent();
            scriptBuilder.appendLn("cl_cv_i <- cl_cv");
            scriptBuilder.appendLn("cl_cv_i$alpha <- alpha[i]");
            scriptBuilder.appendLn("cvlist$cvfit[[i]] <- eval(cl_cv_i)");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("}");
            scriptBuilder.appendLn("min_i <- which.min(unlist(lapply(cvlist$cvfit, function(x) min(x$cvm))))");
            scriptBuilder.appendLn("alpha <- cvlist$alpha[[min_i]]");
            scriptBuilder.appendLn("model <- cvlist$cvfit[[min_i]]");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("}");
            scriptBuilder.unindent();
            scriptBuilder.appendLn("}");
            scriptBuilder.appendLn();
        }
        scriptBuilder.appendLn("att <- list(terms = mt, xlevels = xlev)");
        if (string.equals("xgboost")) {
            scriptBuilder.appendLn("if(obj == \"multi:softprob\") att$ylevels <- levels(y)");
            scriptBuilder.appendLn("if(.IMPORTANCE) importance <- try(xgboost::xgb.importance(model = model))");
            scriptBuilder.appendLn("if(.IMPORTANCE && !inherits(importance, \"try-error\")) att$importance <- importance");
            scriptBuilder.appendLn();
        }
        if (string.equals("glmnet")) {
            scriptBuilder.appendLn("if(is.factor(y)) att$ylevels <- levels(y)");
            scriptBuilder.appendLn("att$family <- family");
            scriptBuilder.appendLn("att$alpha <- alpha");
            scriptBuilder.appendLn("if(exists(\"foldid\")) att$foldid <- foldid");
            scriptBuilder.appendLn("if(exists(\"cvlist\")) att$cvlist <- cvlist");
            scriptBuilder.appendLn();
        }
        scriptBuilder.appendLn("attr(model, \"_rflow_\") <- att");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("model");
        scriptBuilder.unind_Ln("}");
    }

    private String getAnonymousFunction(String string, String string2, ArgsList argsList, String string3, String string4, String string5) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < argsList.size(); i += 2) {
            hashMap.put((String)argsList.get(i), (String)argsList.get(i + 1));
        }
        ArgsList argsList2 = new ArgsList();
        argsList2.add("formula", "update(terms(" + string3 + ", data = " + string5 + "), . ~ 1)");
        argsList2.add("data", (String)hashMap.get("data"));
        argsList2.add("subset", (String)hashMap.get("subset"));
        argsList2.add("na.action", (String)hashMap.get("na.action"));
        RAnonymousFunction rAnonymousFunction = new RAnonymousFunction();
        ScriptBuilder scriptBuilder = new ScriptBuilder();
        scriptBuilder.appLnInd(rAnonymousFunction.getHeadStr());
        scriptBuilder.appendLn("y <- model.response(" + RUtility.function("model.frame", argsList2) + ")");
        scriptBuilder.appendLn("cl <- quote(" + string2 + ")");
        if (string.equals("nnet")) {
            scriptBuilder.appLnInd("if (is.character(y)) {");
            scriptBuilder.appendLn("cl$formula <- evalq(update(terms(" + string3 + ", data = " + string5 + "), as.factor(.) ~ .), envir = parent.frame())");
            scriptBuilder.unLn_Ind("} else if (is.logical(y) || all(y %in% c(0, 1))) {");
            scriptBuilder.appendLn("if (!(\"entropy\" %in% names(cl))) cl$entropy <- TRUE");
            scriptBuilder.unLn_Ind("} else if (is.numeric(y) && any(y > 1 | y < 0)) {");
            scriptBuilder.appendLn("if (!(\"linout\" %in% names(cl))) cl$linout <- TRUE");
            scriptBuilder.unind_Ln("}");
        } else if (string.equals("ranger")) {
            boolean bl = this.getValue(RANGER_CLASSIFY_BINARY);
            boolean bl2 = this.getValue(RANGER_AUTO_PROB);
            scriptBuilder.appLnInd("if(is.character(y)) {");
            scriptBuilder.appendLn("cl$formula <- evalq(update(terms(" + string3 + ", data = " + string5 + "), as.factor(.) ~ .), envir = parent.frame())");
            scriptBuilder.unind_Ln("}");
            if (bl) {
                scriptBuilder.appLnInd("if(is.logical(y) || (!is.factor(y) && all(y %in% c(0, 1)))) {");
                scriptBuilder.appendLn("cl$formula <- evalq(update(terms(" + string3 + ", data = " + string5 + "), as.factor(.) ~ .), envir = parent.frame())");
                scriptBuilder.unind_Ln("}");
            }
            if (bl2) {
                scriptBuilder.appLnInd("if (!(\"probability\" %in% names(cl))) {");
                scriptBuilder.appLnInd("if (is.factor(y) || is.character(y)" + (bl ? "|| is.logical(y) || all(y %in% c(0, 1))" : "") + ") {");
                scriptBuilder.appendLn("cl$probability <- TRUE");
                scriptBuilder.unind_Ln("}");
                scriptBuilder.unind_Ln("}");
            }
        }
        scriptBuilder.appendLn("eval.parent(cl)");
        scriptBuilder.unind_Ln(rAnonymousFunction.getTailStr());
        return scriptBuilder.toString();
    }

    private void rpartPrune(ScriptBuilder scriptBuilder, String string, boolean bl) {
        String string2 = string + "$cptable";
        if (bl) {
            scriptBuilder.appLnInd("prune_ <- function(" + string + ") {");
        }
        scriptBuilder.appLnInd("if (all(c(\"xerror\", \"xstd\") %in% colnames(" + string2 + "))) {");
        if (!bl) {
            scriptBuilder.append(string + " <- ");
        }
        scriptBuilder.appendLn("rpart::prune(" + string + ", cp = " + string2 + "[which.min(" + string2 + "[, \"xerror\"] + " + string2 + "[, \"xstd\"]), \"CP\"])");
        scriptBuilder.unind_Ln("} else {");
        scriptBuilder.indentLn("warning(\"Could not prune the tree without cross validation result\")");
        if (bl) {
            scriptBuilder.appendLn(string);
        }
        scriptBuilder.unind_Ln("}");
        if (bl) {
            scriptBuilder.unind_Ln("}");
        }
    }

    private void evaluation(ScriptBuilder scriptBuilder, boolean bl, boolean bl2, boolean bl3, PreviewOption previewOption) {
        if (bl) {
            scriptBuilder.appLnInd(RUtility.assign(this.getValue(EVAL_OUTPUT), RAnonymousFunction.getEmptyHeadStr()));
            scriptBuilder.appendLn("model_ <- " + RUtility.evalq(this.getValue(OUTPUT)));
        } else {
            scriptBuilder.appendLn();
            scriptBuilder.appendLn("models_ <- " + RUtility.evalq(this.getValue(OUTPUT)));
        }
        scriptBuilder.appendLn("testData_ <- " + RUtility.evalq(this.getValue(EVAL_TEST_DATA)));
        scriptBuilder.appendLn("y_ <- " + this.y("testData_"));
        scriptBuilder.appendLn();
        RPredict rPredict = bl ? RPredict.singlePredictForEvaluation("model_", "testData_", "predicts_", this.getValue(OUTPUT), this.getValue(EVAL_TYPE).equals(EVAL_BINARY)) : RPredict.modelListPredictForEvaluation("models_", "testData_", "predicts_", "try_", this.getValue(EVAL_TYPE).equals(EVAL_BINARY));
        rPredict.getRScript(scriptBuilder, bl2, bl3, previewOption);
        scriptBuilder.appendLn();
        REvaluate rEvaluate = REvaluate.instance("testData_", "y_", "predicts_", bl ? "" : "eval_", this.getValue(EVAL_TYPE), this.getValue(EVAL_SORT_RESULT), this.getValue(EVAL_SORT_COLUMN), this.getValue(EVAL_CONF_MATRIX), this.getValue(EVAL_CHART), bl);
        rEvaluate.getRScript(scriptBuilder, bl2, bl3, previewOption);
        if (bl) {
            scriptBuilder.unind_Ln(RAnonymousFunction.getEmptyTailStr());
        } else {
            scriptBuilder.appendLn("assign(" + RModeling.quote(this.getValue(EVAL_OUTPUT)) + ", eval_, envir = parent.frame())");
        }
    }

    private void getRScript(ScriptBuilder scriptBuilder, ROperation rOperation, ROperation rOperation2, String string, String string2, String string3, String string4, boolean bl) {
        boolean bl2;
        int n;
        Object object;
        Object object2;
        Object object3;
        boolean bl3 = this.getValue(INTERFACE).equals(SINGLE);
        String string5 = this.getUpperFormula(rOperation);
        String string6 = this.getLowerFormula(rOperation);
        ArgsList argsList = new ArgsList();
        String string7 = rOperation.getValue(METHOD);
        boolean bl4 = false;
        if (rOperation.getValue(STEPWISE).booleanValue()) {
            switch (string7) {
                case "lm": 
                case "logit": 
                case "glm": 
                case "multinom": {
                    bl4 = true;
                }
            }
        }
        boolean bl5 = bl4 && (rOperation.getValue(STEPWISE_DIRECTION).equals("forward") || rOperation.getValue(STEPWISE_DIRECTION).equals("forward_both"));
        argsList.add("formula", bl5 ? string6 : string5);
        argsList.add("data", string);
        ROperation rOperation3 = rOperation2 == null ? rOperation : rOperation2;
        String string8 = rOperation3.getValue(WEIGHTS);
        if (!string8.isEmpty()) {
            if (string7.equals("ranger")) {
                argsList.add("case.weights", RUtility.function("with", "", string, "", string8));
            } else if (string7.equals("xgboost")) {
                argsList.add("weight", RUtility.function("with", "", string, "", string8));
            } else {
                argsList.add("weights", string8);
            }
        }
        Object object4 = string7;
        switch (string7) {
            case "lm": {
                object4 = "lm";
                argsList.add("model", "FALSE");
                argsList.addAll(rOperation.getArgs(ARGS_LM));
                break;
            }
            case "logit": {
                object4 = "glm";
                argsList.add("family", "binomial(logit)");
                argsList.add("model", "FALSE");
                argsList.addAll(rOperation.getArgs(ARGS_GLM));
                break;
            }
            case "multinom": {
                object4 = "nnet::multinom";
                argsList.addAll(rOperation.getArgs(ARGS_MULTINOM));
                break;
            }
            case "glm": {
                object4 = "glm";
                argsList.add("family", rOperation.getValue(FAMILY));
                argsList.add("model", "FALSE");
                argsList.addAll(rOperation.getArgs(ARGS_GLM));
                break;
            }
            case "rpart": {
                object4 = "rpart::rpart";
                argsList.add("method", rOperation.getValue(RPART_METHOD));
                String string9 = RUtility.function("rpart::rpart.control", rOperation.getArgs(ARGS_RPART_CONTROL), "minsplit", rOperation.getValue(RPART_MINSPLIT), "minbucket", rOperation.getValue(RPART_MINBUCKET), "cp", rOperation.getValue(RPART_CP), "xval", rOperation.getValue(RPART_XVAL), "maxdepth", rOperation.getValue(RPART_MAX_DEPTH));
                if (!string9.equals("rpart::rpart.control()")) {
                    argsList.add("control", string9);
                }
                argsList.addAll(rOperation.getArgs(ARGS_RPART));
                break;
            }
            case "nnet": {
                object4 = bl3 ? "nnet::nnet" : ".(nnet_)";
                argsList.add("size", rOperation.getValue(NNET_SIZE));
                argsList.add("decay", rOperation.getValue(NNET_DECAY));
                argsList.add("maxit", rOperation.getValue(NNET_MAXIT));
                argsList.addAll(rOperation.getArgs(ARGS_NNET));
                break;
            }
            case "ranger": {
                object4 = bl3 ? "ranger::ranger" : ".(ranger_)";
                object3 = rOperation.getValue(RANGER_NUM_TREES);
                if (bl) {
                    object2 = "10";
                    object3 = ((String)object3).isEmpty() ? object2 : "min(" + (String)object2 + ", " + (String)object3 + ")";
                }
                argsList.add("num.trees", (String)object3);
                argsList.add("mtry", rOperation.getValue(RANGER_MTRY));
                argsList.add("importance", rOperation.getValue(RANGER_IMPORTANCE));
                argsList.add("min.node.size", rOperation.getValue(RANGER_MIN_NODE_SIZE));
                argsList.addAll(rOperation.getArgs(ARGS_RANGER));
                if (bl3) break;
                argsList.add(".AUTO_PROB", RUtility.toRBoolean(rOperation.getValue(RANGER_AUTO_PROB)));
                argsList.add(".CLASSIFY_BINARY", RUtility.toRBoolean(rOperation.getValue(RANGER_CLASSIFY_BINARY)));
                break;
            }
            case "xgboost": {
                if (bl3) {
                    object2 = new ScriptBuilder();
                    this.appendCustomFunc((ScriptBuilder)object2, "xgboost", false);
                    object4 = "(" + ((ScriptBuilder)object2).toString() + ")";
                } else {
                    object4 = ".(xgboost_)";
                }
                if (rOperation.getValue(XGBOOST_CV).booleanValue()) {
                    object2 = rOperation.getValue(XGBOOST_CV_MAXIT);
                    if (bl) {
                        object2 = "min(2, " + (String)object2 + ")";
                    }
                    argsList.add("nrounds", (String)object2);
                    object = new ArgsList();
                    ((ArgsList)object).add("nfold", rOperation.getValue(XGBOOST_CV_NFOLDS));
                    ((ArgsList)object).add("early_stopping_rounds", rOperation.getValue(XGBOOST_CV_EARLY_STOP));
                    ((ArrayList)object).addAll(rOperation.getArgs(ARGS_XGBOOST_CV));
                    argsList.add(".CV_ARGS", RUtility.function("list", (Collection<String>)object));
                } else {
                    object2 = rOperation.getValue(XGBOOST_NROUNDS);
                    if (bl) {
                        object2 = "min(2, " + (String)object2 + ")";
                    }
                    argsList.add("nrounds", (String)object2);
                    argsList.add(".CV_ARGS", "NULL");
                }
                argsList.add(".IMPORTANCE", RUtility.toRBoolean(rOperation.getValue(XGBOOST_IMPORTANCE)));
                argsList.add("eta", rOperation.getValue(XGBOOST_ETA));
                argsList.add("max_depth", rOperation.getValue(XGBOOST_MAX_DEPTH));
                argsList.addAll(rOperation.getArgs(ARGS_XGBOOST));
                break;
            }
            case "glmnet": {
                if (bl3) {
                    object2 = new ScriptBuilder();
                    this.appendCustomFunc((ScriptBuilder)object2, "glmnet", false);
                    object4 = "(" + ((ScriptBuilder)object2).toString() + ")";
                } else {
                    object4 = ".(glmnet_)";
                }
                argsList.add("family", rOperation.getValue(GLMNET_FAMILY));
                switch (rOperation.getValue(GLMNET_TYPE)) {
                    case "grid_search": {
                        if (bl) {
                            argsList.add("alpha", "median(" + rOperation.getValue(GLMNET_ALPHA_GRID) + ")");
                            break;
                        }
                        argsList.add("alpha", rOperation.getValue(GLMNET_ALPHA_GRID));
                        break;
                    }
                    case "lasso": {
                        argsList.add("alpha", "1");
                        break;
                    }
                    case "ridge": {
                        argsList.add("alpha", "0");
                    }
                }
                object2 = new ArgsList();
                ((ArgsList)object2).add("nfolds", rOperation.getValue(GLMNET_NFOLDS));
                ((ArrayList)object2).addAll(rOperation.getArgs(ARGS_CV_GLMNET));
                argsList.add(".CV_ARGS", RUtility.function("list", (Collection<String>)object2));
                if (rOperation.getValue(EXCLUDE_INTERCEPT).booleanValue()) {
                    argsList.add("intercept", "FALSE");
                }
                argsList.addAll(rOperation.getArgs(ARGS_GLMNET));
                break;
            }
        }
        Object object5 = RUtility.function((String)object4, argsList);
        int n2 = n = rOperation.getValue(METHOD).equals("rpart") && rOperation.getValue(RPART_AUTO_PRUNING) != false ? 1 : 0;
        if (!bl3 && n != 0) {
            object5 = ".(prune_)(" + (String)object5 + ")";
        }
        if (bl3 && string7.equals("nnet")) {
            object5 = this.getAnonymousFunction(string7, (String)object5, argsList, string5, string, string2);
        }
        boolean bl6 = bl2 = rOperation.getValue(RANGER_AUTO_PROB) != false || rOperation.getValue(RANGER_CLASSIFY_BINARY) != false;
        if (bl3 && string7.equals("ranger") && bl2) {
            object5 = this.getAnonymousFunction(string7, (String)object5, argsList, string5, string, string2);
        }
        if (bl4) {
            object3 = null;
            object2 = "terms(" + string6 + ", data = " + string2 + ")";
            object = "terms(" + string5 + ", data = " + string2 + ")";
            object3 = bl5 ? object : (rOperation.getValue(USE_LOWER) != false ? RUtility.function("list", new String[]{"lower", object2, "upper", object}) : object);
            String string10 = rOperation.getValue(STEPWISE_DIRECTION);
            if (string10.equals("backward_both") || string10.equals("forward_both")) {
                string10 = "both";
            }
            object5 = RUtility.function("step", rOperation.getArgs(ARGS_STEP), new String[]{"", object5, "direction", RUtility.quote(string10), "scope", object3});
        }
        object3 = RUtility.assign(string3, (String)object5);
        if (!bl3) {
            object3 = ".(try_)(" + (String)object3 + ", " + RModeling.quote(string4) + ")";
        }
        scriptBuilder.appendLn((CharSequence)object3);
        if (bl3 && n != 0) {
            this.rpartPrune(scriptBuilder, string3, false);
        }
    }

    private String getSubset(ROperation rOperation) {
        ListModel<ValueMap> listModel = rOperation.getValue(SUBSET_CONDITIONS);
        List<ValueMap> list = SUBSET_CONDITIONS.validElements(listModel);
        if (list.isEmpty()) {
            return "";
        }
        boolean bl = rOperation.getValue(SUBSET_TYPE).equals(X_EXCLUDE);
        boolean bl2 = rOperation.getValue(SUBSET_LOGICAL).equals("OR");
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("!(");
        }
        for (int i = 0; i < list.size(); ++i) {
            ValueMap valueMap = list.get(i);
            if (n > 1) {
                stringBuilder.append("(");
            }
            if (valueMap instanceof RFormRowSelector) {
                stringBuilder.append(((RFormRowSelector)valueMap).getExpression());
            } else if (valueMap instanceof RSimpleRowSelector) {
                stringBuilder.append(((RSimpleRowSelector)valueMap).getExpression());
            }
            if (n > 1) {
                stringBuilder.append(")");
            }
            if (i == list.size() - 1) continue;
            stringBuilder.append(bl2 ? " | " : " & ");
        }
        if (bl) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean showPreviewInBrowser() {
        return this.getValue(INTERFACE).equals(MULTIPLE_LIST);
    }

    @Override
    protected String[] getNewRObjects() {
        switch (this.getValue(INTERFACE)) {
            case "single": 
            case "multiple_list": {
                if (this.getValue(EVALUATION, false).booleanValue()) {
                    return new String[]{this.getValue(OUTPUT), this.getValue(EVAL_OUTPUT)};
                }
                return new String[]{this.getValue(OUTPUT)};
            }
        }
        return super.getNewRObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RModeling runSelectionInstance(int[] nArray) {
        RModeling rModeling = (RModeling)this.copy();
        rModeling.putValue(APPEND, Boolean.TRUE);
        KeysTableModel keysTableModel = rModeling.getValue(MODELS);
        List<ValueMap> list = keysTableModel.getValues(MODEL);
        keysTableModel.beginValueChange();
        try {
            keysTableModel.removeAllRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0 || n >= list.size()) continue;
                keysTableModel.addNewRow(list.get(n));
            }
        }
        finally {
            keysTableModel.endValueChange();
        }
        return rModeling;
    }

    @Override
    protected void processValueChanged(ValueChangeEvent valueChangeEvent) {
        super.processValueChanged(valueChangeEvent);
        Key<?> key = valueChangeEvent.getKey();
        if (this.getValue(EVALUATION).booleanValue() && this.getValue(EVAL_TYPE_AUTO).booleanValue() && (EVALUATION == key || DATA == key || FORMULA_TYPE == key || FORMULA_Y == key || FORMULA_TEXT == key || FORMULA_OBJECT == key)) {
            this.autoDetectType();
        }
    }

    private void autoDetectType() {
        if (this.getValue(DATA).isEmpty()) {
            return;
        }
        String string = RModeling.scriptBuilder().appendLn("(function(y) {").appendLn("if (inherits(y, \"try-error\")) { \"\" ").appendLn("} else if (is.logical(y) || (is.character(y) && (all(y %in% c(\"0\", \"1\")) || all(y %in% c(\"FALSE\", \"TRUE\"))))) { \"binary\" ").appendLn("} else if (is.factor(y) || is.character(y)) { \"category\" ").appendLn("} else if (is.numeric(y) && head(y, 1000) %in% c(0, 1)) { \"binary\" ").appendLn("} else if (is.numeric(y)) { \"numeric\" ").appendLn("} else { \"\" }").appendLn("})(y = try(" + this.y(this.getValue(DATA)) + ", silent = TRUE))").toString();
        R.queryQueue().addQuery(() -> {
            String string2;
            switch (string2 = RClient.rexpToString(R.client().silentTimeoutEvalGet(string), "")) {
                case "category": {
                    this.putValue(EVAL_TYPE, EVAL_CATEGORY);
                    break;
                }
                case "binary": {
                    this.putValue(EVAL_TYPE, EVAL_BINARY);
                    break;
                }
                case "numeric": {
                    this.putValue(EVAL_TYPE, EVAL_NUMERIC);
                    break;
                }
            }
        });
    }

    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if ("eval".equals(string)) {
            RModeling rModeling = (RModeling)this.copy();
            rModeling.putValue(EVAL_RUN, Boolean.TRUE);
            FlowRunOption flowRunOption = FlowRunOption.createRunImmediatelyOption().setFocusResult(true);
            NodeModelTask nodeModelTask = new NodeModelTask(flowRunOption, new UINodeModel(rModeling));
            OpExecutor opExecutor = (OpExecutor)widgetNode.getRoot().getProperty(OpExecutor.PROPERTY_EXECUTOR);
            if (opExecutor != null) {
                opExecutor.run(nodeModelTask);
            } else {
                TaskQueue.getInstance().addTask(nodeModelTask);
            }
        }
    }

    @Override
    public RPackage[] getRPackages() {
        if (this.getValue(INTERFACE).equals(SINGLE)) {
            String string2 = (String)METHOD_PACKAGE_MAP.get(this.getValue(METHOD));
            if (string2 == null) {
                return null;
            }
            return new RPackage[]{new RPackage(string2, true, false)};
        }
        RPackage[] rPackageArray = (RPackage[])this.getValue(MODELS).getValues(MODEL).stream().map(valueMap -> (String)METHOD_PACKAGE_MAP.get(valueMap.getValue(METHOD))).filter(string -> string != null).distinct().map(string -> new RPackage((String)string, true, false)).toArray(RPackage[]::new);
        if (rPackageArray.length == 0) {
            return null;
        }
        return rPackageArray;
    }

    private static /* synthetic */ boolean lambda$getRScript$1(String string, String string2) {
        return !string2.equals(string);
    }
}

