/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.app.r.console.ConsoleEntry;
import com.ef_prime.rflow.core.app.r.keyvalue.RArgsKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.flow.FlowRunOption;
import com.ef_prime.rflow.core.task.Task;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.PreviewFunction;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RConsoleResultView;
import com.ef_prime.rflow.ui.app.r.RObjectPreviewView;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import com.ef_prime.rflow.ui.common.component.Flavors;
import com.ef_prime.rflow.ui.common.item.ItemManager;
import com.ef_prime.rflow.ui.common.item.ItemManagers;
import com.ef_prime.rflow.ui.common.item.ItemName;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ROperation
extends Operation {
    public static final String PREVIEW_PROPERTY_ENV = "PREVIEW_PROPERTY_ENV";
    public static final String VALUE_LINK_INPUT = "r.input";
    private List<ConsoleEntry> consoleEntries;
    public static final PreviewFunction<String> DATA_PREVIEW = new PreviewFunction<String>(){

        @Override
        public String apply(String string, ValueMap valueMap, PreviewOption previewOption) {
            return ROperation.data(string, previewOption);
        }
    };
    public static final PreviewFunction<String> ROW_NUMBER_PREVIEW = new PreviewFunction<String>(){

        @Override
        public String apply(String string, ValueMap valueMap, PreviewOption previewOption) {
            return ROperation.rowNumber(string, previewOption);
        }
    };

    public ROperation() {
    }

    protected ROperation(ROperation rOperation) {
        super(rOperation);
    }

    public static RChoiceKey logicalKey(String string, String string2, String string3) {
        return ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder(string, string2).setDefaultValue(string3)).setValues("", "TRUE", "FALSE")).build();
    }

    public static RChoiceKey logicalKey(String string, String string2, String string3, String string4, String string5) {
        return ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder(string, string2).setDefaultValue(string3)).setValuesAndLabels("", "", "TRUE", string4, "FALSE", string5)).build();
    }

    public static ChoiceKey argsSwitchKey(String string, AutoValueLink autoValueLink, String ... stringArray) {
        ChoiceKey.Builder<?> builder = ChoiceKey.builder(string, "");
        builder.setValues(stringArray);
        builder.setLabelPosition("none");
        if (autoValueLink != null) {
            builder.setAutoValueLink(autoValueLink);
        }
        return builder.build();
    }

    public static RArgsKey argsKey(String string, String string2, String string3, ChoiceKey choiceKey, String ... stringArray) {
        if (string3 == null) {
            string3 = string2;
        }
        String string4 = Messages.format("Widget.R.parameters", string3);
        RArgsKey.Builder<?> builder = RArgsKey.builder(string, string4, string2, stringArray);
        builder.setFunctionLabel(string3);
        if (choiceKey != null) {
            builder.addVisibleKeyLink(choiceKey, string3);
        }
        builder.setDefaultRowPredicate();
        return builder.build();
    }

    public static RArgsKey argsKey(String string) {
        return ROperation.argsKey(string, null, new String[0]);
    }

    public static RArgsKey argsKey(String string, String string2, String ... stringArray) {
        return ROperation.argsKey("advanced", string, string2, null, stringArray);
    }

    protected List<String> getArgs(RTableKey rTableKey) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (KeysTableRow keysTableRow : this.getValue(rTableKey).validRows()) {
            arrayList.add((String)keysTableRow.getValue(0));
            arrayList.add((String)keysTableRow.getValue(1));
        }
        return arrayList;
    }

    protected static String quote(String string) {
        return RUtility.quote(string);
    }

    protected static String unquote(String string) {
        return RUtility.unquote(string);
    }

    protected static String sQuote(String string) {
        return new StringBuilder(string.length() + 2).append('\"').append(string).append('\"').toString();
    }

    protected static String makeName(String string) {
        return RUtility.makeName(string);
    }

    protected static String suffix(String string, String string2) {
        if (string.isEmpty()) {
            return string2;
        }
        if (string.length() > 1 && string.charAt(string.length() - 1) == '`') {
            return string.substring(0, string.length() - 1) + string2 + "`";
        }
        return string + string2;
    }

    @Override
    public void setPreviewOption(PreviewOption previewOption) {
        for (Key<?> key : this.keySet()) {
            String string;
            RStrKey rStrKey;
            if (!(key instanceof RStrKey) || !(rStrKey = (RStrKey)key).isOutput() || (string = this.getValue(rStrKey)).isEmpty()) continue;
            this.putValueQuietly(rStrKey, ROperation.makeName(string));
        }
        super.setPreviewOption(previewOption);
    }

    protected void setPreviewData(StrKey strKey, PreviewOption previewOption) {
        this.putValue(strKey, ROperation.data(this.getValue(strKey), previewOption));
    }

    public static String data(String string, PreviewOption previewOption) {
        if (!previewOption.isEnabled() || previewOption.useAllRows()) {
            return string;
        }
        if (StringUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return "head(" + string + ", n = " + previewOption.getNumber() + ")";
    }

    protected static String rowNumber(String string, PreviewOption previewOption) {
        if (!previewOption.isEnabled() || previewOption.useAllRows()) {
            return string;
        }
        long l = previewOption.getNumber();
        if (StringUtils.isEmpty((CharSequence)string)) {
            return String.valueOf(l);
        }
        return "if(" + string + " > 0) min(" + string + ", " + l + ") else " + l;
    }

    protected static ScriptBuilder scriptBuilder() {
        return new ScriptBuilder("\n");
    }

    public RPackage[] getRPackages() {
        return null;
    }

    public List<ConsoleEntry> getConsoleEntries() {
        return this.consoleEntries;
    }

    private void run(Task task, boolean bl, Command command) throws Exception {
        FlowRunOption flowRunOption = task.getOption();
        if (task.getPreviewOption().isEnabled()) {
            command.setCheckError(true);
            command.setNoRecover(true);
            if (!Rflow.isDevel() || !Rflow.develSettings().isOutputPreviewCode()) {
                command.setCaptureOutput(true);
            }
        } else {
            if (flowRunOption.isCheckError()) {
                command.setCheckError(true);
            }
            if (flowRunOption.isNoRecover()) {
                command.setNoRecover(true);
            }
        }
        R.receiver().passCommand(command);
        this.waitForCommand(command);
        this.consoleEntries = command.getConsoleEntries();
        if (command.isError()) {
            R.client().fireItemStructureChanged();
            throw new Exception(ConsoleEntry.getError(this.consoleEntries, "Error occurred while running R."));
        }
    }

    @Override
    public void run(Task task, boolean bl) throws Exception {
        FlowRunOption flowRunOption = task.getOption();
        Command command = this.getRCommand(bl, flowRunOption.dontSplitCommand(), true, task.getPreviewOption());
        this.run(task, bl, command);
    }

    @Override
    public void runSavedCommand(Task task, String string) throws Exception {
        BasicCommand basicCommand = new BasicCommand(string);
        this.run(task, false, basicCommand);
    }

    @Override
    public ItemManager getItemManager() {
        return ItemManagers.getInstance().get(Apps.R.getId());
    }

    @Override
    public ItemName[] getNewItemNames() {
        Object[] objectArray = this.getNewRObjects();
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return null;
        }
        ItemName[] itemNameArray = new ItemName[objectArray.length];
        for (int i = 0; i < itemNameArray.length; ++i) {
            itemNameArray[i] = new ItemName(Apps.R.getId(), (String)objectArray[i]);
        }
        return itemNameArray;
    }

    @Override
    public List<ItemName> checkOverwrite() {
        Object[] objectArray = this.getNewItemNames();
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return null;
        }
        List<String> list = Arrays.stream(objectArray).map(itemName -> itemName.getName()).collect(Collectors.toList());
        String string = RUtility.combineCharacters(list);
        boolean[] blArray = RClient.rexpToBooleans(R.client().silentIdleEvalGet(string + " %in% ls(envir = globalenv())"), null);
        if (blArray == null) {
            return null;
        }
        ArrayList<ItemName> arrayList = new ArrayList<ItemName>(objectArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            arrayList.add((ItemName)objectArray[i]);
        }
        return arrayList;
    }

    @Override
    public boolean isSupported(App app) {
        return app == Apps.R;
    }

    @Override
    public boolean canImport(Transferable transferable) {
        if (this.getRObjectImportKey() != null && RObjectFlavor.isSupported(transferable)) {
            Predicate<RObject> predicate;
            if (this.getRObjectImportKey() instanceof RChoiceKey && (predicate = ((RChoiceKey)this.getRObjectImportKey()).getCompletionSupport().getFilter()) != null) {
                RObject rObject = RObjectFlavor.getOnlyObject(transferable);
                if (rObject == null) {
                    return false;
                }
                return predicate.test(rObject);
            }
            return true;
        }
        if (this.getFileImportKey() != null) {
            File file = Flavors.getOnlyFile(transferable);
            FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
            return this.canImportFile(fileInfo);
        }
        return false;
    }

    @Override
    protected void importValues(Transferable transferable) {
        Object object;
        if (this.getRObjectImportKey() != null && RObjectFlavor.isSupported(transferable) && (object = RObjectFlavor.get(transferable)) != null && !object.isEmpty()) {
            this.putValue(this.getRObjectImportKey(), ((RObject)object.get(0)).getFullName(true));
        }
        if (this.getFileImportKey() != null && Flavors.isFileFlavorSupported(transferable) && (object = Flavors.getFile(transferable)) != null) {
            object = WorkingDirectory.toAbstractPath((File)object);
            this.putValue(this.getFileImportKey(), RUtility.quotedPath(((File)object).getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importToTable(TableKey tableKey, int n, List<RObject> list, boolean bl) {
        KeysTableModel keysTableModel = this.getValue(tableKey);
        keysTableModel.beginValueChange();
        try {
            for (RObject rObject : list) {
                KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getDefaultRow();
                keysTableRow.setValue(rObject.getName(bl), n);
                keysTableModel.addRow(keysTableRow);
            }
        }
        finally {
            keysTableModel.endValueChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importToTableFullName(TableKey tableKey, int n, List<RObject> list) {
        KeysTableModel keysTableModel = this.getValue(tableKey);
        keysTableModel.beginValueChange();
        try {
            for (RObject rObject : list) {
                KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getDefaultRow();
                keysTableRow.setValue(rObject.getFullName(true), n);
                keysTableModel.addRow(keysTableRow);
            }
        }
        finally {
            keysTableModel.endValueChange();
        }
    }

    protected boolean test(RChoiceKey rChoiceKey, RObject rObject) {
        Predicate<RObject> predicate = rChoiceKey.getCompletionSupport().getFilter();
        if (predicate != null) {
            return predicate.test(rObject);
        }
        return true;
    }

    protected boolean isDataOrColumns(Transferable transferable, RChoiceKey rChoiceKey) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        RObject rObject = list.get(0);
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null) {
            return this.test(rChoiceKey, rObject) && list.size() == 1;
        }
        if (this.test(rChoiceKey, rObject)) {
            return list.size() == 1;
        }
        return this.test(rChoiceKey, rObject2);
    }

    protected void importDataOrColumns(Transferable transferable, RChoiceKey rChoiceKey, TableKey tableKey, int n, boolean bl) {
        this.importDataOrColumns(transferable, rChoiceKey, list -> this.importToTable(tableKey, n, (List<RObject>)list, bl));
    }

    protected void importDataOrColumns(Transferable transferable, RChoiceKey rChoiceKey, Consumer<List<RObject>> consumer) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        RObject rObject = list.get(0);
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null || this.test(rChoiceKey, rObject)) {
            this.putValue(rChoiceKey, rObject.getFullName(false));
        } else {
            this.putValue(rChoiceKey, rObject2.getFullName(false));
            consumer.accept(list);
        }
    }

    protected StrKey getRObjectImportKey() {
        return null;
    }

    protected StrKey getFileImportKey() {
        return null;
    }

    protected boolean canImportFile(FileInfo fileInfo) {
        return false;
    }

    public StrKey getFileExportKey() {
        return null;
    }

    protected StrKey getOutputKey() {
        return null;
    }

    protected String[] getNewRObjects() {
        if (this.getOutputKey() != null) {
            return new String[]{this.getValue(this.getOutputKey())};
        }
        String string = null;
        try {
            string = this.getRScript(false, false, PreviewOption.OFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return R.client().findNewVariables(string);
    }

    public boolean showPreviewInBrowser() {
        return false;
    }

    protected void waitForCommand(Command command) {
        while (!command.isDone()) {
            try {
                command.waitForCommand(50L);
            }
            catch (InterruptedException interruptedException) {
                Rflow.getInstance().getConsole().stopIfBusy();
                break;
            }
        }
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getContentWidgetNode(viewOptions);
        if (!viewOptions.isWizard()) {
            return this.createTabPaneWithScript(widgetNode);
        }
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        WidgetNode widgetNode2 = this.getPreviewWidgetNode();
        if (widgetNode2 != null) {
            tabPaneWidgetNode.add(widgetNode2);
            tabPaneWidgetNode.add(new ViewWidgetNode(RConsoleResultView.class));
        }
        tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
        if (!(widgetNode instanceof TabPaneWidgetNode)) {
            TabPaneWidgetNode tabPaneWidgetNode2 = new TabPaneWidgetNode();
            tabPaneWidgetNode2.addTab("Main", widgetNode);
            widgetNode = tabPaneWidgetNode2;
        }
        return this.createSplitPaneWidgetNode().addElements(widgetNode, tabPaneWidgetNode);
    }

    protected SplitPaneWidgetNode createSplitPaneWidgetNode() {
        return new SplitPaneWidgetNode(true, this.getSplitHeight());
    }

    protected int getSplitHeight() {
        return 300;
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return new ViewWidgetNode(RObjectPreviewView.class);
    }

    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return super.getWidgetNode(viewOptions);
    }

    protected TabPaneWidgetNode createTabPaneWithScript(WidgetNode widgetNode) {
        if (widgetNode instanceof TabPaneWidgetNode) {
            TabPaneWidgetNode tabPaneWidgetNode = (TabPaneWidgetNode)widgetNode;
            tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
            return tabPaneWidgetNode;
        }
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        tabPaneWidgetNode.addTab("Main", widgetNode);
        tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
        return tabPaneWidgetNode;
    }

    protected void appendArgs(Collection<String> collection, String ... stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            if (StringUtils.isEmpty((CharSequence)string2)) continue;
            collection.add(string);
            collection.add(string2);
        }
    }

    protected void appendArgs(Collection<String> collection, StrKey ... strKeyArray) {
        for (StrKey strKey : strKeyArray) {
            String string = this.getValue(strKey);
            if (StringUtils.isEmpty((CharSequence)string)) continue;
            String string2 = strKey.getId();
            collection.add(string2);
            collection.add(string);
        }
    }

    protected Optional<String> getDefaultEncoding() {
        String string;
        String string2;
        Charset charset = Rflow.project().getCharset(Charset.defaultCharset());
        String string3 = string2 = R.client() != null ? R.client().getNativeEncoding() : null;
        if (string2 == null) {
            string2 = "";
        }
        return StringUtils.isEmpty((CharSequence)(string = RUtility.toREncoding(charset, string2))) ? Optional.empty() : Optional.of(string);
    }

    protected Optional<String> getDefaultNewline() {
        String string;
        switch (string = Rflow.project().getNewline()) {
            case "LF": {
                return Optional.of(ROperation.sQuote("\\n"));
            }
            case "CRLF": {
                return Optional.of(ROperation.sQuote("\\r\\n"));
            }
        }
        return Optional.empty();
    }
}

