/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTextKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RPrcomp
extends ROperation {
    private static final String X_ALL = "all";
    private static final String X_INCLUDE = "include";
    private static final String X_EXCLUDE = "exclude";
    private static final String X_INPUT = "input";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((Key.Builder)RStrKey.builder("_output", "Output").setOutput(true)).setAutoValueLink(DATA)).build();
    private static final RadioButtonKey FORMULA_X = ((RadioButtonKey.Builder)RadioButtonKey.builder("variables", "Variables").setValuesAndLabels("all", "All Numerics", "include", "Include", "exclude", "Exclude", "input", "Input Formula")).build();
    private static final RChoiceKey FORMULA_COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("formula_column", "X").setChoiceProvider(new ColumnChoiceProvider(DATA, FORMULA_X))).build();
    private static final RTableKey FORMULA_LIST = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("formula_list", "Input (X)", FORMULA_COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(FORMULA_X, "include", "exclude")).setDefaultRowPredicate()).setLabelPosition("none")).setWidth(500)).build();
    private static final RTextKey FORMULA_TEXT = ((RTextKey.Builder)((RTextKey.Builder)((Key.Builder)RTextKey.builder("formula_text", "").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addVisibleKeyLink(FORMULA_X, "input")).setLabelPosition("none")).build();
    private static final BoolKey SCALE = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("scale.", "Use Correlation Matrix").setDefaultValue(Boolean.TRUE)).setLabelPosition("none")).build();
    private static final RTableKey ADVANCED = RPrcomp.argsKey("stats:::prcomp.formula", "prcomp", new String[0]);

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, FORMULA_X, FORMULA_LIST, FORMULA_TEXT, SCALE, ADVANCED);
    }

    @Override
    protected String getDefaultTitle() {
        return "Principal Component Analysis";
    }

    @Override
    public String getOpClass() {
        return "summary";
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return RPrcomp.suffix(this.getValue(DATA), ".pc");
        }
        return super.getAutoValue(key);
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, SCALE, FORMULA_X, FORMULA_LIST, FORMULA_TEXT).addTabWithElements("Advanced", ADVANCED);
        return tabPaneWidgetNode;
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        ArgsList argsList = new ArgsList();
        this.addFormulaOrData(argsList);
        argsList.add("scale.", RUtility.toRBoolean(this.getValue(SCALE)));
        argsList.addAll(this.getArgs(ADVANCED));
        return RUtility.assignFunction(this.getValue(OUTPUT), "prcomp", argsList);
    }

    private void addFormulaOrData(ArgsList argsList) {
        String string = this.getValue(FORMULA_X);
        if (string.equals(X_INPUT)) {
            argsList.add("formula", this.getValue(FORMULA_TEXT));
        } else {
            if (string.equals(X_ALL)) {
                argsList.add("x", this.getValue(DATA) + "[ , sapply(" + this.getValue(DATA) + ", is.numeric)]");
                return;
            }
            List<String> list = this.getValue(FORMULA_LIST).getValues(FORMULA_COLUMN);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ~ ");
            if (string.equals(X_INCLUDE)) {
                if (list.isEmpty()) {
                    stringBuilder.append("1");
                } else {
                    stringBuilder.append(StringUtils.join(list, (String)" + "));
                }
            } else {
                stringBuilder.append(".");
                if (!list.isEmpty()) {
                    stringBuilder.append(" - ");
                    stringBuilder.append(StringUtils.join(list, (String)" - "));
                }
            }
            argsList.add("formula", stringBuilder.toString());
        }
        argsList.add("data", this.getValue(DATA));
    }

    private static class ColumnChoiceProvider
    implements ChoiceProvider {
        private StrKey dataKey;
        private StrKey xTypeKey;

        public ColumnChoiceProvider(StrKey strKey, StrKey strKey2) {
            this.dataKey = strKey;
            this.xTypeKey = strKey2;
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            boolean bl = valueMap.getValue(this.xTypeKey).equals(RPrcomp.X_INCLUDE);
            String string = bl ? "is.numeric" : "";
            String[] stringArray = R.client().getNames(valueMap.getValue(this.dataKey), true, string, null);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }
    }
}

