/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RAnonymousFunction;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BasicValueError;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValidationContext;
import com.ef_prime.rflow.core.common.keyvalue.Validator;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import com.google.common.collect.Sets;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RPredict
extends ROperation {
    private static final String[] MODEL_CLASSES = new String[]{"lm", "glm", "rpart", "nnet", "ranger", "xgb.Booster", "glmnet", "cv.glmnet", "prcomp"};
    private static final String SINGLE = "single";
    private static final String MULTIPLE = "multiple";
    private static final String MULTIPLE_LIST = "multiple_list";
    private static final String OUTPUT_TYPE_SELECT = "select";
    private static final String OUTPUT_TYPE_INPUT = "input";
    private static final String TYPE_PROB = "prob";
    private static final String TYPE_CLASS = "class";
    private static final RadioButtonKey INTERFACE = ((RadioButtonKey.Builder)RadioButtonKey.builder("interface", "Model").setValuesAndLabels("single", "Single", "multiple_list", "List", "multiple", "Multiple")).build();
    private static final RChoiceKey MODEL_OBJECT = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("model_object", "Model").setCompletionSupport(RChoiceProvider.inherits(1, MODEL_CLASSES))).addVisibleKeyLink(INTERFACE, "single")).build();
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).build();
    private static final RadioButtonKey OUTPUT_TYPE = ((RadioButtonKey.Builder)RadioButtonKey.builder("output_type", "Output").setValuesAndLabels("select", "Specify object", "input", "Append column to input data")).build();
    private static final RStrKey OUTPUT_PARENT = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("output_parent", "Output Data").setAutoValueLink(DATA, OUTPUT_TYPE)).addVisibleKeyLink(OUTPUT_TYPE, "select")).build();
    private static final BoolKey APPEND = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("append", "Append if the object exists").noLabel()).addVisibleKeyLink(OUTPUT_TYPE, "select")).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("output", "Output Name").setRequired(true)).setAutoValueLink(MODEL_OBJECT)).addVisibleKeyLink(INTERFACE, "single")).build();
    private static final RChoiceKey COL_MODEL_OBJECT = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("model_object", "Model").setCompletionSupport(RChoiceProvider.inherits(1, MODEL_CLASSES))).setRequired(true)).addVisibleKeyLink(INTERFACE, "multiple")).build();
    private static final RStrKey COL_OUTPUT = ((RStrKey.Builder)RStrKey.builder("output", "Output Name").setDynamicDefault(true)).build();
    private static final RTableKey MODELS = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("models", "Models", COL_MODEL_OBJECT, COL_OUTPUT).addVisibleKeyLink(INTERFACE, "multiple")).setDefaultRowPredicate()).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(INTERFACE, "multiple")).build();
    private static final RChoiceKey MODELS_LIST = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("models_list", "Model List").setCompletionSupport(RChoiceProvider.objects(rObject -> {
        List<RObject> list = rObject.getChildren();
        if (!rObject.inherits("list") || list == null || list.isEmpty()) {
            return false;
        }
        return list.get(0).inherits(Sets.newHashSet((Object[])MODEL_CLASSES));
    }, 1))).addVisibleKeyLink(INTERFACE, "multiple_list")).build();
    private static final RStrKey OUTPUT_PREFIX = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("output_prefix", "Output Name Prefix").setDefaultValue("Predict_")).addVisibleKeyLink(INTERFACE, "multiple_list")).build();
    private static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)RadioButtonKey.builder("type", "Prediction of Categories").setValuesAndLabels("class", "Class", "prob", "Probabilities")).build();
    private static final BoolKey AUTO_FLAG = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("auto_flag", "Treat 0/1 or TRUE/FALSE Output as Flag").setDefaultValue(Boolean.TRUE)).noLabel()).build();
    private static final RTableKey ADVANCED = RPredict.argsKey("predict");
    private static final StrKey TRY = ((StrKey.Builder)StrKey.builder("try", "").setNoSave(true)).build();

    public static RPredict singlePredictForEvaluation(String string, String string2, String string3, String string4, boolean bl) {
        RPredict rPredict = new RPredict();
        rPredict.putValue(INTERFACE, SINGLE);
        rPredict.putValue(MODEL_OBJECT, string);
        rPredict.putValue(DATA, string2);
        rPredict.putValue(OUTPUT_TYPE, OUTPUT_TYPE_SELECT);
        rPredict.putValue(OUTPUT_PARENT, string3);
        rPredict.putValue(APPEND, Boolean.FALSE);
        rPredict.putValue(OUTPUT, string4);
        rPredict.putValue(TYPE, TYPE_PROB);
        rPredict.putValue(AUTO_FLAG, bl);
        return rPredict;
    }

    public static RPredict modelListPredictForEvaluation(String string, String string2, String string3, String string4, Boolean bl) {
        RPredict rPredict = new RPredict();
        rPredict.putValue(INTERFACE, MULTIPLE_LIST);
        rPredict.putValue(MODELS_LIST, string);
        rPredict.putValue(DATA, string2);
        rPredict.putValue(OUTPUT_TYPE, OUTPUT_TYPE_SELECT);
        rPredict.putValue(OUTPUT_PARENT, string3);
        rPredict.putValue(APPEND, Boolean.FALSE);
        rPredict.putValue(OUTPUT_PREFIX, "");
        rPredict.putValue(TYPE, TYPE_PROB);
        rPredict.putValue(AUTO_FLAG, bl);
        rPredict.putValue(TRY, string4);
        return rPredict;
    }

    @Override
    public Version getVersion() {
        return new Version(0, 3, 1);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            this.putValue(OUTPUT.getAutoValueLinkKey(), Boolean.FALSE);
        }
        if (version.isOlderThan("0.3")) {
            this.putValue(APPEND, Boolean.TRUE);
            if (this.getValue(DATA).equals(this.getValue(OUTPUT_PARENT))) {
                this.putValue(OUTPUT_TYPE, OUTPUT_TYPE_INPUT);
            }
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(INTERFACE, MODEL_OBJECT, DATA, OUTPUT_TYPE, OUTPUT_PARENT, APPEND, OUTPUT, MODELS, MODELS_LIST, OUTPUT_PREFIX, TYPE, AUTO_FLAG, ADVANCED, TRY);
    }

    @Override
    public String getDefaultTitle() {
        return "Predict";
    }

    @Override
    public String getOpClass() {
        return "model";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT_PARENT.equals(key)) {
            return RPredict.suffix(this.getValue(DATA), ".predict");
        }
        if (OUTPUT.equals(key)) {
            return "predict." + RUtility.extractName(this.getValue(MODEL_OBJECT));
        }
        return super.getAutoValue(key);
    }

    @Override
    public Object getDynamicDefaultValue(KeysTableModel keysTableModel, int n, Key<?> key) {
        if (key.equals(COL_OUTPUT)) {
            String string = ((KeysTableRow)keysTableModel.getRow(n)).getValue(COL_MODEL_OBJECT);
            string = RUtility.extractName(string);
            return "Predict_" + string;
        }
        return super.getDynamicDefaultValue(keysTableModel, n, key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        ScriptBuilder scriptBuilder = RPredict.scriptBuilder();
        this.getRScript(scriptBuilder, bl, bl2, previewOption);
        return scriptBuilder.toString();
    }

    public void getRScript(ScriptBuilder scriptBuilder, boolean bl, boolean bl2, PreviewOption previewOption) {
        boolean bl3 = this.getValue(OUTPUT_TYPE).equals(OUTPUT_TYPE_INPUT);
        boolean bl4 = this.getValue(OUTPUT_TYPE).equals(OUTPUT_TYPE_SELECT) && this.getValue(APPEND) != false;
        String string = bl3 ? this.getValue(DATA) : this.getValue(OUTPUT_PARENT);
        String string2 = RPredict.data(this.getValue(DATA), previewOption);
        List<String> list = this.getArgs(ADVANCED);
        boolean bl5 = this.getValue(AUTO_FLAG);
        String string3 = this.getValue(TYPE);
        if (this.getValue(INTERFACE).equals(SINGLE)) {
            String string4 = this.getValue(OUTPUT);
            String string5 = this.getValue(MODEL_OBJECT);
            RPredict.getRScriptSingle(scriptBuilder, previewOption, string, bl3, bl4, string2, list, bl5, string3, string4, string5);
        } else {
            boolean bl6 = this.getValue(INTERFACE).equals(MULTIPLE);
            List<String> list2 = this.getValue(MODELS).getValidValues(COL_MODEL_OBJECT);
            String string6 = this.getValue(MODELS_LIST);
            List<String> list3 = this.getValue(MODELS).getValidValuesOrDefault(this, COL_OUTPUT, TableKey.DEFAULT_VALID_ROW_PREDICATE);
            String string7 = this.getValue(OUTPUT_PREFIX);
            String string8 = this.getValue(TRY);
            RPredict.getRScriptMulti(scriptBuilder, previewOption, string, bl3, bl4, string2, list, bl5, string3, bl6, list2, string6, list3, string7, string8);
        }
    }

    private static void getRScriptSingle(ScriptBuilder scriptBuilder, PreviewOption previewOption, String string, boolean bl, boolean bl2, String string2, List<String> list, boolean bl3, String string3, String string4, String string5) {
        Object object;
        if (!bl && !string.isEmpty()) {
            if (bl2) {
                scriptBuilder.appLnInd("if (tryCatch(!is.data.frame(" + string + "), error = function(e) TRUE)) {");
            }
            scriptBuilder.appendLn(string + " <- data.frame(row.names = row.names(" + string2 + "))");
            if (bl2) {
                scriptBuilder.unind_Ln("}");
            }
        }
        if (previewOption.isEnabled() && !string.isEmpty()) {
            scriptBuilder.append(string + " <- `$<-`(" + RPredict.data(string, previewOption) + ", " + RPredict.quote(string4) + ", ");
        } else {
            object = string.isEmpty() ? string4 : string + "[[" + RPredict.quote(string4) + "]]";
            scriptBuilder.append(RUtility.assign((String)object, ""));
        }
        object = new RAnonymousFunction();
        ((RAnonymousFunction)object).addArgs("object", string5);
        scriptBuilder.appLnInd(((RAnonymousFunction)object).getHeadStr());
        RPredict.appendPredictFunction(scriptBuilder, true, string2, list, bl3, string3);
        scriptBuilder.unind_Ln(((RAnonymousFunction)object).getTailStr());
        if (previewOption.isEnabled() && !string.isEmpty()) {
            scriptBuilder.appendLn(")");
        }
    }

    private static void getRScriptMulti(ScriptBuilder scriptBuilder, PreviewOption previewOption, String string, boolean bl, boolean bl2, String string2, List<String> list, boolean bl3, String string3, boolean bl4, List<String> list2, String string4, List<String> list3, String string5, String string6) {
        RAnonymousFunction rAnonymousFunction = new RAnonymousFunction();
        if (bl4) {
            rAnonymousFunction.addArgs("models", "list(" + StringUtils.join(list2, (String)", ") + ")");
        } else {
            rAnonymousFunction.addArgs("models", string4);
        }
        scriptBuilder.appLnInd(rAnonymousFunction.getHeadStr());
        if (!bl && !string.isEmpty()) {
            String string7 = "evalq(" + string + " <- data.frame(row.names = row.names(" + string2 + ")), envir = parent.frame())";
            if (bl2) {
                scriptBuilder.appLnInd("if (tryCatch(!is.data.frame(" + string + "), error = function(e) TRUE)) {");
                scriptBuilder.appendLn(string7);
                scriptBuilder.unind_Ln("}");
            } else {
                scriptBuilder.appendLn(string7);
            }
        }
        if (bl4) {
            scriptBuilder.appendLn("outputNames <- " + RUtility.combineCharacters(list3));
        } else {
            scriptBuilder.appendLn("mn <- if (is.null(names(models))) rep(\"\", length(models)) else names(models)");
            scriptBuilder.appendLn("outputNames <- make.unique(ifelse(mn == \"\", as.character(seq_along(mn)), mn), sep = \".\")");
            if (!string5.isEmpty()) {
                scriptBuilder.appendLn("outputNames <- paste(" + RPredict.quote(string5) + ", outputNames, sep = \"\")");
            }
        }
        scriptBuilder.appLnInd("for (i in seq_along(models)) {");
        scriptBuilder.appendLn("object <- models[[i]]");
        scriptBuilder.appendLn("outputName <- outputNames[[i]]");
        if (!string6.isEmpty()) {
            scriptBuilder.appendLn("tryFunc <- " + RUtility.evalq(string6));
            scriptBuilder.appLnInd("tryFunc({");
        }
        RPredict.appendPredictFunction(scriptBuilder, false, string2, list, bl3, string3);
        if (string.isEmpty()) {
            scriptBuilder.appendLn("assign(x = outputName, value = pred, pos = parent.frame())");
        } else if (previewOption.isEnabled()) {
            scriptBuilder.appendLn("eval.parent(bquote(" + string + " <- `[[<-`(" + RPredict.data(string, previewOption) + ", .(outputName), value=.(pred))))");
        } else {
            scriptBuilder.appendLn("eval.parent(bquote(" + string + "[[.(outputName)]] <- .(pred)))");
        }
        if (!string6.isEmpty()) {
            scriptBuilder.unind_Ln("}, paste(\"Predicting \", outputName, sep=\"\"))");
        }
        scriptBuilder.unind_Ln("}");
        scriptBuilder.unind_Ln(rAnonymousFunction.getTailStr());
    }

    private static void appendPredictFunction(ScriptBuilder scriptBuilder, boolean bl, String string, List<String> list, boolean bl2, String string2) {
        scriptBuilder.appLnInd("if (inherits(object, \"nnet\")) {");
        scriptBuilder.appendLn("requireNamespace(\"nnet\")");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn();
        scriptBuilder.appLnInd("if (inherits(object, \"xgb.Booster\")) {");
        scriptBuilder.appendLn("requireNamespace(\"xgboost\")");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn();
        scriptBuilder.appLnInd("if (inherits(object, c(\"glmnet\", \"cv.glmnet\"))) {");
        scriptBuilder.appendLn("requireNamespace(\"glmnet\")");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn();
        scriptBuilder.appLnInd("if (inherits(object, \"rpart\") && object$method == \"class\" && !is.null(attr(object, \"ylevels\"))) {");
        scriptBuilder.appendLn("attr(object, \"ylevels\") <- attr(object, \"ylevels\")[seq_len(object$numresp-2)]");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn();
        String string3 = RUtility.function("predict", list, "object", ".(object)");
        scriptBuilder.appendLn("cl <- bquote(" + string3 + ")");
        scriptBuilder.appendLn();
        scriptBuilder.appLnInd("if (inherits(object, \"ranger\")) {");
        scriptBuilder.appendLn("requireNamespace(\"ranger\")");
        scriptBuilder.appendLn("cl$data <- quote(" + string + ")");
        scriptBuilder.unind_Ln("} else if (inherits(object, c(\"xgb.Booster\", \"glmnet\", \"cv.glmnet\"))) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("if(!is.null(attr(object, \"_rflow_\"))) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("bq <- bquote(local({");
        scriptBuilder.indent();
        scriptBuilder.appendLn("att <- attr(.(object), \"_rflow_\")");
        scriptBuilder.appendLn("mt <- delete.response(att$terms)");
        scriptBuilder.appendLn("mf <- model.frame(mt, " + string + ", na.action = na.pass, xlev = att$xlevels)");
        scriptBuilder.appendLn("model.matrix(mt, mf)");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}))");
        scriptBuilder.appendLn("if(inherits(object, \"xgb.Booster\")) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("cl$newdata <- bq");
        scriptBuilder.appendLn("cl$reshape <- TRUE");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("} else if (inherits(object, c(\"glmnet\", \"cv.glmnet\"))) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("cl$newx <- bq");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        scriptBuilder.unind_Ln("} else {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("cl$newdata <- quote(" + string + ")");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        scriptBuilder.appLnInd("if (!(\"type\" %in% names(cl))) {");
        scriptBuilder.appLnInd("if (inherits(object, \"glm\")) {");
        scriptBuilder.appendLn("cl$type <- \"response\"");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("} else if (inherits(object, \"multinom\")) {");
        RPredict.classIfNotBinary(scriptBuilder, string2.equals(TYPE_PROB), RPredict.sQuote("probs"), "object$lev", bl2);
        scriptBuilder.appendLn("} else if (inherits(object, \"rpart\") && !is.null(object$frame$yval2)) {");
        RPredict.classIfNotBinary(scriptBuilder, string2.equals(TYPE_PROB), RPredict.sQuote(TYPE_PROB), "attr(object, \"ylevels\")", bl2);
        scriptBuilder.appendLn("} else if (inherits(object, \"nnet\") && !is.null(object$lev)) {");
        RPredict.classIfNotBinary(scriptBuilder, string2.equals(TYPE_PROB), RPredict.sQuote("raw"), "object$lev", bl2);
        scriptBuilder.appLnInd("} else if (inherits(object, c(\"glmnet\", \"cv.glmnet\"))) {");
        scriptBuilder.appendLn("cl$type <- \"response\"");
        scriptBuilder.appendLn(".GLMNET_AUTO_TYPE <- TRUE");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn();
        scriptBuilder.appendLn("pred <- eval.parent(cl)");
        scriptBuilder.appendLn();
        if (bl2) {
            scriptBuilder.appendLn("# " + AUTO_FLAG.getTitle());
            scriptBuilder.appLnInd("if (inherits(object, \"rpart\") && !is.null(attr(object, \"ylevels\"))) {");
            scriptBuilder.appendLn("if (all(attr(object, \"ylevels\") %in% c(\"0\", \"1\"))) pred <- pred[, \"1\"]");
            scriptBuilder.appendLn("if (all(attr(object, \"ylevels\") %in% c(\"FALSE\", \"TRUE\"))) pred <- pred[, \"TRUE\"]");
            scriptBuilder.unind_Ln("}");
            scriptBuilder.appendLn();
        }
        scriptBuilder.appLnInd("if (inherits(object, \"nnet\")) {");
        scriptBuilder.appLnInd("if(length(object$lev) == 2 && is.numeric(pred)) {");
        if (bl2) {
            scriptBuilder.appendLn("# " + AUTO_FLAG.getTitle());
            scriptBuilder.appLnInd("if(all(object$lev %in% c(\"0\", \"1\")) || all(object$lev %in% c(\"FALSE\", \"TRUE\"))) {");
            scriptBuilder.appendLn("if(object$lev[2] %in% c(\"0\", \"FALSE\")) pred <- 1 - pred");
            scriptBuilder.unind_Ln("} else {");
            scriptBuilder.indent();
        }
        scriptBuilder.appendLn("pred <- cbind(1 - pred, pred)");
        scriptBuilder.appendLn("colnames(pred) <- object$lev");
        if (bl2) {
            scriptBuilder.unind_Ln("}");
        }
        scriptBuilder.unind_Ln("} else if(is.character(pred) && !is.null(object$lev)) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("pred <- factor(pred, levels = object$lev)");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appLnInd("if (is.matrix(pred) && ncol(pred) == 1) {");
        scriptBuilder.appendLn("pred <- as.vector(pred)");
        scriptBuilder.unind_Ln("}");
        scriptBuilder.unind_Ln("}");
        String string4 = "stop(\"Set probability = TRUE when training ranger model to predict probability.\")";
        scriptBuilder.appLnInd("if (inherits(object, \"ranger\")) {");
        scriptBuilder.appendLn("pred <- pred$predictions");
        if (bl2 || string2.equals(TYPE_CLASS)) {
            scriptBuilder.appLnInd("if (!(\"type\" %in% names(cl)) && object$treetype == \"Probability estimation\") {");
            if (bl2) {
                scriptBuilder.appendLn("# " + AUTO_FLAG.getTitle());
                scriptBuilder.appLnInd("if(all(colnames(pred) %in% c(\"0\", \"1\")) || all(colnames(pred) %in% c(\"FALSE\", \"TRUE\"))) {");
                scriptBuilder.appLnInd("if(any(c(\"1\", \"TRUE\") %in% colnames(pred))) {");
                scriptBuilder.appendLn("pred <- pred[, which(colnames(pred) %in% c(\"1\", \"TRUE\"))]");
                scriptBuilder.unind_Ln("} else {");
                scriptBuilder.indent();
                scriptBuilder.appendLn("pred <- 1 - pred[, which(colnames(pred) %in% c(\"0\", \"FALSE\"))]");
                scriptBuilder.unind_Ln("}");
            }
            if (string2.equals(TYPE_CLASS)) {
                if (bl2) {
                    scriptBuilder.unind_Ln("} else {");
                    scriptBuilder.indent();
                }
                scriptBuilder.appendLn("pred <- factor(colnames(pred)[apply(pred, 1, which.max)], levels = object$forest$levels)");
            }
            if (bl2) {
                scriptBuilder.unind_Ln("}");
            }
            if (string2.equals(TYPE_PROB)) {
                scriptBuilder.unind_Ln("} else if (object$treetype == \"Classification\"){");
                scriptBuilder.indent();
                scriptBuilder.appendLn(string4);
            }
            scriptBuilder.unind_Ln("}");
        } else {
            scriptBuilder.appLnInd("if (object$treetype == \"Classification\") {");
            scriptBuilder.appendLn(string4);
            scriptBuilder.unind_Ln("}");
        }
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn("if(inherits(object, \"xgb.Booster\") && length(ylev <- attr(object, \"_rflow_\")$ylevels) > 1 && !any(c(\"predleaf\", \"predcontrib\") %in% names(cl))) {");
        scriptBuilder.indent();
        if (string2.equals(TYPE_CLASS)) {
            if (bl2) {
                scriptBuilder.appendLn("# " + AUTO_FLAG.getTitle());
                scriptBuilder.appendLn("if (all(ylev %in% c(\"0\", \"1\"))) {");
                scriptBuilder.indent();
                scriptBuilder.appendLn("pred <- pred[, ylev == \"1\"]");
                scriptBuilder.unindent();
                scriptBuilder.appendLn("} else if (all(ylev %in% c(\"FALSE\", \"TRUE\"))) {");
                scriptBuilder.indent();
                scriptBuilder.appendLn("pred <- pred[, ylev == \"TRUE\"]");
                scriptBuilder.unindent();
                scriptBuilder.appendLn("} else {");
                scriptBuilder.indent();
            }
            scriptBuilder.appendLn("pred <- factor(ylev[apply(pred, 1, which.max)], levels = ylev)");
            if (bl2) {
                scriptBuilder.unindent();
                scriptBuilder.appendLn("}");
            }
        } else {
            scriptBuilder.appendLn("colnames(pred) <- ylev");
            if (bl2) {
                scriptBuilder.appendLn();
                scriptBuilder.appendLn("# " + AUTO_FLAG.getTitle());
                scriptBuilder.appendLn("if (all(ylev %in% c(\"0\", \"1\"))) pred <- pred[, \"1\"]");
                scriptBuilder.appendLn("if (all(ylev %in% c(\"FALSE\", \"TRUE\"))) pred <- pred[, \"TRUE\"]");
            }
        }
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        scriptBuilder.appendLn("if(inherits(object, c(\"glmnet\", \"cv.glmnet\"))) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("if (is.matrix(pred) && ncol(pred) == 1) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("pred <- as.vector(pred)");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("} else if(is.array(pred) && length(dim(pred)) == 3 && dim(pred)[3] == 1) {");
        scriptBuilder.indent();
        scriptBuilder.appendLn("pred <- pred[, , 1]");
        scriptBuilder.unindent();
        scriptBuilder.appendLn("}");
        scriptBuilder.unindent();
        if (bl2 || string2.equals(TYPE_CLASS)) {
            scriptBuilder.appLnInd("if (exists(\".GLMNET_AUTO_TYPE\") && is.matrix(pred)) {");
            if (bl2) {
                scriptBuilder.appendLn("# " + AUTO_FLAG.getTitle());
                scriptBuilder.appLnInd("if(all(colnames(pred) %in% c(\"0\", \"1\")) || all(colnames(pred) %in% c(\"FALSE\", \"TRUE\"))) {");
                scriptBuilder.appLnInd("if(any(c(\"1\", \"TRUE\") %in% colnames(pred))) {");
                scriptBuilder.appendLn("pred <- pred[, which(colnames(pred) %in% c(\"1\", \"TRUE\"))]");
                scriptBuilder.unind_Ln("} else {");
                scriptBuilder.indent();
                scriptBuilder.appendLn("pred <- 1 - pred[, which(colnames(pred) %in% c(\"0\", \"FALSE\"))]");
                scriptBuilder.unind_Ln("}");
            }
            if (string2.equals(TYPE_CLASS)) {
                if (bl2) {
                    scriptBuilder.unind_Ln("} else {");
                    scriptBuilder.indent();
                }
                scriptBuilder.appendLn("pred <- factor(colnames(pred)[apply(pred, 1, which.max)], levels = colnames(pred))");
            }
            if (bl2) {
                scriptBuilder.unind_Ln("}");
            }
            scriptBuilder.unind_Ln("}");
        }
        scriptBuilder.appendLn("}");
        if (bl) {
            scriptBuilder.appendLn("pred");
        }
    }

    private static void classIfNotBinary(ScriptBuilder scriptBuilder, boolean bl, String string, String string2, boolean bl2) {
        scriptBuilder.indent();
        if (bl) {
            scriptBuilder.appendLn("cl$type <- " + string);
        } else if (bl2) {
            scriptBuilder.appendLn("# " + AUTO_FLAG.getTitle());
            scriptBuilder.appLnInd("cl$type <- if (length(" + string2 + ") == 2 && (all(" + string2 + " %in% c(\"0\", \"1\")) || all(" + string2 + " %in% c(\"FALSE\", \"TRUE\"))))");
            scriptBuilder.appendLn(string);
            scriptBuilder.unLn_Ind("else");
            scriptBuilder.appendLn("\"class\"");
            scriptBuilder.unindent();
        } else {
            scriptBuilder.appendLn("cl$type <- \"class\"");
        }
        scriptBuilder.unindent();
    }

    @Override
    public WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", PanelWidgetNode.noScroll().addKeys(INTERFACE), MODEL_OBJECT, MODELS_LIST, DATA, OUTPUT_TYPE, OUTPUT_PARENT, APPEND, OUTPUT, OUTPUT_PREFIX, MODELS).addTabWithKeys("Options", TYPE, AUTO_FLAG).addTabWithKeys("Advanced", ADVANCED);
    }

    @Override
    public boolean canImport(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (RObject rObject : list) {
            if (this.test(MODEL_OBJECT, rObject)) {
                if (bl) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (!this.test(DATA, rObject)) continue;
            if (bl2) {
                return false;
            }
            bl2 = true;
        }
        return bl | bl2;
    }

    @Override
    protected void importValues(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (RObject rObject : list) {
            if (this.test(MODEL_OBJECT, rObject)) {
                this.putValue(MODEL_OBJECT, rObject.getFullName());
                continue;
            }
            if (!this.test(DATA, rObject)) continue;
            this.putValue(DATA, rObject.getFullName());
        }
    }

    @Override
    protected String[] getNewRObjects() {
        String string = this.getValue(OUTPUT_PARENT);
        if (this.getValue(INTERFACE).equals(SINGLE)) {
            Object object = this.getValue(OUTPUT);
            if (!string.isEmpty()) {
                object = string + "$" + (String)object;
            }
            return new String[]{object};
        }
        if (this.getValue(INTERFACE).equals(MULTIPLE)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            KeysTableModel keysTableModel = this.getValue(MODELS);
            for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
                KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(i);
                if (!TableKey.DEFAULT_VALID_ROW_PREDICATE.test(keysTableRow)) continue;
                Object object = keysTableRow.getValue(COL_OUTPUT);
                if (((String)object).isEmpty()) {
                    object = this.getDynamicDefaultValue(keysTableModel, i, COL_OUTPUT).toString();
                }
                if (!string.isEmpty()) {
                    object = string + "$" + (String)object;
                }
                arrayList.add((String)object);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        if (!string.isEmpty()) {
            return new String[]{string};
        }
        return new String[0];
    }

    @Override
    protected void configureValidationContext(ValidationContext validationContext) {
        Validator validator = new Validator(){

            @Override
            public void validate(Key<?> key, Object object, ValidationContext validationContext) {
                if (RPredict.this.getValue(OUTPUT_TYPE).equals(RPredict.OUTPUT_TYPE_SELECT) && !RPredict.this.getValue(DATA).isEmpty() && RPredict.this.getValue(DATA).equals(RPredict.this.getValue(OUTPUT_PARENT))) {
                    validationContext.addError(this, new BasicValueError(4, Messages.getString("Error.predict_output_same"), key));
                }
            }
        };
        validationContext.addValidator(OUTPUT_TYPE, validator);
        validationContext.addValidator(DATA, validator);
        validationContext.addValidator(OUTPUT_PARENT, validator);
    }
}

