/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.ui.app.r.RConsoleResultView;
import com.ef_prime.rflow.ui.app.r.RObjectPreviewView;
import java.util.List;

public class RPropertyTable
extends ROperation {
    private static final BoolKey COMMENT = ((BoolKey.Builder)BoolKey.builder("comment", "Show Comments").noLabel()).build();
    private static final RStrKey COL_NAME = ((RStrKey.Builder)RStrKey.builder("name", "Name").setRequired(true)).build();
    private static final RStrKey COL_VALUE = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("value", "Value").setRequired(true)).setMultiLine(true)).build();
    private static final StrKey COL_COMMENT = ((StrKey.Builder)((Key.Builder)StrKey.builder("comment", "Comment").setMultiLine(true)).addVisibleKeyLink(COMMENT, true)).build();
    private static final RTableKey TABLE = ((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("table", "Table", COL_NAME, COL_VALUE, COL_COMMENT).setUiControls(GeneralTableModel.UI_DEFAULT2)).setDefaultRowPredicate()).build();
    private static final BoolKey AS_LIST = ((BoolKey.Builder)BoolKey.builder("as_list", "Output as List").setLabelPosition("none")).build();
    private static final RStrKey LIST_NAME = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("list_name", "Name").addVisibleKeyLink(AS_LIST, true)).setRequired(true)).build();

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(TABLE, COMMENT, AS_LIST, LIST_NAME);
    }

    @Override
    public String getDefaultTitle() {
        return "Assign Variables";
    }

    @Override
    public String getOpClass() {
        return "io";
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        boolean bl3;
        ScriptBuilder scriptBuilder = RPropertyTable.scriptBuilder();
        boolean bl4 = bl3 = this.getValue(COMMENT) != false && this.getValue(TABLE).getRows().stream().anyMatch(keysTableRow -> !keysTableRow.getValue(COL_COMMENT).isEmpty());
        if (!this.getValue(AS_LIST).booleanValue()) {
            List<KeysTableRow> list = this.getValue(TABLE).validRows();
            for (int i = 0; i < list.size(); ++i) {
                KeysTableRow keysTableRow2 = list.get(i);
                if (bl3) {
                    this.addComment(scriptBuilder, keysTableRow2.getValue(COL_COMMENT));
                }
                scriptBuilder.appendLn(keysTableRow2.getValue(COL_NAME) + " <- " + keysTableRow2.getValue(COL_VALUE));
                if (!bl3 || i == list.size() - 1) continue;
                scriptBuilder.appendLn();
            }
        } else {
            scriptBuilder.appendLn(this.getValue(LIST_NAME) + " <- list(");
            scriptBuilder.indent();
            for (int i = 0; i < this.getValue(TABLE).getRowCount(); ++i) {
                if (i != 0) {
                    scriptBuilder.appendLn(", ");
                    if (bl3) {
                        scriptBuilder.appendLn();
                    }
                }
                KeysTableRow keysTableRow3 = (KeysTableRow)this.getValue(TABLE).getRow(i);
                if (bl3) {
                    this.addComment(scriptBuilder, keysTableRow3.getValue(COL_COMMENT));
                }
                String string = keysTableRow3.getValue(COL_NAME);
                String string2 = keysTableRow3.getValue(COL_VALUE);
                scriptBuilder.append(string + " = " + string2);
            }
            scriptBuilder.unindent();
            scriptBuilder.appendLn("");
            scriptBuilder.append(")");
        }
        return scriptBuilder.toString();
    }

    private void addComment(ScriptBuilder scriptBuilder, String string) {
        String[] stringArray;
        if (string.isEmpty()) {
            return;
        }
        if (string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        for (String string2 : stringArray = string.split("\n")) {
            scriptBuilder.appendLn("# " + string2);
        }
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getContentWidgetNode(viewOptions);
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        tabPaneWidgetNode.addTab("Main", widgetNode);
        if (!viewOptions.isWizard()) {
            tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
            return tabPaneWidgetNode;
        }
        WidgetNode widgetNode2 = new TabPaneWidgetNode().add(new ViewWidgetNode(RObjectPreviewView.class)).add(new ViewWidgetNode(RConsoleResultView.class)).add(new ViewWidgetNode(OpRScriptView.class));
        return this.createSplitPaneWidgetNode().add(tabPaneWidgetNode).add(widgetNode2);
    }
}

