/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RArgsKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.MultipleKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.SeparatorWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RProportionTest2
extends ROperation {
    private static final String TYPE_SUCCESS_TRIAL = "success_trial";
    private static final String TYPE_SUCCESS_FAILURE = "success_failure";
    private static final String TYPE_LOGICAL = "logical";
    private static final String GROUP_TYPE_GROUP_COLUMN = "group_column";
    private static final String GROUP_TYPE_EACH_ROW = "each_row";
    private static final String ALTERNATIVE_TWO_SIDEED = "two_sided";
    private static final String ALTERNATIVE_LESS = "less";
    private static final String ALTERNATIVE_GREATER = "greater";
    private static final String METHOD_EXACT_TEST = "exact";
    private static final String METHOD_CHI_SQUARED_TEST = "norm_app";
    private static final String MC_TYPE_FWER = "fwer";
    private static final String MC_TYPE_FDR = "fdr";
    private static final String MC_TYPE_NO_CORRECTION = "no_correction";
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((Key.Builder)RStrKey.builder("_output", "Output").setOutput(true)).setRequired(true)).setDefaultValue("test.result")).build();
    private static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("type", "Type").setValuesAndLabels("success_trial", "Number of Success/Trial", "success_failure", "Number of Success/Failure", "logical", "Logical or 0/1")).setLabelPosition("none")).build();
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("data", "Data").setChoiceProvider(RChoiceProvider.globalDataFrames())).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RChoiceKey SUCCESS = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("success", "Success").setChoiceProvider(RChoiceProvider.names(DATA.getId(), true, "is.numeric"))).setRequired(true)).addVisibleKeyLink(TYPE, "success_trial", "success_failure")).build();
    private static final RChoiceKey TRIAL = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("trial", "Trial").setChoiceProvider(RChoiceProvider.names(DATA.getId(), true, "is.numeric"))).setRequired(true)).addVisibleKeyLink(TYPE, "success_trial")).build();
    private static final RChoiceKey FAILURE = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("failure", "Failure").setChoiceProvider(RChoiceProvider.names(DATA.getId(), true, "is.numeric"))).setRequired(true)).addVisibleKeyLink(TYPE, "success_failure")).build();
    private static final RChoiceKey TARGET = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("target", "Target").setChoiceProvider(new BinaryVariableProvider())).setRequired(true)).addVisibleKeyLink(TYPE, "logical")).build();
    private static final BoolKey MULTISAMPLE = ((BoolKey.Builder)BoolKey.builder("multisample", "Compare groups").setLabelPosition("none")).build();
    private static final RadioButtonKey GROUP_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("group_type", "Group Type").setValuesAndLabels("group_column", "Sum by group", "each_row", "Each row is a group")).setLabelPosition("none")).addKeyLink(KeyLink.visible(MultipleKeyTest.and(BoolKeyTest.create(MULTISAMPLE, true), StrKeyTest.create(TYPE, "success_trial", "success_failure"))))).build();
    private static final RChoiceKey GROUP = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("group", "Group").setCompletionSupport(RChoiceProvider.columns(DATA, true))).addKeyLink(KeyLink.visible(MultipleKeyTest.and(BoolKeyTest.create(MULTISAMPLE, true), MultipleKeyTest.or(StrKeyTest.create(TYPE, "logical"), StrKeyTest.create(GROUP_TYPE, "group_column")))))).build();
    private static final BoolKey REPLACE_GROUP_NAMES = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("replace_group_names", "Set Group Names in Output Object").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).addVisibleKeyLink(MULTISAMPLE, true)).build();
    private static final RChoiceKey GROUP_NAMES = ((RChoiceKey.Builder)((Key.Builder)((RChoiceKey.Builder)RChoiceKey.builder("group_names", "Group Names").setEmptyMessageLink(RProportionTest2::getGroupNamesDescription, "group_names", DATA.getId())).setCompletionSupport(RChoiceProvider.columns(DATA, true))).addKeyLink(KeyLink.visible(MultipleKeyTest.and(StrKeyTest.create(GROUP_TYPE, "each_row"), BoolKeyTest.create(REPLACE_GROUP_NAMES, true))))).build();
    private static final BoolKey NA_AS_FALSE = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("na_as_false", "Count NA's as Failures").setLabelPosition("none")).addVisibleKeyLink(TYPE, "logical")).build();
    private static final StrKey NULL_HYPOTHESIS_LABEL = ((StrKey.Builder)StrKey.builder("label_null_hyp", "Null Hypothesis").label()).build();
    private static final StrKey ALT_HYPOTHESIS_LABEL = ((StrKey.Builder)StrKey.builder("label_alt_hyp", "Alternative Hypothesis").label()).build();
    private static final ChoiceKey NULL_HYPOTHESIS = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("null_hyp", "P").setValuesAndLabels("two_sided", "=", "less", ">=", "greater", "<=")).setMinWidth(0)).build();
    private static final StrKey ALT_HYPOTHESIS = ((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("alt_hyp", "P").label()).disabled()).setAutoValueLink(true, NULL_HYPOTHESIS)).build();
    private static final ChoiceKey NULL_HYPOTHESIS_2 = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("null_hyp_2", "Group 1").setValuesAndLabels("two_sided", "=", "less", ">=", "greater", "<=")).setMinWidth(0)).build();
    private static final StrKey ALT_HYPOTHESIS_2 = ((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("alt_hyp_2", "Group 1").label()).disabled()).setAutoValueLink(true, NULL_HYPOTHESIS_2)).build();
    private static final StrKey GROUP2_LABEL = ((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("group2", "Group 2").label()).setLabelPosition("none")).setDefaultValue("Group 2")).build();
    private static final StrKey GROUP2_LABEL2 = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("group2_2", "Group 2").label()).disabled()).setLabelPosition("none")).setDefaultValue("Group 2")).build();
    private static final RStrKey CONF_LEVEL = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("conf.level", "Confidence Level").setDefaultValue("0.95")).setDescriptionLink(RProportionTest2::getDescription)).build();
    private static final RStrKey P = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("p", "Probability").setLabelPosition("none")).setDefaultValue("0.5")).setDescriptionLink(RProportionTest2::getDescription)).build();
    private static final StrKey ALT_P = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("alt_p", "P").label()).disabled()).setLabelPosition("none")).setAutoValueLink(true, P)).build();
    private static final RadioButtonKey METHOD = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("method", "Method").setValuesAndLabels("exact", "Exact Test", "norm_app", "Chi-squared Test")).addVisibleKeyLink(MULTISAMPLE, false)).build();
    private static final BoolKey YATES_CORRECTION = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("correct", "Yates' Continuity Correction").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).addInvisibleKeyLink(METHOD, "exact")).build();
    private static final BoolKey MULTIPLE_COMPARISONS = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("multiple_comparisons", "Multiple Comparisons").addVisibleKeyLink(MULTISAMPLE, true)).setLabelPosition("none")).build();
    private static final ChoiceKey MC_TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("mc_type", "Type").setValuesAndLabels("fwer", "Family-Wise Error Rate / FWER", "fdr", "False Discovery Rate / FDR", "no_correction", "No Correction")).addVisibleKeyLink(MULTIPLE_COMPARISONS, true)).build();
    private static final ChoiceKey FWER_METHOD = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("fwer_method", "Method").setValuesAndLabels(RProportionTest2.sQuote("holm"), "Holm", RProportionTest2.sQuote("hochberg"), "Hochberg", RProportionTest2.sQuote("hommel"), "Hommel", RProportionTest2.sQuote("bonferroni"), "Bonferroni")).showValueAndLabel(true)).addVisibleKeyLink(MC_TYPE, "fwer")).build();
    private static final ChoiceKey FDR_METHOD = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("fdr_method", "Method").setValuesAndLabels(RProportionTest2.sQuote("BH"), "Benjamini & Hochberg", RProportionTest2.sQuote("BY"), "Benjamini & Yekutieli")).showValueAndLabel(true)).addVisibleKeyLink(MC_TYPE, "fdr")).build();
    private static final ChoiceKey ARGS_SWITCH = RProportionTest2.argsSwitchKey("args_switch", new AutoValueLink(true, METHOD, MULTISAMPLE), "binom.test", "prop.test", "pairwise.prop.test");
    private static final RArgsKey ARGS_BINOM = RProportionTest2.argsKey("args_binom_test", "binom.test", null, ARGS_SWITCH, "alternative", "x", "n");
    private static final RArgsKey ARGS_PROP = RProportionTest2.argsKey("args_prop_test", "prop.test", null, ARGS_SWITCH, "alternative", "x", "n");
    private static final RArgsKey ARGS_PAIRWISE_PROP = RProportionTest2.argsKey("args_pairwise_prop_test", "pairwise.prop.test", null, ARGS_SWITCH, "alternative", "x", "n", "p.adjust.method");

    @Override
    protected void initKeys() {
        this.registerKeys(OUTPUT, TYPE, DATA, SUCCESS, TRIAL, FAILURE, TARGET, GROUP_TYPE, GROUP, GROUP_NAMES, NA_AS_FALSE, YATES_CORRECTION, NULL_HYPOTHESIS_LABEL, ALT_HYPOTHESIS_LABEL, NULL_HYPOTHESIS, ALT_HYPOTHESIS, NULL_HYPOTHESIS_2, ALT_HYPOTHESIS_2, CONF_LEVEL, MULTISAMPLE, P, METHOD, ARGS_SWITCH, ARGS_BINOM, ARGS_PROP, ARGS_PAIRWISE_PROP, ALT_P, REPLACE_GROUP_NAMES, MULTIPLE_COMPARISONS, MC_TYPE, FWER_METHOD, FDR_METHOD);
    }

    @Override
    public void initValueMap() {
        super.initValueMap();
        this.putAutoValueQuietly(ALT_HYPOTHESIS);
        this.putAutoValueQuietly(ALT_HYPOTHESIS_2);
        this.putAutoValueQuietly(ARGS_SWITCH);
        this.putAutoValueQuietly(ALT_P);
    }

    @Override
    protected String getDefaultTitle() {
        return "Test of Proportion";
    }

    @Override
    public String getOpClass() {
        return "summary";
    }

    @Override
    public boolean canImport(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.size() != 1) {
            return false;
        }
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        RObject rObject = RObjectFlavor.getObject(transferable);
        if (rObject == null) {
            return;
        }
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null || rObject.inherits("data.frame")) {
            this.putValue(DATA, rObject.getFullName(false));
        } else {
            this.putValue(DATA, rObject2.getFullName(false));
            this.putValue(TARGET, rObject.getName(true));
            this.putValue(TYPE, TYPE_LOGICAL);
        }
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (ALT_HYPOTHESIS.equals(key)) {
            return this.nullToAlt(this.getValue(NULL_HYPOTHESIS));
        }
        if (ALT_HYPOTHESIS_2.equals(key)) {
            return this.nullToAlt(this.getValue(NULL_HYPOTHESIS_2));
        }
        if (ARGS_SWITCH.equals(key)) {
            if (!this.getValue(MULTISAMPLE).booleanValue() && this.getValue(METHOD).equals(METHOD_EXACT_TEST)) {
                return "binom.test";
            }
            return "prop.test";
        }
        if (ALT_P.equals(key)) {
            return this.getValue(P);
        }
        return super.getAutoValue(key);
    }

    private String nullToAlt(String string) {
        String string2 = " !=     ";
        switch (string) {
            case "less": {
                string2 = " <      ";
                break;
            }
            case "greater": {
                string2 = " >      ";
                break;
            }
        }
        return string2;
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        if (!this.getValue(MULTISAMPLE).booleanValue()) {
            return this.oneSample(bl, previewOption);
        }
        return this.multiSample(bl, previewOption);
    }

    private String getAlternative(String string) {
        switch (string) {
            case "two_sided": {
                return RProportionTest2.quote("two.sided");
            }
            case "less": {
                return RProportionTest2.quote(ALTERNATIVE_LESS);
            }
            case "greater": {
                return RProportionTest2.quote(ALTERNATIVE_GREATER);
            }
        }
        throw new RuntimeException("Unknown alternative");
    }

    private String getValidation() {
        switch (this.getValue(TYPE)) {
            case "success_trial": {
                return "all(" + this.getValue(TRIAL) + " >= 0) && all(" + this.getValue(TRIAL) + " >= " + this.getValue(SUCCESS) + ")";
            }
            case "success_failure": {
                return "all(" + this.getValue(SUCCESS) + " >= 0) && all(" + this.getValue(FAILURE) + " >= 0)";
            }
            case "logical": {
                return "all(" + this.getValue(TARGET) + " %in% c(0L, 1L, NA))";
            }
        }
        throw new RuntimeException("Unknown type");
    }

    public String oneSample(boolean bl, PreviewOption previewOption) throws Exception {
        String string;
        Object object;
        ArgsList argsList = new ArgsList();
        boolean bl2 = this.getValue(METHOD).equals(METHOD_EXACT_TEST);
        switch (this.getValue(TYPE)) {
            case "success_trial": {
                argsList.add("x", "sum(" + this.getValue(SUCCESS) + ")");
                argsList.add("n", "sum(" + this.getValue(TRIAL) + ")");
                break;
            }
            case "success_failure": {
                object = RUtility.combine("sum(" + this.getValue(SUCCESS) + ")", "sum(" + this.getValue(FAILURE) + ")");
                if (bl2) {
                    argsList.add("x", (String)object);
                    break;
                }
                argsList.add("x", "matrix(" + (String)object + ", ncol = 2)");
                break;
            }
            case "logical": {
                argsList.add("x", "sum(" + this.getValue(TARGET) + ", na.rm = TRUE)");
                if (!this.getValue(NA_AS_FALSE).booleanValue()) {
                    argsList.add("n", "sum(!is.na(" + this.getValue(TARGET) + "))");
                    break;
                }
                argsList.add("n", "length(" + this.getValue(TARGET) + ")");
                break;
            }
        }
        argsList.add("p", this.getValue(P));
        argsList.add("alternative", this.getAlternative(this.getValue(NULL_HYPOTHESIS)));
        argsList.add("conf.level", this.getValue(CONF_LEVEL));
        String string2 = string = bl2 ? "binom.test" : "prop.test";
        if (!bl2) {
            argsList.add("correct", RUtility.toRBoolean(this.getValue(YATES_CORRECTION)));
        }
        argsList.addAll(bl2 ? this.getArgs(ARGS_BINOM) : this.getArgs(ARGS_PROP));
        String string3 = "stopifnot(" + this.getValidation() + ")";
        object = RProportionTest2.scriptBuilder();
        if (this.getValue(DATA).isEmpty()) {
            ((ScriptBuilder)object).appLnInd("local({");
        } else {
            ((ScriptBuilder)object).appLnInd("with(" + this.getValue(DATA) + ", {");
        }
        ((ScriptBuilder)object).appendLn(string3);
        ((ScriptBuilder)object).appendLn(RUtility.function(string, argsList));
        ((ScriptBuilder)object).unind_Ln("})");
        return RUtility.assign(this.getValue(OUTPUT), ((ScriptBuilder)object).toString());
    }

    private String with(String string) {
        if (this.getValue(DATA).isEmpty()) {
            return string;
        }
        return "with(" + this.getValue(DATA) + ", " + string + ")";
    }

    public String multiSample(boolean bl, PreviewOption previewOption) throws Exception {
        Object object;
        String string;
        Object object2;
        String string2;
        boolean bl2;
        ScriptBuilder scriptBuilder = RProportionTest2.scriptBuilder();
        scriptBuilder.appLnInd("local({");
        scriptBuilder.appendLn("stopifnot(" + this.with(this.getValidation()) + ")");
        Object object3 = "";
        switch (this.getValue(TYPE)) {
            case "success_trial": {
                object3 = "cbind(success = " + this.getValue(SUCCESS) + ", trial = " + this.getValue(TRIAL) + ")";
                break;
            }
            case "success_failure": {
                object3 = "cbind(success = " + this.getValue(SUCCESS) + ", trial = " + this.getValue(SUCCESS) + " + " + this.getValue(FAILURE) + ")";
                break;
            }
            case "logical": {
                String string3 = this.getValue(NA_AS_FALSE) != false ? "1" : "!is.na(" + this.getValue(TARGET) + ")";
                object3 = "cbind(success = " + this.getValue(TARGET) + ", trial = " + string3 + ")";
                break;
            }
        }
        String string4 = "";
        boolean bl3 = bl2 = this.getValue(GROUP_TYPE).equals(GROUP_TYPE_EACH_ROW) && !this.getValue(TYPE).equals(TYPE_LOGICAL);
        if (bl2) {
            string2 = this.with(this.getValue(SUCCESS));
            string4 = this.with(this.getValue(TRIAL));
            object2 = this.with("length(" + this.getValue(SUCCESS) + ") <= 1 || length(" + this.getValue(TRIAL) + ") <= 1");
            scriptBuilder.appendLn("if (" + (String)object2 + ") { stop(\"Group should have two or more unique values\") }");
        } else {
            object2 = this.with("aggregate(" + (String)object3 + ", by = list(group = " + this.getValue(GROUP) + "), sum, na.rm = TRUE)");
            scriptBuilder.appendLn("agg <- " + (String)object2);
            scriptBuilder.appendLn("if (nrow(agg) <= 1) { stop(\"Group should have two or more unique values\") }");
            string2 = "agg$success";
            string4 = "agg$trial";
        }
        object2 = new ArgsList();
        ((ArgsList)object2).add("x", string2);
        ((ArgsList)object2).add("n", string4);
        ((ArgsList)object2).add("alternative", this.getAlternative(this.getValue(NULL_HYPOTHESIS_2)));
        ((ArgsList)object2).add("conf.level", this.getValue(CONF_LEVEL));
        ((ArgsList)object2).add("correct", RUtility.toRBoolean(this.getValue(YATES_CORRECTION)));
        if (!this.getValue(MULTIPLE_COMPARISONS).booleanValue()) {
            string = "prop.test";
            ((ArrayList)object2).addAll(this.getArgs(ARGS_PROP));
        } else {
            string = "pairwise.prop.test";
            switch (this.getValue(MC_TYPE)) {
                case "fwer": {
                    object = this.getValue(FWER_METHOD);
                    break;
                }
                case "fdr": {
                    object = this.getValue(FDR_METHOD);
                    break;
                }
                default: {
                    object = RProportionTest2.sQuote("none");
                }
            }
            ((ArgsList)object2).add("p.adjust.method", (String)object);
            ((ArrayList)object2).addAll(this.getArgs(ARGS_PAIRWISE_PROP));
        }
        scriptBuilder.appendLn("res <- do.call(" + string + ", " + RUtility.function("list", (Collection<String>)object2) + ")");
        if (this.getValue(REPLACE_GROUP_NAMES).booleanValue()) {
            if (!this.getValue(MULTIPLE_COMPARISONS).booleanValue()) {
                if (bl2) {
                    if (this.getValue(GROUP_NAMES).isEmpty()) {
                        if (!this.getValue(DATA).isEmpty()) {
                            scriptBuilder.appendLn("names(res$estimate) <- row.names(" + this.getValue(DATA) + ")");
                        }
                    } else {
                        scriptBuilder.appendLn("names(res$estimate) <- " + this.with(this.getValue(GROUP_NAMES)));
                    }
                } else {
                    scriptBuilder.appendLn("names(res$estimate) <- agg[, 1]");
                }
            } else {
                object = null;
                if (bl2) {
                    if (this.getValue(GROUP_NAMES).isEmpty()) {
                        if (!this.getValue(DATA).isEmpty()) {
                            object = "row.names(" + this.getValue(DATA) + ")";
                        }
                    } else {
                        object = this.with(this.getValue(GROUP_NAMES));
                    }
                } else {
                    object = "agg[, 1]";
                }
                if (object != null) {
                    scriptBuilder.appendLn("dimnames(res$p.value)[[1]] <- " + (String)object + "[-1]");
                    scriptBuilder.appendLn("dimnames(res$p.value)[[2]] <- " + (String)object + "[-length(" + (String)object + ")]");
                }
            }
        }
        scriptBuilder.appendLn("res");
        scriptBuilder.unind_Ln("})");
        return RUtility.assign(this.getValue(OUTPUT), scriptBuilder.toString());
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, TYPE, SUCCESS, TRIAL, FAILURE, TARGET, MULTISAMPLE, PanelWidgetNode.indent().addVisibleKeyLink(MULTISAMPLE, true).addElements(GROUP_TYPE, GROUP, REPLACE_GROUP_NAMES, GROUP_NAMES, MULTIPLE_COMPARISONS)).addTabWithElements("Options", CONF_LEVEL, NA_AS_FALSE, new SeparatorWidgetNode("1-Sample Test").addVisibleKeyLink(MULTISAMPLE, false), new XFlowPanelWidgetNode(true).addElements(NULL_HYPOTHESIS_LABEL, NULL_HYPOTHESIS, P).addVisibleKeyLink(MULTISAMPLE, Boolean.FALSE), new XFlowPanelWidgetNode(true).addElements(ALT_HYPOTHESIS_LABEL, ALT_HYPOTHESIS, ALT_P).addVisibleKeyLink(MULTISAMPLE, Boolean.FALSE), METHOD, YATES_CORRECTION, new SeparatorWidgetNode("2-Sample Test").addVisibleKeyLink(MULTISAMPLE, true), PanelWidgetNode.noScroll().addElements(new XFlowPanelWidgetNode(true).addElements(NULL_HYPOTHESIS_LABEL, NULL_HYPOTHESIS_2, GROUP2_LABEL).addVisibleKeyLink(MULTISAMPLE, Boolean.TRUE), new XFlowPanelWidgetNode(true).addElements(ALT_HYPOTHESIS_LABEL, ALT_HYPOTHESIS_2, GROUP2_LABEL2).addVisibleKeyLink(MULTISAMPLE, Boolean.TRUE)), new SeparatorWidgetNode(MULTIPLE_COMPARISONS.getTitle()).addVisibleKeyLink(MULTIPLE_COMPARISONS, true), MC_TYPE, FWER_METHOD, FDR_METHOD).addTabWithElements("Advanced", ARGS_SWITCH, ARGS_BINOM, ARGS_PROP, ARGS_PAIRWISE_PROP);
    }

    @Override
    protected int getSplitHeight() {
        return 305;
    }

    public static String getDescription(Key<?> key, Object object, ValueMap valueMap) {
        if (object.toString().isEmpty()) {
            return null;
        }
        return RClient.rexpToString(R.client().silentEvalGet("sprintf(\"(%s%%)\", " + String.valueOf(object) + " * 100)"), null);
    }

    public static String getGroupNamesDescription(Key<?> key, Object object, ValueMap valueMap) {
        if (!object.toString().isEmpty() || valueMap.getValue(DATA).isEmpty()) {
            return null;
        }
        return "row.names";
    }

    private static class BinaryVariableProvider
    implements ChoiceProvider {
        private BinaryVariableProvider() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            String string = valueMap.getValue(DATA);
            if (string.isEmpty()) {
                string = "globalenv()";
            }
            String[] stringArray = RClient.rexpToStrings(R.client().silentIdleEvalGet(".rflowBinaryVariables(" + string + ")"), null, null);
            return ChoiceProvider.strArrayToChoices(stringArray);
        }

        @Override
        public boolean isLabel() {
            return false;
        }

        @Override
        public boolean isDescription() {
            return false;
        }

        @Override
        public boolean isExclusive() {
            return false;
        }
    }
}

