/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RSubsetInterface;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.MultipleKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RConsoleResultView;
import com.ef_prime.rflow.ui.app.r.RPlotPreviewView;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RQPlot
extends ROperation
implements RSubsetInterface {
    private static final String LEGEND_AUTO = "AUTO";
    private static final String LEGEND_NONE = "NONE";
    private static final String LEGEND_TOP = "TOP";
    private static final String LEGEND_BOTTOM = "BOTTOM";
    private static final String LEGEND_LEFT = "LEFT";
    private static final String LEGEND_RIGHT = "RIGHT";
    private static final String GEOM_1D_CONT = "1D_CONTINUOUS";
    private static final String GEOM_1D_DISC = "1D_DISCRETE";
    private static final String GEOM_2D_CONT = "2D_BOTH_CONTINUOUS";
    private static final String GEOM_2D_DISC = "2D_BOTH_DISCRETE";
    private static final String GEOM_2D_CONT_DISC = "2D_CONTINOUS_DISCRETE";
    private static final String GEOM_2D_DISC_CONT = "2D_DISCRETE_CONTINOUS";
    private static final String SCATTER_PLOT = "scatterplot";
    private static final String LINE_CHARTS = "line charts";
    private static final String GEOM_BLANK = "blank";
    private static final String GEOM_BAR = "bar";
    private static final String GEOM_HISTOGRAM = "histogram";
    private static final String GEOM_DENSITY = "density";
    private static final String GEOM_FREQPOLY = "freqpoly";
    private static final String GEOM_COUNT = "count";
    private static final String GEOM_BOXPLOT = "boxplot";
    private static final String GEOM_VIOLIN = "violin";
    private static final String GEOM_POINT = "point";
    private static final String GEOM_LINE = "line";
    private static final String GEOM_PATH = "path";
    private static final String GEOM_STEP = "step";
    private static final String GEOM_JITTER = "jitter";
    private static final String GEOM_RUG = "rug";
    private static final String GEOM_SMOOTH = "smooth";
    private static final String GEOM_QUANTILE = "quantile";
    private static final String SMOOTH_METHOD_LM = "lm";
    private static final String BAR_DODGE = "dodge";
    private static final String BAR_FILL = "fill";
    private static final String BAR_STACK = "stack";
    private static final Map<String, String> GEOM_PACKAGE_MAP = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(RQPlot.GEOM_QUANTILE, "quantreg");
        }
    });
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RChoiceKey X = ((RChoiceKey.Builder)RChoiceKey.builder("x", "X").setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    private static final RChoiceKey Y = ((RChoiceKey.Builder)RChoiceKey.builder("y", "Y").setCompletionSupport(RChoiceProvider.columns(DATA, true))).build();
    private static final RChoiceKey GROUPS = ((RChoiceKey.Builder)RChoiceKey.builder("groups", "Group By").setCompletionSupport(RChoiceProvider.columns(DATA.getId(), true))).build();
    private static final RChoiceKey FACETS = ((RChoiceKey.Builder)RChoiceKey.builder("facets", "Split By").setCompletionSupport(RChoiceProvider.columns(DATA.getId(), true))).build();
    private static final BoolKey MARGINS = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("margins", "Compare with the entire data").noLabel()).addKeyLink(KeyLink.disabled(StrKeyTest.create(FACETS, "")))).build();
    private static final ChoiceKey GEOM_TYPE_1D = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_type_1d", "Type").addKeyLink(KeyLink.visible(MultipleKeyTest.or(StrKeyTest.create(X, ""), StrKeyTest.create(Y, ""))))).setValuesAndLabels("1D_CONTINUOUS", "Continuous", "1D_DISCRETE", "Discrete")).noLabel()).build();
    private static final ChoiceKey GEOM_TYPE_2D = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_type_2d", "Type").addKeyLink(KeyLink.invisible(MultipleKeyTest.or(StrKeyTest.create(X, ""), StrKeyTest.create(Y, ""))))).setValuesAndLabels("2D_BOTH_CONTINUOUS", "Both Continuous", "2D_BOTH_DISCRETE", "Both Discrete", "2D_CONTINOUS_DISCRETE", "Continuous X, Discrete Y", "2D_DISCRETE_CONTINOUS", "Discrete X, Continuous Y")).noLabel()).build();
    private static final BoolKey GEOM_AUTO = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("geom_auto", "Auto Update").setDefaultValue(Boolean.TRUE)).noLabel()).build();
    private static final ChoiceKey GEOM_TYPE_1D_CONT = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_type_1d_cont", "").addVisibleKeyLink(GEOM_TYPE_1D, "1D_CONTINUOUS")).setValuesAndLabels("histogram", "Histogram", "density", "Density", "freqpoly", "Frequency Polygons")).noLabel()).build();
    private static final RStrKey N_BINS = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("bins", "Number of Bins").addVisibleKeyLink(GEOM_TYPE_1D, "1D_CONTINUOUS")).addInvisibleKeyLink(GEOM_TYPE_1D_CONT, "density")).setDefaultMessage("log2(n) + 1")).build();
    private static final ChoiceKey GEOM_TYPE_1D_DISC = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_type_1d_disc", "").addVisibleKeyLink(GEOM_TYPE_1D, "1D_DISCRETE")).setValuesAndLabels("bar", "Bar Chart")).noLabel()).build();
    private static ChoiceKey BAR_TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("bar_type", "Arrangement").addVisibleKeyLink(GEOM_TYPE_1D, "1D_DISCRETE")).addVisibleKeyLink(GEOM_TYPE_1D_DISC, "bar")).addKeyLink(KeyLink.disabled(StrKeyTest.create(GROUPS, "")))).setValuesAndLabels("dodge", "By Group", "stack", "Stack", "fill", "Stack (Ratio)")).build();
    private static final ChoiceKey PLOT_TYPE_2D_CONT = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_type_2d_cont", "").addVisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_CONTINUOUS")).setValuesAndLabels("scatterplot", "Scatter Plot", "line charts", "Line Charts")).noLabel()).build();
    private static final ChoiceKey GEOM_LINE_TYPE = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_line_type", "Line Type").addVisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_CONTINUOUS")).addVisibleKeyLink(PLOT_TYPE_2D_CONT, "line charts")).setValuesAndLabels("line", "Line", "step", "Step", "path", "Path")).noLabel()).build();
    private static final BoolKey ADD_RUG = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("add_rug", "Add Rug Plots").addInvisibleKeyLink(GEOM_TYPE_1D, "1D_DISCRETE")).addInvisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_DISCRETE")).noLabel()).build();
    private static final BoolKey ADD_FITTED = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("add_fitted", "Add Fitted Line").addVisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_CONTINUOUS")).noLabel()).build();
    private static final BoolKey ADD_JITTER = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("add_jitter", "Add Noise (Jitter)").addVisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_CONTINUOUS")).addVisibleKeyLink(PLOT_TYPE_2D_CONT, "scatterplot")).noLabel()).build();
    private static final BoolKey ADD_POINTS = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("add_point", "Add Points").addVisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_CONTINUOUS")).addVisibleKeyLink(PLOT_TYPE_2D_CONT, "line charts")).noLabel()).build();
    private static final ChoiceKey TYPE_FITTED = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("type_fitted", "").addVisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_CONTINUOUS")).addEnabledKeyLink(ADD_FITTED, Boolean.TRUE)).setValuesAndLabels("lm", "Linear Regression", "smooth", "Smoothed Regression", "quantile", "Quantile Regression")).setRequiredRPackageMap(GEOM_PACKAGE_MAP)).noLabel()).build();
    private static final ChoiceKey GEOM_TYPE_2D_DISC = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_type_2d_disc", "").addVisibleKeyLink(GEOM_TYPE_2D, "2D_BOTH_DISCRETE")).setValuesAndLabels("count", "Points with Counts")).noLabel()).build();
    private static final ChoiceKey GEOM_TYPE_2D_CONT_DISC = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("geom_type_2d_cont_disc", "").addKeyLink(KeyLink.visible(MultipleKeyTest.or(StrKeyTest.create(GEOM_TYPE_2D, "2D_CONTINOUS_DISCRETE"), StrKeyTest.create(GEOM_TYPE_2D, "2D_DISCRETE_CONTINOUS"))))).setValuesAndLabels("boxplot", "Box Plot", "violin", "Violin Plot")).noLabel()).build();
    private static final BoolKey CHANGE_COLORS = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("change_colors", "Colors").setDefaultValue(Boolean.TRUE)).noLabel()).addKeyLink(KeyLink.disabled(StrKeyTest.create(GROUPS, "")))).build();
    private static final BoolKey CHANGE_POINTS = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("change_points", "Points").noLabel()).addKeyLink(KeyLink.disabled(StrKeyTest.create(GROUPS, "")))).build();
    private static final BoolKey CHANGE_LINES = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("change_lines", "Lines").noLabel()).addKeyLink(KeyLink.disabled(StrKeyTest.create(GROUPS, "")))).build();
    private static final ChoiceKey LEGEND_KEY = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("legend_key", "Legends").setValuesAndLabels("AUTO", "Auto", "NONE", "None", "TOP", "Top", "BOTTOM", "Bottom", "LEFT", "Left", "RIGHT", "Right")).setDefaultValue("AUTO")).addKeyLink(KeyLink.disabled(StrKeyTest.create(GROUPS, "")))).build();
    private static final RChoiceKey COLOUR_FIXED = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("colour_fixed", "Color").setValues(RQPlot.quote("black"), RQPlot.quote("blue"), RQPlot.quote("brown"), RQPlot.quote("cyan"), RQPlot.quote("gray"), RQPlot.quote("green"), RQPlot.quote("lightblue"), RQPlot.quote("magenta"), RQPlot.quote("orange"), RQPlot.quote("purple"), RQPlot.quote("red"), RQPlot.quote("white"))).addKeyLink(KeyLink.enabled(MultipleKeyTest.or(StrKeyTest.create(GROUPS, ""), BoolKeyTest.create(CHANGE_COLORS, false))))).build();
    private static final RChoiceKey FILL_FIXED = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("fill_fixed", "Fill Color").setValues(RQPlot.quote("black"), RQPlot.quote("blue"), RQPlot.quote("brown"), RQPlot.quote("cyan"), RQPlot.quote("gray"), RQPlot.quote("green"), RQPlot.quote("lightblue"), RQPlot.quote("magenta"), RQPlot.quote("orange"), RQPlot.quote("purple"), RQPlot.quote("red"), RQPlot.quote("white"))).addKeyLink(KeyLink.enabled(MultipleKeyTest.or(StrKeyTest.create(GROUPS, ""), BoolKeyTest.create(CHANGE_COLORS, false))))).build();
    private static final RChoiceKey ALPHA_FIXED = ((RChoiceKey.Builder)RChoiceKey.builder("alpha_fixed", "Opacity (\u03b1)").setValues("0.1", "0.3", "0.5", "0.7", "0.9")).build();
    private static final RChoiceKey SIZE_FIXED = ((RChoiceKey.Builder)RChoiceKey.builder("size_fixed", "Size (Relative)").setValues("0.5", "0.8", "1.0", "1.2", "1.5", "2.0", "3.0")).build();
    private static final RStrKey MAIN = ((RStrKey.Builder)RStrKey.builder("main", "Main").setCharSupport(true)).build();
    private static final RStrKey X_LAB = ((RStrKey.Builder)RStrKey.builder("xlab", "X").setCharSupport(true)).build();
    private static final RStrKey Y_LAB = ((RStrKey.Builder)RStrKey.builder("ylab", "Y").setCharSupport(true)).build();
    private static final RChoiceKey ASP = ((RChoiceKey.Builder)RChoiceKey.builder("asp", "Aspect Ratio (Y/X)").setValuesAndLabels("1", "1/1", "3/4", null, "9/16", null)).build();
    private static final RStrKey X_MIN = RStrKey.builder("xmin", "Min").build();
    private static final RStrKey X_MAX = RStrKey.builder("xmax", "Max").build();
    private static final BoolKey X_LOG_SCALE = BoolKey.builder("x_log_scale", "Log Scale").build();
    private static final RStrKey Y_MIN = RStrKey.builder("ymin", "Min").build();
    private static final RStrKey Y_MAX = RStrKey.builder("ymax", "Max").build();
    private static final BoolKey Y_LOG_SCALE = BoolKey.builder("y_log_scale", "Log Scale").build();
    private static final RTableKey ADVANCED = RQPlot.argsKey("ggplot2::qplot", "ggplot2::qplot", "x", "y", "colour", "fill", "size", "alpha", "shape", "linetype", "show.legend", "data", "facets", "margins", "geom", "xlim", "ylim", "log", "main", "xlab", "ylab", "asp", "bins", "stat", "position");

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, X, Y, GROUPS, CHANGE_COLORS, CHANGE_POINTS, CHANGE_LINES, LEGEND_KEY, FACETS, MARGINS, GEOM_TYPE_1D, GEOM_TYPE_2D, GEOM_AUTO, GEOM_TYPE_1D_CONT, GEOM_TYPE_1D_DISC, PLOT_TYPE_2D_CONT, GEOM_TYPE_2D_DISC, GEOM_TYPE_2D_CONT_DISC, GEOM_LINE_TYPE, N_BINS, BAR_TYPE, ADD_POINTS, ADD_RUG, ADD_FITTED, TYPE_FITTED, ADD_JITTER, COLOUR_FIXED, FILL_FIXED, ALPHA_FIXED, SIZE_FIXED, MAIN, ASP, X_LAB, X_MIN, X_MAX, X_LOG_SCALE, Y_LAB, Y_MIN, Y_MAX, Y_LOG_SCALE, ADVANCED);
        this.registerKeys(this.getSubsetKeys());
    }

    @Override
    public RPackage[] getRPackages() {
        if (this.getValue(GEOM_TYPE_2D).equals(GEOM_2D_CONT) && this.isEnabled(TYPE_FITTED) && this.getValue(TYPE_FITTED).equals(GEOM_QUANTILE)) {
            return new RPackage[]{new RPackage("ggplot2", true, false), new RPackage(GEOM_PACKAGE_MAP.get(GEOM_QUANTILE), true, false)};
        }
        return new RPackage[]{new RPackage("ggplot2", true, false)};
    }

    @Override
    protected String getDefaultTitle() {
        return "Quick Plot";
    }

    @Override
    public String getOpClass() {
        return "chart";
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return new ViewWidgetNode(RPlotPreviewView.class);
    }

    @Override
    public boolean canImport(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.isEmpty() || list.size() > 2) {
            return false;
        }
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        RObject rObject = list.get(0);
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null || rObject.inherits("data.frame")) {
            this.putValue(DATA, rObject.getFullName(false));
        } else {
            this.putValue(DATA, rObject2.getFullName(false));
            this.putValue(X, rObject.getName(true));
            if (list.size() > 1) {
                this.putValue(Y, list.get(1).getName(true));
            }
        }
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getContentWidgetNode(viewOptions);
        if (!viewOptions.isWizard()) {
            return this.createTabPaneWithScript(widgetNode);
        }
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        WidgetNode widgetNode2 = this.getPreviewWidgetNode();
        if (widgetNode2 != null) {
            tabPaneWidgetNode.add(widgetNode2);
            tabPaneWidgetNode.add(new ViewWidgetNode(RConsoleResultView.class));
        }
        tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
        return this.createSplitPaneWidgetNode().addElements(widgetNode, tabPaneWidgetNode);
    }

    @Override
    protected int getSplitHeight() {
        return 225;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        ButtonWidgetNode buttonWidgetNode = new ButtonWidgetNode("Swap X and Y", "swap_xy").setIconOnly(true).setIconPath("16/arrow_switch.png");
        ButtonWidgetNode buttonWidgetNode2 = new ButtonWidgetNode("Swap Group and Variable", "swap_group").setIconOnly(true).setIconPath("16/arrow_switch.png");
        KeyLink keyLink = KeyLink.disabled(StrKeyTest.create(GROUPS, ""));
        return new TabPaneWidgetNode().addTabWithElements("Main", new SplitPaneWidgetNode(false, 0.5f).setGrowY(true).addElements(new PanelWidgetNode().addElements(DATA, X, new XFlowPanelWidgetNode(true).addElements(Y, buttonWidgetNode), new XFlowPanelWidgetNode(true).addElements(GROUPS, buttonWidgetNode2), FACETS, PanelWidgetNode.indent().addElements(MARGINS)), PanelWidgetNode.noScroll().addElements(new TitledPanelWidgetNode("Plot Type", true), new XFlowPanelWidgetNode().addElements(GEOM_TYPE_1D, GEOM_TYPE_2D, GEOM_AUTO), GEOM_TYPE_1D_CONT, GEOM_TYPE_1D_DISC, BAR_TYPE, GEOM_TYPE_2D_DISC, GEOM_TYPE_2D_CONT_DISC, new XFlowPanelWidgetNode(true).addElements(PLOT_TYPE_2D_CONT, GEOM_LINE_TYPE), ADD_POINTS, new XFlowPanelWidgetNode(true).addElements(ADD_FITTED, TYPE_FITTED), N_BINS, ADD_RUG, ADD_JITTER))).addTabWithElements("Options", new SplitPaneWidgetNode(false, 0.5f).setGrowY(true).addElements(PanelWidgetNode.noScroll().addElements(new TitledPanelWidgetNode("Fixed Parameters", true), COLOUR_FIXED, FILL_FIXED, ALPHA_FIXED, SIZE_FIXED), PanelWidgetNode.noScroll().addElements(new TitledPanelWidgetNode("Group By", true), LEGEND_KEY, new XFlowPanelWidgetNode(true).addElements(CHANGE_COLORS, CHANGE_POINTS, CHANGE_LINES)).addKeyLink(keyLink))).addTabWithElements("Title", MAIN, X_LAB, Y_LAB).addTabWithElements("Axis", ASP, new SplitPaneWidgetNode(false, 0.5f).addElements(new TitledPanelWidgetNode("X", true).addElements(X_MIN, X_MAX, X_LOG_SCALE), new TitledPanelWidgetNode("Y", true).addElements(Y_MIN, Y_MAX, Y_LOG_SCALE)).setGrowY(true)).addTabWithKeys("Select Rows", this.getSubsetKeys()).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if ("swap_xy".equals(string)) {
            this.swapKeys(X, Y);
            this.swapKeys(X_LAB, Y_LAB);
            this.swapKeys(X_MIN, Y_MIN);
            this.swapKeys(X_MAX, Y_MAX);
            this.swapKeys(X_LOG_SCALE, Y_LOG_SCALE);
        }
        if ("swap_group".equals(string)) {
            if (this.getValue(X).isEmpty()) {
                this.swapKeys(Y, GROUPS);
                this.putValue(Y_LAB, "");
                this.putValue(Y_MIN, "");
                this.putValue(Y_MAX, "");
                this.putValue(Y_LOG_SCALE, Boolean.FALSE);
            }
            if (this.getValue(Y).isEmpty()) {
                this.swapKeys(X, GROUPS);
                this.putValue(X_LAB, "");
                this.putValue(X_MIN, "");
                this.putValue(X_MAX, "");
                this.putValue(X_LOG_SCALE, Boolean.FALSE);
            }
        }
    }

    private void swapKeys(Key<?> key, Key<?> key2) {
        Object obj = this.getValue(key);
        this.putValue(key, this.getValue(key2));
        this.putValue(key2, obj);
    }

    @Override
    protected void processValueChanged(ValueChangeEvent valueChangeEvent) {
        super.processValueChanged(valueChangeEvent);
        Key<?> key = valueChangeEvent.getKey();
        if (this.isEnabled(GEOM_AUTO) && this.getValue(GEOM_AUTO).booleanValue() && (X == key || Y == key || GEOM_AUTO == key)) {
            this.autoDetectType();
        }
    }

    private void autoDetectType() {
        if (this.getValue(DATA).isEmpty()) {
            return;
        }
        String string = this.subsetDF(this.getValue(DATA), this.getSubset(this));
        String string2 = this.getValue(X).isEmpty() ? null : "with(" + string + ", is.numeric(" + this.getValue(X) + "))";
        String string3 = this.getValue(Y).isEmpty() ? null : "with(" + string + ", is.numeric(" + this.getValue(Y) + "))";
        R.queryQueue().addQuery(() -> {
            Boolean bl = null;
            Boolean bl2 = null;
            if (string2 != null) {
                bl = RClient.rexpToBoolean(R.client().silentTimeoutEvalGet(string2), false);
            }
            if (string3 != null) {
                bl2 = RClient.rexpToBoolean(R.client().silentTimeoutEvalGet(string3), false);
            }
            if (bl == null) {
                this.putValue(GEOM_TYPE_1D, bl2 != false ? GEOM_1D_CONT : GEOM_1D_DISC);
            } else if (bl2 == null) {
                this.putValue(GEOM_TYPE_1D, bl != false ? GEOM_1D_CONT : GEOM_1D_DISC);
            }
            if (bl.booleanValue() && bl2.booleanValue()) {
                this.putValue(GEOM_TYPE_2D, GEOM_2D_CONT);
            } else if (!bl.booleanValue() && !bl2.booleanValue()) {
                this.putValue(GEOM_TYPE_2D, GEOM_2D_DISC);
            } else {
                if (bl.booleanValue()) {
                    this.putValue(GEOM_TYPE_2D, GEOM_2D_CONT_DISC);
                }
                if (bl2.booleanValue()) {
                    this.putValue(GEOM_TYPE_2D, GEOM_2D_DISC_CONT);
                }
            }
        });
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        int n;
        boolean bl3;
        String string;
        String string2 = this.getValue(DATA);
        String string3 = this.getSubset(this);
        String string4 = this.subsetDF(string2, string3);
        boolean bl4 = this.getValue(X).isEmpty() && !this.getValue(Y).isEmpty() || this.isEnabled(GEOM_TYPE_2D) && this.getValue(GEOM_TYPE_2D).equals(GEOM_2D_CONT_DISC);
        String string5 = this.getValue(X);
        String string6 = this.getValue(Y);
        if (string5.isEmpty() && string6.isEmpty()) {
            return "";
        }
        String string7 = this.getValue(X_MIN).isEmpty() && this.getValue(X_MAX).isEmpty() ? "" : RUtility.combine((String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(X_MIN), (CharSequence)"NA"), (String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(X_MAX), (CharSequence)"NA"));
        String string8 = this.getValue(Y_MIN).isEmpty() && this.getValue(Y_MAX).isEmpty() ? "" : RUtility.combine((String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(Y_MIN), (CharSequence)"NA"), (String)StringUtils.defaultIfEmpty((CharSequence)this.getValue(Y_MAX), (CharSequence)"NA"));
        Object object = "";
        if (!this.getValue(FACETS).isEmpty()) {
            object = ". ~ " + this.getValue(FACETS);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string9 = null;
        if (this.isEnabled(ADD_RUG) && this.getValue(ADD_RUG).booleanValue()) {
            arrayList.add(RQPlot.quote(GEOM_RUG));
        }
        if (this.isEnabled(GEOM_TYPE_1D_CONT)) {
            arrayList.add(RQPlot.quote(this.getValue(GEOM_TYPE_1D_CONT)));
        } else if (this.isEnabled(GEOM_TYPE_1D_DISC)) {
            arrayList.add(RQPlot.quote(this.getValue(GEOM_TYPE_1D_DISC)));
        } else if (this.isEnabled(PLOT_TYPE_2D_CONT)) {
            if (this.getValue(PLOT_TYPE_2D_CONT).equals(SCATTER_PLOT)) {
                if (this.isEnabled(ADD_JITTER) && this.getValue(ADD_JITTER).booleanValue()) {
                    arrayList.add(RQPlot.quote(GEOM_JITTER));
                } else {
                    arrayList.add(RQPlot.quote(GEOM_POINT));
                }
            } else if (this.getValue(PLOT_TYPE_2D_CONT).equals(LINE_CHARTS)) {
                if (this.isEnabled(ADD_POINTS) && this.getValue(ADD_POINTS).booleanValue()) {
                    arrayList.add(RQPlot.quote(this.getValue(GEOM_LINE_TYPE)));
                    arrayList.add(RQPlot.quote(GEOM_POINT));
                } else {
                    arrayList.add(RQPlot.quote(this.getValue(GEOM_LINE_TYPE)));
                }
            }
            if (this.isEnabled(TYPE_FITTED)) {
                string = this.getValue(TYPE_FITTED);
                if (string.equals(SMOOTH_METHOD_LM)) {
                    string9 = SMOOTH_METHOD_LM;
                } else {
                    arrayList.add(RQPlot.quote(string));
                }
            }
        } else if (this.isEnabled(GEOM_TYPE_2D_DISC)) {
            arrayList.add(RQPlot.quote(this.getValue(GEOM_TYPE_2D_DISC)));
        } else if (this.isEnabled(GEOM_TYPE_2D_CONT_DISC)) {
            arrayList.add(RQPlot.quote(this.getValue(GEOM_TYPE_2D_CONT_DISC)));
        }
        string = RUtility.combine(arrayList);
        String string10 = null;
        if (string.equals(RQPlot.quote(GEOM_BAR)) && !this.getValue(GROUPS).isEmpty() && !this.getValue(BAR_TYPE).equals(BAR_STACK)) {
            string = RQPlot.quote(GEOM_BLANK);
            string10 = this.getValue(BAR_TYPE);
        }
        Object object2 = null;
        if (this.isEnabled(GEOM_TYPE_1D_CONT)) {
            object2 = this.getValue(N_BINS).isEmpty() ? "ceiling(log2(nrow(" + string4 + ")) + 1)" : this.getValue(N_BINS);
            switch (this.getValue(GEOM_TYPE_1D_CONT)) {
                case "histogram": 
                case "freqpoly": {
                    break;
                }
                default: {
                    object2 = null;
                }
            }
        }
        Object object3 = null;
        if (this.isEnabled(CHANGE_COLORS) && this.getValue(CHANGE_COLORS).booleanValue()) {
            object3 = this.getValue(GROUPS);
        } else if (!this.getValue(COLOUR_FIXED).isEmpty()) {
            object3 = "I(" + this.getValue(COLOUR_FIXED) + ")";
        }
        Object object4 = null;
        if ((this.getValue(X).isEmpty() || this.getValue(Y).isEmpty()) && this.isEnabled(CHANGE_COLORS) && this.getValue(CHANGE_COLORS).booleanValue()) {
            object4 = this.getValue(GROUPS);
        } else if (!this.getValue(FILL_FIXED).isEmpty()) {
            object4 = "I(" + this.getValue(FILL_FIXED) + ")";
        }
        Object object5 = null;
        if (arrayList.contains(RQPlot.quote(GEOM_DENSITY)) && !this.getValue(GROUPS).isEmpty()) {
            object5 = "I(0.5)";
        } else if (!this.getValue(ALPHA_FIXED).isEmpty()) {
            object5 = "I(" + this.getValue(ALPHA_FIXED) + ")";
        }
        String string11 = RUtility.function("ggplot2::qplot", this.getArgs(ADVANCED), new String[]{"x", bl4 ? string6 : string5, "y", bl4 ? string5 : string6, "colour", object3, BAR_FILL, object4, "alpha", object5, "size", this.getValue(SIZE_FIXED).isEmpty() ? null : "I(" + this.getValue(SIZE_FIXED) + ")", "shape", !this.getValue(Y).isEmpty() && this.isEnabled(CHANGE_POINTS) && this.getValue(CHANGE_POINTS) != false ? this.getValue(GROUPS) : null, "linetype", this.isEnabled(CHANGE_POINTS) && this.getValue(CHANGE_LINES) != false ? this.getValue(GROUPS) : null, "show.legend", this.isEnabled(LEGEND_KEY) && this.getValue(LEGEND_KEY) == LEGEND_NONE ? "FALSE" : null, "data", string4, "facets", object, "margins", !((String)object).isEmpty() && this.getValue(MARGINS) != false ? "TRUE" : null, "geom", string, "xlim", bl4 ? string8 : string7, "ylim", bl4 ? string7 : string8, "log", this.getLog(bl4), "main", this.getValue(MAIN), "xlab", bl4 ? this.getValue(Y_LAB) : this.getValue(X_LAB), "ylab", bl4 ? this.getValue(X_LAB) : this.getValue(Y_LAB), "asp", this.getValue(ASP), "bins", object2});
        ScriptBuilder scriptBuilder = new ScriptBuilder();
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(RPackage.toNames(this.getRPackages())));
        arrayList2.remove("ggplot2");
        boolean bl5 = bl3 = arrayList2.size() > 0;
        if (bl3) {
            n = 0;
            scriptBuilder.append("if(");
            for (String string12 : arrayList2) {
                if (n > 0) {
                    scriptBuilder.append(" && ");
                }
                scriptBuilder.append("requireNamespace(\"");
                scriptBuilder.append(string12);
                scriptBuilder.append("\")");
                ++n;
            }
            scriptBuilder.appendLn(") {");
            scriptBuilder.indent();
        }
        scriptBuilder.append("print(");
        scriptBuilder.append(string11);
        n = 0;
        if (string10 != null) {
            scriptBuilder.appendLn(" + ");
            if (n == 0) {
                scriptBuilder.indent();
                n = 1;
            }
            scriptBuilder.append("ggplot2::geom_bar(position = " + RQPlot.quote(string10) + ")");
        }
        if (string9 != null) {
            scriptBuilder.appendLn(" + ");
            if (n == 0) {
                scriptBuilder.indent();
                n = 1;
            }
            scriptBuilder.append("ggplot2::geom_smooth(method = " + RQPlot.quote(string9) + ")");
        }
        if (this.isEnabled(LEGEND_KEY) && this.getValue(LEGEND_KEY) != LEGEND_AUTO && this.getValue(LEGEND_KEY) != LEGEND_NONE) {
            scriptBuilder.appendLn(" + ");
            if (n == 0) {
                scriptBuilder.indent();
                n = 1;
            }
            scriptBuilder.append("ggplot2::theme(legend.position = \"" + this.getValue(LEGEND_KEY).toLowerCase() + "\")");
        }
        if (bl4) {
            scriptBuilder.appendLn(" + ");
            if (n == 0) {
                scriptBuilder.indent();
                n = 1;
            }
            scriptBuilder.append("ggplot2::coord_flip()");
        }
        if (n != 0) {
            scriptBuilder.appendLn();
            scriptBuilder.unindent();
        }
        scriptBuilder.append(")");
        if (bl3) {
            scriptBuilder.appendLn();
            scriptBuilder.unindent();
            scriptBuilder.append("}");
        }
        return scriptBuilder.toString();
    }

    private String subsetDF(String string, String string2) {
        if (string.isEmpty()) {
            return null;
        }
        if (string2 == null || string2.isEmpty()) {
            return string;
        }
        return "subset(" + string + ", " + string2 + ")";
    }

    private String getLog(boolean bl) {
        String string;
        String string2 = this.getValue(X_LOG_SCALE) != false ? "x" : "";
        String string3 = string = this.getValue(Y_LOG_SCALE) != false ? "y" : "";
        if (bl) {
            String string4 = string2;
            string2 = string;
            string = string4;
        }
        if (string2.isEmpty() && string.isEmpty()) {
            return null;
        }
        return RUtility.quote(string2 + string);
    }
}

