/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RFileKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.common.component.Flavors;
import java.awt.datatransfer.Transferable;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class RReadExcel
extends ROperation {
    private static final StrKey KEY_OUTPUT = new RStrKey("_output", "Output", "", null, null);
    private static final RFileKey KEY_FILE = RFileKey.builder("file", "File").build();
    private static final StrKey KEY_SHEET_NAME = new RStrKey("sheetName", "Sheet Name");

    @Override
    protected void initKeys() {
        this.registerKeys(KEY_FILE, KEY_OUTPUT, KEY_SHEET_NAME);
    }

    @Override
    public String getDefaultTitle() {
        return "Excel -> R";
    }

    @Override
    public String getSummary() {
        String string = RUtility.unquote(this.getValue(KEY_FILE));
        return this.getValue(KEY_OUTPUT) + "<-" + FilenameUtils.getName((String)string);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string = this.getValue(KEY_FILE);
        String string2 = this.getValue(KEY_OUTPUT);
        if (StringUtils.isEmpty((CharSequence)string) || StringUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2 + " <- local({").append("\n");
        stringBuilder.append("library(xlsx)").append("\n");
        stringBuilder.append("read.xlsx2(file = " + string + ", sheetName = " + this.getValue(KEY_SHEET_NAME) + ", colClasses = NA, stringsAsFactors = FALSE, check.names = TRUE)").append("\n");
        stringBuilder.append("})");
        return stringBuilder.toString();
    }

    @Override
    protected String[] getNewRObjects() {
        return new String[]{this.getValue(KEY_OUTPUT)};
    }

    @Override
    public boolean isSupported(App app) {
        return app == Apps.R || app == Apps.FILE;
    }

    @Override
    public boolean canImport(Transferable transferable) {
        File file = Flavors.getFile(transferable);
        if (file == null || file.isDirectory()) {
            return false;
        }
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        return fileInfo.isContainer(FileInfo.EXCEL) || fileInfo.is(FileInfo.EXCEL);
    }

    @Override
    protected void importValues(Transferable transferable) {
        if (!Flavors.isFileFlavorSupported(transferable)) {
            return;
        }
        File file = Flavors.getFile(transferable);
        if (file == null || file.isDirectory()) {
            return;
        }
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        File file2 = file;
        if (fileInfo.isContainer(FileInfo.EXCEL)) {
            file2 = file.getParentFile();
            this.putValue(KEY_SHEET_NAME, RReadExcel.quote(file.getName()));
        }
        this.putValue(KEY_FILE, RUtility.quotedPath(file2.getAbsolutePath()));
    }
}

