/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RFileKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class RReadObject
extends ROperation {
    private static final String RDS = "rds";
    private static final String RDATA = "RData";
    private static final RFileKey FILE = ((RFileKey.Builder)RFileKey.builder("file", "Input File").setRequired(true)).build();
    private static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("type", "File Format").setValues("rds", "RData")).setLabels("Single Object (.rds)", "Multiple Objects (.RData)")).setAutoValueLink(true, FILE)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((Key.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output Object").setAutoValueLink(FILE)).setOutput(true)).addVisibleKeyLink(TYPE, "rds")).build();

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(FILE, TYPE, OUTPUT);
    }

    @Override
    public String getDefaultTitle() {
        return "Load R Object";
    }

    @Override
    public String getOpClass() {
        return "io";
    }

    @Override
    protected StrKey getFileImportKey() {
        return FILE;
    }

    @Override
    protected boolean canImportFile(FileInfo fileInfo) {
        return fileInfo.isExtensionAny(RDS, RDATA);
    }

    @Override
    public Object getDynamicDefaultValue(Key<?> key) {
        if (key == OUTPUT) {
            String string = RUtility.unquote(this.getValue(FILE));
            return FilenameUtils.removeExtension((String)FilenameUtils.getName((String)string));
        }
        return super.getDynamicDefaultValue(key);
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (key == OUTPUT) {
            String string = RReadObject.unquote(this.getValue(FILE));
            return RReadObject.makeName(FilenameUtils.removeExtension((String)FilenameUtils.getName((String)string)));
        }
        if (key == TYPE) {
            String string = RReadObject.unquote(this.getValue(FILE));
            String string2 = FilenameUtils.getExtension((String)string).toLowerCase();
            if (string2.equals(RDATA.toLowerCase())) {
                return RDATA;
            }
            if (string2.equals(RDS.toLowerCase())) {
                return RDS;
            }
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        if (this.getValue(TYPE).equals(RDS)) {
            return RUtility.assignFunction(this.getValue(OUTPUT), "readRDS", "file", this.getValue(FILE));
        }
        return RUtility.function("load", "file", this.getValue(FILE));
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return null;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new PanelWidgetNode().addKeys(FILE).add(new KeyWidgetNode(TYPE).setAutoUpdate(true)).addKeys(OUTPUT);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            if (StringUtils.isEmpty((CharSequence)this.getValue(OUTPUT))) {
                this.putValue(OUTPUT, this.getDynamicDefaultValue(OUTPUT));
            } else {
                this.putValue(OUTPUT.getAutoValueLinkKey(), Boolean.FALSE);
            }
        }
    }
}

