/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.file.FileInfo;
import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.app.file.ZipFileUtility;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.ArgEntry;
import com.ef_prime.rflow.core.app.r.base.ArgList;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RFileKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceProvider;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.script.RScriptUtility;
import com.ef_prime.rflow.ui.common.component.Flavors;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.Token;

public class RReadTable
extends ROperation
implements ValueChangeEventHandler {
    private static final String COL_CLASSES_COLUMNS = "columns";
    private static final String COL_CLASSES_ALL_SAME = "all_same";
    private static final String TYPE_NA = "NA";
    private static final String TYPE_INTEGER = RReadTable.sQuote("integer");
    private static final String TYPE_NUMERIC = RReadTable.sQuote("numeric");
    private static final String TYPE_LOGICAL = RReadTable.sQuote("logical");
    private static final String TYPE_CHARACTER = RReadTable.sQuote("character");
    private static final String TYPE_FACTOR = RReadTable.sQuote("factor");
    private static final String TYPE_DATE = RReadTable.sQuote("Date");
    private static final String TYPE_POSIX_CT = RReadTable.sQuote("POSIXct");
    private static final String TYPE_COMPLEX = RReadTable.sQuote("complex");
    private static final String TYPE_RAW = RReadTable.sQuote("raw");
    private static final RFileKey FILE = ((RFileKey.Builder)((RFileKey.Builder)RFileKey.builder("file", "Input File").setSubTitle("file")).setRequired(true)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output Object").setAutoValueLink(FILE)).setOutput(true)).build();
    private static final RChoiceKey SEP = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("sep", "Separator").setDefaultValue(RReadTable.sQuote(""))).setValuesAndLabels("", "", RReadTable.sQuote(""), "White Space", RReadTable.sQuote(","), "Comma", RReadTable.sQuote("\\t"), "Tab", RReadTable.sQuote(" "), "Space", RReadTable.sQuote(";"), "Semicolon")).build();
    private static final RChoiceKey HEADER = RReadTable.logicalKey("header", "Header", "FALSE");
    private static final RChoiceKey FILE_ENCODING = ((RChoiceKey.Builder)RChoiceKey.builder("fileEncoding", "Encoding").setValuesAndLabels(RChoiceKey.ENCODINGS)).build();
    private static final RStrKey NROWS = ((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("nrows", "Number of Rows").setDefaultMessage("(All)")).setPreviewFunction(ROW_NUMBER_PREVIEW)).build();
    private static final RChoiceKey QUOTE = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("quote", "Quote Mark").setDefaultValue(RReadTable.quote("\""))).setValuesAndLabels("", "", RReadTable.sQuote(""), "None", RReadTable.sQuote("\\\""), "\"Double\"", RReadTable.sQuote("'"), "'Single'", RReadTable.sQuote("\\\"'"), "\"Double\" / 'Single'")).build();
    private static final RChoiceKey STRING_AS_FACTORS = RReadTable.logicalKey("stringsAsFactors", "Convert Characters to Factors", "FALSE");
    private static final RChoiceKey COMMENT_CHAR = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("comment.char", "Comment Mark").setDefaultValue(RReadTable.quote(""))).setValuesAndLabels("", "", RReadTable.sQuote(""), "None", RReadTable.sQuote("#"), "")).build();
    private static final BoolKey AUTODETECT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("autodetect", "Auto update when file is changed").setDefaultValue(true)).setLabelPosition("none")).build();
    private static final RChoiceKey NA_STRINGS = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("na.strings", "Missing Values").setDefaultValue(RReadTable.quote(""))).setValuesAndLabels("", "", RReadTable.sQuote(""), "None", RReadTable.sQuote("NA"), "", RReadTable.sQuote("null"), "", RReadTable.sQuote("NULL"), "")).build();
    private static final RChoiceKey CHECK_NAMES = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("check.names", "Convert Invalid Column Names").setDefaultMessage("TRUE")).setValues("", "TRUE", "FALSE")).build();
    private static final RadioButtonKey COL_CLASSES_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("colClasses_type", "").setValuesAndLabels("columns", "Set by Column", "all_same", "Use Single Setting")).setLabelPosition("none")).build();
    private static final RChoiceKey COL_COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("column_name", "Column Name").setChoiceProvider(new FileColumnsProvider())).build();
    private static final ChoiceKey COL_TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("type", "Class").setValuesAndLabels("NA", "Auto Detect", TYPE_LOGICAL, "Logical", TYPE_INTEGER, "Integer", TYPE_NUMERIC, "Numeric", TYPE_CHARACTER, "Character", TYPE_FACTOR, "Category", TYPE_DATE, "Date", TYPE_POSIX_CT, "Date and time", TYPE_COMPLEX, "Complex", TYPE_RAW, "Bytes")).showValueAndLabel(true)).build();
    private static final RTableKey COL_CLASSES = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("colClasses", "", COL_COLUMN, COL_TYPE).setUiControls(GeneralTableModel.UI_DEFAULT2)).addVisibleKeyLink(COL_CLASSES_TYPE, "columns")).setLabelPosition("none")).build();
    private static final ChoiceKey COL_CLASS = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("colClass", "Class").setChoices(COL_TYPE.getChoices(null))).showValueAndLabel(true)).setDefaultValue(TYPE_CHARACTER)).addVisibleKeyLink(COL_CLASSES_TYPE, "all_same")).build();
    private static final RTableKey ADVANCED = RReadTable.argsKey("read.table");

    public RReadTable() {
        this.addEventHandler(this);
    }

    @Override
    public Version getVersion() {
        return new Version(0, 2, 1);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            this.putValue(AUTODETECT, Boolean.FALSE);
            if (StringUtils.isEmpty((CharSequence)this.getValue(OUTPUT))) {
                this.putValue(OUTPUT, this.getDynamicDefaultValue(OUTPUT));
            } else {
                this.putValue(OUTPUT.getAutoValueLinkKey(), Boolean.FALSE);
            }
        }
    }

    @Override
    public String getDefaultTitle() {
        return "Read Text File";
    }

    @Override
    public String getOpClass() {
        return "io";
    }

    @Override
    public void initKeys() {
        this.registerKeys(FILE, OUTPUT, AUTODETECT, SEP, HEADER, FILE_ENCODING, NROWS, NA_STRINGS, QUOTE, STRING_AS_FACTORS, COMMENT_CHAR, CHECK_NAMES, COL_CLASSES_TYPE, COL_CLASSES, COL_CLASS, ADVANCED);
    }

    @Override
    public void initialize(boolean bl) {
        super.initialize(bl);
        this.getDefaultEncoding().ifPresent(string -> this.putValue(FILE_ENCODING, RReadTable.quote(string)));
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        return RUtility.assign(this.getValue(OUTPUT), this.readTable(this.getValue(NROWS), this.colClasses()));
    }

    private String colClasses() {
        if (this.getValue(COL_CLASSES_TYPE).equals(COL_CLASSES_COLUMNS)) {
            ArgsList argsList = new ArgsList();
            for (KeysTableRow keysTableRow : this.getValue(COL_CLASSES)) {
                argsList.add(keysTableRow.getValue(COL_COLUMN), keysTableRow.getValue(COL_TYPE));
            }
            if (argsList.isEmpty()) {
                return "";
            }
            return RUtility.function("c", argsList);
        }
        return this.getValue(COL_CLASS);
    }

    private String readTable(String string, String string2) {
        return RUtility.function("read.table", this.getArgs(ADVANCED), "file", this.getValue(FILE), "header", this.getValue(HEADER), "sep", this.getValue(SEP), "fileEncoding", this.getValue(FILE_ENCODING), "colClasses", string2, "nrows", string, "quote", this.getValue(QUOTE), "stringsAsFactors", this.getValue(STRING_AS_FACTORS), "comment.char", this.getValue(COMMENT_CHAR), "na.strings", this.getValue(NA_STRINGS), "check.names", this.getValue(CHECK_NAMES));
    }

    @Override
    public boolean isSupported(App app) {
        return app == Apps.R || app == Apps.FILE;
    }

    @Override
    protected StrKey getFileImportKey() {
        return FILE;
    }

    @Override
    protected boolean canImportFile(FileInfo fileInfo) {
        return fileInfo.isText();
    }

    @Override
    protected void importValues(Transferable transferable) {
        File file = Flavors.getFile(transferable);
        if (file == null || file.isDirectory()) {
            return;
        }
        boolean bl = true;
        FileInfo fileInfo = FileInfos.getInstance().getFileInfo(file);
        if (fileInfo.isContainer(FileInfo.ZIP)) {
            File file2 = ZipFileUtility.getParentZipFile(file);
            String string = RUtility.quotedPath(ZipFileUtility.getInnerPath(file, file2));
            String string2 = RUtility.quotedPath(WorkingDirectory.toAbstractPath(file2).getPath());
            this.putValue(FILE, "unz(" + string2 + ", " + string + ")");
            bl = false;
        } else {
            File file3 = WorkingDirectory.toAbstractPath(file);
            this.putValue(FILE, RUtility.quotedPath(file3.getPath()));
        }
        if (this.getValue(AUTODETECT).booleanValue()) {
            this.autoDetect(file, bl);
        }
    }

    private void autoDetect() {
        Optional<String[]> optional = R.client().getConnectionInfo(this.getValue(FILE));
        optional.ifPresent(stringArray -> {
            String string = stringArray[0];
            String string2 = stringArray[1];
            boolean bl = true;
            if (string2.equals("unz")) {
                int n = string.lastIndexOf(58);
                if (n >= 0) {
                    char[] cArray = string.toCharArray();
                    cArray[n] = 47;
                    string = String.copyValueOf(cArray);
                }
                bl = false;
            }
            this.autoDetect(WorkingDirectory.toAbsolutePath(new File(string)), bl);
        });
    }

    private void autoDetect(File file, boolean bl) {
        if (bl && !WorkingDirectory.toAbsolutePath(file).exists()) {
            return;
        }
        TextFile textFile = TextFile.get(file);
        String string = RUtility.quote(textFile.getSeparator().toString());
        if (string.equals("\"\t\"")) {
            string = "\"\\t\"";
        }
        this.putValue(HEADER, RUtility.toRBoolean(textFile.isHeader()));
        this.putValue(SEP, string);
        String string2 = RUtility.toREncoding(textFile.getEncoding(), R.client().getNativeEncoding());
        if (!string2.isEmpty()) {
            this.putValue(FILE_ENCODING, RReadTable.quote(string2));
        }
    }

    @Override
    public WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        ButtonWidgetNode buttonWidgetNode = new ButtonWidgetNode("Auto Detect", "auto_detect");
        ButtonWidgetNode buttonWidgetNode2 = viewOptions.isWizard() ? new XFlowPanelWidgetNode().addElements(buttonWidgetNode, AUTODETECT) : buttonWidgetNode;
        WidgetNode widgetNode = new ButtonWidgetNode("Auto Detect", "type_detect").addVisibleKeyLink(COL_CLASSES_TYPE, COL_CLASSES_COLUMNS);
        return new TabPaneWidgetNode().addTabWithElements("Main", FILE, OUTPUT, NROWS, new TitledPanelWidgetNode("File Format", true).addElements(buttonWidgetNode2, SEP, HEADER, FILE_ENCODING)).addTabWithKeys("Options", QUOTE, STRING_AS_FACTORS, COMMENT_CHAR, NA_STRINGS, CHECK_NAMES).addTabWithElements("Data Type", COL_CLASSES_TYPE, widgetNode, COL_CLASSES, COL_CLASS).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    public Object getDynamicDefaultValue(Key<?> key) {
        if (key == OUTPUT) {
            String string = RReadTable.unquote(this.getValue(FILE));
            return FilenameUtils.removeExtension((String)FilenameUtils.getName((String)string));
        }
        return super.getDynamicDefaultValue(key);
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (key == OUTPUT) {
            String string;
            String string2 = this.getValue(FILE);
            if (string2.startsWith("unz(") || string2.startsWith("base::unz(")) {
                ArgEntry argEntry;
                ArgList argList;
                String string3;
                if (string2.startsWith("b")) {
                    string2 = string2.substring("base::".length());
                }
                if ((string3 = (argList = RScriptUtility.getArgList((Token)(string = RScriptUtility.getTokenList(string2)))).getValue("filename", false)) == null && argList.size() > 1 && !(argEntry = (ArgEntry)argList.get(1)).isParam()) {
                    string3 = argEntry.getValue();
                }
                if (string3 != null) {
                    string2 = string3;
                }
            }
            string = RReadTable.unquote(string2);
            return RReadTable.makeName(FilenameUtils.removeExtension((String)FilenameUtils.getName((String)string)));
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getSubtitle(Key<?> key) {
        if (key == OUTPUT || key == ADVANCED || key == COL_CLASS) {
            return null;
        }
        return key.getId();
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if ((valueChangeEvent.getKey() == FILE || valueChangeEvent.getKey() == AUTODETECT) && this.getValue(AUTODETECT).booleanValue()) {
            this.autoDetect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if ("auto_detect".equals(string)) {
            this.autoDetect();
        } else if ("type_detect".equals(string)) {
            RObject rObject = RObject.builder(this.readTable("1000", "")).setType("list").setClasses("data.frame").build();
            RObjectSet rObjectSet = R.client().getObjects(rObject, true, 0);
            if (rObjectSet == null) {
                return;
            }
            List<RObject> list = rObjectSet.getObjects();
            KeysTableModel keysTableModel = this.getValue(COL_CLASSES);
            keysTableModel.beginValueChange();
            try {
                keysTableModel.removeAllRows();
                String[] stringArray = new String[]{"Date", TYPE_DATE, "POSIXct", TYPE_POSIX_CT, "factor", TYPE_FACTOR, "integer", TYPE_INTEGER, "numeric", TYPE_NUMERIC, "complex", TYPE_COMPLEX, "logical", TYPE_LOGICAL, "character", TYPE_CHARACTER, "raw", TYPE_RAW};
                for (RObject rObject2 : list) {
                    String string2 = rObject2.getName(true);
                    String string3 = TYPE_NA;
                    for (int i = 0; i < stringArray.length; i += 2) {
                        if (!rObject2.inherits(stringArray[i])) continue;
                        string3 = stringArray[i + 1];
                        break;
                    }
                    keysTableModel.addNewRow(string2, string3);
                }
            }
            finally {
                keysTableModel.endValueChange();
            }
        }
    }

    @Override
    public void configureForFlow() {
        this.putValue(AUTODETECT, Boolean.FALSE);
    }

    private static class FileColumnsProvider
    implements ChoiceProvider {
        private FileColumnsProvider() {
        }

        @Override
        public List<Choice> getChoices(ValueMap valueMap) {
            RReadTable rReadTable = (RReadTable)valueMap;
            return RChoiceProvider.rQueryToChoices(".rflowGetNames(x = " + rReadTable.readTable("1", TYPE_CHARACTER) + ", check.names = TRUE)");
        }
    }
}

