/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RReplaceNA;
import com.ef_prime.rflow.core.app.r.RReplaceNAMulti;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ComponentTableKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.keyvalue.RReplaceNATableWidget;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RReplaceMissingValues
extends ROperation {
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Input").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    private static final ValueMapKey NA_ACTION = ((ValueMapKey.Builder)((ValueMapKey.Builder)((Object)ValueMapKey.builder("na_action", "NA Action", new RReplaceNA()).addClass("replace", RReplaceNA.class))).addClass("replace_multi", RReplaceNAMulti.class)).build();
    private static final ComponentTableKey TABLE = ComponentTableKey.builder("table", "Table", NA_ACTION).build();
    private static final StrKey NA_FLAG_SUFFIX = ((StrKey.Builder)((StrKey.Builder)StrKey.builder("na_flag_suffix", "Missing Value Flag Suffix").setDefaultValue("_NA")).setRequired(true)).build();

    @Override
    public Version getVersion() {
        return new Version(0, 2, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, TABLE, NA_FLAG_SUFFIX);
    }

    @Override
    protected String getDefaultTitle() {
        return "Missing Values";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return this.getValue(DATA);
        }
        return super.getAutoValue(key);
    }

    @Override
    protected StrKey getOutputKey() {
        return OUTPUT;
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        this.importDataOrColumns(transferable, DATA, list -> {
            ArrayList<RReplaceNA> arrayList = new ArrayList<RReplaceNA>(list.size());
            for (RObject rObject : list) {
                arrayList.add(new RReplaceNA(rObject.getName(false), null));
            }
            this.getValue(TABLE).addAll(arrayList);
        });
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        ScriptBuilder scriptBuilder = RReplaceMissingValues.scriptBuilder();
        scriptBuilder.appendLn("{").indent();
        String string = this.getValue(DATA);
        String string2 = this.getValue(OUTPUT);
        String string3 = "x";
        String string4 = "y";
        scriptBuilder.appendLn(RUtility.assign(string3, string));
        scriptBuilder.appendLn(RUtility.assign(string4, string));
        ListModel<ValueMap> listModel = this.getValue(TABLE);
        ArrayList<RReplaceNA> arrayList = new ArrayList<RReplaceNA>();
        for (ValueMap valueMap : listModel) {
            if (!(valueMap instanceof RReplaceNA)) continue;
            RReplaceNA rReplaceNA2 = (RReplaceNA)valueMap;
            if (rReplaceNA2.isActionRemove()) {
                arrayList.add(rReplaceNA2);
                continue;
            }
            rReplaceNA2.addReplaceExpression(scriptBuilder, string4, string3, this.getValue(NA_FLAG_SUFFIX));
        }
        if (!arrayList.isEmpty()) {
            List list = arrayList.stream().flatMap(rReplaceNA -> rReplaceNA.getColumns().stream()).collect(Collectors.toList());
            scriptBuilder.appendLn(RUtility.assign("y", "y[complete.cases(x[ ," + RUtility.combineCharacters(list) + "]), ]"));
        }
        scriptBuilder.appendLn(string4);
        scriptBuilder.unindent().append("}");
        return RUtility.assignFunction(string2, "local", "", scriptBuilder.toString());
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        ButtonWidgetNode buttonWidgetNode = new ButtonWidgetNode("Auto Generate Entries", "autodetect");
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, buttonWidgetNode, new KeyWidgetNode(TABLE, RReplaceNATableWidget.class)).addTabWithElements("Options", NA_FLAG_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if ("autodetect".equals(string)) {
            String string2 = this.getValue(DATA);
            if (string2.isEmpty()) {
                return;
            }
            RObject rObject = RObject.builder(string2).setType("list").setClasses("data.frame").build();
            RObjectSet rObjectSet = R.client().getObjects(rObject, true, 0);
            if (rObjectSet == null) {
                return;
            }
            byte[] byArray = RClient.rexpToLogicalBytes(R.client().silentIdleEvalGet("unlist(lapply(" + string2 + ", anyNA))"), null);
            if (byArray == null || byArray.length != rObjectSet.getSize()) {
                return;
            }
            List<RObject> list = rObjectSet.getObjects();
            ListModel<ValueMap> listModel = this.getValue(TABLE);
            Set set = listModel.stream().flatMap(valueMap -> ((RReplaceNA)valueMap).getColumns().stream()).collect(Collectors.toSet());
            listModel.beginValueChange();
            try {
                for (int i = 0; i < byArray.length; ++i) {
                    RObject rObject2;
                    String string3;
                    if (byArray[i] != 1 || set.contains(string3 = (rObject2 = list.get(i)).getName(false))) continue;
                    String string4 = RUtility.quote("");
                    if (rObject2.inherits("factor")) {
                        string4 = RReplaceMissingValues.quote(RClient.rexpToString(R.client().silentIdleEvalGet("levels(" + string2 + "[[" + RReplaceMissingValues.quote(string3) + "]])[1]"), ""));
                    } else {
                        switch (rObject2.getType()) {
                            case "integer": {
                                string4 = "0L";
                                break;
                            }
                            case "double": 
                            case "numeric": {
                                string4 = "0";
                                break;
                            }
                            case "logical": {
                                string4 = "FALSE";
                                break;
                            }
                        }
                    }
                    listModel.add(new RReplaceNA(string3, string4));
                }
            }
            finally {
                listModel.endValueChange();
            }
        }
    }
}

