/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.function.Predicate;

public class RReplaceNames
extends ROperation {
    private static final String TYPE_STANDARD = "standard";
    private static final String TYPE_SUBSTRING = "substring";
    private static final String TYPE_REGULAR_EXPRESSION = "regex";
    public static final String TARGET_NAMES = "names";
    public static final String TARGET_ROW_NAMES = "rownames";
    public static final String TARGET_COLUMN_NAMES = "colnames";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).build();
    private static final ChoiceKey TARGET = ((ChoiceKey.Builder)ChoiceKey.builder("target", "Target").setValuesAndLabels("names", "Names (names)", "rownames", "Row Names (rownames)", "colnames", "Column Names (colnames)")).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValuesAndLabels("standard", "Perfect Matching", "substring", "Substring", "regex", "Regular Expression")).build();
    private static final ChoiceKey TABLE_TARGET = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("table_target", "Target").setChoiceEditable(true)).setChoiceProvider(RChoiceProvider.arbitraryFunction(TARGET.getId(), DATA.getId()))).setRequired(true)).build();
    private static final StrKey TABLE_REPLACEMENT = StrKey.builder("table_replacement", "Replacement").build();
    private static final RTableKey REPLACEMENT_TABLE = ((RTableKey.Builder)RTableKey.builder("replacement_table", "Replacement Table", TABLE_TARGET, TABLE_REPLACEMENT).setUiControls(GeneralTableModel.UI_DEFAULT2)).build();
    private static final BoolKey ALL_MATCH = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("all_match", "Replace All Matches").setDefaultValue(Boolean.TRUE)).addInvisibleKeyLink(TYPE, "standard")).build();
    private static final BoolKey CASE_SENSITIVE = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("case_sensitive", "Case Sensitive").setDefaultValue(Boolean.TRUE)).addInvisibleKeyLink(TYPE, "standard")).build();
    private static final RTableKey ARGS = RReplaceNames.argsKey("sub", "sub/gsub", new String[0]);

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, TARGET, TYPE, REPLACEMENT_TABLE, ALL_MATCH, CASE_SENSITIVE, ARGS);
    }

    @Override
    protected String getDefaultTitle() {
        return "Rename";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, TARGET, TYPE, REPLACEMENT_TABLE).addTab((TabWidgetNode)new TabWidgetNode("Options").addElements(ALL_MATCH, CASE_SENSITIVE).addKeyLink(TYPE, "VISIBLE_OFF", TYPE_STANDARD)).addTabWithElements("Advanced", ARGS);
    }

    @Override
    protected String[] getNewRObjects() {
        return new String[]{this.getValue(DATA)};
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        int n;
        Object object = switch (this.getValue(TARGET)) {
            case TARGET_ROW_NAMES -> TARGET_ROW_NAMES;
            case TARGET_COLUMN_NAMES -> TARGET_COLUMN_NAMES;
            default -> TARGET_NAMES;
        };
        object = (String)object + "(" + this.getValue(DATA) + ")";
        int n2 = n = this.getValue(REPLACEMENT_TABLE).getRowCount() == 0 ? 1 : 0;
        Object object2 = n != 0 ? object : (this.getValue(TYPE).equals(TYPE_STANDARD) ? this.standardReplace((String)object) : this.grepReplace((String)object));
        if (previewOption.isEnabled()) {
            ScriptBuilder scriptBuilder = RReplaceNames.scriptBuilder();
            scriptBuilder.appendLn(RUtility.assignFunction("preview", "data.frame", new String[]{"Before", object, "` `", RReplaceNames.quote("->"), "After", n != 0 ? object : object2, "check.names", "FALSE", "stringsAsFactors", "FALSE"}));
            scriptBuilder.appendLn("preview[[2]] <- ifelse(preview$Before == preview$After, \" = \", \" ->\")");
            return scriptBuilder.toString();
        }
        return RUtility.assign((String)object, (String)object2);
    }

    private String standardReplace(String string) {
        Predicate<KeysTableRow> predicate = keysTableRow -> !keysTableRow.getValue(TABLE_REPLACEMENT).isEmpty();
        String string2 = RUtility.combineCharacters(this.getValue(REPLACEMENT_TABLE).getValidValues(TABLE_TARGET, predicate));
        String string3 = RUtility.combineCharacters(this.getValue(REPLACEMENT_TABLE).getValidValues(TABLE_REPLACEMENT, predicate));
        if (string2.isEmpty()) {
            return string;
        }
        ScriptBuilder scriptBuilder = RReplaceNames.scriptBuilder();
        scriptBuilder.appendLn("local({").indent();
        scriptBuilder.appendLn("x <- " + string);
        scriptBuilder.appendLn("m <- " + RUtility.function("match", "x", "x", "table", string2));
        scriptBuilder.appendLn(RUtility.function("replace", "", "x", "", "!is.na(m)", "", string3 + "[m[!is.na(m)]]"));
        scriptBuilder.unindent().append("})");
        return scriptBuilder.toString();
    }

    private String grepReplace(String string) {
        ScriptBuilder scriptBuilder = RReplaceNames.scriptBuilder();
        scriptBuilder.appendLn("local({").indent();
        String string2 = RUtility.combineCharacters(this.getValue(REPLACEMENT_TABLE).getValues(TABLE_TARGET));
        String string3 = RUtility.combineCharacters(this.getValue(REPLACEMENT_TABLE).getValues(TABLE_REPLACEMENT));
        String string4 = "gsub";
        if (!this.getValue(ALL_MATCH).booleanValue()) {
            string4 = "sub";
        }
        Object object = "target[i]";
        if (this.getValue(TYPE).equals(TYPE_SUBSTRING)) {
            object = "sprintf(\"\\\\Q%s\\\\E\", " + (String)object + ")";
        }
        scriptBuilder.appendLn("x <- " + string);
        scriptBuilder.appendLn("target <- " + string2);
        scriptBuilder.appendLn("replacement <- " + string3);
        scriptBuilder.appendLn("for (i in seq_along(target)) {").indent();
        scriptBuilder.appendLn(RUtility.assignFunction("x", string4, this.getArgs(ARGS), new String[]{"pattern", object, "replacement", "replacement[i]", "x", "x", "ignore.case", RUtility.toRBoolean(this.getValue(CASE_SENSITIVE) == false)}));
        scriptBuilder.unind_Ln("}");
        scriptBuilder.appendLn("x");
        scriptBuilder.unindent().append("})");
        return scriptBuilder.toString();
    }
}

