/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RAnonymousFunction;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import org.apache.commons.lang3.StringUtils;

public class RSampling
extends ROperation {
    public static final String TYPE_HEAD = "head";
    public static final String TYPE_RANDOM = "random";
    public static final String TYPE_RANDOM_DUPLICATE = "random_duplicate";
    private static final String SIZE_PERCENT = "percent";
    private static final String SIZE_ROW = "row";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Input").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("type", "Type").setValuesAndLabels("head", "Head", "random", "Random", "random_duplicate", "Random (with Replacement)")).setDefaultValue("random")).build();
    @Deprecated
    private static final RStrKey NROW = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("nrow", "Number of Rows").setDefaultValue("100")).setPreviewFunction(ROW_NUMBER_PREVIEW)).setObsolete(true)).setNoSave(true)).build();
    private static final RStrKey SIZE = ((RStrKey.Builder)RStrKey.builder("size", "Size").setDefaultValue("10")).build();
    private static final ChoiceKey SIZE_TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("size_type", "").setValuesAndLabels("percent", "%", "row", "Rows")).setLabelPosition("none")).setMinWidth(0)).build();
    private static final BoolKey KEEP_ORDER = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("keep_order", "Keep the Original Order").setDefaultValue(Boolean.TRUE)).addInvisibleKeyLink(TYPE, "head")).setLabelPosition("none")).build();
    private static final BoolKey REMOVE_ROW_NAMES = ((BoolKey.Builder)BoolKey.builder("remove_row_names", "Remove Row Names").setLabelPosition("none")).build();
    private static final BoolKey OUTPUT_REMAINING = ((BoolKey.Builder)BoolKey.builder("output_remaining", "Output Remaining Data").setLabelPosition("none")).build();
    private static final RStrKey OUTPUT2 = ((RStrKey.Builder)((Key.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("output2", "Output2").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).addVisibleKeyLink(OUTPUT_REMAINING, true)).build();

    @Override
    public Version getVersion() {
        return new Version(0, 2, 0, 1);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            if (StringUtils.isEmpty((CharSequence)this.getValue(OUTPUT))) {
                this.putValue(OUTPUT, this.getDynamicDefaultValue(OUTPUT));
            } else {
                this.putValue(OUTPUT.getAutoValueLinkKey(), Boolean.FALSE);
            }
        }
        if (version.isOlderThan("0.2")) {
            this.putValue(SIZE, this.getValue(NROW));
            this.putValue(SIZE_TYPE, SIZE_ROW);
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, OUTPUT_REMAINING, OUTPUT2, TYPE, KEEP_ORDER, NROW, SIZE, SIZE_TYPE, REMOVE_ROW_NAMES);
    }

    @Override
    public String getDefaultTitle() {
        return "Sampling";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    @Override
    public Object getDynamicDefaultValue(Key<?> key) {
        if (key == OUTPUT) {
            return this.getValue(DATA) + ".sample";
        }
        return super.getDynamicDefaultValue(key);
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return RSampling.suffix(this.getValue(DATA), ".sample");
        }
        if (OUTPUT2.equals(key)) {
            return RSampling.suffix(this.getValue(DATA), ".sample.2");
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        Object object = this.getValue(SIZE_TYPE).equals(SIZE_PERCENT) ? (this.getValue(TYPE) == TYPE_HEAD || !this.getValue(OUTPUT_REMAINING).booleanValue() ? "nrow(" + this.getValue(DATA) + ") / 100 * " + this.getValue(SIZE) : "nrow(x) / 100 * " + this.getValue(SIZE)) : this.getValue(SIZE);
        ScriptBuilder scriptBuilder = RSampling.scriptBuilder();
        switch (this.getValue(TYPE)) {
            case "head": {
                String string = RUtility.assignFunction(this.getValue(OUTPUT), TYPE_HEAD, new String[]{"x", this.getValue(DATA), "n", object});
                if (!this.getValue(OUTPUT_REMAINING).booleanValue()) {
                    scriptBuilder.appendLn(string);
                    break;
                }
                String string2 = RUtility.assignFunction(this.getValue(OUTPUT2), "tail", "x", this.getValue(DATA), "n", "-" + (String)object);
                if (this.getValue(DATA).equals(this.getValue(OUTPUT))) {
                    scriptBuilder.appendLn(string2);
                    scriptBuilder.appendLn(string);
                    break;
                }
                scriptBuilder.appendLn(string);
                scriptBuilder.appendLn(string2);
                break;
            }
            case "random": 
            case "random_duplicate": {
                String string = RUtility.toRBoolean(this.getValue(TYPE).equals(TYPE_RANDOM_DUPLICATE));
                if (!this.getValue(OUTPUT_REMAINING).booleanValue()) {
                    Object object2 = RUtility.function("sample", new String[]{"x", "nrow(" + this.getValue(DATA) + ")", "size", object, "replace", string});
                    if (this.getValue(KEEP_ORDER).booleanValue()) {
                        object2 = "sort(" + (String)object2 + ")";
                    }
                    scriptBuilder.appendLn(RUtility.assign(this.getValue(OUTPUT), this.getValue(DATA) + "[" + (String)object2 + ", , drop = FALSE]"));
                    break;
                }
                String string3 = RUtility.function("sample", new String[]{"x", "nrow(x)", "size", object, "replace", string});
                RAnonymousFunction rAnonymousFunction = new RAnonymousFunction();
                rAnonymousFunction.addArgs("x", this.getValue(DATA));
                scriptBuilder.appLnInd(rAnonymousFunction.getHeadStr());
                scriptBuilder.appendLn(RUtility.assign("smpl", string3));
                String string4 = this.getValue(KEEP_ORDER) != false ? "sort(smpl)" : "smpl";
                scriptBuilder.appendLn(RUtility.function("assign", "x", RSampling.quote(this.getValue(OUTPUT)), "value", "x[" + string4 + ", , drop = FALSE]", "pos", "parent.frame()"));
                scriptBuilder.appendLn(RUtility.function("assign", "x", RSampling.quote(this.getValue(OUTPUT2)), "value", "x[-smpl, , drop = FALSE]", "pos", "parent.frame()"));
                scriptBuilder.unind_Ln(rAnonymousFunction.getTailStr());
                break;
            }
        }
        if (this.getValue(REMOVE_ROW_NAMES).booleanValue() && !this.getValue(OUTPUT).isEmpty()) {
            scriptBuilder.appendLn("row.names(" + this.getValue(OUTPUT) + ") <- NULL");
            if (this.getValue(OUTPUT_REMAINING).booleanValue()) {
                scriptBuilder.appendLn("row.names(" + this.getValue(OUTPUT2) + ") <- NULL");
            }
        }
        return scriptBuilder.toString();
    }

    @Override
    protected String[] getNewRObjects() {
        if (!this.getValue(OUTPUT_REMAINING).booleanValue()) {
            return new String[]{this.getValue(OUTPUT)};
        }
        return new String[]{this.getValue(OUTPUT), this.getValue(OUTPUT2)};
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, TYPE, new XFlowPanelWidgetNode(true).addElements(SIZE, SIZE_TYPE), OUTPUT_REMAINING, OUTPUT2).addTabWithElements("Options", KEEP_ORDER, REMOVE_ROW_NAMES);
    }
}

