/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.file.TextFile;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.base.FileEdit;
import com.ef_prime.rflow.core.base.FileEditBackups;
import com.ef_prime.rflow.core.base.FileEditEventHandler;
import com.ef_prime.rflow.core.base.FileEditSupplier;
import com.ef_prime.rflow.core.base.FileEditSupplierSupport;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.SplitPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.ui.app.r.RConsoleResultView;
import com.ef_prime.rflow.ui.app.r.RScriptFileNodeView;
import com.ef_prime.rflow.ui.common.component.Flavors;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;

public class RScriptFile
extends ROperation
implements ValueChangeEventHandler,
FileEditSupplier {
    public static final FileKey FILE = ((FileKey.Builder)FileKey.builder("file", "R Script File").setLazyUpdate(true)).build();
    public static final String AUTOEDETECT_ACTION = "auto_detect";
    public static final BoolKey AUTODETECT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("autodetect", "Auto update when file is changed").setDefaultValue(true)).setLabelPosition("none")).build();
    public static final ChoiceKey ENCODING = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("encoding", "Encoding").setValuesAndLabels(RUtility.JAVA_COMPATIBLE_ENCODINGS)).showValueAndLabel(true)).build();
    private static final BoolKey ECHO = ((BoolKey.Builder)BoolKey.builder("echo", "Output R Commands").setLabelPosition("none")).build();
    private FileEditSupplierSupport supplierSupport = new FileEditSupplierSupport(this);

    public RScriptFile() {
        this.addEventHandler(this);
    }

    @Override
    public void initialize(boolean bl) {
        super.initialize(bl);
        if (this.getValue(FILE).isEmpty()) {
            this.getDefaultEncoding().ifPresent(string -> this.putValue(ENCODING, string));
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(FILE, AUTODETECT, ENCODING, ECHO);
    }

    @Override
    public String getDefaultTitle() {
        return "R Script File";
    }

    @Override
    public String getSubtitle(Key<?> key) {
        if (key == ECHO) {
            return key.getId();
        }
        return null;
    }

    @Override
    public String getSummary() {
        String string = this.getValue(FILE);
        if (string.isEmpty()) {
            return this.getTitle();
        }
        TextFile textFile = this.getFileEdit();
        String string2 = textFile != null && textFile.isDirty() ? "*" : "";
        return string2 + FilenameUtils.getName((String)string);
    }

    @Override
    public String getOpClass() {
        return "script";
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        Object object;
        String string = this.getValue(FILE);
        if (bl2 && (object = this.getFileEdit()).isDirty()) {
            Path path = FileEditBackups.getInstance().getBackupFile((FileEdit)object);
            if (path == null) {
                return "stop(\"Couldn't create temporary file to execute. Please save file first.\")";
            }
            string = path.toString();
        }
        object = new ArgsList();
        ((ArgsList)object).add("file", RUtility.quotedPath(string));
        ((ArgsList)object).add("encoding", RScriptFile.quote(this.getValue(ENCODING)));
        ((ArgsList)object).add("echo", RUtility.toRBoolean(this.getValue(ECHO)));
        if (previewOption.isEnabled()) {
            ((ArgsList)object).add("local", "TRUE");
        }
        return RUtility.function("source", (Collection<String>)object);
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
        tabPaneWidgetNode.addTab("Main", new ViewWidgetNode(RScriptFileNodeView.class).setGrowY(true));
        tabPaneWidgetNode.addTab("Options", new PanelWidgetNode().addElements(ECHO));
        tabPaneWidgetNode.add(new ViewWidgetNode(OpRScriptView.class));
        if (!viewOptions.isWizard()) {
            return tabPaneWidgetNode;
        }
        WidgetNode widgetNode = new TabPaneWidgetNode().add(new ViewWidgetNode(RConsoleResultView.class));
        return new SplitPaneWidgetNode(true, 0.6f).add(tabPaneWidgetNode).add(widgetNode);
    }

    @Override
    public boolean canImport(Transferable transferable) {
        File file = Flavors.getFile(transferable);
        return file != null && !file.isDirectory();
    }

    @Override
    protected void importValues(Transferable transferable) {
        if (!Flavors.isFileFlavorSupported(transferable)) {
            return;
        }
        File file = Flavors.getFile(transferable);
        if (file == null || file.isDirectory()) {
            return;
        }
        if (!FilenameUtils.isExtension((String)(file = WorkingDirectory.toAbstractPath(file)).getName().toLowerCase(), (String)"r")) {
            return;
        }
        this.putValue(FILE, RUtility.path(file.getPath()));
        String string = RUtility.toREncoding(TextFile.get(file).getEncoding(), R.client().getNativeEncoding());
        if (!string.isEmpty()) {
            this.putValue(ENCODING, string);
        }
    }

    @Override
    public boolean supportsPreview() {
        return false;
    }

    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if (AUTOEDETECT_ACTION.equals(string)) {
            this.autoDetect();
        }
    }

    private void autoDetect() {
        String string = this.getValue(FILE);
        if (string.isEmpty()) {
            return;
        }
        this.autoDetect(WorkingDirectory.toAbsolutePath(new File(string)));
    }

    private void autoDetect(File file) {
        String string;
        if (!file.exists()) {
            return;
        }
        TextFile textFile = TextFile.get(file);
        String string2 = RUtility.quote(textFile.getSeparator().toString());
        if (string2.equals("\"\t\"")) {
            string2 = "\"\\t\"";
        }
        if (!textFile.isDefaultEncoding() && !(string = RUtility.toREncoding(textFile.getEncoding(), R.client().getNativeEncoding())).isEmpty()) {
            this.putValue(ENCODING, string);
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if ((valueChangeEvent.getKey() == FILE || valueChangeEvent.getKey() == AUTODETECT) && this.getValue(AUTODETECT).booleanValue()) {
            this.autoDetect();
        }
        if (valueChangeEvent.getKey() == FILE) {
            TextFile textFile = valueChangeEvent.getOldValue() == null ? null : TextFile.get(new File(valueChangeEvent.getOldValue().toString()));
            this.supplierSupport.fileEditChanged(textFile, this.getFileEdit());
        }
    }

    @Override
    public TextFile getFileEdit() {
        String string = this.getValue(FILE);
        return string.isEmpty() ? null : TextFile.get(new File(string));
    }

    @Override
    public void load(Object object) {
        this.supplierSupport.load(object);
    }

    @Override
    public void unload(Object object) {
        this.supplierSupport.unload(object);
    }

    @Override
    public void addFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.supplierSupport.addFileEditEventHandler(fileEditEventHandler);
    }

    @Override
    public void removeFileEditEventHandler(FileEditEventHandler fileEditEventHandler) {
        this.supplierSupport.removeFileEditEventHandler(fileEditEventHandler);
    }
}

