/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.awt.datatransfer.Transferable;
import java.util.List;

public class RSelectColumns
extends ROperation {
    private static final String TYPE_INCLUDE = "Include";
    private static final String TYPE_EXCLUDE = "Exclude";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Input").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    public static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)RadioButtonKey.builder("type", "Type").setValuesAndLabels("Include", "Include", "Exclude", "Exclude")).build();
    private static final ChoiceKey COLS_COLUMN = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("cols_column", "Column").setChoiceProvider(RChoiceProvider.columns(DATA, false))).setChoiceEditable(true)).setRequired(true)).build();
    private static final RTableKey COLUMNS = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("columns", "Column Selection", COLS_COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT)).setDefaultRowPredicate()).setWidth(500)).build();
    private static final BoolKey REFLECT_ORDER = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("reflect_order", "Reflect the order").setLabelPosition("none")).addVisibleKeyLink(TYPE, "Include")).build();

    @Override
    public Version getVersion() {
        return new Version(0, 2, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, TYPE, COLUMNS, REFLECT_ORDER);
    }

    @Override
    public String getDefaultTitle() {
        return "Select Columns";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return this.getValue(DATA);
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string = this.getValue(DATA);
        List<String> list = this.getValue(COLUMNS).getValidValues(COLS_COLUMN);
        if (list.isEmpty()) {
            return RUtility.assign(this.getValue(OUTPUT), string);
        }
        boolean bl3 = this.getValue(TYPE).equals(TYPE_INCLUDE);
        boolean bl4 = bl3 && this.getValue(REFLECT_ORDER) != false;
        Object object = RUtility.combineCharacters(list);
        if (!bl4) {
            object = "names(" + string + ") %in% " + (String)object;
        }
        if (!bl3) {
            object = "!(" + (String)object + ")";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "[, ");
        stringBuilder.append((String)object);
        if (!bl4 || list.size() == 1) {
            stringBuilder.append(", drop = FALSE");
        }
        stringBuilder.append("]");
        return RUtility.assign(this.getValue(OUTPUT), stringBuilder.toString());
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        this.importDataOrColumns(transferable, DATA, COLUMNS, 0, false);
    }

    @Override
    protected int getSplitHeight() {
        return 325;
    }
}

