/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.RFormRowSelector;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.RSimpleRowSelector;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ComponentTableKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.util.List;

public class RSelectRows2
extends ROperation {
    private static final String TYPE_INCLUDE = "include";
    private static final String TYPE_EXCLUDE = "exclude";
    private static final String LOGICAL_AND = "AND";
    private static final String LOGICAL_OR = "OR";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Input").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    private static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("type", "Type").setValues("include", "exclude")).setLabels("Include", "Exclude")).build();
    private static final RadioButtonKey LOGICAL = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("logical", "And/Or").setValues("AND", "OR")).setLabels("And", "Or")).build();
    private static final ValueMapKey CONDITION_TYPES = ((ValueMapKey.Builder)((ValueMapKey.Builder)((Object)ValueMapKey.builder("types", "Types", new RFormRowSelector()).addClass("form", RFormRowSelector.class))).addClass("simple", RSimpleRowSelector.class)).build();
    private static final ComponentTableKey CONDITIONS = ComponentTableKey.builder("conditions", "Conditions", CONDITION_TYPES).build();
    private static final RTableKey ADVANCED = RSelectRows2.argsKey("base:::subset.data.frame", "subset", new String[0]);

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, TYPE, LOGICAL, CONDITIONS, ADVANCED);
    }

    @Override
    public String getDefaultTitle() {
        return "Select Rows";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return this.getValue(DATA);
        }
        return super.getAutoValue(key);
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return DATA;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, TYPE, LOGICAL, CONDITIONS).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        ListModel<ValueMap> listModel = this.getValue(CONDITIONS);
        List<ValueMap> list = CONDITIONS.validElements(listModel);
        if (list.isEmpty()) {
            return this.getValue(OUTPUT) + " <- " + this.getValue(DATA);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getValue(OUTPUT) + " <- subset(x = " + this.getValue(DATA) + ", subset = ");
        stringBuilder.append(this.getExpression(list));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private String getExpression(List<ValueMap> list) {
        boolean bl = this.getValue(TYPE).equals(TYPE_EXCLUDE);
        boolean bl2 = this.getValue(LOGICAL).equals(LOGICAL_OR);
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("!(");
        }
        for (int i = 0; i < list.size(); ++i) {
            ValueMap valueMap = list.get(i);
            if (n > 1) {
                stringBuilder.append("(");
            }
            if (valueMap instanceof RFormRowSelector) {
                stringBuilder.append(((RFormRowSelector)valueMap).getExpression());
            } else if (valueMap instanceof RSimpleRowSelector) {
                stringBuilder.append(((RSimpleRowSelector)valueMap).getExpression());
            }
            if (n > 1) {
                stringBuilder.append(")");
            }
            if (i == list.size() - 1) continue;
            stringBuilder.append(bl2 ? " | " : " & ");
        }
        if (bl) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

