/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ButtonWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.awt.datatransfer.Transferable;
import java.util.List;

public class RSetColumnTypes
extends ROperation {
    private static final String TYPE_DO_NOTHING = "";
    private static final String TYPE_INTEGER = "integer";
    private static final String TYPE_NUMERIC = "numeric";
    private static final String TYPE_LOGICAL = "logical";
    private static final String TYPE_CHARACTER = "character";
    private static final String TYPE_FACTOR = "factor";
    private static final String TYPE_DATE = "Date";
    private static final String TYPE_POSIX_CT = "POSIXct";
    private static final String TYPE_COMPLEX = "complex";
    private static final String TYPE_RAW = "raw";
    public static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Input").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    private static final RChoiceKey TABLE_COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("column_name", "Column Name").setChoiceProvider(RChoiceProvider.columns(DATA, true))).build();
    private static final ChoiceKey TABLE_TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("type", "Class").setValuesAndLabels("", "No Conversion", "logical", "Logical", "integer", "Integer", "numeric", "Numeric", "character", "Character", "factor", "Category", "Date", "Date", "POSIXct", "Date and Time", "complex", "Complex", "raw", "Bytes")).showValueAndLabel(true)).build();
    private static final RTableKey TABLE = ((RTableKey.Builder)RTableKey.builder("table", "Table", TABLE_COLUMN, TABLE_TYPE).setUiControls(GeneralTableModel.UI_DEFAULT2)).build();

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, TABLE);
    }

    @Override
    protected String getDefaultTitle() {
        return "Set Data Type";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return this.getValue(DATA);
        }
        return super.getAutoValue(key);
    }

    @Override
    protected StrKey getOutputKey() {
        return OUTPUT;
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        this.importDataOrColumns(transferable, DATA, TABLE, 0, true);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string = this.getValue(DATA);
        String string2 = this.getValue(OUTPUT);
        ScriptBuilder scriptBuilder = RSetColumnTypes.scriptBuilder();
        scriptBuilder.appendLn("{").indent();
        for (KeysTableRow keysTableRow : this.getValue(TABLE)) {
            String string3 = keysTableRow.getValue(TABLE_COLUMN);
            String string4 = this.typeToFunction(keysTableRow.getValue(TABLE_TYPE));
            if (string4.isEmpty()) continue;
            scriptBuilder.appendLn(RUtility.assignFunction(string3, string4, TYPE_DO_NOTHING, string3));
        }
        scriptBuilder.unindent().append("}");
        return RUtility.assignFunction(string2, "within", TYPE_DO_NOTHING, string, TYPE_DO_NOTHING, scriptBuilder.toString());
    }

    private String typeToFunction(String string) {
        switch (string) {
            case "": {
                return TYPE_DO_NOTHING;
            }
            case "integer": {
                return "as.integer";
            }
            case "numeric": {
                return "as.numeric";
            }
            case "logical": {
                return "as.logical";
            }
            case "character": {
                return "as.character";
            }
            case "factor": {
                return "as.factor";
            }
            case "Date": {
                return "as.Date";
            }
            case "POSIXct": {
                return "as.POSIXct";
            }
            case "complex": {
                return "as.complex";
            }
            case "raw": {
                return "as.raw";
            }
        }
        return TYPE_DO_NOTHING;
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        ButtonWidgetNode buttonWidgetNode = new ButtonWidgetNode("Detect Current Settings", "autodetect");
        return new PanelWidgetNode().addElements(DATA, OUTPUT, buttonWidgetNode, TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction(WidgetNode widgetNode, String string) {
        if ("autodetect".equals(string)) {
            String string2 = this.getValue(DATA);
            if (string2.isEmpty()) {
                return;
            }
            RObject rObject = RObject.builder(string2).setType("list").setClasses("data.frame").build();
            RObjectSet rObjectSet = R.client().getObjects(rObject, true, 0);
            if (rObjectSet == null) {
                return;
            }
            List<RObject> list = rObjectSet.getObjects();
            KeysTableModel keysTableModel = this.getValue(TABLE);
            keysTableModel.beginValueChange();
            try {
                keysTableModel.removeAllRows();
                String[] stringArray = new String[]{TYPE_DATE, TYPE_DATE, TYPE_POSIX_CT, TYPE_POSIX_CT, TYPE_FACTOR, TYPE_FACTOR, TYPE_INTEGER, TYPE_INTEGER, TYPE_NUMERIC, TYPE_NUMERIC, TYPE_COMPLEX, TYPE_COMPLEX, TYPE_LOGICAL, TYPE_LOGICAL, TYPE_CHARACTER, TYPE_CHARACTER, TYPE_RAW, TYPE_RAW};
                for (RObject rObject2 : list) {
                    String string3 = rObject2.getName(true);
                    String string4 = TYPE_DO_NOTHING;
                    for (int i = 0; i < stringArray.length; i += 2) {
                        if (!rObject2.inherits(stringArray[i])) continue;
                        string4 = stringArray[i + 1];
                        break;
                    }
                    keysTableModel.addNewRow(string3, string4);
                }
            }
            finally {
                keysTableModel.endValueChange();
            }
        }
    }
}

