/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.node.ui.OpRScriptView;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RSortPreviewView;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RSort
extends ROperation {
    public static final String ORDER_ASCENDING = "ASC";
    public static final String ORDER_DESCENDING = "DESC";
    public static final RChoiceKey DATA = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Input").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    public static final RChoiceKey COL_COLUMN = ((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("column", "Column").setCompletionSupport(RChoiceProvider.columns(DATA, true))).setRequired(true)).build();
    public static final ChoiceKey COL_ORDER = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("order", "Order").setValues("ASC", "DESC")).setLabels("Ascending", "Descending")).setDefaultValue("ASC")).showValueAndLabel(true)).build();
    public static final RTableKey COLUMN = ((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("column", "Sort By", COL_COLUMN, COL_ORDER).setUiControls(GeneralTableModel.UI_DEFAULT)).setRowPredicate(RSort::isRowValid)).build();

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, COLUMN);
    }

    @Override
    public String getDefaultTitle() {
        return "Sort";
    }

    @Override
    public String getOpClass() {
        return "transform";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return this.getValue(DATA);
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        String string = this.getValue(DATA);
        String string2 = RSort.data(string, previewOption);
        KeysTableModel keysTableModel = this.getValue(COLUMN);
        List<KeysTableRow> list = keysTableModel.validRows(RSort::isRowValid);
        if (list.isEmpty()) {
            return RUtility.assign(this.getValue(OUTPUT), string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "[with(" + string2 + ", order(");
        boolean bl3 = true;
        for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
            String string3 = (String)keysTableModel.getValueAt(i, 1);
            boolean bl4 = string3.equals(ORDER_DESCENDING);
            if (bl4) continue;
            bl3 = false;
            break;
        }
        ArgsList argsList = new ArgsList();
        for (KeysTableRow keysTableRow : list) {
            String string4 = keysTableRow.getValue(COL_COLUMN);
            String string5 = keysTableRow.getValue(COL_ORDER);
            boolean bl5 = string5.equals(ORDER_DESCENDING);
            if (bl3 || !bl5) {
                argsList.add(string4);
                continue;
            }
            argsList.add("-xtfrm(" + string4 + ")");
        }
        if (bl3) {
            argsList.add("decreasing = TRUE");
        }
        stringBuilder.append(StringUtils.join((Iterable)argsList, (String)", "));
        stringBuilder.append(")), ]");
        return RUtility.assign(this.getValue(OUTPUT), stringBuilder.toString());
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        this.importDataOrColumns(transferable, DATA, COLUMN, 0, true);
    }

    @Override
    public WidgetNode getWidgetNode(ViewOptions viewOptions) {
        WidgetNode widgetNode = this.getContentWidgetNode(viewOptions);
        if (viewOptions.isWizard()) {
            TabPaneWidgetNode tabPaneWidgetNode = new TabPaneWidgetNode();
            tabPaneWidgetNode.addTab("Main", widgetNode);
            WidgetNode widgetNode2 = new TabPaneWidgetNode().add(new ViewWidgetNode(RSortPreviewView.class)).add(new ViewWidgetNode(OpRScriptView.class));
            return this.createSplitPaneWidgetNode().add(tabPaneWidgetNode).add(widgetNode2);
        }
        return super.getWidgetNode(viewOptions);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            if (StringUtils.isEmpty((CharSequence)this.getValue(OUTPUT))) {
                this.putValue(OUTPUT, this.getValue(DATA));
            } else {
                this.putValue(OUTPUT.getAutoValueLinkKey(), Boolean.FALSE);
            }
        }
    }

    private static boolean isRowValid(KeysTableRow keysTableRow) {
        return !keysTableRow.getValue(COL_COLUMN).isEmpty();
    }
}

