/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.RFormRowSelector;
import com.ef_prime.rflow.core.app.r.RSimpleRowSelector;
import com.ef_prime.rflow.core.common.keyvalue.ComponentTableKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.node.ui.UIInterfaceInitializer;
import java.util.List;

public interface RSubsetInterface {
    public static final String TYPE_INCLUDE = "include";
    public static final String TYPE_EXCLUDE = "exclude";
    public static final String LOGICAL_AND = "AND";
    public static final String LOGICAL_OR = "OR";
    public static final RadioButtonKey SUBSET_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("subset_type", "Type").setValues("include", "exclude")).setLabels("Include", "Exclude")).build();
    public static final RadioButtonKey SUBSET_LOGICAL = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("subset_logical", "And/Or").setValues("AND", "OR")).setLabels("And", "Or")).build();
    public static final ValueMapKey CONDITION_TYPES = ((ValueMapKey.Builder)((Key.Builder)((ValueMapKey.Builder)((Object)ValueMapKey.builder("types", "Types", new RFormRowSelector()).addClass("form", RFormRowSelector.class))).addClass("simple", RSimpleRowSelector.class)).setNoRegister(true)).build();
    public static final ComponentTableKey SUBSET_CONDITIONS = ((ComponentTableKey.Builder)((ComponentTableKey.Builder)ComponentTableKey.builder("subset_conditions", "Conditions", CONDITION_TYPES).setHeight(100)).setGrowY(false)).build();
    public static final UIInterfaceInitializer init = new UIInterfaceInitializer(RSubsetInterface.class);

    default public Key<?>[] getSubsetKeys() {
        return new Key[]{SUBSET_TYPE, SUBSET_LOGICAL, SUBSET_CONDITIONS};
    }

    default public String getSubset(ValueMap valueMap) {
        ListModel<ValueMap> listModel = valueMap.getValue(SUBSET_CONDITIONS);
        List<ValueMap> list = SUBSET_CONDITIONS.validElements(listModel);
        if (list.isEmpty()) {
            return "";
        }
        boolean bl = valueMap.getValue(SUBSET_TYPE).equals(TYPE_EXCLUDE);
        boolean bl2 = valueMap.getValue(SUBSET_LOGICAL).equals(LOGICAL_OR);
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("!(");
        }
        for (int i = 0; i < list.size(); ++i) {
            ValueMap valueMap2 = list.get(i);
            if (n > 1) {
                stringBuilder.append("(");
            }
            if (valueMap2 instanceof RFormRowSelector) {
                stringBuilder.append(((RFormRowSelector)valueMap2).getExpression());
            } else if (valueMap2 instanceof RSimpleRowSelector) {
                stringBuilder.append(((RSimpleRowSelector)valueMap2).getExpression());
            }
            if (n > 1) {
                stringBuilder.append(")");
            }
            if (i == list.size() - 1) continue;
            stringBuilder.append(bl2 ? " | " : " & ");
        }
        if (bl) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

