/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RArgsKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.common.keyvalue.AutoValueLink;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.BoolKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.MultipleKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.SeparatorWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKeyTest;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.XFlowPanelWidgetNode;
import com.ef_prime.rflow.core.util.ArgsList;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class RTWilcoxTest
extends ROperation {
    private static final String MULTI_TYPE_TWO = "two";
    private static final String MULTI_TYPE_GROUP = "group";
    private static final String METHOD_T = "t";
    private static final String METHOD_WILCOX = "wilcox";
    private static final String ALTERNATIVE_TWO_SIDEED = "two_sided";
    private static final String ALTERNATIVE_LESS = "less";
    private static final String ALTERNATIVE_GREATER = "greater";
    private static final String EXACT_AUTO = "auto";
    private static final String EXACT_ON = "on";
    private static final String EXACT_OFF = "off";
    private static final String MC_TYPE_FWER = "fwer";
    private static final String MC_TYPE_FDR = "fdr";
    private static final String MC_TYPE_NO_CORRECTION = "no_correction";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("data", "Data").setChoiceProvider(RChoiceProvider.globalDataFrames())).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((Key.Builder)RStrKey.builder("_output", "Output").setOutput(true)).setRequired(true)).setDefaultValue("test.result")).build();
    private static final RChoiceKey X = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("x", "X").setChoiceProvider(RChoiceProvider.names(DATA.getId(), true, "is.numeric"))).setRequired(true)).build();
    private static final BoolKey MULTI_SAMPLE = ((BoolKey.Builder)BoolKey.builder("multi_sample", "2-Sample Test / Multiple comparison").setLabelPosition("none")).build();
    private static final RadioButtonKey MULTI_TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("multi_type", "Type").setLabelPosition("none")).setValuesAndLabels("two", "Compare with another variable", "group", "Specify groups")).addVisibleKeyLink(MULTI_SAMPLE, true)).build();
    private static final RChoiceKey Y = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("y", "Y").setChoiceProvider(RChoiceProvider.names(DATA.getId(), true, "is.numeric"))).setRequired(true)).addVisibleKeyLink(MULTI_TYPE, "two")).build();
    private static final RChoiceKey GROUP = ((RChoiceKey.Builder)((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("group", "Group").setChoiceProvider(RChoiceProvider.columns(DATA, true))).setRequired(true)).addVisibleKeyLink(MULTI_TYPE, "group")).build();
    private static final BoolKey MULTIPLE_COMPARISONS = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("multiple_comparisons", "Multiple Comparisons").setLabelPosition("none")).addVisibleKeyLink(MULTI_TYPE, "group")).build();
    private static final RadioButtonKey METHOD = ((RadioButtonKey.Builder)RadioButtonKey.builder("method", "Method").setValuesAndLabels("t", "t-Test", "wilcox", "Wilcoxon Test")).build();
    private static final StrKey NULL_HYPOTHESIS_LABEL = ((StrKey.Builder)StrKey.builder("label_null_hyp", "Null Hypothesis").label()).build();
    private static final StrKey ALT_HYPOTHESIS_LABEL = ((StrKey.Builder)StrKey.builder("label_alt_hyp", "Alternative Hypothesis").label()).build();
    private static final StrKey LEFT_MU_LABEL = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("mu_label", "mu").label()).disabled()).setDefaultValue("mu")).setLabelPosition("none")).setAutoValueLink(true, MULTI_SAMPLE, MULTI_TYPE, MULTIPLE_COMPARISONS)).build();
    private static final ChoiceKey NULL_HYPOTHESIS = ((ChoiceKey.Builder)((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("null_hyp", "mu").setValuesAndLabels("two_sided", "=", "less", ">=", "greater", "<=")).setMinWidth(0)).setLabelPosition("none")).build();
    private static final StrKey ALT_HYPOTHESIS = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("alt_hyp", "mu").label()).disabled()).setAutoValueLink(true, NULL_HYPOTHESIS)).setLabelPosition("none")).build();
    private static final RStrKey MU = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("mu", "Mu").setLabelPosition("none")).setDefaultValue("0")).addKeyLink(KeyLink.invisible(MultipleKeyTest.and(StrKeyTest.create(METHOD, "t"), BoolKeyTest.create(MULTIPLE_COMPARISONS, true))))).build();
    private static final StrKey ALT_MU = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("alt_mu", "mu").label()).disabled()).setLabelPosition("none")).setAutoValueLink(true, MU)).addKeyLinks(MU.getKeyLinks())).build();
    private static final StrKey RIGHT_MU_LABEL = ((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((StrKey.Builder)((Key.Builder)StrKey.builder("alt_mu_label", "mu").label()).disabled()).setDefaultValue("mu_j")).setLabelPosition("none")).addKeyLink(KeyLink.visible(MultipleKeyTest.and(StrKeyTest.create(METHOD, "t"), BoolKeyTest.create(MULTIPLE_COMPARISONS, true))))).build();
    private static final BoolKey PAIRED = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("paired", "Paired Test").setLabelPosition("none")).addVisibleKeyLink(MULTI_SAMPLE, true)).addEnabledKeyLink(MULTI_TYPE, "two")).build();
    private static final RStrKey CONF_LEVEL = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("conf.level", "Confidence Level").setDefaultValue("0.95")).setDescriptionLink(RTWilcoxTest::getDescription)).addVisibleKeyLink(METHOD, "t")).addKeyLink(KeyLink.visible(MultipleKeyTest.and(StrKeyTest.create(METHOD, "t"), BoolKeyTest.create(MULTIPLE_COMPARISONS, false))))).build();
    private static final BoolKey VAR_EQUAL = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("var.equal", "Assumption of Equal Variance").setLabelPosition("none")).addKeyLink(KeyLink.visible(MultipleKeyTest.and(StrKeyTest.create(METHOD, "t"), BoolKeyTest.create(PAIRED, false))))).build();
    private static final BoolKey CONF_INT = ((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("conf.int", "Compute Confidence Interaval").setLabelPosition("none")).addKeyLink(KeyLink.visible(MultipleKeyTest.and(StrKeyTest.create(METHOD, "wilcox"), BoolKeyTest.create(MULTIPLE_COMPARISONS, false))))).build();
    private static final RStrKey CONF_LEVEL2 = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("conf.level2", "Confidence Level").setDefaultValue("0.95")).setDescriptionLink(RTWilcoxTest::getDescription)).addVisibleKeyLink(CONF_INT, true)).build();
    private static final RadioButtonKey EXACT = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("exact", "p-Value").setValuesAndLabels("auto", "Auto", "on", "Exact", "off", "Approximation")).addVisibleKeyLink(METHOD, "wilcox")).build();
    private static final BoolKey CORRECT = ((BoolKey.Builder)((BoolKey.Builder)((BoolKey.Builder)BoolKey.builder("correct", "Continuity Correction").setLabelPosition("none")).setDefaultValue(Boolean.TRUE)).addVisibleKeyLink(EXACT, "auto", "off")).build();
    private static final ChoiceKey MC_TYPE = ((ChoiceKey.Builder)((Key.Builder)ChoiceKey.builder("mc_type", "Type").setValuesAndLabels("fwer", "Family-Wise Error Rate / FWER", "fdr", "False Discovery Rate / FDR", "no_correction", "No Correction")).addVisibleKeyLink(MULTIPLE_COMPARISONS, true)).build();
    private static final ChoiceKey FWER_METHOD = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("fwer_method", "Method").setValuesAndLabels(RTWilcoxTest.sQuote("holm"), "Holm", RTWilcoxTest.sQuote("hochberg"), "Hochberg", RTWilcoxTest.sQuote("hommel"), "Hommel", RTWilcoxTest.sQuote("bonferroni"), "Bonferroni")).showValueAndLabel(true)).addVisibleKeyLink(MC_TYPE, "fwer")).build();
    private static final ChoiceKey FDR_METHOD = ((ChoiceKey.Builder)((Key.Builder)((ChoiceKey.Builder)ChoiceKey.builder("fdr_method", "Method").setValuesAndLabels(RTWilcoxTest.sQuote("BH"), "Benjamini & Hochberg", RTWilcoxTest.sQuote("BY"), "Benjamini & Yekutieli")).showValueAndLabel(true)).addVisibleKeyLink(MC_TYPE, "fdr")).build();
    private static final ChoiceKey ARGS_SWITCH = RTWilcoxTest.argsSwitchKey("args_switch", new AutoValueLink(true, METHOD, MULTI_SAMPLE, MULTIPLE_COMPARISONS), "t.test", "wilcox.test", "pairwise.t.test", "pairwise.wilcox.test");
    private static final RArgsKey ARGS_T = RTWilcoxTest.argsKey("args_t_test", "t.test", null, ARGS_SWITCH, new String[0]);
    private static final RArgsKey ARGS_WILCOX = RTWilcoxTest.argsKey("args_wilcox_test", "wilcox.test", null, ARGS_SWITCH, new String[0]);
    private static final RArgsKey ARGS_PAIRWISE_T = RTWilcoxTest.argsKey("args_pairwise_t_test", "pairwise.t.test", null, ARGS_SWITCH, "p.adjust.method");
    private static final RArgsKey ARGS_PAIRWISE_WILCOX = RTWilcoxTest.argsKey("args_pairwise_wilcox_test", "pairwise.wilcox.test", null, ARGS_SWITCH, "p.adjust.method");

    public static String getDescription(Key<?> key, Object object, ValueMap valueMap) {
        if (object.toString().isEmpty()) {
            return null;
        }
        return RClient.rexpToString(R.client().silentEvalGet("sprintf(\"(%s%%)\", " + String.valueOf(object) + " * 100)"), null);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, X, MULTI_SAMPLE, MULTI_TYPE, Y, GROUP, MULTIPLE_COMPARISONS, METHOD, NULL_HYPOTHESIS_LABEL, ALT_HYPOTHESIS_LABEL, LEFT_MU_LABEL, RIGHT_MU_LABEL, NULL_HYPOTHESIS, ALT_HYPOTHESIS, MU, ALT_MU, PAIRED, CONF_LEVEL, VAR_EQUAL, CONF_INT, CONF_LEVEL2, EXACT, CORRECT, MC_TYPE, FWER_METHOD, FDR_METHOD, ARGS_SWITCH, ARGS_T, ARGS_WILCOX, ARGS_PAIRWISE_T, ARGS_PAIRWISE_WILCOX);
    }

    @Override
    public void initValueMap() {
        super.initValueMap();
        this.putAutoValueQuietly(ALT_HYPOTHESIS);
        this.putAutoValueQuietly(ARGS_SWITCH);
        this.putAutoValueQuietly(ALT_MU);
        this.putAutoValueQuietly(LEFT_MU_LABEL);
        this.putAutoValueQuietly(RIGHT_MU_LABEL);
    }

    @Override
    protected String getDefaultTitle() {
        return "t-Test / Wilcoxon Test";
    }

    @Override
    public String getOpClass() {
        return "summary";
    }

    @Override
    public boolean canImport(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.isEmpty() || list.size() > 2) {
            return false;
        }
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        RObject rObject = list.get(0);
        RObject rObject2 = rObject.getParent();
        if (rObject2 == null || rObject.inherits("data.frame")) {
            this.putValue(DATA, rObject.getFullName(false));
        } else {
            this.putValue(DATA, rObject2.getFullName(false));
            this.putValue(X, rObject.getName(true));
            if (list.size() > 1) {
                this.putValue(Y, list.get(1).getName(true));
                this.putValue(MULTI_SAMPLE, Boolean.TRUE);
            }
        }
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (ALT_HYPOTHESIS.equals(key)) {
            return this.nullToAlt(this.getValue(NULL_HYPOTHESIS));
        }
        if (ARGS_SWITCH.equals(key)) {
            boolean bl;
            boolean bl2 = bl = this.isEnabled(MULTIPLE_COMPARISONS) && this.getValue(MULTIPLE_COMPARISONS) != false;
            if (this.getValue(METHOD).equals(METHOD_T)) {
                return bl ? ARGS_PAIRWISE_T.getFunction() : ARGS_T.getFunction();
            }
            return bl ? ARGS_PAIRWISE_WILCOX.getFunction() : ARGS_WILCOX.getFunction();
        }
        if (ALT_MU.equals(key)) {
            return this.getValue(MU);
        }
        if (LEFT_MU_LABEL.equals(key)) {
            boolean bl = this.isEnabled(MULTIPLE_COMPARISONS) && this.getValue(MULTIPLE_COMPARISONS) != false;
            return bl ? "mu_i" : "mu";
        }
        return super.getAutoValue(key);
    }

    private String nullToAlt(String string) {
        switch (string) {
            case "less": {
                return " <      ";
            }
            case "greater": {
                return " >      ";
            }
        }
        return " !=     ";
    }

    private String getAlternative() {
        switch (this.getValue(NULL_HYPOTHESIS)) {
            case "two_sided": {
                return RTWilcoxTest.quote("two.sided");
            }
            case "less": {
                return RTWilcoxTest.quote(ALTERNATIVE_LESS);
            }
            case "greater": {
                return RTWilcoxTest.quote(ALTERNATIVE_GREATER);
            }
        }
        throw new RuntimeException("Unknown alternative");
    }

    private String getExact() {
        switch (this.getValue(EXACT)) {
            case "on": {
                return "TRUE";
            }
            case "off": {
                return "FALSE";
            }
        }
        return "";
    }

    private String getPAdjustMethod() {
        switch (this.getValue(MC_TYPE)) {
            case "fwer": {
                return this.getValue(FWER_METHOD);
            }
            case "fdr": {
                return this.getValue(FDR_METHOD);
            }
        }
        return RTWilcoxTest.sQuote("none");
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        boolean bl3;
        boolean bl4;
        ArgsList argsList = new ArgsList();
        boolean bl5 = bl4 = !this.getValue(DATA).isEmpty();
        if (!this.getValue(MULTI_SAMPLE).booleanValue()) {
            argsList.add("x", this.getValue(X));
        } else {
            switch (this.getValue(MULTI_TYPE)) {
                case "two": {
                    argsList.add("x", this.getValue(X));
                    argsList.add("y", this.getValue(Y));
                    break;
                }
                default: {
                    if (!this.getValue(MULTIPLE_COMPARISONS).booleanValue()) {
                        argsList.add("formula", this.getValue(X) + " ~ " + this.getValue(GROUP));
                        argsList.add("data", this.getValue(DATA));
                        bl4 = false;
                        break;
                    }
                    argsList.add("x", this.getValue(X));
                    argsList.add("g", this.getValue(GROUP));
                }
            }
        }
        boolean bl6 = bl3 = this.isEnabled(MULTIPLE_COMPARISONS) && this.getValue(MULTIPLE_COMPARISONS) != false;
        if (bl3) {
            argsList.add("p.adjust.method", this.getPAdjustMethod());
        }
        argsList.add("alternative", this.getAlternative());
        if (this.isEnabled(MU)) {
            argsList.add("mu", this.getValue(MU));
        }
        if (this.isEnabled(PAIRED)) {
            argsList.add("paired", RUtility.toRBoolean(this.getValue(PAIRED)));
        }
        if (this.isEnabled(VAR_EQUAL)) {
            argsList.add(!bl3 ? "var.equal" : "pool.sd", RUtility.toRBoolean(this.getValue(VAR_EQUAL)));
        }
        if (this.isEnabled(CONF_LEVEL)) {
            argsList.add("conf.level", this.getValue(CONF_LEVEL));
        }
        if (this.isEnabled(EXACT)) {
            argsList.add("exact", this.getExact());
        }
        if (this.isEnabled(CORRECT)) {
            argsList.add("correct", RUtility.toRBoolean(this.getValue(CORRECT)));
        }
        if (this.isEnabled(CONF_INT)) {
            argsList.add("conf.int", RUtility.toRBoolean(this.getValue(CONF_INT)));
        }
        if (this.isEnabled(CONF_LEVEL2)) {
            argsList.add("conf.level", this.getValue(CONF_LEVEL2));
        }
        String string = null;
        RArgsKey rArgsKey = null;
        switch (this.getValue(METHOD)) {
            case "t": {
                string = bl3 ? "pairwise.t.test" : "t.test";
                rArgsKey = bl3 ? ARGS_PAIRWISE_T : ARGS_T;
                break;
            }
            default: {
                string = bl3 ? "pairwise.wilcox.test" : "wilcox.test";
                rArgsKey = bl3 ? ARGS_PAIRWISE_WILCOX : ARGS_WILCOX;
            }
        }
        argsList.addAll(this.getArgs(rArgsKey));
        Object object = RUtility.function(string, argsList);
        if (bl4) {
            object = "with(" + this.getValue(DATA) + ", " + (String)object + ")";
        }
        return RUtility.assign(this.getValue(OUTPUT), (String)object);
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, X, MULTI_SAMPLE, PanelWidgetNode.indent().addKeyLinks(MULTI_TYPE.getKeyLinks()).addElements(MULTI_TYPE, Y, GROUP, MULTIPLE_COMPARISONS), METHOD).addTabWithElements("Options", new XFlowPanelWidgetNode(true).addElements(NULL_HYPOTHESIS_LABEL, LEFT_MU_LABEL, NULL_HYPOTHESIS, MU, RIGHT_MU_LABEL), new XFlowPanelWidgetNode(true).addElements(ALT_HYPOTHESIS_LABEL, LEFT_MU_LABEL, ALT_HYPOTHESIS, ALT_MU, RIGHT_MU_LABEL), PAIRED, CONF_LEVEL, VAR_EQUAL, CONF_INT, CONF_LEVEL2, EXACT, PanelWidgetNode.indent().addKeys(CORRECT), new SeparatorWidgetNode(MULTIPLE_COMPARISONS.getTitle()).addKeyLinks(MC_TYPE.getKeyLinks()), MC_TYPE, FWER_METHOD, FDR_METHOD).addTabWithElements("Advanced", ARGS_SWITCH, ARGS_T, ARGS_WILCOX, ARGS_PAIRWISE_T, ARGS_PAIRWISE_WILCOX);
    }
}

