/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RFileKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.object.RObjectFlavor;
import com.ef_prime.rflow.ui.common.item.ItemName;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RWriteObject
extends ROperation {
    private static final String RDS = "rds";
    private static final String RDATA = "RData";
    private static final RadioButtonKey TYPE = ((RadioButtonKey.Builder)((RadioButtonKey.Builder)RadioButtonKey.builder("type", "File Format").setValues("rds", "RData")).setLabels("Single Object (.rds)", "Multiple Objects (.RData)")).build();
    private static final RChoiceKey OBJECT = ((RChoiceKey.Builder)((Key.Builder)((RChoiceKey.Builder)RChoiceKey.builder("object", "Object").addVisibleKeyLink(TYPE, "rds")).setCompletionSupport(RChoiceProvider.globalObjects())).setRequired(true)).build();
    private static final RChoiceKey COL_OBJECT = ((RChoiceKey.Builder)RChoiceKey.builder("col_object", "Object").setCompletionSupport(RChoiceProvider.globalObjects())).build();
    private static final RTableKey OBJECTS = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("objects", "Objects", COL_OBJECT).addVisibleKeyLink(TYPE, "RData")).setUiControls(GeneralTableModel.UI_DEFAULT2)).setDefaultMessage("Whole Workspace")).build();
    private static final RFileKey FILE = ((RFileKey.Builder)((RFileKey.Builder)((RFileKey.Builder)RFileKey.builder("file", "Output File").setAutoValueLink(OBJECT)).setRequired(true)).addVisibleKeyLink(TYPE, "rds")).build();
    private static final RFileKey RDATA_FILE = ((RFileKey.Builder)((RFileKey.Builder)((RFileKey.Builder)RFileKey.builder("rdata_file", "Output File").setRequired(true)).addVisibleKeyLink(TYPE, "RData")).setDefaultValue(RWriteObject.quote("save.RData"))).build();

    @Override
    public Version getVersion() {
        return new Version(0, 2, 0);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            if (StringUtils.isEmpty((CharSequence)this.getValue(FILE))) {
                this.putValue(FILE, this.getDynamicDefaultValue(FILE));
            } else {
                this.putValue(FILE.getAutoValueLinkKey(), Boolean.FALSE);
            }
        }
        if (version.isOlderThan("0.2") && this.getValue(TYPE).equals(RDATA)) {
            this.putValue(RDATA_FILE, this.getValue(FILE));
        }
    }

    @Override
    protected void initKeys() {
        this.registerKeys(TYPE, OBJECT, FILE, RDATA_FILE, OBJECTS);
    }

    @Override
    public String getDefaultTitle() {
        return "Save R Object";
    }

    @Override
    public String getOpClass() {
        return "output";
    }

    @Override
    public Object getDynamicDefaultValue(Key<?> key) {
        if (key == FILE) {
            if (this.getValue(TYPE).equals(RDS)) {
                String string = FileUtility.toLegalFileName(this.getValue(OBJECT));
                return RUtility.quote(string + ".rds");
            }
            List<String> list = this.getValue(OBJECTS).getValues(COL_OBJECT);
            String string = "";
            if (!list.isEmpty()) {
                string = FileUtility.toLegalFileName(list.get(0));
            }
            return RUtility.quote(string + ".RData");
        }
        return super.getDynamicDefaultValue(key);
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (FILE.equals(key) && this.getValue(TYPE).equals(RDS)) {
            String string = FileUtility.toLegalFileName(this.getValue(OBJECT));
            return RWriteObject.quote(string + ".rds");
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        if (this.getValue(TYPE).equals(RDS)) {
            return RUtility.function("saveRDS", "object", this.getValue(OBJECT), "file", this.getValueOrDefault(FILE));
        }
        List<String> list = this.getValue(OBJECTS).getValues(COL_OBJECT);
        if (list.isEmpty()) {
            return RUtility.function("save.image", "file", this.getValue(RDATA_FILE));
        }
        return RUtility.function("save", "", StringUtils.join(list, (String)", "), "file", this.getValue(RDATA_FILE));
    }

    @Override
    public ItemName[] getNewItemNames() {
        return new ItemName[]{RWriteObject.fileItemName(new File(this.getValueOrDefault(FILE)))};
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return RObjectFlavor.isSupported(transferable);
    }

    @Override
    protected void importValues(Transferable transferable) {
        List<RObject> list = RObjectFlavor.get(transferable);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (list.size() == 1) {
            this.putValue(TYPE, RDS);
            this.putValue(OBJECT, list.get(0).getFullName(true));
        } else {
            this.putValue(TYPE, RDATA);
            this.importToTableFullName(OBJECTS, 0, list);
        }
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return null;
    }
}

