/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.base.App;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RFileKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.ViewWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import com.ef_prime.rflow.ui.app.r.RFilePreviewView;
import com.ef_prime.rflow.ui.common.item.ItemName;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class RWriteTable
extends ROperation {
    private static final RChoiceKey OBJECT = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("x", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RChoiceKey SEP = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("sep", "Separator").setDefaultValue(RWriteTable.sQuote("\\t"))).setValuesAndLabels("", "", RWriteTable.sQuote(","), "Comma", RWriteTable.sQuote("\\t"), "Tab", RWriteTable.sQuote(" "), "Space", RWriteTable.sQuote(";"), "Semicolon")).build();
    private static final RFileKey FILE = ((RFileKey.Builder)RFileKey.builder("file", "Output File").setAutoValueLink(OBJECT, SEP)).build();
    private static final RChoiceKey NA = ((RChoiceKey.Builder)((RChoiceKey.Builder)RChoiceKey.builder("na", "Missing Value").setDefaultValue(RWriteTable.quote(""))).setValuesAndLabels(RWriteTable.quote(""), "Empty", RWriteTable.quote("NA"), "")).build();
    private static final RChoiceKey FILE_ENCODING = ((RChoiceKey.Builder)RChoiceKey.builder("fileEncoding", "Encoding").setValuesAndLabels(RChoiceKey.ENCODINGS)).build();
    private static final RChoiceKey APPEND = RWriteTable.logicalKey("append", "Append", "");
    private static final RChoiceKey QUOTE = RWriteTable.logicalKey("quote", "Quote", "");
    private static final RChoiceKey ROWNAMES = RWriteTable.logicalKey("row.names", "Row Names", "FALSE");
    private static final RChoiceKey COLNAMES = RWriteTable.logicalKey("col.names", "Column Names", "TRUE", "Include Header", "Exclude Header");
    private static final RTableKey ADVANCED = RWriteTable.argsKey("write.table");

    @Override
    public Version getVersion() {
        return new Version(0, 3, 0);
    }

    @Override
    public void updateVersion(Version version) {
        if (version.isOlderThan("0.1")) {
            if (StringUtils.isEmpty((CharSequence)this.getValue(FILE))) {
                this.putValue(FILE, this.getDynamicDefaultValue(FILE));
            } else {
                this.putValue(FILE.getAutoValueLinkKey(), Boolean.FALSE);
            }
        }
        if (version.isOlderThan("0.2") && this.getValue(FILE.getAutoValueLinkKey()).booleanValue() && this.getValue(SEP).equals(RWriteTable.sQuote(","))) {
            this.putValue(FILE.getAutoValueLinkKey(), Boolean.FALSE);
        }
    }

    @Override
    public void initialize(boolean bl) {
        super.initialize(bl);
        this.getDefaultEncoding().ifPresent(string -> this.putValue(FILE_ENCODING, RWriteTable.quote(string)));
    }

    @Override
    protected void initKeys() {
        this.registerKeys(OBJECT, FILE, SEP, COLNAMES, FILE_ENCODING, NA, APPEND, QUOTE, ROWNAMES, ADVANCED);
    }

    @Override
    public String getDefaultTitle() {
        return "Write Text File";
    }

    @Override
    public String getOpClass() {
        return "output";
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        return RUtility.function("write.table", this.getArgs(ADVANCED), "x", this.getValue(OBJECT), "file", this.getValue(FILE), "sep", this.getValue(SEP), "na", this.getValue(NA), "fileEncoding", this.getValue(FILE_ENCODING), "append", this.getValue(APPEND), "quote", this.getValue(QUOTE), "row.names", this.getValue(ROWNAMES), "col.names", this.getValue(COLNAMES));
    }

    @Override
    public ItemName[] getNewItemNames() {
        return new ItemName[]{RWriteTable.fileItemName(new File(RWriteTable.unquote(this.getValueOrDefault(FILE))))};
    }

    @Override
    public boolean isSupported(App app) {
        return app == Apps.R || app == Apps.FILE;
    }

    @Override
    public Object getDynamicDefaultValue(Key<?> key) {
        if (key == FILE) {
            String string = this.getValue(OBJECT);
            return RUtility.quote(string + ".txt");
        }
        return super.getDynamicDefaultValue(key);
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (key == FILE) {
            String string = ".txt";
            if (this.getValue(SEP).equals(RWriteTable.sQuote(","))) {
                string = ".csv";
            }
            return RWriteTable.quote(FileUtility.toLegalFileName(this.getValue(OBJECT)) + string);
        }
        return super.getAutoValue(key);
    }

    @Override
    public String getSubtitle(Key<?> key) {
        if (key == ADVANCED) {
            return null;
        }
        return key.getId();
    }

    @Override
    protected StrKey getRObjectImportKey() {
        return OBJECT;
    }

    @Override
    public WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithKeys("Main", OBJECT, SEP, FILE, COLNAMES, FILE_ENCODING).addTabWithKeys("Options", NA, APPEND, QUOTE, ROWNAMES).addTabWithKeys("Advanced", ADVANCED);
    }

    @Override
    public WidgetNode getPreviewWidgetNode() {
        return new ViewWidgetNode(RFilePreviewView.class);
    }

    @Override
    public StrKey getFileExportKey() {
        return FILE;
    }
}

