/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.keyvalue.RChoiceKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RStrKey;
import com.ef_prime.rflow.core.app.r.keyvalue.RTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.TabPaneWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.GeneralTableModel;
import com.ef_prime.rflow.core.util.Version;
import com.ef_prime.rflow.node.PreviewOption;
import com.ef_prime.rflow.ui.app.r.RChoiceProvider;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RXTabs
extends ROperation {
    private static final String TYPE_COUNT = "count";
    private static final String TYPE_RATIO = "ratio";
    private static final String TYPE_ROW_RATIO = "row_ratio";
    private static final String TYPE_COLUMN_RATIO = "column_ratio";
    private static final RChoiceKey DATA = ((RChoiceKey.Builder)((RChoiceKey.Builder)((Key.Builder)RChoiceKey.builder("data", "Data").setCompletionSupport(RChoiceProvider.globalDataFrames())).setRequired(true)).setPreviewFunction(DATA_PREVIEW)).build();
    private static final RStrKey OUTPUT = ((RStrKey.Builder)((RStrKey.Builder)((RStrKey.Builder)RStrKey.builder("_output", "Output").setAutoValueLink(DATA)).setRequired(true)).setOutput(true)).build();
    private static final RChoiceKey COLUMN = ((RChoiceKey.Builder)RChoiceKey.builder("column", "Column").setCompletionSupport(RChoiceProvider.columns(DATA.getId(), true))).build();
    private static final RTableKey COLUMNS = ((RTableKey.Builder)((RTableKey.Builder)((RTableKey.Builder)RTableKey.builder("columns", "Group By", COLUMN).setUiControls(GeneralTableModel.UI_DEFAULT2)).setRequired(true)).setDefaultRowPredicate()).build();
    private static final ChoiceKey TYPE = ((ChoiceKey.Builder)((ChoiceKey.Builder)ChoiceKey.builder("type", "Type").setValues("count", "ratio", "row_ratio", "column_ratio")).setLabels("Sum", "Ratio", "Row Ratio", "Column Ratio")).build();
    private static final RTableKey ADVANCED = RXTabs.argsKey("xtabs");

    @Override
    public Version getVersion() {
        return new Version(0, 1, 0, 1);
    }

    @Override
    protected void initKeys() {
        this.registerKeys(DATA, OUTPUT, COLUMNS, TYPE, ADVANCED);
    }

    @Override
    protected String getDefaultTitle() {
        return "Cross Tabulation";
    }

    @Override
    public String getOpClass() {
        return "summary";
    }

    @Override
    public Object getAutoValue(Key<?> key) {
        if (OUTPUT.equals(key)) {
            return RXTabs.suffix(this.getValue(DATA), ".xtabs");
        }
        return super.getAutoValue(key);
    }

    @Override
    public boolean canImport(Transferable transferable) {
        return this.isDataOrColumns(transferable, DATA);
    }

    @Override
    protected void importValues(Transferable transferable) {
        this.importDataOrColumns(transferable, DATA, COLUMNS, 0, true);
    }

    @Override
    protected WidgetNode getContentWidgetNode(ViewOptions viewOptions) {
        return new TabPaneWidgetNode().addTabWithElements("Main", DATA, OUTPUT, COLUMNS).addTabWithElements("Options", TYPE).addTabWithElements("Advanced", ADVANCED);
    }

    @Override
    public String getRScript(boolean bl, boolean bl2, PreviewOption previewOption) throws Exception {
        Object object = "";
        List<String> list = this.getValue(COLUMNS).getValidValues(COLUMN);
        if (!list.isEmpty()) {
            object = "~ " + StringUtils.join(list, (String)" + ");
        }
        String string = RUtility.function("xtabs", this.getArgs(ADVANCED), new String[]{"data", this.getValue(DATA), "formula", object});
        switch (this.getValue(TYPE)) {
            case "ratio": {
                return RUtility.assignFunction(this.getValue(OUTPUT), "prop.table", "", string);
            }
            case "row_ratio": {
                return RUtility.assignFunction(this.getValue(OUTPUT), "prop.table", "", string, "margin", "1");
            }
            case "column_ratio": {
                return RUtility.assignFunction(this.getValue(OUTPUT), "prop.table", "", string, "margin", "2");
            }
        }
        return RUtility.assign(this.getValue(OUTPUT), string);
    }
}

