/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.AppRpcInterface;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RJavaInterface;
import com.ef_prime.rflow.core.app.r.base.RServerRpcClient;
import com.ef_prime.rflow.core.app.r.base.RSessionManager;
import com.ef_prime.rflow.core.app.r.base.RpcUtility;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.ui.app.r.gd.GD;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.apache.thrift.TException;
import org.rosuda.JRI.RMainLoopCallbacks;

public class AppRpc
implements AppRpcInterface.Iface,
RSessionManager.RSessionEventHandler {
    private static final Logger LOGGER = Logger.getLogger(AppRpc.class.getName());
    private RMainLoopCallbacks loopCallbacks;
    private RServerRpcClient serverRpcClient;
    private ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)ThreadUtility.threadFactory("AppRpc-%d", false));
    private ExecutorService gdExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThreadUtility.threadFactory("GDRpc-%d", false));
    private List<GD> gdList = new ArrayList<GD>();

    public AppRpc(RMainLoopCallbacks rMainLoopCallbacks) {
        this.loopCallbacks = rMainLoopCallbacks;
        R.sessionManager().addEventHandler(this);
    }

    public void setServerRpcClient(RServerRpcClient rServerRpcClient) {
        this.serverRpcClient = rServerRpcClient;
    }

    @Override
    public void rWriteConsole(String string, int n) throws TException {
        this.executorService.execute(() -> this.loopCallbacks.rWriteConsole(null, string, n));
    }

    @Override
    public void rBusy(int n) throws TException {
        this.executorService.execute(() -> this.loopCallbacks.rBusy(null, n));
    }

    @Override
    public void rReadConsole(String string, int n) throws TException {
        this.executorService.execute(() -> {
            block3: {
                String string2 = this.loopCallbacks.rReadConsole(null, string, n);
                if (this.serverRpcClient != null && string2 != null) {
                    try {
                        this.serverRpcClient.rReadConsoleResponse(string2);
                    }
                    catch (TException tException) {
                        if (!R.sessionManager().isSessionAlive()) break block3;
                        LOGGER.log(Level.SEVERE, "Failed to send read console response.", tException);
                    }
                }
            }
        });
    }

    @Override
    public void rShowMessage(String string) throws TException {
        this.executorService.execute(() -> this.loopCallbacks.rShowMessage(null, string));
    }

    @Override
    public void rChooseFile(int n) throws TException {
        this.executorService.execute(() -> {
            block3: {
                String string = this.loopCallbacks.rChooseFile(null, n);
                if (this.serverRpcClient != null) {
                    try {
                        this.serverRpcClient.rChooseFileResponse(string);
                    }
                    catch (TException tException) {
                        if (!R.sessionManager().isSessionAlive()) break block3;
                        LOGGER.log(Level.SEVERE, "Failed to send choose file response.", tException);
                    }
                }
            }
        });
    }

    @Override
    public void rFlushConsole() throws TException {
        this.executorService.execute(() -> this.loopCallbacks.rFlushConsole(null));
    }

    @Override
    public void rSaveHistory(String string) throws TException {
        this.executorService.execute(() -> this.loopCallbacks.rSaveHistory(null, string));
    }

    @Override
    public void rLoadHistory(String string) throws TException {
        this.executorService.execute(() -> this.loopCallbacks.rLoadHistory(null, string));
    }

    @Override
    public int canBrowse() throws TException {
        RJavaInterface rJavaInterface = RClient.getRJavaInterface();
        if (rJavaInterface != null) {
            return RClient.getRJavaInterface().canBrowse();
        }
        return 0;
    }

    @Override
    public void setFrame(int n) throws TException {
        RClient.getRJavaInterface().setFrame(n);
    }

    @Override
    public int selectFrame() throws TException {
        return RClient.getRJavaInterface().selectFrame();
    }

    @Override
    public void pager(String string, String string2, String string3, boolean bl) throws TException {
        RClient.getRJavaInterface().pager(string, string2, string3, bl);
    }

    @Override
    public void browser(String string, boolean bl) throws TException {
        RClient.getRJavaInterface().browser(string, bl);
    }

    @Override
    public void view(String string, String string2) throws TException {
        RClient.getRJavaInterface().view(string, string2);
    }

    @Override
    public int state() throws TException {
        return 0;
    }

    @Override
    public void packageStatus(String string, boolean bl) throws TException {
        RClient.getRJavaInterface().packageStatus(string, bl);
    }

    @Override
    public List<Integer> openDevice(double d, double d2) throws TException {
        return RpcUtility.toIntegerList(GD.openDevice(d, d2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createGD(int n) throws TException {
        GD gD = new GD();
        List<GD> list = this.gdList;
        synchronized (list) {
            while (n + 1 >= this.gdList.size()) {
                this.gdList.add(null);
            }
            this.gdList.set(n, gD);
        }
    }

    private GD gd(int n) {
        return this.gdList.get(n);
    }

    @Override
    public void gdOpen(int n, double d, double d2) throws TException {
        this.gd(n).gdOpen(d, d2);
    }

    @Override
    public void gdActivate(int n) throws TException {
        this.gd(n).gdActivate();
    }

    @Override
    public void gdCircle(int n, double d, double d2, double d3) throws TException {
        this.gd(n).gdCircle(d, d2, d3);
    }

    @Override
    public void gdClip(int n, double d, double d2, double d3, double d4) throws TException {
        this.gd(n).gdClip(d, d2, d3, d4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gdClose(int n) throws TException {
        this.gd(n).gdClose();
        List<GD> list = this.gdList;
        synchronized (list) {
            this.gdList.set(n, null);
        }
    }

    @Override
    public void gdDeactivate(int n) throws TException {
        this.gd(n).gdDeactivate();
    }

    @Override
    public void gdHold(int n) throws TException {
        this.gd(n).gdHold();
    }

    @Override
    public void gdFlush(int n, boolean bl) throws TException {
        this.gd(n).gdFlush(bl);
    }

    @Override
    public void gdLocator(int n) throws TException {
        GD gD = this.gd(n);
        this.gdExecutor.execute(() -> {
            block3: {
                double[] dArray = gD.gdLocator();
                if (this.serverRpcClient != null) {
                    try {
                        this.serverRpcClient.gdLocatorResponse(RpcUtility.toDoubleList(dArray));
                    }
                    catch (TException tException) {
                        if (!R.sessionManager().isSessionAlive()) break block3;
                        LOGGER.log(Level.SEVERE, "Failed to send locator response.", tException);
                    }
                }
            }
        });
    }

    @Override
    public void gdLine(int n, double d, double d2, double d3, double d4) throws TException {
        this.gd(n).gdLine(d, d2, d3, d4);
    }

    @Override
    public List<Double> gdMetricInfo(int n, int n2) throws TException {
        return RpcUtility.toDoubleList(this.gd(n).gdMetricInfo(n2));
    }

    @Override
    public void gdMode(int n, int n2) throws TException {
        this.gd(n).gdMode(n2);
    }

    @Override
    public void gdNewPageOld(int n) throws TException {
        this.gd(n).gdNewPage();
    }

    @Override
    public void gdNewPage(int n, int n2) throws TException {
        this.gd(n).gdNewPage(n2);
    }

    @Override
    public void gdPath(int n, int n2, List<Integer> list, List<Double> list2, List<Double> list3, boolean bl) throws TException {
        this.gd(n).gdPath(n2, RpcUtility.toIntegerArray(list), RpcUtility.toDoubleArray(list2), RpcUtility.toDoubleArray(list3), bl);
    }

    @Override
    public void gdPolygon(int n, int n2, List<Double> list, List<Double> list2) throws TException {
        this.gd(n).gdPolygon(n2, RpcUtility.toDoubleArray(list), RpcUtility.toDoubleArray(list2));
    }

    @Override
    public void gdPolyline(int n, int n2, List<Double> list, List<Double> list2) throws TException {
        this.gd(n).gdPolyline(n2, RpcUtility.toDoubleArray(list), RpcUtility.toDoubleArray(list2));
    }

    @Override
    public void gdRect(int n, double d, double d2, double d3, double d4) throws TException {
        this.gd(n).gdRect(d, d2, d3, d4);
    }

    @Override
    public void gdRaster(int n, ByteBuffer byteBuffer, int n2, int n3, double d, double d2, double d3, double d4, double d5, boolean bl) throws TException {
        byte[] byArray = ArrayUtils.subarray((byte[])byteBuffer.array(), (int)byteBuffer.position(), (int)byteBuffer.limit());
        this.gd(n).gdRaster(byArray, n2, n3, d, d2, d3, d4, d5, bl);
    }

    @Override
    public List<Double> gdSize(int n) throws TException {
        return RpcUtility.toDoubleList(this.gd(n).gdSize());
    }

    @Override
    public double gdStrWidth(int n, String string) throws TException {
        return this.gd(n).gdStrWidth(string);
    }

    @Override
    public void gdText(int n, double d, double d2, String string, double d3, double d4) throws TException {
        this.gd(n).gdText(d, d2, string, d3, d4);
    }

    @Override
    public void gdcSetColor(int n, int n2) throws TException {
        this.gd(n).gdcSetColor(n2);
    }

    @Override
    public void gdcSetFill(int n, int n2) throws TException {
        this.gd(n).gdcSetFill(n2);
    }

    @Override
    public void gdcSetLine(int n, double d, int n2) throws TException {
        this.gd(n).gdcSetLine(d, n2);
    }

    @Override
    public void gdcSetFont(int n, double d, double d2, double d3, int n2, String string) throws TException {
        this.gd(n).gdcSetFont(d, d2, d3, n2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRSessionEvent(RSessionManager.RSessionEvent rSessionEvent) {
        switch (rSessionEvent.getType()) {
            case 2: 
            case 3: {
                List<GD> list = this.gdList;
                synchronized (list) {
                    this.gdList.clear();
                    break;
                }
            }
        }
    }
}

