/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RTimeoutException;
import java.lang.reflect.Constructor;
import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REngineException;

public class EmbeddedRClient
extends RClient {
    private JRIEngine engine;
    private boolean evaluating;

    public EmbeddedRClient(String[] stringArray, long l, RMainLoopCallbacks rMainLoopCallbacks) throws Exception {
        try {
            Constructor constructor = JRIEngine.class.getConstructor(String[].class, RMainLoopCallbacks.class, Boolean.TYPE, Long.TYPE);
            if (l < 102400L) {
                l = 0L;
            }
            this.engine = (JRIEngine)constructor.newInstance(stringArray, rMainLoopCallbacks, false, l);
        }
        catch (Exception exception) {
            this.engine = new JRIEngine(stringArray, rMainLoopCallbacks, false);
        }
        if (!this.engine.getRni().waitForR()) {
            throw new Exception("Failed to init R");
        }
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    public JRIEngine getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private REXP doEval(String string, boolean bl) throws REngineException, REXPMismatchException {
        string = EmbeddedRClient.toParseCommand(string);
        REXP rEXP = null;
        REXP rEXP2 = null;
        REXP rEXP3 = null;
        try {
            rEXP = this.engine.parse(string, false);
            rEXP2 = this.engine.eval(rEXP, null, false);
            REXP rEXP4 = rEXP3 = this.engine.eval(rEXP2, null, bl);
            return rEXP4;
        }
        finally {
            if (rEXP instanceof REXPReference) {
                ((REXPReference)rEXP).release();
            }
            if (rEXP2 instanceof REXPReference) {
                ((REXPReference)rEXP2).release();
            }
            if (!bl && rEXP3 instanceof REXPReference) {
                ((REXPReference)rEXP3).release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized REXP eval(String string, boolean bl) {
        REXP rEXP = null;
        int n = this.engine.lock();
        if (n != 1) {
            return null;
        }
        try {
            this.evaluating = true;
            if (Rengine.DEBUG > 0) {
                System.out.println("e: " + string);
            }
            rEXP = this.doEval(string, bl);
        }
        catch (Exception exception) {
        }
        finally {
            this.evaluating = false;
            this.engine.unlock(n);
        }
        return rEXP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized REXP idleEval(String string, boolean bl) {
        REXP rEXP = null;
        int n = this.engine.tryLock();
        if (n != 1) {
            return null;
        }
        try {
            this.evaluating = true;
            if (Rengine.DEBUG > 0) {
                System.out.println("i: " + string);
            }
            rEXP = this.doEval(string, bl);
        }
        catch (Exception exception) {
        }
        finally {
            this.evaluating = false;
            this.engine.unlock(n);
        }
        return rEXP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized REXP timeoutEval(String string, long l, boolean bl) throws REngineException, RTimeoutException, REXPMismatchException {
        REXP rEXP = null;
        Mutex mutex = this.engine.getRni().getRsync();
        boolean bl2 = mutex.safeLockWithTimeout(l);
        if (!bl2) {
            throw new RTimeoutException(l);
        }
        try {
            this.evaluating = true;
            if (Rengine.DEBUG > 0) {
                System.out.println("t: " + string);
            }
            rEXP = this.doEval(string, bl);
        }
        finally {
            this.evaluating = false;
            mutex.unlock();
        }
        return rEXP;
    }

    @Override
    public void startMainLoop() {
        this.engine.getRni().startMainLoop();
    }

    @Override
    public void stop() {
        this.engine.getRni().rniStop(0);
    }

    @Override
    public void idle() {
        this.engine.getRni().rniIdle();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean isBrowseEnabled() {
        return !this.evaluating;
    }
}

