/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.base.Apps;
import com.ef_prime.rflow.core.app.r.base.EmbeddedRClient;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RInterface;
import com.ef_prime.rflow.core.app.r.base.RPackageManager;
import com.ef_prime.rflow.core.app.r.base.RSessionManager;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.base.RpcRClient;
import com.ef_prime.rflow.core.app.r.console.CommandReceiver;
import com.ef_prime.rflow.core.app.r.console.RConsole;
import com.ef_prime.rflow.core.app.r.console.RQueryQueue;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.item.ItemManagers;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.commons.lang3.ArrayUtils;

public class R {
    private static RSessionManager sessionManager = new RSessionManager();
    private static RClient r;
    private static RConsole console;
    private static RInterface rInterface;
    private static RPackageManager packageManager;
    private static EventSupport<ChangeEvent, ChangeEventHandler> eventSupport;

    public static void initClient(RConsole rConsole) {
        RClient rClient;
        block8: {
            Settings settings = Rflow.settings();
            boolean bl = Rflow.develSettings().getValue(DevelSettings.KEY_R_PROCESS);
            try {
                ServerSocket serverSocket;
                Object[] objectArray = settings.getValue(Settings.R_OPTIONS).split(" ");
                if (!Platform.isWindowsFamily()) {
                    objectArray = (String[])ArrayUtils.add((Object[])objectArray, (Object)"--interactive");
                }
                long l = settings.getValue(Settings.STACK_SIZE);
                if (!bl) {
                    rClient = new EmbeddedRClient((String[])objectArray, l, rConsole);
                    break block8;
                }
                int n = settings.getValue(Settings.APP_SERVER_PORT);
                int n2 = settings.getValue(Settings.R_SERVER_PORT);
                if (n <= 0) {
                    n = RSessionManager.findAvailablePort();
                }
                try {
                    serverSocket = new ServerSocket(n, 50, InetAddress.getLoopbackAddress());
                }
                catch (Exception exception) {
                    serverSocket = new ServerSocket(0, 50, InetAddress.getLoopbackAddress());
                }
                if (n2 <= 0) {
                    n2 = RSessionManager.findAvailablePort();
                }
                rClient = new RpcRClient(serverSocket, InetAddress.getLoopbackAddress().getHostAddress(), n2, rConsole, settings.getValue(Settings.CREATE_R_SERVER), l, (String[])objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to init R", exception);
            }
        }
        ItemManagers.getInstance().add(Apps.R.getId(), rClient);
        R.setClient(rClient);
        R.setConsole(rConsole);
        Rflow.settings().addEventHandler(new SettingsListener());
    }

    public static RSessionManager sessionManager() {
        return sessionManager;
    }

    static void setClient(RClient rClient) {
        r = rClient;
        eventSupport.dispatchEvent(new ChangeEvent(rClient));
    }

    public static RClient client() {
        return r;
    }

    static void setConsole(RConsole rConsole) {
        console = rConsole;
    }

    public static RConsole console() {
        return console;
    }

    public static CommandReceiver receiver() {
        return console.getReceiver();
    }

    public static RQueryQueue queryQueue() {
        return console.getRQueryQueue();
    }

    public static RInterface getInterface() {
        return rInterface;
    }

    public static RPackageManager packageManager() {
        return packageManager;
    }

    public static void addEventHandler(ChangeEventHandler changeEventHandler) {
        eventSupport.addEventHandler(changeEventHandler);
    }

    public static void removeEventHandler(ChangeEventHandler changeEventHandler) {
        eventSupport.removeEventHandler(changeEventHandler);
    }

    static {
        rInterface = new RInterfaceImpl();
        packageManager = new RPackageManager();
        eventSupport = new EventSupport();
    }

    private static class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.USE_RFLOW_VIEW.equals(valueChangeEvent.getKey())) {
                String string = r.assignInRflowEnv(RUtility.quote(".USE_RFLOW_VIEW"), RUtility.toRBoolean(Rflow.settings().getValue(Settings.USE_RFLOW_VIEW)));
                R.queryQueue().addQuery(() -> R.client().silentTimeoutEval(string));
            }
        }
    }

    private static class RInterfaceImpl
    implements RInterface {
        private RInterfaceImpl() {
        }

        @Override
        public RClient client() {
            return R.client();
        }

        @Override
        public CommandReceiver receiver() {
            return R.receiver();
        }

        @Override
        public RQueryQueue queryQueue() {
            return R.queryQueue();
        }
    }
}

