/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.file.FileUtility;
import com.ef_prime.rflow.core.app.r.base.ArgEntry;
import com.ef_prime.rflow.core.app.r.base.ArgList;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RJavaInterface;
import com.ef_prime.rflow.core.app.r.base.RObject;
import com.ef_prime.rflow.core.app.r.base.RObjectNameSet;
import com.ef_prime.rflow.core.app.r.base.RObjectSet;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RPackageListChangeEvent;
import com.ef_prime.rflow.core.app.r.base.RTimeoutException;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.base.SentenceInfo;
import com.ef_prime.rflow.core.app.r.console.BasicCommand;
import com.ef_prime.rflow.core.app.r.console.Command;
import com.ef_prime.rflow.core.base.DevelSettings;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.ui.common.component.SaveToFile;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemEvent;
import com.ef_prime.rflow.ui.common.item.ItemEventHandler;
import com.ef_prime.rflow.ui.common.item.ItemManager;
import com.ef_prime.rflow.ui.common.item.ItemManagerSupport;
import com.ef_prime.rflow.ui.common.item.ItemName;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;

public abstract class RClient
implements ItemManager {
    private static final Logger LOGGER = Logger.getLogger(RClient.class.getName());
    public static final RPackage[] REQUIRED_PACKAGES = new RPackage[]{new RPackage("codetools", true, false), new RPackage("JavaGD", true, false), new RPackage("rJava", true, false)};
    public static final String RFLOW_ENV = ".RflowEnv";
    public static final String PREVIEW_ENV = ".PREVIEW_ENV";
    public static final int BROWSER_NONE = 0;
    public static final int BROWSER_ON = 1;
    public static final int BROWSER_RECOVER = 2;
    private String env = ".RflowEnv";
    private static RJavaInterface rJavaInterface;
    private ItemManagerSupport itemManagerSupport = new ItemManagerSupport(this);
    protected boolean initialized;
    private boolean availablePackagesUpdated;
    private ItemEvent structureChangedEvent = new ItemEvent(this, 1, null);
    private String nativeEncoding;
    private boolean canDebuggingState;
    private String pkgType;
    private static final long PACKAGE_UPDATE_INTERVAL_SEC = 3L;
    private Set<String> installedPackagesCache = null;
    private LocalDateTime lastPackageUpdateTime = null;
    private String userLib = null;
    private Timer timer;
    private static final String KEY_LINE = "line";
    private static final String KEY_FUNC = "func";
    private static final String KEY_ARGS = "args";
    private static final String KEY_SYMBOL = "symbol";
    private static final String KEY_CONTROL = "control";
    private static final String KEY_SRCLINE = "srcline";
    private static final String KEY_SRCREF = "srcref";

    public abstract boolean isEmbedded();

    public abstract boolean isConnected();

    public abstract REXP eval(String var1, boolean var2);

    public abstract REXP idleEval(String var1, boolean var2);

    public abstract REXP timeoutEval(String var1, long var2, boolean var4) throws REngineException, RTimeoutException, REXPMismatchException;

    public abstract void startMainLoop() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void idle();

    public abstract void shutdown() throws Exception;

    public abstract boolean isBrowseEnabled();

    public static void setRJavaInterface(RJavaInterface rJavaInterface) {
        RClient.rJavaInterface = rJavaInterface;
    }

    public static RJavaInterface getRJavaInterface() {
        return rJavaInterface;
    }

    public static int canBrowse() {
        if (rJavaInterface != null) {
            return rJavaInterface.canBrowse();
        }
        return 0;
    }

    public static void setFrame(int n) {
        if (rJavaInterface != null) {
            rJavaInterface.setFrame(n);
        }
    }

    public static int selectFrame() {
        if (rJavaInterface != null) {
            return rJavaInterface.selectFrame();
        }
        return 0;
    }

    public static void pager(String string, String string2, String string3, boolean bl) {
        if (rJavaInterface != null) {
            rJavaInterface.pager(string, string2, string3, bl);
        }
    }

    public static void browser(String string, boolean bl) {
        if (rJavaInterface != null) {
            rJavaInterface.browser(string, bl);
        }
    }

    public static void flushConsole() {
        if (rJavaInterface != null) {
            rJavaInterface.flushConsole();
        }
    }

    public static void view(String string, String string2) {
        if (rJavaInterface != null) {
            rJavaInterface.view(string, string2);
        }
    }

    public static void packageStatus(String string, boolean bl) {
        if (rJavaInterface != null) {
            rJavaInterface.packageStatus(string, bl);
        }
    }

    protected static String toParseCommand(String string) {
        return "suppressWarnings(tryCatch(parse(text=" + RUtility.quote(string) + "), error=function(e){}))";
    }

    public void eval(String string) {
        this.eval(string, false);
    }

    public REXP evalGet(String string) {
        return this.eval(string, true);
    }

    public boolean idleEval(String string) {
        return this.idleEval(string, false) != null;
    }

    public REXP idleEvalGet(String string) {
        return this.idleEval(string, true);
    }

    public void timeoutEval(String string, long l) {
        try {
            this.timeoutEval(string, l, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public REXP timeoutEvalGet(String string, long l) {
        try {
            return this.timeoutEval(string, l, true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String silent(String string) {
        if (this.initialized) {
            if (this.canDebuggingState) {
                return ".rflowSilent(" + string + ")";
            }
            return ".rflowSilent(" + string + ", debugState=FALSE)";
        }
        return null;
    }

    public void silentEval(String string) {
        this.eval(this.silent(string));
    }

    public REXP silentEvalGet(String string) {
        return this.evalGet(this.silent(string));
    }

    public boolean silentIdleEval(String string) {
        return this.idleEval(this.silent(string));
    }

    public REXP silentIdleEvalGet(String string) {
        return this.idleEvalGet(this.silent(string));
    }

    public void silentTimeoutEval(String string) {
        this.silentTimeoutEval(string, 1000L);
    }

    public REXP silentTimeoutEvalGet(String string) {
        return this.silentTimeoutEvalGet(string, 1000L);
    }

    public void silentTimeoutEval(String string, long l) {
        this.timeoutEval(this.silent(string), l);
    }

    public REXP silentTimeoutEvalGet(String string, long l) {
        return this.timeoutEvalGet(this.silent(string), l);
    }

    public REXP silentTimeoutEvalGetEx(String string) throws REngineException, RTimeoutException, REXPMismatchException {
        return this.timeoutEval(this.silent(string), 5000L, true);
    }

    public String noDebug(String string) {
        String string2 = this.canDebuggingState ? ".rflowNoDebug" : ".rflowNoTracing";
        return RUtility.func(string2, string);
    }

    protected String getEnv() {
        return this.env;
    }

    protected String getGDClass() {
        return "com/ef_prime/rflow/ui/app/r/gd/GD";
    }

    public void init(File file, String string, boolean bl) {
        this.canDebuggingState = RClient.rexpToBoolean(this.evalGet("getRversion() >= R_system_version(\"3.2.0\")"), Boolean.FALSE);
        this.eval("Sys.setenv(\"JAVAGD_CLASS_NAME\"=" + RUtility.quote(this.getGDClass()) + ")");
        String string2 = "\n";
        this.eval("attach(new.env(hash=TRUE, parent=.GlobalEnv), name=\"" + this.env + "\")");
        this.eval(RUtility.function("assign", "", RUtility.quote(RFLOW_ENV), "", this.getRflowEnvCommand(), "envir", this.getRflowEnvCommand()));
        this.eval("eval(quote(source(\"" + string + "/rcommons.R\", encoding=\"UTF-8\", local=TRUE)), envir=" + this.getRflowEnvCommand() + ")");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("assign(\".rflowErrorHandler\", ");
        stringBuilder.append("function(){" + string2);
        if (this.canDebuggingState) {
            stringBuilder.append("  oldDebuggingState <- debuggingState(on = FALSE)" + string2);
        }
        stringBuilder.append("  oldTracingState <- tracingState(on = FALSE)" + string2);
        stringBuilder.append("  on.exit({" + string2);
        if (this.canDebuggingState) {
            stringBuilder.append("  \tdebuggingState(on=oldDebuggingState)" + string2);
        }
        stringBuilder.append("  \ttracingState(on=oldTracingState)" + string2);
        stringBuilder.append("  })" + string2);
        stringBuilder.append("  canBrowse <- try(rJava::.jcall(.rflowRJavaInterfaceClass, \"I\", \"canBrowse\"), silent=TRUE)" + string2);
        stringBuilder.append("  if (!is.integer(canBrowse) || canBrowse != 1) { return() }" + string2);
        stringBuilder.append("\trflowEnv <- " + this.getRflowEnvCommand() + string2);
        stringBuilder.append("\t" + string2);
        stringBuilder.append("\t#set error object" + string2);
        stringBuilder.append("\ttry(assign(\".rflowErrorObject\", TRUE, envir=rflowEnv), silent=TRUE)" + string2);
        stringBuilder.append("\t" + string2);
        stringBuilder.append("\t#browse if .rflowRecover is set" + string2);
        stringBuilder.append("\trecoverFlag <- get(\".rflowRecover\", envir=rflowEnv)" + string2);
        stringBuilder.append("\tnframe <- sys.nframe()" + string2);
        stringBuilder.append("\twhich <- sys.nframe()-1L" + string2);
        stringBuilder.append("\tcurrentEnv <- get(\".rflowDebugEnvironment\", envir=rflowEnv)[[1]]" + string2);
        stringBuilder.append("\tif(!is.null(recoverFlag) && recoverFlag && !identical(sys.frame(-1), currentEnv) && !identical(sys.frame(-1), globalenv())){" + string2);
        stringBuilder.append("\t\trepeat {" + string2);
        stringBuilder.append("\t\t\ttry(rJava::.jcall(.rflowRJavaInterfaceClass, \"V\", \"setFrame\", as.integer(which)), silent=TRUE)" + string2);
        stringBuilder.append("\t\t\tbase::eval(substitute(browser(text = \".rflowRecover\", skipCalls = skip), list(skip = nframe-which+2)), envir = sys.frame(which))" + string2);
        stringBuilder.append("\t\t\twhich <- tryCatch(rJava::.jcall(.rflowRJavaInterfaceClass, \"I\", \"selectFrame\"), error=function(e){0})" + string2);
        stringBuilder.append("\t\t\tif (which <= 0) {break}" + string2);
        stringBuilder.append("\t\t}" + string2);
        stringBuilder.append("\t}" + string2);
        stringBuilder.append("\t" + string2);
        stringBuilder.append("\tinvisible()" + string2);
        stringBuilder.append("}" + string2);
        stringBuilder.append(", envir = " + this.getRflowEnvCommand() + ")");
        this.eval(stringBuilder.toString());
        this.eval("options(error=.rflowErrorHandler)");
        String string3 = RClient.class.getName().replace('.', '/');
        this.eval(this.assignInRflowEnv(RUtility.quote(".rflowRJavaInterfaceClass"), RUtility.quote(string3)));
        this.initRJava(bl);
        this.eval(this.assignInRflowEnv(RUtility.quote(".deviceTemp"), "options()$device"));
        this.eval("if(\"JavaGD\" %in% .packages(all.available = TRUE)) {options(device = RflowGD)}");
        String string4 = Rflow.settings().getValue(Settings.USE_RFLOW_VIEW) != false ? "TRUE" : "FALSE";
        this.eval("eval(quote(.USE_RFLOW_VIEW <- " + string4 + "), envir=" + this.getRflowEnvCommand() + ")");
        this.eval("lockEnvironment(" + this.getRflowEnvCommand() + ")");
        if (!bl) {
            if (Platform.isLinux() || Platform.isMac()) {
                this.eval("options(menu.graphics = FALSE)");
            }
            this.eval("options(help_type = \"html\")");
            this.eval("options(max.print = 5000)");
        }
        if (Platform.isWindowsFamily()) {
            this.eval("if(!is.na(as.numeric(Sys.getenv(\"RFLOW_MAX_MEMORY\")))){suppressWarnings(memory.limit(floor(as.numeric(Sys.getenv(\"RFLOW_MAX_MEMORY\")))/1024/1024))}");
            this.eval("if (getRversion() < R_system_version(\"3.3.0\") && exists(\"setInternet2\", where = \"package:utils\")) { utils::setInternet2(use=TRUE) }");
        }
        this.nativeEncoding = RClient.rexpToString(this.evalGet("localeToCharset()"), "");
        if (file.exists()) {
            this.eval("source(" + RUtility.quotedPath(file.getPath()) + ", encoding=\"UTF-8\")");
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                R.client().updateInstalledPackages(true);
            }
        }, 0L, 10000L);
        this.initialized = true;
    }

    public void initRJava(boolean bl) {
        this.eval("if(\"rJava\" %in% .packages(all.available = TRUE)){rJava::.jinit(silent=TRUE)}");
        if (bl) {
            return;
        }
        if (!Rflow.develSettings().getValue(DevelSettings.KEY_EXTERNAL_HELP_BROWSER).booleanValue()) {
            this.eval(this.assignInRflowEnv(RUtility.quote(".original.browser"), "getOption(\"browser\")"));
            this.eval("if(\"rJava\" %in% .packages(all.available = TRUE)){options(browser=.rflow.browser)}");
        }
        if (Platform.isWindowsFamily()) {
            this.eval("if(\"rJava\" %in% .packages(all.available = TRUE)){" + RUtility.override("flush.console", ".rflow.flush.console", "utils", "utils") + "}");
        }
        this.eval("if(\"rJava\" %in% .packages(all.available = TRUE)){options(pager=.rflow.pager)}");
    }

    public Command getInitialCommand() {
        String string = "tools::startDynamicHelp()";
        if (Rflow.develSettings().getValue(DevelSettings.KEY_SHOW_HELP_START_PAGE).booleanValue()) {
            string = "help.start()";
        }
        BasicCommand basicCommand = new BasicCommand(string);
        basicCommand.setCaptureOutput(true);
        return basicCommand;
    }

    public static Boolean rexpToBoolean(REXP rEXP, Boolean bl) {
        if (rEXP == null || !rEXP.isLogical()) {
            return bl;
        }
        try {
            return rEXP.asInteger() > 0;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return bl;
        }
    }

    public static boolean[] rexpToBooleans(REXP rEXP, boolean[] blArray) {
        int[] nArray;
        if (rEXP == null || !rEXP.isLogical()) {
            return blArray;
        }
        try {
            nArray = rEXP.asIntegers();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return blArray;
        }
        boolean[] blArray2 = new boolean[nArray.length];
        for (int i = 0; i < blArray2.length; ++i) {
            blArray2[i] = nArray[i] > 0;
        }
        return blArray2;
    }

    public static String rexpToString(REXP rEXP, String string) {
        return RClient.rexpToString(rEXP, string, string);
    }

    public static String rexpToString(REXP rEXP, String string, String string2) {
        if (RClient.isError(rEXP) || !rEXP.isString()) {
            return string;
        }
        try {
            String string3 = rEXP.asString();
            if (string3 == null) {
                return string2;
            }
            return string3;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String[] rexpToStrings(REXP rEXP, String[] stringArray, String string) {
        if (RClient.isError(rEXP) || !rEXP.isString()) {
            return stringArray;
        }
        try {
            String[] stringArray2 = rEXP.asStrings();
            if (string != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i] != null) continue;
                    stringArray2[i] = string;
                }
            }
            return stringArray2;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return stringArray;
        }
    }

    public static String[] rexpToStringsNArm(REXP rEXP, String[] stringArray) {
        String[] stringArray2 = RClient.rexpToStrings(rEXP, stringArray, null);
        if (stringArray2 == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i] != null) continue;
            ++n;
        }
        if (n > 0) {
            String[] stringArray3 = new String[stringArray2.length - n];
            int n2 = 0;
            for (int i = 0; i < stringArray2.length && n2 < stringArray3.length; ++i) {
                if (stringArray2[i] == null) continue;
                stringArray3[n2] = stringArray2[i];
                ++n2;
            }
            return stringArray3;
        }
        return stringArray2;
    }

    public static Double rexpToDouble(REXP rEXP, Double d) {
        if (rEXP == null || !rEXP.isNumeric()) {
            return d;
        }
        try {
            return rEXP.asDouble();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return d;
        }
    }

    public static double[] rexpToDoubles(REXP rEXP, double[] dArray) {
        if (rEXP == null || !rEXP.isNumeric()) {
            return dArray;
        }
        try {
            return rEXP.asDoubles();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return dArray;
        }
    }

    public static Integer rexpToInteger(REXP rEXP, Integer n) {
        if (rEXP == null || !rEXP.isInteger()) {
            return n;
        }
        try {
            return rEXP.asInteger();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return n;
        }
    }

    public static int[] rexpToIntegers(REXP rEXP, int[] nArray) {
        if (rEXP == null || !rEXP.isInteger()) {
            return nArray;
        }
        try {
            return rEXP.asIntegers();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return nArray;
        }
    }

    public static byte[] rexpToLogicalBytes(REXP rEXP, byte[] byArray) {
        if (rEXP == null || !rEXP.isLogical()) {
            return byArray;
        }
        try {
            return rEXP.asBytes();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return byArray;
        }
    }

    public static RList rexpToRList(REXP rEXP) {
        if (rEXP == null || !rEXP.isList() || rEXP.isNull()) {
            return null;
        }
        try {
            return rEXP.asList();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return null;
        }
    }

    public static boolean isError(REXP rEXP) {
        if (rEXP == null) {
            return true;
        }
        REXP rEXP2 = rEXP.getAttribute("class");
        if (rEXP2 != null && rEXP2.isString()) {
            try {
                if ("try-error".equals(rEXP2.asString())) {
                    return true;
                }
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getNativeEncoding() {
        return this.nativeEncoding;
    }

    public String getVersion() {
        REXP rEXP = this.timeoutEvalGet("try(R.version.string, silent=TRUE)", 1000L);
        return RClient.rexpToString(rEXP, "");
    }

    public String getRflowEnvCommand() {
        return "as.environment(\"" + this.getEnv() + "\")";
    }

    public String assignInRflowEnv(String string, String string2) {
        return "assign(x = " + string + ", value = " + string2 + ", envir = " + this.getRflowEnvCommand() + ")";
    }

    public String get(String string) {
        return "get(" + RUtility.quote(string) + ", envir=" + this.getRflowEnvCommand() + ")";
    }

    public boolean isErrorOccurred() {
        REXP rEXP = this.silentIdleEvalGet(this.get(".rflowErrorObject"));
        return rEXP != null && !rEXP.isNull();
    }

    public void clearErrorObject() {
        this.silentIdleEval(this.assignInRflowEnv(RUtility.quote(".rflowErrorObject"), "NULL"));
    }

    public void setRecover(boolean bl) {
        this.silentIdleEval(this.assignInRflowEnv(RUtility.quote(".rflowRecover"), RUtility.toRBoolean(bl)));
    }

    public String getContinuePrompt() {
        REXP rEXP = this.silentIdleEvalGet("getOption(\"continue\")");
        return RClient.rexpToString(rEXP, "+ ");
    }

    public String checkBrowserCommand() {
        return this.silent(".rflowCheckBrowser(" + this.getRflowEnvCommand() + ")");
    }

    public int isBrowser_Wait() {
        REXP rEXP = this.silentEvalGet(this.get(".rflowBrowserObject"));
        if (rEXP == null || rEXP.isNull()) {
            return 0;
        }
        String string = RClient.rexpToString(rEXP, null);
        return string != null && string.equals(".rflowRecover") ? 2 : 1;
    }

    public String getPreviewEnv(String string) {
        if (string == null) {
            return PREVIEW_ENV;
        }
        return ".PREVIEW_ENV$" + string;
    }

    public RObject getPreviewEnvObject(String string) {
        return RObject.environment(this.getPreviewEnv(string)).build();
    }

    public String createNewPreviewEnv() {
        String string = null;
        while (string == null) {
            String string2 = RandomStringUtils.randomAlphabetic((int)8);
            REXP rEXP = this.silentTimeoutEvalGet("exists(" + RUtility.quote(string2) + ", envir = .PREVIEW_ENV)");
            if (RClient.rexpToBoolean(rEXP, true).booleanValue()) continue;
            string = string2;
        }
        this.silentTimeoutEval("assign(\"" + string + "\", new.env(), envir=.PREVIEW_ENV)");
        return string;
    }

    public void recreatePreviewEnv(String string) {
        this.silentTimeoutEval("assign(\"" + string + "\", NULL, envir=.PREVIEW_ENV)");
        this.silentTimeoutEval("assign(\"" + string + "\", new.env(), envir=.PREVIEW_ENV)");
    }

    public void clearPreviewEnv(String string) {
        this.silentTimeoutEval("rm(" + string + ", envir=.PREVIEW_ENV)");
    }

    public String getWorkingDirectory() {
        REXP rEXP = this.silentTimeoutEvalGet("ifelse(Encoding(getwd())==\"UTF-8\", iconv(getwd(), \"UTF-8\", localeToCharset()), getwd())");
        return RClient.rexpToString(rEXP, null);
    }

    public String getCurrentCall() {
        REXP rEXP = this.silentIdleEvalGet(this.get(".rflowCurrentCall"));
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return null;
        }
        REXP rEXP2 = rList.at(0);
        String[] stringArray = RClient.rexpToStrings(rEXP2, null, null);
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        return stringArray[0];
    }

    public String[] getCurrentCalls() {
        REXP rEXP = this.silentIdleEvalGet(this.get(".rflowCurrentCall"));
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < rList.size(); ++i) {
            REXP rEXP2 = rList.at(i);
            String[] stringArray = RClient.rexpToStrings(rEXP2, null, "");
            if (stringArray == null || stringArray.length < 1) {
                return null;
            }
            arrayList.add(stringArray[0]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void clearBrowserObject() {
        this.silentIdleEval(this.assignInRflowEnv(RUtility.quote(".rflowBrowserObject"), "NULL"));
    }

    public void clearDebugEnv() {
        this.silentIdleEval(this.assignInRflowEnv(RUtility.quote(".rflowDebugEnvironment"), "NULL"));
    }

    public void setDebugConstant_Wait(boolean bl) {
        this.silentEval(this.assignInRflowEnv(RUtility.quote(".RFLOW_DEBUG"), RUtility.toRBoolean(bl)));
    }

    public String checkSyntax(String string) {
        if (string.isEmpty() || !this.initialized) {
            return null;
        }
        String string2 = RUtility.quote(string);
        StringBuilder stringBuilder = new StringBuilder(38 + string2.length());
        stringBuilder.append(".rflowCheckSyntax(");
        stringBuilder.append(string2);
        if (!this.canDebuggingState) {
            stringBuilder.append(", debugState = TRUE");
        }
        stringBuilder.append(")");
        REXP rEXP = this.idleEvalGet(stringBuilder.toString());
        if (rEXP == null || !rEXP.isString()) {
            return null;
        }
        try {
            return rEXP.asString();
        }
        catch (REXPMismatchException rEXPMismatchException) {
            return null;
        }
    }

    public RObjectNameSet supportList(String string) {
        if (string == null) {
            return null;
        }
        REXP rEXP = this.silentIdleEvalGet(".rflowSupportCommand(\"" + string + "\")");
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return null;
        }
        String[] stringArray = RClient.rexpToStrings(rList.at(0), null, "");
        if (stringArray == null) {
            return null;
        }
        String string2 = RClient.rexpToString(rList.at("namespace"), null);
        if (string2 != null) {
            return new RObjectNameSet(stringArray, string2);
        }
        int[] nArray = RClient.rexpToIntegers(rList.at(1), null);
        String[] stringArray2 = RClient.rexpToStrings(rList.at(2), null, "");
        if (stringArray == null || nArray == null || stringArray2 == null) {
            return null;
        }
        return new RObjectNameSet(stringArray, nArray, stringArray2);
    }

    public String[] names(String string, boolean bl, String string2) {
        return this.getNames(string, bl, "", string2);
    }

    public String[] factorLikeColumns(String string, boolean bl, String string2) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        REXP rEXP = this.silentIdleEvalGet(RUtility.function(".rflowFactorLikeColumns", "x", string, "check.names", RUtility.toRBoolean(bl)));
        return RClient.rexpToStrings(rEXP, ArrayUtils.EMPTY_STRING_ARRAY, string2);
    }

    public String[] getNames(String string, boolean bl, String string2, String string3) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        REXP rEXP = this.silentIdleEvalGet(RUtility.function(".rflowGetNames", "x", string, "check.names", RUtility.toRBoolean(bl), "filter", string2));
        return RClient.rexpToStrings(rEXP, ArrayUtils.EMPTY_STRING_ARRAY, string3);
    }

    public ArgList argListChar(String string) {
        return this.argList(RUtility.quote(string));
    }

    public ArgList argList(String string) {
        if (!RClient.checkCommandString(string)) {
            return null;
        }
        REXP rEXP = this.silentIdleEvalGet(".rflowGetFormals(" + string + ")");
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return null;
        }
        ArgList argList = new ArgList();
        String[] stringArray = rList.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            REXP rEXP2 = rList.at(i);
            Object[] objectArray = RClient.rexpToStrings(rEXP2, null, "");
            if (objectArray == null) {
                return null;
            }
            String string3 = StringUtils.join((Object[])objectArray, (String)"\n");
            argList.add(new ArgEntry(string2, string3.trim()));
        }
        return argList;
    }

    public String[] getAllVars(String string) {
        if (!RClient.checkCommandString(string)) {
            return null;
        }
        REXP rEXP = this.silentIdleEvalGet("all.vars(expression(" + string + "))");
        return RClient.rexpToStringsNArm(rEXP, null);
    }

    public String[] getLocalVariables(String string) {
        if (!RClient.checkCommandString(string)) {
            return null;
        }
        REXP rEXP = this.silentIdleEvalGet(".rflowFindLocals(" + string + ")");
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return null;
        }
        return RClient.rexpToStringsNArm(rList.at("variables"), null);
    }

    public String[] getForElements(String string) {
        REXP rEXP = this.silentIdleEvalGet(".rflowForElements(" + RUtility.quote(string) + ")");
        String[] stringArray = RClient.rexpToStringsNArm(rEXP, null);
        if (stringArray != null && stringArray.length != 2) {
            stringArray = null;
        }
        return stringArray;
    }

    public String getClearObjectsCommand() {
        return ".clearObjects()";
    }

    public String[] getObjectsFiltered(String string) {
        REXP rEXP = this.silentIdleEvalGet(".rflowGetObjectsFiltered(FILTERFUN=" + string + ")");
        return RClient.rexpToStringsNArm(rEXP, null);
    }

    public Integer getLength(String string) {
        REXP rEXP = this.silentTimeoutEvalGet(".rflowGetLength(" + string + ")");
        return RClient.rexpToInteger(rEXP, null);
    }

    public boolean isGlobalObject(String string) {
        REXP rEXP = this.silentIdleEvalGet(RUtility.quote(string) + " %in% ls()");
        return RClient.rexpToBoolean(rEXP, false);
    }

    private String debugEnv() {
        return this.getRflowEnvCommand() + "$.rflowDebugEnvironment[[1]]";
    }

    public boolean isDebugEnvObject(String string) {
        REXP rEXP = this.silentIdleEvalGet(RUtility.quote(string) + " %in% ls(envir=" + this.debugEnv() + ")");
        return RClient.rexpToBoolean(rEXP, false);
    }

    private RObject rexp2RObject(REXP rEXP, RObject rObject, String string, boolean bl, int n) {
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return null;
        }
        String string2 = RClient.rexpToString(rList.at("type"), null);
        String[] stringArray = RClient.rexpToStrings(rList.at("class"), null, "");
        String[] stringArray2 = RClient.rexpToStrings(rList.at("newclass"), null, "");
        Integer n2 = RClient.rexpToInteger(rList.at("flag"), null);
        int[] nArray = RClient.rexpToIntegers(rList.at("dim"), null);
        String string3 = RClient.rexpToString(rList.at("tip"), null);
        Boolean bl2 = RClient.rexpToBoolean(rList.at("validname"), null);
        String string4 = RClient.rexpToString(rList.at("pointer"), null);
        if (string2 == null || stringArray == null || n2 == null || nArray == null || string3 == null || bl2 == null) {
            return null;
        }
        RList rList2 = RClient.rexpToRList(rList.at("exInfo"));
        RObject rObject2 = new RObject(rObject, string, string2, stringArray, stringArray2, n2, nArray, string3, bl2, string4, bl, n, false, rList2, null);
        rObject2.setChildren(this.rexpToRObjects(rList.at("children"), rObject2, 0));
        return rObject2;
    }

    public RObject updateObject(RObject rObject) {
        REXP rEXP = this.silentIdleEvalGet(RUtility.function(".rflowGetObject", "obj", rObject.getFullName(), "name", rObject.isIndexName() ? rObject.getName(false) : RUtility.quote(rObject.getName(false))));
        if (rEXP == null) {
            return null;
        }
        RObject rObject2 = this.rexp2RObject(rEXP, rObject.getParent(), rObject.getName(false), rObject.isIndexName(), rObject.getIndex());
        if (rObject2 != null) {
            rObject2.setDisplayName(rObject.getDisplayName());
        }
        return rObject2;
    }

    public RObject getObject(RObject rObject, String string) {
        RObject rObject2 = RObject.builder(string).setParent(rObject).build();
        return this.updateObject(rObject2);
    }

    public RObject getObject(String string) {
        return this.getObject(string, false);
    }

    public RObject getObject(String string, boolean bl) {
        string = RUtility.removeBackticks(string);
        REXP rEXP = bl ? this.silentIdleEvalGet(RUtility.function(".rflowGetObject", "parent", this.debugEnv(), "fullName", RUtility.quote(string), "name", RUtility.quote(string))) : this.silentIdleEvalGet(RUtility.function(".rflowGetObject", "obj", string, "name", RUtility.quote(string)));
        if (rEXP == null) {
            return null;
        }
        RObject rObject = null;
        if (bl) {
            rObject = RObject.environment(this.debugEnv()).build();
        }
        return this.rexp2RObject(rEXP, rObject, string, false, 0);
    }

    public RObjectSet getObjects(RObject rObject, boolean bl, int n) {
        return this.getObjects(rObject, bl, n, 0, 0);
    }

    private List<RObject> rexpToRObjects(REXP rEXP, RObject rObject, int n) {
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<RObject> arrayList = new ArrayList<RObject>();
        Vector vector = rList.names;
        boolean bl = vector != null;
        boolean bl2 = rObject != null && rObject.getType().equals("list");
        boolean bl3 = false;
        for (int i = 0; i < rList.size(); ++i) {
            RObject rObject2;
            boolean bl4;
            String string = bl ? (String)vector.get(i) : String.valueOf(i + n + 1);
            boolean bl5 = StringUtils.isEmpty((CharSequence)string);
            boolean bl6 = bl4 = !bl || bl5;
            if (bl2 && bl && !bl3 && !bl5 && !hashSet.add(string)) {
                bl3 = true;
            }
            if (bl5) {
                string = String.valueOf(i + n + 1);
            }
            if ((rObject2 = this.rexp2RObject(rList.at(i), rObject, string, bl4, i + n + 1)) == null) continue;
            arrayList.add(rObject2);
        }
        return arrayList;
    }

    public RObjectSet getObjects(RObject rObject, boolean bl, int n, int n2, int n3) {
        int n4;
        REXP rEXP;
        RList rList;
        String string = null;
        if (rObject != null) {
            if (rObject.isAtomic()) {
                return null;
            }
            string = rObject.getFullName();
        }
        if ((rList = RClient.rexpToRList(rEXP = this.silentTimeoutEvalGet(RUtility.function(".rflowGetObjects", "parent", string, "all.names", RUtility.toRBoolean(bl), "limit", String.valueOf(n), "offset", String.valueOf(n2), "depth", Integer.toString(n3))))) == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<RObject> arrayList = new ArrayList<RObject>();
        Vector vector = rList.names;
        boolean bl2 = vector != null;
        boolean bl3 = rObject != null && rObject.getType().equals("list");
        boolean bl4 = false;
        for (n4 = 0; n4 < rList.size(); ++n4) {
            RObject rObject2;
            boolean bl5;
            String string2 = bl2 ? (String)vector.get(n4) : String.valueOf(n4 + n2 + 1);
            boolean bl6 = StringUtils.isEmpty((CharSequence)string2);
            boolean bl7 = bl5 = !bl2 || bl6;
            if (bl3 && bl2 && !bl4 && !bl6 && !hashSet.add(string2)) {
                bl4 = true;
            }
            if (bl6) {
                string2 = String.valueOf(n4 + n2 + 1);
            }
            if ((rObject2 = this.rexp2RObject(rList.at(n4), rObject, string2, bl5, n4 + n2 + 1)) == null) continue;
            arrayList.add(rObject2);
        }
        n4 = arrayList.size();
        int n5 = rList.size() - n4;
        REXP rEXP2 = rEXP.getAttribute("overlimit");
        Integer n6 = RClient.rexpToInteger(rEXP2, 0);
        if (n6 > 0) {
            n4 = n6;
        }
        n4 -= n5;
        if (bl3) {
            rObject.setDuplicateName(bl4);
        }
        return new RObjectSet(arrayList, n2, n, n4);
    }

    public void addExtendedInfoFunction(String string) {
        this.silentEval(RUtility.function(".rflowAddExtendedInfoFunction", "f", string));
    }

    public String[] getInstalledPackages() {
        if (Rflow.getInstance().isBusy()) {
            return this.getInstalledPackagesCached();
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        if (this.lastPackageUpdateTime != null && localDateTime.isBefore(this.lastPackageUpdateTime.plusSeconds(3L))) {
            return this.getInstalledPackagesCached();
        }
        this.updateInstalledPackages(true);
        return this.getInstalledPackagesCached();
    }

    private String[] getInstalledPackagesCached() {
        return this.installedPackagesCache == null ? ArrayUtils.EMPTY_STRING_ARRAY : this.installedPackagesCache.toArray(new String[this.installedPackagesCache.size()]);
    }

    public List<String> getMissingPackages(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getInstalledPackages();
        if (stringArray != null && stringArray2.length > 0) {
            List<String> list = Arrays.asList(stringArray2);
            for (String string : stringArray) {
                if (list.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public void updateInstalledPackages(boolean bl) {
        REXP rEXP;
        String string = ".packages(all.available=TRUE)";
        if (bl) {
            rEXP = this.silentTimeoutEvalGet(string, 500L);
            this.userLib = RClient.rexpToString(this.silentTimeoutEvalGet(".getUserLibraryPathIfNeeded()", 500L), null);
        } else {
            rEXP = this.silentEvalGet(string);
            this.userLib = RClient.rexpToString(this.silentEvalGet(".getUserLibraryPathIfNeeded()"), null);
        }
        Object[] objectArray = RClient.rexpToStringsNArm(rEXP, null);
        if (objectArray != null) {
            Set<String> set = this.installedPackagesCache;
            HashSet hashSet = Sets.newHashSet((Object[])objectArray);
            if (!hashSet.equals(set)) {
                this.installedPackagesCache = hashSet;
                EventManager.getInstance().dispatchEvent(new RPackageListChangeEvent());
            }
            this.lastPackageUpdateTime = LocalDateTime.now();
        }
    }

    public void updateAvailablePackagesFile() {
        if (this.availablePackagesUpdated) {
            return;
        }
        ThreadUtility.execute(() -> {
            Object object = RClient.rexpToString(this.silentTimeoutEvalGet("contrib.url(repos = getOption(\"repos\")[1], type = getOption(\"pkgType\"))"), null);
            if (object == null) {
                return;
            }
            String string = "PACKAGES.gz";
            object = (String)object + "/" + string;
            Path path = UserFolder.getUserDirFile("R/packages").toPath();
            Path path2 = path.resolve(string);
            Path path3 = path.resolve("PACKAGESlm");
            try {
                Date date;
                Object object2;
                Date date2 = null;
                if (Files.exists(path3, new LinkOption[0]) && (object2 = Files.readAllLines(path3, StandardCharsets.UTF_8)).size() > 0) {
                    try {
                        date2 = new Date(Long.valueOf((String)object2.get(0)));
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Invalid last modified time", exception);
                    }
                }
                object2 = new URL((String)object);
                if (date2 != null && Files.exists(path2, new LinkOption[0]) && !(date = new Date(((URL)object2).openConnection().getLastModified())).after(date2)) {
                    this.availablePackagesUpdated = true;
                    return;
                }
                FileUtility.safeSave(path3, path, new SaveToFile(){
                    final /* synthetic */ URL val$u;
                    {
                        this.val$u = uRL;
                    }

                    @Override
                    public void save(Path path) throws IOException {
                        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                            bufferedWriter.append(Long.toString(this.val$u.openConnection().getLastModified()));
                        }
                    }
                });
                FileUtility.safeSave(path2, path, new SaveToFile(){
                    final /* synthetic */ URL val$u;
                    {
                        this.val$u = uRL;
                    }

                    @Override
                    public void save(Path path) throws IOException {
                        try (InputStream inputStream = this.val$u.openStream();){
                            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                });
                this.availablePackagesUpdated = true;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Failed to save " + string, iOException);
            }
        });
    }

    public List<String> getAvailablePackages() {
        ArrayList<String> arrayList;
        Path path = UserFolder.getUserDirFile("R/packages/PACKAGES.gz").toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return new ArrayList<String>(0);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]), 1024), StandardCharsets.UTF_8));
        try {
            String string;
            ArrayList<String> arrayList2 = new ArrayList<String>(0);
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("Package:")) continue;
                arrayList2.add(string.substring("Package: ".length()).trim());
            }
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return new ArrayList<String>(0);
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    public String getUserLibraryPath() {
        return this.userLib;
    }

    public String[] getDatasets(String string) {
        if (!StringUtils.isEmpty((CharSequence)string) && (string.equals("\"base\"") || string.equals("\"stats\""))) {
            return null;
        }
        REXP rEXP = this.silentTimeoutEvalGet("suppressWarnings(" + RUtility.function("data", "package", string) + "$results)");
        return RClient.rexpToStringsNArm(rEXP, null);
    }

    public String evalToString(String string) {
        REXP rEXP = this.silentTimeoutEvalGet(string);
        return RClient.rexpToString(rEXP, null);
    }

    public boolean exists(String string, String string2) {
        REXP rEXP = this.silentTimeoutEvalGet(RUtility.function("exists", new String[]{"x", RUtility.quote(string), "envir", string2 == null ? "" : "getNamespace(" + RUtility.quote(string2) + ")"}));
        return RClient.rexpToBoolean(rEXP, false);
    }

    public Boolean exists(RObject rObject) {
        RObject rObject2 = rObject.getParent();
        String string = rObject2 == null ? "exists(" + RUtility.quote(rObject.getName(false)) + ")" : RUtility.quote(rObject.getName(false)) + " %in% names(" + rObject2.getFullName() + ")";
        return RClient.rexpToBoolean(this.silentTimeoutEvalGet(string), null);
    }

    public boolean isAtomicLengthOne(String string) {
        REXP rEXP = this.silentTimeoutEvalGet("is.atomic(" + string + ") && length(" + string + ") <= 1");
        return RClient.rexpToBoolean(rEXP, true);
    }

    public boolean isHelp(String string, String string2) {
        String string3 = RUtility.function("help", "topic", RUtility.quote(string), "package", string2 == null ? "" : RUtility.quote(string2));
        REXP rEXP = this.silentTimeoutEvalGet("length(" + string3 + ") == 0");
        return RClient.rexpToBoolean(rEXP, true) == false;
    }

    public String getHtmlHelp(String string, boolean bl) {
        String string2 = RUtility.function(".rflowGetHtmlHelp", "topic", RUtility.quote(string), "dynamic", RUtility.toRBoolean(bl));
        REXP rEXP = this.silentTimeoutEvalGet(string2);
        String[] stringArray = RClient.rexpToStrings(rEXP, null, null);
        if (stringArray == null || stringArray.length <= 1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean isFunction(String string) {
        REXP rEXP = this.silentIdleEvalGet(RUtility.function("is.function", "", string));
        return RClient.rexpToBoolean(rEXP, false);
    }

    public boolean isDataframe(String string) {
        String string2 = RUtility.function("get", "", RUtility.quote(string));
        String string3 = RUtility.function("is.data.frame", "", string2);
        REXP rEXP = this.silentIdleEvalGet(string3);
        return RClient.rexpToBoolean(rEXP, false);
    }

    public String makenames(String string) {
        REXP rEXP = this.silentIdleEvalGet("make.names(\"" + string + "\")");
        return RClient.rexpToString(rEXP, null);
    }

    public String[] readHeader(File file, String string) {
        REXP rEXP = this.silentIdleEvalGet(RUtility.function("scan", "file", RUtility.quotedPath(file.getAbsolutePath()), "sep", RUtility.quote(string), "nlines", "1", "what", RUtility.EMPTY_STRING, "na.strings", RUtility.EMPTY_STRING, "quiet", "TRUE"));
        return RClient.rexpToStrings(rEXP, null, "");
    }

    public String[] getMethodRank(String[] stringArray, String[] stringArray2) {
        REXP rEXP = this.silentIdleEvalGet(RUtility.function(".rflowMethodRank", "classes", RUtility.combineCharactersBase(stringArray), "methods", RUtility.combineCharactersBase(stringArray2)));
        return RClient.rexpToStrings(rEXP, stringArray2, "");
    }

    public String captureOutput(String string) {
        REXP rEXP = this.silentTimeoutEvalGet(RUtility.function("capture.output", "", string));
        String[] stringArray = RClient.rexpToStrings(rEXP, null, null);
        if (stringArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (string2 == null) continue;
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public boolean setWD(String string) {
        REXP rEXP = this.silentTimeoutEvalGet(RClient.errorCheckCommand("setwd(\"" + string + "\")"), 5000L);
        return RClient.rexpToBoolean(rEXP, true) == false;
    }

    public void setConsoleWidth(int n) {
        this.silentIdleEval("options(width=" + n + ")");
    }

    @Deprecated
    public boolean isOpeningDevice_Wait() {
        REXP rEXP = this.silentEvalGet("dev.cur() != 1");
        return RClient.rexpToBoolean(rEXP, false);
    }

    public boolean isDebugCommand(String string) {
        string = string.trim();
        return string.equals(this.getDebugCommand());
    }

    public String getDebugCommand() {
        return "browser(expr=ifelse(" + RUtility.quote(this.getEnv()) + " %in% search(), .RFLOW_DEBUG, FALSE)) #inserted for debug";
    }

    public Optional<String[]> getConnectionInfo(String string) {
        REXP rEXP = this.silentIdleEvalGet(RUtility.func(".rflowGetConnectionInfo", string));
        RList rList = RClient.rexpToRList(rEXP);
        if (rList == null) {
            return Optional.empty();
        }
        String string2 = RClient.rexpToString(rList.at("description"), null);
        String string3 = RClient.rexpToString(rList.at("class"), null);
        if (string2 == null || string3 == null) {
            return Optional.empty();
        }
        return Optional.of(new String[]{string2, string3});
    }

    public Optional<String> getPkgType() {
        if (this.pkgType == null) {
            this.pkgType = RClient.rexpToString(this.silentTimeoutEvalGet(".Platform$pkgType"), null);
        }
        return Optional.ofNullable(this.pkgType);
    }

    public SentenceInfo[] parseToNodes(File file, boolean bl) {
        return this.parseToNodesInternal(null, file, bl);
    }

    public SentenceInfo[] parseToNodes(String string, boolean bl) {
        return this.parseToNodesInternal(string, null, bl);
    }

    private SentenceInfo[] parseToNodesInternal(String string, File file, boolean bl) {
        REXP rEXP;
        String[] stringArray;
        if (string != null) {
            stringArray = string.split("\n");
            if (stringArray.length == 0) {
                return null;
            }
            rEXP = this.silentIdleEvalGet("parseToNodes(" + RUtility.combineCharactersBase(stringArray) + ", keep.source=" + RUtility.toRBoolean(bl) + ")");
        } else if (file != null) {
            try {
                rEXP = this.silentIdleEvalGet("parseToNodes(file=" + RUtility.quotedPath(file.getCanonicalPath()) + ", keep.source=" + RUtility.toRBoolean(bl) + ")");
            }
            catch (IOException iOException) {
                return null;
            }
        } else {
            return null;
        }
        stringArray = RClient.rexpToRList(rEXP);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.size();
        SentenceInfo[] sentenceInfoArray = new SentenceInfo[n];
        for (int i = 0; i < n; ++i) {
            REXP rEXP2 = stringArray.at(i);
            RList rList = RClient.rexpToRList(rEXP2);
            if (rList == null) {
                return null;
            }
            REXP rEXP3 = rList.at(KEY_LINE);
            String string2 = RClient.rexpToString(rEXP3, null);
            if (string2 == null) {
                return null;
            }
            REXP rEXP4 = rList.at(KEY_SRCLINE);
            String string3 = RClient.rexpToString(rEXP4, null);
            REXP rEXP5 = rList.at(KEY_SRCREF);
            int[] nArray = RClient.rexpToIntegers(rEXP5, null);
            REXP rEXP6 = rList.at(KEY_CONTROL);
            boolean bl2 = RClient.rexpToBoolean(rEXP6, false);
            REXP rEXP7 = rList.at(KEY_FUNC);
            String string4 = RClient.rexpToString(rEXP7, "");
            REXP rEXP8 = rList.at(KEY_SYMBOL);
            String string5 = RClient.rexpToString(rEXP8, "");
            ArgList argList = new ArgList();
            REXP rEXP9 = rList.at(KEY_ARGS);
            RList rList2 = RClient.rexpToRList(rEXP9);
            if (rList2 != null) {
                Vector vector = rList2.names;
                boolean bl3 = vector != null && vector.size() > 0;
                for (int j = 0; j < rList2.size(); ++j) {
                    String string6 = bl3 ? vector.get(j).toString() : "";
                    REXP rEXP10 = rList2.at(j);
                    String string7 = RClient.rexpToString(rEXP10, null);
                    if (string7 == null) break;
                    argList.add(new ArgEntry(string6, string7.trim()));
                }
            }
            sentenceInfoArray[i] = new SentenceInfo(string2, string5, string4, bl2, argList, string3, nArray);
        }
        return sentenceInfoArray;
    }

    private static boolean checkCommandString(String string) {
        return string != null && string.trim().length() >= 1;
    }

    private static String errorCheckCommand(String string) {
        return "inherits(try(" + string + ", silent=TRUE), \"try-error\")";
    }

    public boolean gdResize(int n) {
        return this.silentIdleEval(".C(\"javaGDresize\", as.integer(" + n + "))");
    }

    public void gdDevOff_Wait(int n) {
        this.silentEval("dev.off(" + n + ")");
    }

    public void setGdSize(int n, int n2) {
        this.silentIdleEval(RUtility.function("assign", "", RUtility.quote(".RFLOW_GD_SIZE"), "", "c(" + n + ", " + n2 + ")", "envir", this.getRflowEnvCommand()));
    }

    public boolean isInstalledPackage(String string) {
        String[] stringArray = this.getInstalledPackages();
        return stringArray == null ? false : Arrays.asList(stringArray).contains(string);
    }

    public Map<String, String> getPackageVersions(String ... stringArray) {
        String string = RUtility.combineCharactersBase(stringArray);
        String string2 = "installed.packages()[which(rownames(installed.packages()) %in% " + string + "), 3]";
        REXP rEXP = this.timeoutEvalGet(string2, 500L);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray2 = RClient.rexpToStrings(rEXP, null, "");
        if (stringArray2 == null) {
            return hashMap;
        }
        REXP rEXP2 = rEXP.getAttribute("names");
        String[] stringArray3 = RClient.rexpToStrings(rEXP2, null, "");
        if (rEXP2 == null) {
            return hashMap;
        }
        int n = Math.min(stringArray2.length, stringArray3.length);
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray3[i], stringArray2[i]);
        }
        return hashMap;
    }

    public String[] findNewVariables(String string) {
        String[] stringArray = string.split("\n");
        if (stringArray.length == 0) {
            return null;
        }
        REXP rEXP = this.silentIdleEvalGet(RUtility.function(".rflowFindNewVariables", "text", RUtility.combineCharactersBase(stringArray)));
        return RClient.rexpToStringsNArm(rEXP, null);
    }

    public List<ItemName> findNewVariables(String string, String string2) {
        String[] stringArray = this.findNewVariables(string2);
        if (stringArray == null || stringArray.length == 0) {
            return new ArrayList<ItemName>();
        }
        ArrayList<ItemName> arrayList = new ArrayList<ItemName>(stringArray.length);
        for (String string3 : stringArray) {
            arrayList.add(new ItemName(string, string3));
        }
        return arrayList;
    }

    public String assignInViewEnv(String string) {
        return RClient.rexpToString(this.silentIdleEvalGet(".rflowAssignInViewEnv(" + string + ")"), null);
    }

    @Override
    public Item getItem(String string) {
        return null;
    }

    @Override
    public void addNewItem(String string) {
        this.itemManagerSupport.addNewItem(string);
    }

    @Override
    public void removeNewItem(String string) {
        this.itemManagerSupport.removeNewItem(string);
    }

    @Override
    public void clearNewItems() {
        this.itemManagerSupport.clearNewItems();
    }

    @Override
    public boolean isNewItem(String string) {
        return this.itemManagerSupport.isNewItem(string);
    }

    @Override
    public void addItemEventHandler(ItemEventHandler itemEventHandler) {
        this.itemManagerSupport.addItemEventHandler(itemEventHandler);
    }

    @Override
    public void removeItemEventHandler(ItemEventHandler itemEventHandler) {
        this.itemManagerSupport.removeItemEventHandler(itemEventHandler);
    }

    @Override
    public void dispatchItemEvent(ItemEvent itemEvent) {
        this.itemManagerSupport.dispatchItemEvent(itemEvent);
    }

    public void fireItemStructureChanged() {
        this.itemManagerSupport.dispatchItemEvent(this.structureChangedEvent);
    }
}

