/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.rosuda.REngine.RList;

public class RObject {
    public static final int FLAG_DATA_FRAME = 1;
    public static final int FLAG_MATRIX = 2;
    public static final int FLAG_ARRAY = 4;
    public static final String MORE_OBJECTS = "more objects";
    private static final Set<String> graphicClasses = Sets.newHashSet((Object[])new String[]{"trellis", "ggplot"});
    public static final String EX_INFO_NO_DIM = "no.dim";
    private RObject parent;
    private String name;
    private String type;
    private String[] clas;
    private String[] newClasses;
    private int flag;
    private int[] dim;
    private String tip;
    private boolean validName;
    private boolean indexName;
    private boolean indexObject;
    private int index;
    private String displayName;
    private boolean duplicateName = true;
    private String pointer;
    private RList extendedInfo;
    private List<RObject> children;

    public RObject(RObject rObject, String string, String string2, String[] stringArray, String[] stringArray2, int n, int[] nArray, String string3, boolean bl, String string4, boolean bl2, int n2, boolean bl3, RList rList, List<RObject> list) {
        this.parent = rObject;
        this.name = string;
        this.type = string2;
        this.clas = stringArray;
        this.newClasses = stringArray2;
        this.flag = n;
        this.dim = nArray;
        this.tip = string3;
        this.validName = bl;
        this.pointer = string4;
        this.indexName = bl2;
        this.indexObject = bl3;
        this.index = n2;
        this.extendedInfo = rList;
        this.children = list;
        this.init();
    }

    private void init() {
        if (this.dim == null || this.dim.length == 0) {
            this.dim = new int[]{1};
        }
        if (this.index != 0 && (this.parent == null || this.parent.type.equals("environment") || this.parent.type.equals("S4"))) {
            this.index = 0;
        }
        if (this.inherits("POSIXlt")) {
            this.type = "character";
        }
    }

    public String getClas() {
        if (this.clas == null) {
            return "";
        }
        return this.clas[0];
    }

    public String[] getClasses() {
        if (this.clas == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return this.clas;
    }

    public String[] getNewClasses() {
        return this.newClasses;
    }

    public boolean isIndexName() {
        return this.indexName;
    }

    public boolean isIndexObject() {
        return this.indexObject;
    }

    public boolean isValidName() {
        return this.validName;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.getName(true) : this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayTitle() {
        if (this.dim.length == 1 && this.dim[0] == 1 || this.noDim()) {
            return this.getDisplayName();
        }
        return this.getDisplayName() + " " + this.getDimString();
    }

    public String getName(boolean bl) {
        if (this.indexObject && this.parent != null) {
            return this.parent.getName(true) + this.name;
        }
        if (!bl || this.validName || this.indexName) {
            return this.name;
        }
        return RUtility.quoteWithBackticks(this.name);
    }

    public String getQuotedName() {
        return RUtility.quote(this.name);
    }

    public RObject getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public int getFlag() {
        return this.flag;
    }

    public boolean isFlag(int n) {
        return (this.flag & n) == n;
    }

    public int getIndex() {
        return this.index;
    }

    public String getTip() {
        return this.tip;
    }

    public int[] getDim() {
        return this.dim;
    }

    public String getDimString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.dim.length; ++i) {
            stringBuilder.append(this.dim[i]);
            if (i == this.dim.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String getPointer() {
        return this.pointer;
    }

    public String getFullName() {
        return this.getFullName(true);
    }

    public String getFullName(boolean bl) {
        if (this.parent == null) {
            return this.getName(true);
        }
        Object object = this.getName(true);
        object = this.indexObject ? ((String)object).substring(this.parent.getName(true).length(), ((String)object).length()) : (!this.isIndexName() ? (bl && this.getIndex() > 0 && this.parent.isDuplicateName() ? "[[" + this.getIndex() + "]]" : (this.parent.getType().equals("S4") ? "@" + (String)object : "$" + (String)object)) : "[[" + (String)object + "]]");
        return this.parent.getFullName() + (String)object;
    }

    public boolean isAtomic() {
        return !this.type.equals("pairlist") && !this.type.equals("list") && !this.type.equals("environment") && !this.type.equals("S4");
    }

    public void setDuplicateName(boolean bl) {
        this.duplicateName = bl;
    }

    public boolean isDuplicateName() {
        return this.duplicateName;
    }

    public void setChildren(List<RObject> list) {
        this.children = list;
    }

    public List<RObject> getChildren() {
        return this.children;
    }

    public boolean inherits(String string) {
        if (this.clas == null) {
            return false;
        }
        for (String string2 : this.clas) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean inherits(Set<String> set) {
        if (this.clas == null) {
            return false;
        }
        for (String string : this.clas) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean is(String string) {
        if (this.newClasses == null) {
            return false;
        }
        for (String string2 : this.newClasses) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean pointerEquals(RObject rObject) {
        if (this.pointer == null || rObject.pointer == null) {
            return false;
        }
        return this.pointer.equals(rObject.pointer);
    }

    public boolean isInPreviewEnv() {
        return this.getFullName().startsWith(".PREVIEW_ENV");
    }

    public String getIcon() {
        if (this.inherits("data.frame")) {
            return "16/table.png";
        }
        if (this.inherits(graphicClasses)) {
            return "16/chart_stock.png";
        }
        if (!this.isAtomic()) {
            return "16/text_list_bullets.png";
        }
        return "16/bullet_black.png";
    }

    private String getShortName() {
        Object object = this.name;
        if (this.parent != null && this.parent.getType().equals("S4")) {
            object = "@ " + (String)object;
        }
        if (((String)object).length() > 50) {
            object = ((String)object).substring(0, 50) + "...";
        }
        return object;
    }

    private String getTipString() {
        Object object = this.dim.length == 1 && this.dim[0] == 1 && this.isAtomic() || this.noDim() ? this.tip : this.getDimString();
        if (((String)object).length() > 50) {
            object = ((String)object).substring(0, 50) + "...";
        }
        return this.getClas() + " " + (String)object;
    }

    public String getHtmlString(boolean bl) {
        if (bl) {
            return "<html><u><font color=\"blue\">" + StringEscapeUtils.escapeHtml4((String)this.toString()) + "</font></u></html>";
        }
        return "<html>" + StringEscapeUtils.escapeHtml4((String)this.getShortName()) + "<font color=\"#4f71a8\"> : " + StringEscapeUtils.escapeHtml4((String)this.getTipString()) + "</font></html>";
    }

    public RList getExtendedInfo() {
        return this.extendedInfo;
    }

    private boolean noDim() {
        return this.getBooleanExtendedInfo(EX_INFO_NO_DIM, false);
    }

    public boolean getBooleanExtendedInfo(String string, boolean bl) {
        if (this.extendedInfo == null) {
            return bl;
        }
        return RClient.rexpToBoolean(this.extendedInfo.at(string), bl);
    }

    public String toString() {
        return this.getShortName() + " : " + this.getTipString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.indexName ? 1231 : 1237);
        n = 31 * n + (this.indexObject ? 1231 : 1237);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        n = 31 * n + this.index;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RObject)) {
            return false;
        }
        RObject rObject = (RObject)object;
        return Objects.equals(this.parent, rObject.parent) && Objects.equals(this.name, rObject.name) && Objects.equals(this.type, rObject.type) && this.indexObject == rObject.indexObject && this.indexName == rObject.indexName && this.index == rObject.index;
    }

    public int simpleHashCode() {
        return this.name == null ? 0 : this.name.hashCode() + this.index;
    }

    public boolean simpleEquals(RObject rObject) {
        return Objects.equals(this.name, rObject.name) && this.index == rObject.index;
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    public static Builder environment(String string) {
        return new Builder(string).setType("environment").setClasses("environment").setNewClasses("environment", "refObject");
    }

    public static class Builder {
        private RObject obj;

        public Builder(String string) {
            this.obj = new RObject(null, string, null, null, null, 0, null, "", true, null, false, 0, false, null, null);
        }

        public RObject build() {
            this.obj.init();
            return this.obj;
        }

        public Builder setParent(RObject rObject) {
            this.obj.parent = rObject;
            return this;
        }

        public Builder setName(String string) {
            this.obj.name = string;
            return this;
        }

        public Builder setType(String string) {
            this.obj.type = string;
            return this;
        }

        public Builder setClasses(String ... stringArray) {
            this.obj.clas = stringArray;
            return this;
        }

        public Builder setNewClasses(String ... stringArray) {
            this.obj.newClasses = stringArray;
            return this;
        }

        public Builder setFlag(int n) {
            this.obj.flag = n;
            return this;
        }

        public Builder setDim(int ... nArray) {
            this.obj.dim = nArray;
            return this;
        }

        public Builder setTip(String string) {
            this.obj.tip = string;
            return this;
        }

        public Builder setValidName(boolean bl) {
            this.obj.validName = bl;
            return this;
        }

        public Builder setIndexObject(boolean bl) {
            this.obj.indexObject = bl;
            return this;
        }

        public Builder setExtendedInfo(RList rList) {
            this.obj.extendedInfo = rList;
            return this;
        }
    }
}

