/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.RObjectName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class RObjectNameSet
implements Iterable<RObjectName> {
    private static final Comparator<RObjectName> DEFAULT_SORTER = new DefaultSorter();
    private List<RObjectName> objectNames;

    public RObjectNameSet(String[] stringArray, int[] nArray, String[] stringArray2) {
        int n;
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException();
        }
        stringArray2[0] = "global";
        for (n = 1; n < stringArray2.length; ++n) {
            stringArray2[n] = stringArray2[n].replaceFirst("package:", "");
        }
        this.objectNames = new ArrayList<RObjectName>();
        for (n = 0; n < stringArray.length; ++n) {
            this.objectNames.add(new RObjectName(stringArray[n], nArray[n], stringArray2[nArray[n] - 1]));
        }
    }

    public RObjectNameSet(String[] stringArray, String string) {
        this.objectNames = new ArrayList<RObjectName>();
        for (int i = 0; i < stringArray.length; ++i) {
            this.objectNames.add(new RObjectName(stringArray[i], -1, string));
        }
    }

    @Override
    public Iterator<RObjectName> iterator() {
        return this.objectNames.iterator();
    }

    public String[] getNames() {
        String[] stringArray = new String[this.getLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.objectNames.get(i).getName();
        }
        return stringArray;
    }

    public List<RObjectName> getObjectNames() {
        return this.objectNames;
    }

    public void addObjectName(RObjectName rObjectName) {
        this.objectNames.add(rObjectName);
    }

    public int getLength() {
        return this.objectNames.size();
    }

    public void sort() {
        Collections.sort(this.objectNames, DEFAULT_SORTER);
    }

    private static class DefaultSorter
    implements Comparator<RObjectName> {
        private DefaultSorter() {
        }

        @Override
        public int compare(RObjectName rObjectName, RObjectName rObjectName2) {
            if (rObjectName.getSearchIndex() == 1) {
                if (rObjectName2.getSearchIndex() != 1) {
                    return -1;
                }
            } else if (rObjectName2.getSearchIndex() == 1) {
                return 1;
            }
            return rObjectName.getName().compareTo(rObjectName2.getName());
        }
    }
}

