/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.RObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RObjectSet {
    private List<RObject> objects;
    private int offset;
    private int limit;
    private int size;
    private List<RObject> extraObjects;

    public static RObjectSet createEmptySet() {
        return new RObjectSet(new ArrayList<RObject>(0), 0, 0, 0);
    }

    public RObjectSet(List<RObject> list, int n, int n2, int n3) {
        this.objects = list;
        this.offset = n;
        this.limit = n2;
        this.size = n3;
    }

    public List<RObject> getObjects() {
        return this.objects;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isLimitExceeded() {
        return this.offset + this.objects.size() < this.size;
    }

    public int getExceededCount() {
        return Math.max(0, this.size - this.offset - this.objects.size());
    }

    public void addExtraObjects(List<RObject> list) {
        if (this.extraObjects == null) {
            this.extraObjects = new ArrayList<RObject>(list);
        } else {
            this.extraObjects.addAll(list);
        }
    }

    public List<RObject> getExtraObjects() {
        return this.extraObjects;
    }

    public Iterator<RObject> treeIterator() {
        return new TreeIterator();
    }

    private class TreeIterator
    implements Iterator<RObject> {
        private ArrayDeque<RObject> deque = new ArrayDeque();

        public TreeIterator() {
            for (int i = RObjectSet.this.objects.size() - 1; i >= 0; --i) {
                this.deque.addLast(RObjectSet.this.objects.get(i));
            }
        }

        @Override
        public RObject next() {
            RObject rObject = this.deque.removeLast();
            List<RObject> list = rObject.getChildren();
            if (list != null) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    this.deque.addLast(list.get(i));
                }
            }
            return rObject;
        }

        @Override
        public boolean hasNext() {
            return !this.deque.isEmpty();
        }
    }
}

