/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.ROperation;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowUtil;
import com.ef_prime.rflow.core.flow.task.NodeTask;
import com.ef_prime.rflow.core.flow.task.NodeTaskGroup;
import com.ef_prime.rflow.node.NodeModel;
import com.ef_prime.rflow.node.base.FreeNodeModel;
import com.ef_prime.rflow.node.base.SubflowNodeModel;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.resource.Messages;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.rosuda.REngine.REXP;

public class RPackage
implements Comparable<RPackage> {
    private String name;
    private boolean required;
    private boolean attach;

    public RPackage(String string) {
        this(string, true, false);
    }

    public RPackage(String string, boolean bl, boolean bl2) {
        this.name = string;
        this.required = bl;
        this.attach = bl2;
    }

    public static List<String> getMissingPackages(String[] stringArray, NodeModel nodeModel) {
        return RPackage.getMissingPackages(stringArray, RPackage.getRPackages(nodeModel));
    }

    public static List<String> getMissingPackages(String[] stringArray, RPackage[] rPackageArray) {
        if (ArrayUtils.isEmpty((Object[])rPackageArray)) {
            return Collections.EMPTY_LIST;
        }
        HashSet hashSet = Sets.newHashSet((Object[])stringArray);
        ArrayList<String> arrayList = new ArrayList<String>(rPackageArray.length);
        for (int i = 0; i < rPackageArray.length; ++i) {
            String string = rPackageArray[i].getName();
            if (hashSet.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static RPackage[] getRPackages(NodeModel nodeModel) {
        List<RPackage> list = nodeModel.getRequiredPackageList();
        return list.toArray(new RPackage[list.size()]);
    }

    public static RPackage[] getRPackages(Operation operation) {
        if (operation instanceof ROperation) {
            return ((ROperation)operation).getRPackages();
        }
        return null;
    }

    public static RPackage[] getRPackages(NodeTask nodeTask, boolean bl) {
        if (nodeTask instanceof NodeTaskGroup) {
            TreeSet<RPackage> treeSet = new TreeSet<RPackage>();
            List<NodeTask> list = ((NodeTaskGroup)nodeTask).getTaskEntrys();
            for (NodeTask nodeTask2 : list) {
                RPackage[] rPackageArray;
                for (RPackage object2 : rPackageArray = RPackage.getRPackages(nodeTask2, bl)) {
                    treeSet.add(object2);
                }
            }
            return treeSet.toArray(new RPackage[treeSet.size()]);
        }
        List<FlowNode> list = FlowUtil.getStreamSimple(nodeTask.getNode());
        FlowNode flowNode = nodeTask.getChildEntrys()[0].getStartNode();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        boolean bl2 = flowNode == null;
        boolean bl3 = false;
        ArrayList arrayList = new ArrayList();
        for (FlowNode object : list) {
            if (!bl2 && object.equals(flowNode)) {
                bl2 = true;
            }
            if (!bl2) continue;
            Object object2 = object.getModel();
            List<RPackage> list2 = ((NodeModel)object2).getRequiredPackageList();
            if (bl && !bl3) {
                if (object2 instanceof FreeNodeModel) {
                    List<RPackage> list3 = ((FreeNodeModel)object2).getAttachPackageList();
                    arrayList.addAll(list3);
                }
                if (object.isCacheData() && object.getCacheData().isValid()) {
                    list2.addAll(arrayList);
                    bl3 = true;
                }
            }
            for (RPackage rPackage : list2) {
                String string = rPackage.getName();
                Boolean bl4 = rPackage.isAttach();
                if (hashMap.containsKey(string)) {
                    if (!bl4.booleanValue()) continue;
                    hashMap.put(string, bl4);
                    continue;
                }
                hashMap.put(string, bl4);
            }
        }
        TreeSet treeSet = new TreeSet();
        for (Object object2 : hashMap.keySet()) {
            treeSet.add(new RPackage((String)object2, true, (Boolean)hashMap.get(object2)));
        }
        return treeSet.toArray(new RPackage[treeSet.size()]);
    }

    public static String[] toNames(RPackage[] rPackageArray) {
        if (rPackageArray != null && rPackageArray.length > 0) {
            String[] stringArray = new String[rPackageArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = rPackageArray[i].getName();
            }
            return stringArray;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAttach() {
        return this.attach;
    }

    @Override
    public int compareTo(RPackage rPackage) {
        return this.name.compareTo(rPackage.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RPackage)) {
            return false;
        }
        return this.name.equals(((RPackage)object).name);
    }

    public static List<RPackage> getDetectedPackages(FlowNode flowNode) {
        if (flowNode.getModel() instanceof SubflowNodeModel) {
            return flowNode.getModel().getRequiredPackageList();
        }
        return flowNode.getModel().getAutoPackageList();
    }

    public static String packageListToString(List<RPackage> list) {
        boolean bl = true;
        String string = "(" + Messages.getString("View.RequiredPackagesView.none") + ")";
        Object object = string;
        for (RPackage rPackage : list) {
            if (bl) {
                bl = false;
                object = "";
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + rPackage.getName();
        }
        return object;
    }

    public static List<RPackage> detectRequiredPackages(String string, Boolean bl) {
        ArrayList<RPackage> arrayList = new ArrayList<RPackage>();
        String string2 = ".detectPackages(" + RUtility.quote(string) + ", attach.only = " + RUtility.toRBoolean(bl) + ")";
        R.queryQueue().addQuery(() -> {
            String[] stringArray;
            REXP rEXP = R.client().silentIdleEvalGet(string2);
            if (rEXP != null && (stringArray = RClient.rexpToStringsNArm(rEXP, null)) != null) {
                for (String string2 : stringArray) {
                    arrayList.add(new RPackage(string2, true, bl));
                }
            }
        });
        return arrayList;
    }
}

