/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RSessionManager;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.KeyTest;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEvent;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEventHandler;
import com.ef_prime.rflow.core.util.ScriptBuilder;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.event.Event;
import com.ef_prime.rflow.ui.common.event.EventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class RPackageManager
extends ValueMap
implements RSessionManager.RSessionEventHandler,
Runnable,
RowBasedTableModelEventHandler {
    private static final BoolKey ATTACHED = BoolKey.builder("attached", " ").build();
    private static final StrKey NAME = ((StrKey.Builder)StrKey.builder("name", Messages.getString("View.Package.package_name")).setEditable(false)).build();
    private static final StrKey TITLE = ((StrKey.Builder)StrKey.builder("title", Messages.getString("View.Package.package_title")).setEditable(false)).build();
    private static final StrKey LIBPATH = ((StrKey.Builder)StrKey.builder("libpath", "").addKeyLink(KeyLink.visible(KeyTest.ALWAYS_FALSE))).build();
    public static final TableKey PACKAGES = ((TableKey.Builder)((TableKey.Builder)((TableKey.Builder)((TableKey.Builder)((TableKey.Builder)TableKey.builder("packages", "", ATTACHED, NAME, TITLE, LIBPATH).noLabel()).setFixedColumnWidth(0, 30)).setColumnWidth(1, 100)).setUnboundTableArea(false)).setSelectionMode(2)).build();
    private Map<String, Boolean> libPaths = new HashMap<String, Boolean>(4);
    private FutureTask<Void> task;
    private EventSupport<RPackageManagerEvent, RPackageManagerEventHandler> eventSupport = new EventSupport();

    RPackageManager() {
        this.registerKeys(PACKAGES);
        this.getValue(PACKAGES).addRowBasedTableModelEventHandler(this);
        R.sessionManager().addEventHandler(this);
    }

    public KeysTableModel getPackages() {
        return this.getValue(PACKAGES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageStatus(String string, boolean bl) {
        KeysTableModel keysTableModel = this.getPackages();
        keysTableModel.removeRowBasedTableModelEventHandler(this);
        try {
            for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
                KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(i);
                String string2 = (String)keysTableRow.getValue(1);
                if (!string2.equals(string)) continue;
                keysTableModel.setValueAt(bl, i, 0);
            }
        }
        finally {
            keysTableModel.addRowBasedTableModelEventHandler(this);
        }
    }

    public Future<Void> refresh() {
        this.task = new FutureTask<Object>(this, null);
        R.queryQueue().addQuery(this.task);
        this.eventSupport.dispatchEvent(new RPackageManagerEvent(0));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RPackageManager.this.task.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                RPackageManager.this.eventSupport.dispatchEvent(new RPackageManagerEvent(0));
            }
        });
        thread.setDaemon(true);
        thread.start();
        return this.task;
    }

    public boolean isRefreshing() {
        return this.task != null && !this.task.isDone();
    }

    public String getName(int n) {
        return (String)this.getPackages().getValueAt(n, NAME);
    }

    public String getLibPath(int n) {
        return (String)this.getPackages().getValueAt(n, LIBPATH);
    }

    public boolean isUninstallable(int n) {
        if (this.getName(n).equals("base")) {
            return false;
        }
        Boolean bl = this.libPaths.get(this.getLibPath(n));
        return bl == null ? false : bl;
    }

    public int[] getRows(List<String> list, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        KeysTableModel keysTableModel = this.getPackages();
        for (int i = 0; i < keysTableModel.getRowCount(); ++i) {
            KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(i);
            String string2 = keysTableRow.getValue(LIBPATH);
            String string3 = keysTableRow.getValue(NAME);
            if (!list.contains(string3) || !string.isEmpty() && !string2.equals(string)) continue;
            arrayList.add(i);
        }
        return arrayList.stream().mapToInt(n -> n).toArray();
    }

    public void showHelp(int n) {
        String string = this.getName(n);
        String string2 = "help(package=" + RUtility.quote(string) + ")";
        R.queryQueue().addQuery(() -> R.client().silentIdleEval(string2));
    }

    public void showDocuments(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        KeysTableModel keysTableModel = this.getPackages();
        for (int n : nArray) {
            KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(n);
            String string = keysTableRow.getValue(NAME);
            R.receiver().passCommand(RUtility.function("library", "help", RUtility.quote(string)));
        }
    }

    public void uninstall(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        KeysTableModel keysTableModel = this.getPackages();
        for (int n : nArray) {
            KeysTableRow keysTableRow = (KeysTableRow)keysTableModel.getRow(n);
            String string = keysTableRow.getValue(NAME);
            String string2 = keysTableRow.getValue(LIBPATH);
            if (keysTableRow.getValue(ATTACHED).booleanValue()) {
                keysTableModel.setValueAt(Boolean.FALSE, n, keysTableModel.getColumnIndex(ATTACHED));
            }
            R.receiver().passCommand(RUtility.function("remove.packages", "pkgs", RUtility.quote(string), "lib", RUtility.quote(string2)));
        }
        this.refresh();
    }

    @Override
    public void rowBasedTableChanged(RowBasedTableModelEvent rowBasedTableModelEvent) {
        if (rowBasedTableModelEvent.getType() == 2 && rowBasedTableModelEvent.getUpdatedColumn() == 0) {
            KeysTableModel keysTableModel = this.getPackages();
            int n = rowBasedTableModelEvent.getUpdatedRow();
            String string = (String)keysTableModel.getValueAt(n, NAME);
            Boolean bl = (Boolean)keysTableModel.getValueAt(n, ATTACHED);
            if (string == null || bl == null) {
                return;
            }
            String string2 = bl != false ? "library(" + string + ")" : "detach(" + RUtility.quote("package:" + string) + ", unload = TRUE)";
            R.receiver().passCommand(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string;
        String string2 = "[, c(\"Package\", \"LibPath\", \"Version\", \"Title\")]";
        String string3 = "utils::installed.packages(fields = \"Title\")" + string2;
        String[] stringArray = RClient.rexpToStrings(R.client().silentTimeoutEvalGet(string3), null, "");
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = RClient.rexpToStrings(R.client().silentTimeoutEvalGet("search()"), null, null);
        if (stringArray2 == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray2.length);
        for (String string4 : stringArray2) {
            if (string4 == null || !string4.startsWith("package:")) continue;
            hashSet.add(string4.substring("package:".length()));
        }
        ArrayList arrayList = new ArrayList();
        KeysTableModel keysTableModel = this.getPackages();
        keysTableModel.beginValueChange();
        try {
            keysTableModel.removeAllRows();
            this.libPaths.clear();
            int n = stringArray.length / 4;
            for (int i = 0; i < n; ++i) {
                string = stringArray[i];
                String string5 = stringArray[n + i].intern();
                String string6 = stringArray[n * 3 + i];
                keysTableModel.addNewRow(hashSet.contains(string), string, string6, string5);
                arrayList.add(string);
                if (this.libPaths.containsKey(string5)) continue;
                this.libPaths.put(string5, Files.isWritable(Paths.get(string5, new String[0])));
            }
        }
        finally {
            keysTableModel.endValueChange();
        }
        ScriptBuilder scriptBuilder = new ScriptBuilder();
        String string7 = R.client().get(".rflowPackageAttached");
        string = R.client().get(".rflowPackageDetached");
        scriptBuilder.appendLn("local({");
        scriptBuilder.appendLn("for (pkg in " + RUtility.combineCharacters(arrayList) + ") {");
        scriptBuilder.appendLn("if (!any(sapply(getHook(packageEvent(pkg, \"attach\")), function(x) {identical(x, " + string7 + ")}))) {");
        scriptBuilder.appendLn("setHook(packageEvent(pkg, \"attach\"), " + string7 + ")");
        scriptBuilder.appendLn("}");
        scriptBuilder.appendLn("if (!any(sapply(getHook(packageEvent(pkg, \"detach\")), function(x) {identical(x, " + string + ")}))) {");
        scriptBuilder.appendLn("setHook(packageEvent(pkg, \"detach\"), " + string + ")");
        scriptBuilder.appendLn("}");
        scriptBuilder.appendLn("}");
        scriptBuilder.appendLn("})");
        R.client().silentTimeoutEval(scriptBuilder.toString());
    }

    @Override
    public void onRSessionEvent(RSessionManager.RSessionEvent rSessionEvent) {
        switch (rSessionEvent.getType()) {
            case 0: {
                this.refresh();
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void addRPackageManagerEventHandler(RPackageManagerEventHandler rPackageManagerEventHandler) {
        this.eventSupport.addEventHandler(rPackageManagerEventHandler);
    }

    public void removeRPackageManagerEventHandler(RPackageManagerEventHandler rPackageManagerEventHandler) {
        this.eventSupport.removeEventHandler(rPackageManagerEventHandler);
    }

    public static class RPackageManagerEvent
    extends Event<RPackageManagerEventHandler> {
        public static final int BUSY_STATE_CHANGED = 0;
        private int type;

        public RPackageManagerEvent(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public void dispatch(RPackageManagerEventHandler rPackageManagerEventHandler) {
            rPackageManagerEventHandler.handleRPackageManagerEvent(this);
        }
    }

    public static interface RPackageManagerEventHandler
    extends EventHandler {
        public void handleRPackageManagerEvent(RPackageManagerEvent var1);
    }
}

