/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.AppRpcInterface;
import com.ef_prime.rflow.core.app.r.base.RServerResponseReceiver;
import com.ef_prime.rflow.core.app.r.base.RSession;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TException;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;

public class RServerCallBacks
implements RMainLoopCallbacks {
    private static final Logger LOGGER = Logger.getLogger(RServerCallBacks.class.getName());
    private AppRpcInterface.Iface client;
    private JRIEngine engine;
    private int failedCount = 0;
    private int consecutiveFailedCount = 0;
    private int wrongThread = 0;

    public RServerCallBacks(AppRpcInterface.Iface iface) {
        this.client = iface;
    }

    public void setEngine(JRIEngine jRIEngine) {
        this.engine = jRIEngine;
    }

    private void success() {
        this.failedCount = 0;
        this.consecutiveFailedCount = 0;
    }

    private void failed(Exception exception) {
        if (this.consecutiveFailedCount == 0) {
            if (RSession.debug()) {
                exception.printStackTrace();
            }
            LOGGER.log(Level.SEVERE, "Failed to communicate with application process", exception);
        }
        if (this.consecutiveFailedCount > 4) {
            LOGGER.info("Cannot communicate with application process. Start shutdown.");
            RSession.shutdown();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.failedCount > 2) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.failedCount = 0;
            ++this.consecutiveFailedCount;
        }
        ++this.failedCount;
    }

    public void rWriteConsole(Rengine rengine, String string, int n) {
        try {
            this.client.rWriteConsole(string, n);
            this.success();
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
        }
    }

    public void rBusy(Rengine rengine, int n) {
        try {
            this.client.rBusy(n);
            this.success();
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
        }
    }

    public String rReadConsole(Rengine rengine, String string, int n) {
        try {
            if (Thread.currentThread() != rengine) {
                this.failed(new Exception("rReadConsole invoked by unexpected thread :" + String.valueOf(Thread.currentThread())));
                ++this.wrongThread;
                if (this.wrongThread > 10) {
                    LOGGER.info("rReadConsole invoked by unexpected thread repeatedly. Start shutdown.");
                    RSession.shutdown();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(1);
                }
                return "invisible()\n";
            }
            this.wrongThread = 0;
            if (RServerResponseReceiver.getInstance().isCommand()) {
                return RServerResponseReceiver.getInstance().getCommand();
            }
            this.client.rReadConsole(string, n);
            String string2 = this.waitForCommand();
            this.success();
            return string2;
        }
        catch (Exception exception) {
            this.failed(exception);
            return "\n";
        }
    }

    private String waitForCommand() throws TException {
        int n = 0;
        String string = RServerResponseReceiver.getInstance().getCommand();
        while (string == null) {
            if (this.engine != null) {
                int n2 = this.engine.tryLock();
                if (n2 != 0) {
                    this.engine.getRni().rniIdle();
                }
                this.engine.unlock(n2);
            }
            if (n > 9) {
                try {
                    this.client.state();
                    this.success();
                }
                catch (Exception exception) {
                    this.failed(exception);
                }
                n = 0;
            } else {
                ++n;
            }
            RServerResponseReceiver.getInstance().waitForCommand(50L);
            string = RServerResponseReceiver.getInstance().getCommand();
        }
        return string;
    }

    public void rShowMessage(Rengine rengine, String string) {
        try {
            this.client.rShowMessage(string);
            this.success();
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
        }
    }

    public String rChooseFile(Rengine rengine, int n) {
        try {
            this.client.rChooseFile(n);
            String string = RServerResponseReceiver.getInstance().waitForFile();
            this.success();
            return string;
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
            return null;
        }
    }

    public void rFlushConsole(Rengine rengine) {
        try {
            this.client.rFlushConsole();
            this.success();
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
        }
    }

    public void rSaveHistory(Rengine rengine, String string) {
        try {
            this.client.rSaveHistory(string);
            this.success();
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
        }
    }

    public void rLoadHistory(Rengine rengine, String string) {
        try {
            this.client.rLoadHistory(string);
            this.success();
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
        }
    }
}

