/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.AppRpcInterface;
import com.ef_prime.rflow.core.app.r.base.RServerResponseReceiver;
import com.ef_prime.rflow.core.app.r.base.RSession;
import com.ef_prime.rflow.core.app.r.base.RpcUtility;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TException;
import org.rosuda.javaGD.GDInterface;

public class RServerGD
extends GDInterface {
    private static final Logger LOGGER = Logger.getLogger(RServerGD.class.getName());
    private static List<RServerGD> gdList = new ArrayList<RServerGD>();
    private AppRpcInterface.Iface client = RSession.getAppClient();
    private int id;
    private int failedCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RServerGD() {
        List<RServerGD> list = gdList;
        synchronized (list) {
            this.id = 0;
            while (this.id < Integer.MAX_VALUE) {
                while (this.id >= gdList.size()) {
                    gdList.add(null);
                }
                if (gdList.get(this.id) == null) {
                    gdList.set(this.id, this);
                    break;
                }
                ++this.id;
            }
        }
        if (this.id == Integer.MAX_VALUE) {
            throw new RuntimeException("Fail to assign ID.");
        }
        try {
            this.client.createGD(this.id);
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
        }
    }

    private void failed(Exception exception) {
        if (this.failedCount < 100) {
            if (RSession.debug()) {
                exception.printStackTrace();
            }
            LOGGER.log(Level.SEVERE, "GD failed to communicate with application process", exception);
            ++this.failedCount;
        } else if (this.failedCount == 100) {
            LOGGER.log(Level.INFO, "Too many Exception. Stop logging.", exception);
            ++this.failedCount;
        }
    }

    public static int[] openDevice(double d, double d2) {
        try {
            return RpcUtility.toIntegerArray(RSession.getAppClient().openDevice(d, d2));
        }
        catch (Exception exception) {
            if (RSession.debug()) {
                exception.printStackTrace();
            }
            LOGGER.log(Level.SEVERE, "GD failed to communicate with application process", exception);
            return new int[]{(int)d, (int)d2};
        }
    }

    public void gdOpen(double d, double d2) {
        try {
            this.client.gdOpen(this.id, d, d2);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdActivate() {
        try {
            this.client.gdActivate(this.id);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdCircle(double d, double d2, double d3) {
        try {
            this.client.gdCircle(this.id, d, d2, d3);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdClip(double d, double d2, double d3, double d4) {
        try {
            this.client.gdClip(this.id, d, d2, d3, d4);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gdClose() {
        try {
            this.client.gdClose(this.id);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
        List<RServerGD> list = gdList;
        synchronized (list) {
            gdList.set(this.id, null);
        }
    }

    public void gdDeactivate() {
        try {
            this.client.gdDeactivate(this.id);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdHold() {
        try {
            this.client.gdHold(this.id);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdFlush(boolean bl) {
        try {
            this.client.gdFlush(this.id, bl);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public double[] gdLocator() {
        try {
            this.client.gdLocator(this.id);
            List<Double> list = RServerResponseReceiver.getInstance().waitForLocatorPoint();
            double[] dArray = RpcUtility.toDoubleArray(list);
            return (double[])(dArray.length == 2 ? dArray : null);
        }
        catch (TException tException) {
            this.failed((Exception)((Object)tException));
            return null;
        }
    }

    public void gdLine(double d, double d2, double d3, double d4) {
        try {
            this.client.gdLine(this.id, d, d2, d3, d4);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public double[] gdMetricInfo(int n) {
        try {
            return RpcUtility.toDoubleArray(this.client.gdMetricInfo(this.id, n));
        }
        catch (Exception exception) {
            this.failed(exception);
            return new double[]{0.0, 0.0, 0.8};
        }
    }

    public void gdMode(int n) {
        try {
            this.client.gdMode(this.id, n);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdNewPage() {
        try {
            this.client.gdNewPageOld(this.id);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdNewPage(int n) {
        try {
            this.client.gdNewPage(this.id, n);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdPath(int n, int[] nArray, double[] dArray, double[] dArray2, boolean bl) {
        try {
            this.client.gdPath(this.id, n, RpcUtility.toIntegerList(nArray), RpcUtility.toDoubleList(dArray), RpcUtility.toDoubleList(dArray2), bl);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdPolygon(int n, double[] dArray, double[] dArray2) {
        try {
            this.client.gdPolygon(this.id, n, RpcUtility.toDoubleList(dArray), RpcUtility.toDoubleList(dArray2));
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdPolyline(int n, double[] dArray, double[] dArray2) {
        try {
            this.client.gdPolyline(this.id, n, RpcUtility.toDoubleList(dArray), RpcUtility.toDoubleList(dArray2));
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdRect(double d, double d2, double d3, double d4) {
        try {
            this.client.gdRect(this.id, d, d2, d3, d4);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdRaster(byte[] byArray, int n, int n2, double d, double d2, double d3, double d4, double d5, boolean bl) {
        try {
            this.client.gdRaster(this.id, ByteBuffer.wrap(byArray), n, n2, d, d2, d3, d4, d5, bl);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public double[] gdSize() {
        try {
            return RpcUtility.toDoubleArray(this.client.gdSize(this.id));
        }
        catch (Exception exception) {
            this.failed(exception);
            return new double[4];
        }
    }

    public double gdStrWidth(String string) {
        try {
            return this.client.gdStrWidth(this.id, string);
        }
        catch (Exception exception) {
            this.failed(exception);
            return 8 * string.length();
        }
    }

    public void gdText(double d, double d2, String string, double d3, double d4) {
        try {
            this.client.gdText(this.id, d, d2, string, d3, d4);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdcSetColor(int n) {
        try {
            this.client.gdcSetColor(this.id, n);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdcSetFill(int n) {
        try {
            this.client.gdcSetFill(this.id, n);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdcSetLine(double d, int n) {
        try {
            this.client.gdcSetLine(this.id, d, n);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }

    public void gdcSetFont(double d, double d2, double d3, int n, String string) {
        try {
            this.client.gdcSetFont(this.id, d, d2, d3, n, string);
        }
        catch (Exception exception) {
            this.failed(exception);
        }
    }
}

