/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.EmbeddedRClient;
import com.ef_prime.rflow.core.app.r.base.RServerResponseReceiver;
import com.ef_prime.rflow.core.app.r.base.RServerRpcInterface;
import com.ef_prime.rflow.core.app.r.base.RSession;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.thrift.TException;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.Rserve.protocol.REXPFactory;

public class RServerRpc
implements RServerRpcInterface.Iface {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private static final byte[] SUCCESS_BYTES = new byte[]{1};
    private EmbeddedRClient rClient;

    public RServerRpc(EmbeddedRClient embeddedRClient) {
        this.rClient = embeddedRClient;
    }

    @Override
    public ByteBuffer eval(String string, boolean bl) throws TException {
        REXP rEXP = this.rClient.eval(string, bl);
        return this.rexpToByteBuffer(rEXP, bl);
    }

    @Override
    public ByteBuffer idleEval(String string, boolean bl) throws TException {
        REXP rEXP = this.rClient.idleEval(string, bl);
        return this.rexpToByteBuffer(rEXP, bl);
    }

    @Override
    public ByteBuffer timeoutEval(String string, long l, boolean bl) throws TException {
        try {
            REXP rEXP = this.rClient.timeoutEval(string, l, bl);
            return this.rexpToByteBuffer(rEXP, bl);
        }
        catch (Exception exception) {
            return EMPTY_BYTE_BUFFER;
        }
    }

    private ByteBuffer rexpToByteBuffer(REXP rEXP, boolean bl) throws TException {
        if (rEXP == null) {
            return EMPTY_BYTE_BUFFER;
        }
        if (bl) {
            try {
                REXPFactory rEXPFactory = new REXPFactory(rEXP);
                int n = rEXPFactory.getBinaryLength();
                byte[] byArray = new byte[n];
                rEXPFactory.getBinaryRepresentation(byArray, 0);
                return ByteBuffer.wrap(byArray);
            }
            catch (Exception exception) {
                throw new TException("REXP selialize failed", (Throwable)exception);
            }
        }
        return ByteBuffer.wrap(SUCCESS_BYTES);
    }

    @Override
    public void startMainLoop() throws TException {
        try {
            this.rClient.startMainLoop();
        }
        catch (Exception exception) {
            throw new TException((Throwable)exception);
        }
    }

    @Override
    public void stop() throws TException {
        try {
            this.rClient.stop();
        }
        catch (Exception exception) {
            throw new TException((Throwable)exception);
        }
    }

    @Override
    public void shutdown() throws TException {
        RSession.shutdown();
    }

    @Override
    public void rReadConsoleResponse(String string) throws TException {
        RServerResponseReceiver.getInstance().setCommand(string);
    }

    @Override
    public void rChooseFileResponse(String string) throws TException {
        RServerResponseReceiver.getInstance().setFile(string);
    }

    @Override
    public void gdLocatorResponse(List<Double> list) throws TException {
        RServerResponseReceiver.getInstance().setLocatorPoint(list);
    }
}

