/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.AppRpcClient;
import com.ef_prime.rflow.core.app.r.base.AppRpcInterface;
import com.ef_prime.rflow.core.app.r.base.EmbeddedRClient;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RServerCallBacks;
import com.ef_prime.rflow.core.app.r.base.RServerRJava;
import com.ef_prime.rflow.core.app.r.base.RServerRpc;
import com.ef_prime.rflow.core.app.r.base.RServerRpcInterface;
import com.ef_prime.rflow.core.app.r.base.RSessionLogManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.rosuda.JRI.Rengine;

public class RSession {
    private static final Logger LOGGER = Logger.getLogger(RSession.class.getName());
    private static EmbeddedRClient rClient;
    private static TServer server;
    private static AppRpcClient appClient;
    private static AppProcessMonitor appProcessMonitor;
    private static boolean debug;

    public static void main(String[] stringArray) {
        Options options = new Options();
        options.addOption(Option.builder((String)"env").argName("env").hasArg().build());
        options.addOption(Option.builder((String)"port").hasArg().argName("number").desc("port number").build());
        options.addOption(Option.builder((String)"chost").hasArg().argName("clienthost").desc("client host name").required().build());
        options.addOption(Option.builder((String)"cport").hasArg().argName("number").desc("client port number").build());
        options.addOption(Option.builder((String)"log").hasArg().argName("Log Path").desc("Path to output log").build());
        options.addOption("wait", false, "wait till appication side server starts");
        options.addOption("debug", false, "show R debug outputs");
        options.addOption(Option.builder((String)"stacksize").hasArg().desc("R thread stack size (bytes)").build());
        options.addOption(Option.builder((String)"rargs").hasArgs().desc("R arguments").build());
        CommandLine commandLine = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        boolean bl = false;
        String[] stringArray2 = null;
        long l = 0x1800000L;
        try {
            commandLine = new DefaultParser().parse(options, stringArray);
            if (commandLine.hasOption("port")) {
                n = Integer.parseInt(commandLine.getOptionValue("port"));
            }
            if (commandLine.hasOption("cport")) {
                n2 = Integer.parseInt(commandLine.getOptionValue("cport"));
            }
            if (commandLine.hasOption("log")) {
                string = commandLine.getOptionValue("log");
            }
            bl = commandLine.hasOption("wait");
            if (commandLine.hasOption("debug")) {
                Rengine.DEBUG = 2;
                debug = true;
            }
            if (commandLine.hasOption("stacksize")) {
                l = Long.parseLong(commandLine.getOptionValue("stacksize"));
            }
            if (commandLine.hasOption("rargs")) {
                stringArray2 = commandLine.getOptionValues("rargs");
            }
        }
        catch (ParseException parseException) {
            new HelpFormatter().printHelp("rsession", options);
            return;
        }
        if (string != null) {
            RSessionLogManager.getInstance().init(string);
        }
        try {
            block15: {
                String string2 = commandLine.getOptionValue("chost");
                TSocket tSocket = new TSocket(string2, n2);
                tSocket = new TFramedTransport((TTransport)tSocket);
                TBinaryProtocol tBinaryProtocol = new TBinaryProtocol((TTransport)tSocket, true, true);
                appClient = new AppRpcClient(new AppRpcInterface.Client((TProtocol)tBinaryProtocol));
                if (bl) {
                    while (true) {
                        try {
                            tSocket.open();
                            break block15;
                        }
                        catch (Exception exception) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        break;
                    }
                }
                tSocket.open();
            }
            RServerCallBacks rServerCallBacks = new RServerCallBacks(appClient);
            rClient = new EmbeddedRClient(stringArray2, l, rServerCallBacks);
            RClient.setRJavaInterface(new RServerRJava(appClient));
            rServerCallBacks.setEngine(rClient.getEngine());
            RServerRpc rServerRpc = new RServerRpc(rClient);
            RServerRpcInterface.Processor<RServerRpc> processor = new RServerRpcInterface.Processor<RServerRpc>(rServerRpc);
            TServerSocket tServerSocket = new TServerSocket(new InetSocketAddress(InetAddress.getLoopbackAddress(), n));
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)tServerSocket).processor(processor)).transportFactory((TTransportFactory)new TFramedTransport.Factory())).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true))).executorService((ExecutorService)new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new RServerRpcThreadFactory(l)));
            server = new TThreadPoolServer(args);
            appProcessMonitor = new AppProcessMonitor(appClient);
            appProcessMonitor.start();
            server.serve();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to initialize R process.", exception);
        }
    }

    public static boolean debug() {
        return debug;
    }

    public static void shutdown() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RSession.stopServer();
                RSessionLogManager.getInstance().close();
                if (rClient != null) {
                    rClient.eval("base::q(save=\"no\")");
                }
            }
        }, "RSession-Shutdown").start();
    }

    static void stopServer() {
        if (appProcessMonitor != null) {
            appProcessMonitor.stopMonitor();
        }
        if (server != null) {
            server.stop();
        }
    }

    public static AppRpcInterface.Iface getAppClient() {
        return appClient;
    }

    static {
        debug = false;
    }

    private static class RServerRpcThreadFactory
    implements ThreadFactory {
        private AtomicInteger threadCounter = new AtomicInteger(1);
        private long stackSize;
        private ThreadGroup group;

        public RServerRpcThreadFactory(long l) {
            this.stackSize = l;
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, "RServerRPC-" + this.threadCounter.getAndIncrement(), this.stackSize);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private static class AppProcessMonitor
    extends Thread {
        private AppRpcClient client;
        private boolean stopped;

        public AppProcessMonitor(AppRpcClient appRpcClient) {
            super("AppProcessMonitor");
            this.setDaemon(true);
            this.client = appRpcClient;
        }

        public void stopMonitor() {
            this.stopped = true;
            this.interrupt();
        }

        @Override
        public void run() {
            int n = 0;
            while (n < 5 && !this.stopped) {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.client.state();
                    n = 0;
                }
                catch (TException tException) {
                    if (n == 0) {
                        LOGGER.log(Level.SEVERE, "App process didn't respond", tException);
                    }
                    ++n;
                    if (!RSession.debug()) continue;
                    System.err.println("App process didn't respond: " + n);
                    tException.printStackTrace();
                }
            }
            if (this.stopped) {
                return;
            }
            LOGGER.info("App process didn't respond. Starts shutdown.");
            if (RSession.debug()) {
                System.err.println("App process didn't respond. Starts shutdown.");
            }
            RSession.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
    }
}

