/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.core.app.r.base.RSession;
import com.ef_prime.rflow.core.base.LogFileFormatter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RSessionLogManager {
    private static final RSessionLogManager instance = new RSessionLogManager();
    private Logger rootLogger;

    private RSessionLogManager() {
    }

    public static RSessionLogManager getInstance() {
        return instance;
    }

    public void init(String string) {
        block4: {
            if (string == null || string.isEmpty()) {
                return;
            }
            try {
                Path path = Paths.get(string, new String[0]);
                if (!path.isAbsolute()) {
                    throw new IOException("Invalid log path: " + string);
                }
                this.rootLogger = Logger.getLogger("com.ef_prime");
                this.rootLogger.setUseParentHandlers(false);
                this.rootLogger.setLevel(Level.ALL);
                FileHandler fileHandler = new FileHandler(string, 0x200000, 1, true);
                fileHandler.setEncoding("UTF-8");
                fileHandler.setLevel(Level.FINE);
                fileHandler.setFormatter(new LogFileFormatter());
                this.rootLogger.addHandler(fileHandler);
            }
            catch (Exception exception) {
                if (!RSession.debug()) break block4;
                System.err.println("Failed to start log: " + exception.getMessage());
            }
        }
    }

    public void close() {
        if (this.rootLogger != null) {
            for (Handler handler : this.rootLogger.getHandlers()) {
                handler.close();
            }
        }
    }
}

