/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.app.r.base.RClient;
import com.ef_prime.rflow.core.app.r.base.RPackage;
import com.ef_prime.rflow.core.app.r.base.RSupport;
import com.ef_prime.rflow.core.app.r.base.RUtility;
import com.ef_prime.rflow.core.app.r.base.RpcRClient;
import com.ef_prime.rflow.core.base.LogManager;
import com.ef_prime.rflow.core.base.PluginManager;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.util.OSUtility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.ui.app.r.RJavaUI;
import com.ef_prime.rflow.ui.common.event.Event;
import com.ef_prime.rflow.ui.common.event.EventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.transport.TTransportException;
import org.rosuda.JRI.Rengine;

public class RSessionManager
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RSessionManager.class.getName());
    private ProcessBuilder rProcessBuilder;
    private Process localSession;
    private ProcessStreamReader streamReader;
    private boolean initializing;
    private String chost;
    private int cport;
    private int port;
    private String[] rargs;
    private ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)ThreadUtility.threadFactory("RSessionManager-%d", false));
    private EventSupport<RSessionEvent, RSessionEventHandler> eventSupport = new EventSupport();

    RSessionManager() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "RSessionManager-ShutdownHook"));
    }

    public void start(RpcRClient rpcRClient, String string, String string2, int n, int n2, long l, String[] stringArray) throws IOException {
        this.chost = string2;
        this.cport = n;
        this.port = n2;
        this.rargs = stringArray;
        this.initRProcessBuilder();
    }

    private void initRProcessBuilder() {
        File file = new File(System.getProperty("java.home"));
        file = new File(file, "bin/java");
        String string = RSessionManager.getRAFClassPath(false);
        this.rProcessBuilder = new ProcessBuilder(file.getPath(), "-Djava.library.path=" + System.getProperty("java.library.path"), "-classpath", string, "com.ef_prime.rflow.core.app.r.base.RSession", "-port", Integer.toString(this.port), "-chost", this.chost, "-cport", Integer.toString(this.cport), "-stacksize", Long.toString(Rflow.settings().getValue(Settings.STACK_SIZE)));
        if (LogManager.getInstance().getRProcessLogFile() != null) {
            this.rProcessBuilder.command().add("-log");
            this.rProcessBuilder.command().add(LogManager.getInstance().getRProcessLogFile().getAbsolutePath());
        }
        if (Rengine.DEBUG > 0) {
            this.rProcessBuilder.command().add("-debug");
        }
        if (this.rargs != null && this.rargs.length > 0) {
            this.rProcessBuilder.command().add("-rargs");
            for (String string2 : this.rargs) {
                this.rProcessBuilder.command().add(string2);
            }
        }
        this.rProcessBuilder.directory(Utility.programDir());
        this.rProcessBuilder.redirectErrorStream(true);
    }

    public static String getRAFClassPath(boolean bl) {
        File file;
        Object object = RSessionManager.getClassPath(bl);
        if (Platform.isWindowsFamily() && (file = RSupport.getRBinForWindows(RSupport.getRHomeForWindows(true))) != null) {
            String string = file.getAbsolutePath() + File.separator + "R";
            String string2 = null;
            try {
                String string3 = "(function(x){cat(if(\"rJava\" %in% row.names(x)) paste0(\";\", x[\"rJava\", \"LibPath\"], \"/rJava/java/boot/\") else \"\")})(installed.packages())";
                string2 = RSupport.askRcmd(string, string3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string2 != null && !string2.isEmpty()) {
                object = (String)object + string2;
            }
        }
        return object;
    }

    private static String getClassPath(boolean bl) {
        String[] stringArray = Utility.getClassPaths();
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(OSUtility.getShortPathNameForWindows(Utility.getPathStr("ext")), new String[0]).toAbsolutePath();
        Path path2 = path.resolve("common").toAbsolutePath();
        Path path3 = Paths.get(OSUtility.getShortPathNameForWindows(Utility.getPathStr("plugin")), new String[0]).toAbsolutePath();
        for (int i = 0; i < stringArray.length; ++i) {
            Path path4 = Paths.get(OSUtility.getShortPathNameForWindows(stringArray[i]), new String[0]).toAbsolutePath();
            if (!bl && path4.startsWith(path) && !path4.startsWith(path2) || path4.startsWith(path3)) continue;
            arrayList.add(stringArray[i]);
        }
        return StringUtils.join(arrayList, (char)File.pathSeparatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcess(RpcRClient rpcRClient, boolean bl) throws IOException {
        this.initializing = true;
        try {
            if (this.rProcessBuilder != null) {
                if (bl) {
                    ProcessBuilder processBuilder = new ProcessBuilder(new ArrayList<String>(this.rProcessBuilder.command()));
                    if (!processBuilder.command().contains("-rargs")) {
                        processBuilder.command().add("-rargs");
                    }
                    processBuilder.command().add("-q");
                    processBuilder.directory(Utility.programDir());
                    processBuilder.redirectErrorStream(true);
                    this.localSession = processBuilder.start();
                } else {
                    this.localSession = this.rProcessBuilder.start();
                }
                this.streamReader = new ProcessStreamReader();
                this.streamReader.start();
            }
            TTransportException tTransportException = null;
            for (int i = 0; i < 15; ++i) {
                try {
                    rpcRClient.connect();
                    break;
                }
                catch (TTransportException tTransportException2) {
                    tTransportException = tTransportException2;
                    try {
                        if (i < 10) {
                            Thread.sleep(50L);
                            continue;
                        }
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (!rpcRClient.isConnected()) {
                if (tTransportException != null) {
                    throw new IOException(tTransportException);
                }
                throw new IOException("Connection failed");
            }
        }
        finally {
            this.initializing = false;
        }
    }

    public boolean isSessionEverAlive() {
        return this.localSession != null;
    }

    public boolean isSessionAlive() {
        return !this.isShuttingdown() && !this.initializing && this.localSession != null && this.localSession.isAlive();
    }

    private boolean isShuttingdown() {
        return this.streamReader != null && this.streamReader.shuttingdown;
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }

    public void restart(boolean bl) {
        this.execute(() -> {
            if (!(R.client() instanceof RpcRClient)) {
                return;
            }
            if (this.localSession != null) {
                this.eventSupport.dispatchEvent(new RSessionEvent(1));
            }
            this.shutdown();
            RpcRClient rpcRClient = (RpcRClient)R.client();
            try {
                RSessionManager.init(bl);
                this.initRProcessBuilder();
                this.startProcess(rpcRClient, !bl);
                RSessionManager.initR(bl);
                boolean bl2 = WorkingDirectory.setRWorkingDirectory(WorkingDirectory.getWorkingDirectory());
                this.eventSupport.dispatchEvent(new RSessionEvent(0));
                if (!bl2) {
                    this.eventSupport.dispatchEvent(new RSessionEvent(5));
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Failed to start R process", iOException);
                this.eventSupport.dispatchEvent(new RSessionEvent(4));
            }
        });
    }

    public void waitFor() {
        Future<Integer> future = this.executorService.submit(() -> 0);
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        if (this.streamReader != null) {
            this.streamReader.shuttingdown = true;
        }
        if (this.localSession != null && this.localSession.isAlive()) {
            R.console().stopIfBusy();
            if (R.console().isDebugWaitingForInput()) {
                R.receiver().passCommand("Q");
            }
            try {
                R.client().shutdown();
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Failed to shutdown R", exception);
            }
        }
        int n = 0;
        while (this.localSession != null && this.localSession.isAlive() && n < 20) {
            try {
                Thread.sleep(50L);
                ++n;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.localSession != null) {
            this.localSession.destroy();
        }
    }

    private static void init(boolean bl) {
        R.console().init(bl);
    }

    public static void initR(boolean bl) {
        LOGGER.fine(R.client().getVersion());
        Map<String, String> map = R.client().getPackageVersions(RPackage.toNames(RClient.REQUIRED_PACKAGES));
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            stringBuilder.append(object2.getKey()).append(":").append(object2.getValue()).append(" ");
        }
        LOGGER.fine(stringBuilder.toString());
        R.client().init(UserFolder.getUserDirFile("init.R"), Utility.PROGRAM_DIR, false);
        String string = Rflow.settings().getValue(Settings.CRAN_MIRROR);
        if (string != null && !string.isEmpty()) {
            R.client().eval(".rflowReplaceCRANMirror(url = " + RUtility.quote(string) + ")");
        }
        RClient.setRJavaInterface(new RJavaUI());
        Dimension dimension = Rflow.settings().getGDSettings().getSize();
        R.client().setGdSize(dimension.width, dimension.height);
        R.console().initR(bl);
        R.client().updateAvailablePackagesFile();
        R.client().updateInstalledPackages(false);
        try {
            R.client().startMainLoop();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to init R", exception);
        }
        R.receiver().passCommand(R.client().getInitialCommand());
        PluginManager.getInstance().initR();
    }

    public static int findAvailablePort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0, 50, InetAddress.getLoopbackAddress());){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    @Override
    public void run() {
        if (this.localSession != null && this.localSession.isAlive()) {
            this.shutdown();
        }
    }

    public void addEventHandler(RSessionEventHandler rSessionEventHandler) {
        this.eventSupport.addEventHandler(rSessionEventHandler);
    }

    public void removeEventHandler(RSessionEventHandler rSessionEventHandler) {
        this.eventSupport.removeEventHandler(rSessionEventHandler);
    }

    private class ProcessStreamReader
    extends Thread {
        private boolean shuttingdown;

        public ProcessStreamReader() {
            super("RStreamReader");
        }

        @Override
        public void run() {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(RSessionManager.this.localSession.getInputStream()));){
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Exception while reading R server output stream.", iOException);
            }
            if (this.shuttingdown) {
                RSessionManager.this.eventSupport.dispatchEvent(new RSessionEvent(2));
            } else {
                RSessionManager.this.eventSupport.dispatchEvent(new RSessionEvent(3));
                RSessionManager.this.restart(false);
            }
        }
    }

    public static class RSessionEvent
    extends Event<RSessionEventHandler> {
        public static final int START = 0;
        public static final int RESTART = 1;
        public static final int END = 2;
        public static final int ABNORMAL_END = 3;
        public static final int START_FAILED = 4;
        public static final int SET_WD_FAILED = 5;
        private int type;

        public RSessionEvent(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public void dispatch(RSessionEventHandler rSessionEventHandler) {
            rSessionEventHandler.onRSessionEvent(this);
        }
    }

    public static interface RSessionEventHandler
    extends EventHandler {
        public void onRSessionEvent(RSessionEvent var1);
    }
}

