/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.core.app.r.base;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.util.OSUtility;
import com.ef_prime.rflow.core.util.Platform;
import com.ef_prime.rflow.core.util.WindowsUtility;
import com.ef_prime.rflow.resource.Messages;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.CsvReader;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class RSupport {
    private static final Logger LOGGER = Logger.getLogger(RSupport.class.getName());
    public static final String UNSELECTED_CRAN_MIRROR = "@CRAN@";
    private static boolean supportsInputCancel = true;

    public static void init() throws RInitException {
        supportsInputCancel = false;
        File file = null;
        boolean bl = false;
        String string = System.getProperty("jri.path", "");
        if (string.isEmpty()) {
            string = Rflow.settings().getValue(Settings.JRI_PATH);
        }
        if (!(string.isEmpty() || (file = new File(string)).isDirectory() && file.exists())) {
            file = null;
        }
        if (file == null) {
            File file2 = Utility.programDir();
            if (Platform.isWindowsFamily()) {
                String string2;
                Rversion rversion;
                Object object;
                Object object2;
                File file3 = RSupport.getRHomeForWindows(true);
                File file4 = RSupport.getRBinForWindows(file3);
                if (file3 == null || !file3.exists() || file4 == null || !file4.exists()) {
                    throw new RInitException(Messages.getString("Error.Main.no_r_installdirectory"));
                }
                try {
                    object2 = file4.getAbsolutePath() + File.separator + "R";
                    object = RSupport.getRVersion((String)object2);
                    rversion = Rversion.parse((String)object);
                }
                catch (Exception exception) {
                    throw new RInitException(Messages.getString("Error.Main.launch_r"));
                }
                object2 = RSupport.getLibraryPackVersion(file2, rversion, null);
                if (object2 != null) {
                    file = RSupport.getLibraryPackLocation(file2, (Rversion)object2);
                }
                if (file == null || !file.exists()) {
                    object = Messages.getString("Error.Main.unsupported_r") + RSupport.getSupportedRVersions(file2);
                    throw new RInitException((String)object);
                }
                WindowsUtility.setEnvironmentVariable("R_HOME", file3.getAbsolutePath());
                object = System.getenv("Path") == null ? "PATH" : "Path";
                WindowsUtility.setEnvironmentVariable((String)object, file4.getAbsolutePath() + File.pathSeparator + System.getenv((String)object));
                if (System.getenv("R_USER") == null) {
                    WindowsUtility.setEnvironmentVariable("R_USER", UserFolder.getUserDocumentsDir().getAbsolutePath());
                }
                if ((string2 = System.getProperty("java.home")) == null) {
                    string2 = Utility.getPath("ext/jre").toString();
                }
                WindowsUtility.setEnvironmentVariable("JAVA_HOME", string2);
                bl = true;
            } else if (Platform.isLinux()) {
                try {
                    file = RSupport.getLibraryPackLocation(file2, null);
                    bl = true;
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Failed to load internal JRI.", exception);
                }
            } else if (Platform.isMac()) {
                try {
                    Rversion rversion;
                    try {
                        rversion = Rversion.parse(System.getProperty("r.version"));
                    }
                    catch (Exception exception) {
                        throw new Exception("Invalid r.version", exception);
                    }
                    Rversion rversion2 = RSupport.getLibraryPackVersion(file2, rversion, "_");
                    if (rversion2 == null) {
                        throw new Exception("Unsupported r.version");
                    }
                    file = RSupport.getLibraryPackLocation(file2, rversion2);
                    bl = true;
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Failed to load internal JRI.", exception);
                }
            }
        }
        if (file != null) {
            supportsInputCancel = bl;
        }
    }

    public static String getWindowsJRILibPath() {
        try {
            File file = Utility.programDir();
            File file2 = RSupport.getRHomeForWindows(true);
            File file3 = RSupport.getRBinForWindows(file2);
            String string = file3.getAbsolutePath() + File.separator + "R";
            String string2 = RSupport.getRVersion(string);
            Rversion rversion = Rversion.parse(string2);
            Rversion rversion2 = RSupport.getLibraryPackVersion(file, rversion, null);
            File file4 = RSupport.getLibraryPackLocation(file, rversion2);
            return file4.getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static File getRHomeForWindows(boolean bl) {
        File file;
        String string = Rflow.settings().getValue(Settings.R_HOME);
        File file2 = file = string.isEmpty() ? RSupport.findRForWindows() : new File(string);
        if (bl && file != null) {
            file = new File(OSUtility.getShortPathNameForWindows(file.getAbsolutePath()));
        }
        return file;
    }

    public static boolean supportsInputCancel() {
        return supportsInputCancel;
    }

    private static File getLibraryFolder(File file) {
        if (!Utility.isInstalled()) {
            return new File(file, "installer/" + Platform.getInstallFolder() + "/RLib");
        }
        return new File(file, "ext/R");
    }

    public static Rversion getLibraryPackVersion(File file, Rversion rversion, String string) {
        File file2 = RSupport.getLibraryFolder(file);
        if (!file2.exists()) {
            return null;
        }
        try {
            File[] fileArray = file2.listFiles();
            if (fileArray != null) {
                Rversion rversion2;
                TreeMap<Rversion, File> treeMap = new TreeMap<Rversion, File>();
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        rversion2 = Rversion.parse(fileArray[i].getName(), string);
                        treeMap.put(rversion2, fileArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                File file3 = (File)treeMap.get(rversion);
                if (file3 != null) {
                    return rversion;
                }
                rversion2 = treeMap.lowerKey(rversion);
                return rversion2 == null ? (Rversion)treeMap.lastKey() : rversion2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static File getLibraryPackLocation(File file, Rversion rversion) {
        String string;
        if (Platform.isLinux()) {
            File file2 = RSupport.getLibraryFolder(file);
            return new File(file2, "jri");
        }
        if (rversion == null) {
            return null;
        }
        File file3 = RSupport.getLibraryFolder(file);
        File file4 = new File(file3, rversion.toString());
        if (Platform.isWindowsFamily() && (string = Utility.getJavaBitness()) != null && string.equals("64")) {
            file4 = new File(file4, "64");
        }
        return file4;
    }

    public static String getSupportedRVersions(File file) {
        ArrayList<String> arrayList;
        Object object;
        block7: {
            object = "";
            arrayList = new ArrayList<String>();
            File file2 = RSupport.getLibraryFolder(file);
            try {
                if (!file2.exists() || !file2.isDirectory()) break block7;
                for (File file3 : file2.listFiles()) {
                    String[] stringArray;
                    if (file3.isFile() || (stringArray = file3.getName().split("\\.")).length != 3) continue;
                    try {
                        Integer.parseInt(stringArray[0]);
                        Integer.parseInt(stringArray[1]);
                        Integer.parseInt(stringArray[2]);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    arrayList.add(file3.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    String[] stringArray = string.split("\\.");
                    String[] stringArray2 = string2.split("\\.");
                    Integer[] integerArray = new Integer[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])};
                    Integer[] integerArray2 = new Integer[]{Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2])};
                    for (int i = 0; i < integerArray2.length; ++i) {
                        int n = integerArray[i].compareTo(integerArray2[i]);
                        if (n == 0) continue;
                        return n;
                    }
                    return 0;
                }
            });
            String string = (String)arrayList.get(0);
            Object object2 = (String)arrayList.get(arrayList.size() - 1);
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46) + 1) + "x";
            object = string + " - " + (String)object2;
        } else {
            object = "\n [search failed]";
        }
        return object;
    }

    public static File findRForWindows() {
        String string;
        String string2;
        try {
            string2 = "SOFTWARE\\R-core\\R";
            string = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)string2, (String)"InstallPath");
            if (RSupport.checkRExistsForWindows(new File(string))) {
                return new File(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = System.getenv("ProgramFiles(x86)");
        if (string2 == null) {
            string2 = "C:\\Program Files (x86)";
        }
        if ((string = System.getenv("ProgramW6432")) == null) {
            string = "C:\\Program Files";
        }
        File file = new File(string, "R");
        File file2 = new File(string2, "R");
        for (File file3 : new File[]{file, file2}) {
            File[] fileArray;
            if (!file3.exists() || (fileArray = file3.listFiles()) == null) continue;
            ArrayList<Rversion> arrayList = new ArrayList<Rversion>(fileArray.length);
            for (File file4 : fileArray) {
                String string3 = file4.getName();
                if (!file4.isDirectory() || !string3.startsWith("R-") || string3.length() <= 2) continue;
                try {
                    arrayList.add(Rversion.parse(string3.substring(2)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Collections.sort(arrayList, (rversion, rversion2) -> {
                int n = rversion.compareTo((Rversion)rversion2);
                if (n != 0) {
                    return n;
                }
                File file2 = new File(RSupport.getRBinForWindows(new File(file3, "R-" + rversion.toString())), "R.dll");
                File file3 = new File(RSupport.getRBinForWindows(new File(file3, "R-" + rversion2.toString())), "R.dll");
                return Long.compare(file2.lastModified(), file3.lastModified());
            });
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Rversion rversion3 = (Rversion)arrayList.get(i);
                File file5 = new File(file3, "R-" + rversion3.toString());
                if (!RSupport.checkRExistsForWindows(file5)) continue;
                return file5;
            }
        }
        return null;
    }

    public static File getRBinForWindows(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, "bin");
        String string = null;
        String string2 = Utility.getJavaBitness();
        string = string2 != null && string2.equals("64") ? "x64" : "i386";
        File file3 = new File(file2, string);
        return file3.exists() ? file3 : file2;
    }

    public static boolean checkRExistsForWindows(File file) {
        File file2 = RSupport.getRBinForWindows(file);
        if (file2 == null) {
            return false;
        }
        return new File(file2, "R.dll").exists();
    }

    public static String getRVersion(String string) throws IOException {
        return RSupport.askRcmd(string, "cat(as.character(getRversion()))");
    }

    public static String askRcmd(String string, String string2) throws IOException {
        string2 = string2.replaceAll("\"", "\\\\\\\"");
        ProcessBuilder processBuilder = new ProcessBuilder(string, "--vanilla", "--slave", "-e", string2);
        Process process = processBuilder.start();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                throw new IOException("Failed to get information from R");
            }
            String string4 = string3;
            return string4;
        }
    }

    public static List<String[]> getCranMirrors(String string) {
        List<String[]> list = RSupport.getCranMirrorsFromServer();
        if (list == null) {
            list = RSupport.getCranMirrorsFromLocalFile(string);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String[]> getCranMirrorsFromServer() {
        List<String[]> list = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).build();
        try (CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();){
            HttpGet httpGet = new HttpGet("http://cran.r-project.org/CRAN_mirrors.csv");
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);){
                if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                    List<String[]> list2 = null;
                    return list2;
                }
                list = RSupport.readCranMirrorsCsv(closeableHttpResponse.getEntity().getContent());
                return list;
            }
            finally {
                httpGet.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    private static List<String[]> getCranMirrorsFromLocalFile(String string) {
        List<String[]> list;
        if (string == null) {
            return null;
        }
        File file = new File(string, "doc/CRAN_mirrors.csv");
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            list = RSupport.readCranMirrorsCsv(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        fileInputStream.close();
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String[]> readCranMirrorsCsv(InputStream inputStream) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        CsvConfig csvConfig = new CsvConfig(',', '\"', '\\');
        try (CsvReader csvReader = new CsvReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), csvConfig);){
            Object object;
            List list;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            while ((list = csvReader.readValues()) != null) {
                if (csvReader.getLineNumber() == 1) {
                    n = list.indexOf("Name");
                    n2 = list.indexOf("URL");
                    n3 = list.indexOf("OK");
                    if (n >= 0 && n2 >= 0 && n3 >= 0) continue;
                    object = null;
                    return object;
                }
                if (list.size() < 2 || !((String)(object = (String)list.get(n3))).equals("1") && !((String)object).equals("TRUE")) continue;
                arrayList.add(new String[]{(String)list.get(n), (String)list.get(n2)});
            }
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static class RInitException
    extends Exception {
        public RInitException(String string) {
            super(string);
        }
    }

    public static class Rversion
    implements Comparable<Rversion> {
        private int major;
        private int minor;
        private int build;
        private String versionString;

        public static Rversion parse(String string) throws Exception {
            return Rversion.parse(string, null);
        }

        public static Rversion parse(String string, String string2) throws Exception {
            int n;
            int n2;
            String[] stringArray;
            if (string2 == null) {
                string2 = "\\.";
            }
            if ((stringArray = string.split(string2)).length != 3) {
                throw new Exception("invalid version length: " + stringArray.length);
            }
            int n3 = Integer.parseInt(stringArray[0]);
            int n4 = Integer.parseInt(stringArray[1]);
            String string3 = stringArray[2];
            for (n2 = 0; n2 < string3.length() && (n = string3.charAt(n2)) >= 48 && n <= 57; ++n2) {
            }
            n = Integer.parseInt(string3.substring(0, n2));
            return new Rversion(n3, n4, n, string);
        }

        private Rversion(int n, int n2, int n3, String string) {
            this.major = n;
            this.minor = n2;
            this.build = n3;
            this.versionString = string;
        }

        public boolean minorEquals(Rversion rversion) {
            return this.major == rversion.major && this.minor == rversion.minor;
        }

        public String toString() {
            return this.versionString;
        }

        @Override
        public int compareTo(Rversion rversion) {
            int n = Rversion.intCompare(this.major, rversion.major);
            if (n != 0) {
                return n;
            }
            n = Rversion.intCompare(this.minor, rversion.minor);
            if (n != 0) {
                return n;
            }
            return Rversion.intCompare(this.build, rversion.build);
        }

        private static int intCompare(int n, int n2) {
            if (n > n2) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.build;
            n = 31 * n + this.major;
            n = 31 * n + this.minor;
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Rversion)) {
                return false;
            }
            return this.compareTo((Rversion)object) == 0;
        }
    }
}

